/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.compiler;

import com.google.common.collect.Sets;
import com.google.inject.Singleton;
import io.sarl.lang.compiler.Messages;
import java.util.Set;
import org.eclipse.xtext.generator.OutputConfiguration;
import org.eclipse.xtext.generator.OutputConfigurationProvider;

@Singleton
public class SarlOutputConfigurationProvider
extends OutputConfigurationProvider {
    public Set<OutputConfiguration> getOutputConfigurations() {
        OutputConfiguration defaultOutput = this.createStandardOutputConfiguration();
        OutputConfiguration testOutput = this.createTestOutputConfiguration();
        if (defaultOutput != null) {
            if (testOutput != null) {
                return Sets.newHashSet((Object[])new OutputConfiguration[]{defaultOutput, testOutput});
            }
            return Sets.newHashSet((Object[])new OutputConfiguration[]{defaultOutput});
        }
        if (testOutput != null) {
            return Sets.newHashSet((Object[])new OutputConfiguration[]{testOutput});
        }
        return Sets.newHashSet();
    }

    protected OutputConfiguration createStandardOutputConfiguration() {
        OutputConfiguration defaultOutput = new OutputConfiguration("DEFAULT_OUTPUT");
        defaultOutput.setDescription(Messages.SarlOutputConfigurationProvider_0);
        defaultOutput.setOutputDirectory("src/main/generated-sources/sarl");
        defaultOutput.setOverrideExistingResources(true);
        defaultOutput.setCreateOutputDirectory(true);
        defaultOutput.setCanClearOutputDirectory(false);
        defaultOutput.setCleanUpDerivedResources(true);
        defaultOutput.setSetDerivedProperty(true);
        defaultOutput.setKeepLocalHistory(Boolean.FALSE);
        return defaultOutput;
    }

    protected OutputConfiguration createTestOutputConfiguration() {
        OutputConfiguration testOutput = new OutputConfiguration("DEFAULT_TEST_OUTPUT");
        testOutput.setDescription(Messages.SarlOutputConfigurationProvider_1);
        testOutput.setOutputDirectory("src/test/generated-sources/sarl");
        testOutput.setOverrideExistingResources(true);
        testOutput.setCreateOutputDirectory(true);
        testOutput.setCanClearOutputDirectory(false);
        testOutput.setCleanUpDerivedResources(true);
        testOutput.setSetDerivedProperty(true);
        testOutput.setKeepLocalHistory(Boolean.FALSE);
        return testOutput;
    }
}

