/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.controlflow;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.sarl.lang.controlflow.ISarlEarlyExitComputer;
import io.sarl.lang.core.annotation.EarlyExit;
import io.sarl.lang.sarl.SarlAction;
import io.sarl.lang.sarl.SarlBreakExpression;
import io.sarl.lang.sarl.SarlContinueExpression;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.AnnotationLookup;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.controlflow.DefaultEarlyExitComputer;
import org.eclipse.xtext.xbase.controlflow.IEarlyExitComputer;

@Singleton
public class SARLEarlyExitComputer
extends DefaultEarlyExitComputer
implements ISarlEarlyExitComputer {
    @Inject
    private AnnotationLookup annotations;

    protected Collection<IEarlyExitComputer.ExitPoint> _exitPoints(XAbstractFeatureCall expression) {
        Collection exitPoints = super._exitPoints(expression);
        if (this.isNotEmpty(exitPoints)) {
            return exitPoints;
        }
        JvmIdentifiableElement element = expression.getFeature();
        if (this.isEarlyExitAnnotatedElement(element)) {
            return Collections.singletonList(new SarlExitPoint((XExpression)expression, false));
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isEarlyExitEvent(JvmTypeReference reference) {
        if (reference != null && !reference.eIsProxy()) {
            JvmType type = reference.getType();
            return this.isEarlyExitAnnotatedElement(type);
        }
        return false;
    }

    @Override
    public boolean isEarlyExitAnnotatedElement(Object element) {
        JvmAnnotationTarget cvalue;
        return element instanceof JvmAnnotationTarget && this.annotations.findAnnotation(cvalue = (JvmAnnotationTarget)element, EarlyExit.class) != null;
    }

    @Override
    public boolean isEarlyExitLoop(XExpression expression) {
        return expression instanceof SarlBreakExpression || expression instanceof SarlContinueExpression;
    }

    @Override
    public boolean isEarlyExitOperation(SarlAction operation) {
        if (operation != null) {
            Iterator eventIterator = operation.getFiredEvents().iterator();
            while (eventIterator.hasNext()) {
                if (!this.isEarlyExitEvent((JvmTypeReference)eventIterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEarlyExitInJava(XExpression expression) {
        Collection exitPoints = this.getExitPoints(expression);
        if (this.isNotEmpty(exitPoints)) {
            for (IEarlyExitComputer.ExitPoint exitPoint : exitPoints) {
                if (!(exitPoint instanceof SarlExitPoint)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static class SarlExitPoint
    extends IEarlyExitComputer.ExitPoint {
        public SarlExitPoint(XExpression expression, boolean exceptionalExit) {
            super(expression, exceptionalExit);
        }
    }
}

