/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.documentation;

import io.sarl.lang.documentation.IDocumentationFormatter;
import io.sarl.lang.services.SARLGrammarAccess;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.UntilToken;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.ILineRegion;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.StringBuilderBasedAppendable;
import org.eclipse.xtext.xbase.compiler.output.FakeTreeAppendable;
import org.eclipse.xtext.xbase.lib.Pure;

public class DocumentationFormatter
implements IDocumentationFormatter {
    private static final String SPACE_CHAR = " ";
    private static final String NL_CHAR = "\n";
    private static final String EMPTY_STR = "";
    private String mlLinePrefix;
    private String mlStart;
    private String mlEnd;
    private String slPrefix;

    protected static boolean isNewLine(char character) {
        if (character == '\n' || character == '\r' || character == '\f') {
            return true;
        }
        return (24576 >> Character.getType((int)character) & 1) != 0;
    }

    @Override
    @Pure
    public String getMultilineCommentStartSymbols() {
        return this.mlStart;
    }

    public void setMultilineCommentStartSymbols(String symbols) {
        this.mlStart = symbols;
    }

    @Override
    @Pure
    public String getMultilineCommentEndSymbols() {
        return this.mlEnd;
    }

    public void setMultilineCommentEndSymbols(String symbols) {
        this.mlEnd = symbols;
    }

    @Override
    @Pure
    public String getMultilineCommentLinePrefix() {
        return this.mlLinePrefix;
    }

    public void setMultilineCommentLinePrefix(String prefix) {
        this.mlLinePrefix = prefix;
    }

    @Override
    @Pure
    public String getSinglelineCommentPrefix() {
        return this.slPrefix;
    }

    @Pure
    protected Set<Character> getSinglelineCommentSpecialChars() {
        TreeSet<Character> set = new TreeSet<Character>();
        set.add(Character.valueOf('*'));
        set.add(Character.valueOf('+'));
        set.add(Character.valueOf('-'));
        set.add(Character.valueOf('='));
        return set;
    }

    public void setSinglelineCommentPrefix(String prefix) {
        this.slPrefix = prefix;
    }

    @Inject
    public void setGrammarAccess(SARLGrammarAccess access) {
        Keyword $c$value;
        if (this.mlStart == null || this.mlEnd == null) {
            TerminalRule mlRule = access.getML_COMMENTRule();
            for (AbstractElement element : ((Group)mlRule.getAlternatives()).getElements()) {
                if (element instanceof Keyword) {
                    $c$value = (Keyword)element;
                    if (this.mlStart == null) {
                        this.mlStart = $c$value.getValue();
                        continue;
                    }
                }
                if (!(element instanceof UntilToken)) continue;
                UntilToken $c$value2 = (UntilToken)element;
                if (this.mlEnd != null) continue;
                this.mlEnd = ((Keyword)$c$value2.getTerminal()).getValue();
            }
        }
        if (this.mlLinePrefix == null) {
            this.mlLinePrefix = this.mlStart.substring(this.mlStart.length() - 1);
        }
        if (this.slPrefix == null) {
            TerminalRule slRule = access.getSL_COMMENTRule();
            for (AbstractElement element : ((Group)slRule.getAlternatives()).getElements()) {
                if (!(element instanceof Keyword)) continue;
                $c$value = (Keyword)element;
                this.slPrefix = $c$value.getValue().trim();
                break;
            }
        }
    }

    @Override
    @Pure
    public String formatMultilineComment(String doc) {
        return this.formatMultilineComment(doc, (String)null);
    }

    @Override
    @Pure
    public String formatMultilineComment(String doc, String indentation) {
        StringBuilderBasedAppendable appendable = new StringBuilderBasedAppendable();
        this.formatMultilineComment(doc, indentation, (IAppendable)appendable);
        return appendable.getContent();
    }

    @Override
    @Pure
    public void formatMultilineComment(String doc, IAppendable appendable) {
        this.formatMultilineComment(doc, null, appendable);
    }

    @Override
    @Pure
    public void formatMultilineComment(String doc, String indentation, IAppendable appendable) {
        if (!Strings.isEmpty((String)doc)) {
            TreeMap<Integer, Replacement> replacements = new TreeMap<Integer, Replacement>();
            this.formatMultlineComment(indentation, Strings.newLine(), new AppendableAccessor(appendable, doc, replacements, 0, doc.length()));
        }
    }

    @Override
    @Pure
    public void formatMultilineComment(ITextReplacerContext context, IComment comment) {
        this.formatMultlineComment(context.getIndentationString(), context.getNewLinesString(1), new RegionAccessor(context, comment));
    }

    @Override
    @Pure
    public String formatSinglelineComment(String doc) {
        return this.formatSinglelineComment(doc, (String)null);
    }

    @Override
    @Pure
    public String formatSinglelineComment(String doc, String indentation) {
        StringBuilderBasedAppendable appendable = new StringBuilderBasedAppendable();
        this.formatSinglelineComment(doc, indentation, (IAppendable)appendable);
        return appendable.getContent();
    }

    @Override
    @Pure
    public void formatSinglelineComment(String doc, IAppendable appendable) {
        this.formatSinglelineComment(doc, null, appendable);
    }

    @Override
    @Pure
    public void formatSinglelineComment(String doc, String indentation, IAppendable appendable) {
        if (!Strings.isEmpty((String)doc)) {
            int endOffset;
            TreeMap<Integer, Replacement> replacements = new TreeMap<Integer, Replacement>();
            int offset = doc.indexOf(this.getSinglelineCommentPrefix());
            if (offset < 0) {
                offset = 0;
            }
            if ((endOffset = doc.indexOf(NL_CHAR, offset)) < 0) {
                endOffset = doc.length();
            }
            this.formatSinglelineComment(indentation, new AppendableAccessor(appendable, doc, replacements, offset, endOffset));
        }
    }

    @Override
    public void formatSinglelineComment(ITextReplacerContext context, IComment comment) {
        this.formatSinglelineComment(context.getIndentationString(), new RegionAccessor(context, comment));
    }

    private <T> void formatSinglelineComment(String indentationString, FormattedTextAccessor<T> backend) {
        String indent = Strings.emptyIfNull((String)indentationString);
        String comment = backend.getCommentText();
        int offset = comment.indexOf(this.getSinglelineCommentPrefix());
        if (offset < 0) {
            backend.replace(0, 0, this.getSinglelineCommentPrefix());
            offset = 0;
        } else {
            offset += this.getSinglelineCommentPrefix().length();
        }
        int endOffset = comment.length();
        T currentLine = backend.getFirstLine(backend.getCommentOffset());
        boolean firstLine = true;
        while (currentLine != null) {
            int firstNonWhiteSpacePos;
            int realCommentStart;
            String lineText = backend.getLineText(currentLine);
            int lineOffset = backend.getLineOffset(currentLine);
            int lineLength = backend.getLineLength(currentLine);
            if (firstLine) {
                if (lineOffset < offset) {
                    int len = offset - lineOffset;
                    lineText = lineText.substring(len);
                    lineOffset += len;
                    lineLength -= len;
                }
            } else {
                if (lineOffset >= endOffset) {
                    backend.applyReplacements();
                    return;
                }
                Object prefix = !DocumentationFormatter.startsWith(lineText, 0, this.getSinglelineCommentPrefix()) ? indent + this.getSinglelineCommentPrefix() : indent;
                backend.replace(lineOffset, 0, (String)prefix);
            }
            Set<Character> specialChars = this.getSinglelineCommentSpecialChars();
            for (realCommentStart = 0; realCommentStart < lineLength && specialChars.contains(Character.valueOf(lineText.charAt(realCommentStart))); ++realCommentStart) {
            }
            for (firstNonWhiteSpacePos = realCommentStart; firstNonWhiteSpacePos < lineLength && Character.isWhitespace(lineText.charAt(firstNonWhiteSpacePos)); ++firstNonWhiteSpacePos) {
            }
            if (firstNonWhiteSpacePos == lineLength) {
                if (realCommentStart < firstNonWhiteSpacePos) {
                    backend.replace(realCommentStart + lineOffset, lineLength - realCommentStart, EMPTY_STR);
                }
            } else {
                int nbWhiteSpaces = firstNonWhiteSpacePos - realCommentStart;
                int expectedNbWhiteSpaces = this.getWhiteSpacesOnFirstLine();
                if (nbWhiteSpaces != expectedNbWhiteSpaces) {
                    backend.replace(realCommentStart + lineOffset, nbWhiteSpaces, DocumentationFormatter.makeWhiteSpaces(expectedNbWhiteSpaces));
                }
                this.formatLineText(lineText.substring(firstNonWhiteSpacePos, lineLength), true, new SubAccessor<T>(this, backend, lineOffset + firstNonWhiteSpacePos));
                int endOfText = lineLength;
                while (endOfText - 1 > firstNonWhiteSpacePos && Character.isWhitespace(lineText.charAt(endOfText - 1))) {
                    --endOfText;
                }
                if (endOfText < lineLength) {
                    backend.replace(endOfText + lineOffset, lineLength - endOfText, EMPTY_STR);
                }
            }
            firstLine = false;
            currentLine = backend.getNextLine(currentLine);
        }
        backend.applyReplacements();
    }

    private static String safeSubstring(String text, int start, int length) {
        if (text == null) {
            return EMPTY_STR;
        }
        int index = Math.max(0, start);
        int len = Math.max(0, Math.min(length, text.length()));
        return text.substring(index, index + len);
    }

    private static boolean startsWith(String text, int start, String pattern) {
        return DocumentationFormatter.safeSubstring(text, start, pattern.length()).equals(pattern);
    }

    private static String makeWhiteSpaces(int nb) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < nb; ++i) {
            b.append(SPACE_CHAR);
        }
        return b.toString();
    }

    protected int getWhiteSpacesOnFirstLine() {
        return 1;
    }

    protected int getWhiteSpacesOnOtherLines() {
        return 1;
    }

    protected <T> void formatLineText(String lineText, boolean isMultlineComment, FormattedTextAccessor<T> backend) {
    }

    private <T> boolean formatMultlineCommentFirstLine(String lineText, String indentationString, String newLineString, int endCommentOffset, FormattedTextAccessor<T> backend) {
        int firstNonWhiteSpacePos;
        int realCommentStart;
        for (realCommentStart = 0; realCommentStart < lineText.length() && DocumentationFormatter.startsWith(lineText, realCommentStart, this.getMultilineCommentLinePrefix()); realCommentStart += this.getMultilineCommentLinePrefix().length()) {
        }
        boolean hasNonSpaceChar = false;
        for (firstNonWhiteSpacePos = realCommentStart; firstNonWhiteSpacePos < lineText.length() && Character.isWhitespace(lineText.charAt(firstNonWhiteSpacePos)); ++firstNonWhiteSpacePos) {
            if (Character.isSpaceChar(lineText.charAt(firstNonWhiteSpacePos))) continue;
            hasNonSpaceChar = true;
        }
        int expectedNbWhiteSpaces = this.getWhiteSpacesOnFirstLine();
        int nbWhiteSpaces = firstNonWhiteSpacePos - realCommentStart;
        if (hasNonSpaceChar || nbWhiteSpaces != expectedNbWhiteSpaces) {
            backend.replace(realCommentStart, nbWhiteSpaces, DocumentationFormatter.makeWhiteSpaces(expectedNbWhiteSpaces));
        }
        if (endCommentOffset <= lineText.length()) {
            int endPos;
            int end = endPos = endCommentOffset;
            while (endPos - 1 > firstNonWhiteSpacePos && Character.isWhitespace(lineText.charAt(endPos - 1))) {
                --endPos;
            }
            this.formatLineText(lineText.substring(firstNonWhiteSpacePos, endPos), true, new SubAccessor<T>(this, backend, firstNonWhiteSpacePos));
            backend.replace(endPos, end - endPos, newLineString + indentationString + SPACE_CHAR);
            return true;
        }
        this.formatLineText(lineText.substring(firstNonWhiteSpacePos, lineText.length()), true, new SubAccessor<T>(this, backend, firstNonWhiteSpacePos));
        return false;
    }

    private <T> boolean formatMultlineCommentOtherLines(String lineText, String indentationString, String newLineString, int endCommentOffset, FormattedTextAccessor<T> backend) {
        int realCommentStart;
        for (realCommentStart = 0; realCommentStart < lineText.length() && Character.isWhitespace(lineText.charAt(realCommentStart)); ++realCommentStart) {
        }
        boolean foundStar = false;
        if (realCommentStart < lineText.length() && DocumentationFormatter.startsWith(lineText, realCommentStart, this.getMultilineCommentLinePrefix())) {
            realCommentStart += this.getMultilineCommentLinePrefix().length();
            foundStar = true;
            while (realCommentStart < lineText.length() && Character.isWhitespace(lineText.charAt(realCommentStart))) {
                ++realCommentStart;
            }
        }
        StringBuilder prefix = new StringBuilder(indentationString);
        prefix.append(SPACE_CHAR);
        prefix.append(this.getMultilineCommentLinePrefix());
        prefix.append(DocumentationFormatter.makeWhiteSpaces(this.getWhiteSpacesOnOtherLines()));
        int minBoundForEnd = 0;
        if (endCommentOffset > lineText.length() || foundStar || realCommentStart < endCommentOffset) {
            backend.replace(0, realCommentStart, prefix.toString());
            if (foundStar) {
                minBoundForEnd = prefix.length();
            }
        }
        if (endCommentOffset <= lineText.length()) {
            int endPosition;
            int end = endPosition = endCommentOffset;
            while (endPosition - 1 >= minBoundForEnd && Character.isWhitespace(lineText.charAt(endPosition - 1))) {
                --endPosition;
            }
            if (endPosition > 0) {
                backend.replace(endPosition, end - endPosition, newLineString + indentationString + SPACE_CHAR);
            } else {
                backend.replace(endPosition, end - endPosition, indentationString + SPACE_CHAR);
            }
            return true;
        }
        return false;
    }

    private <T> void formatMultlineComment(String indentationString, String newLineString, FormattedTextAccessor<T> backend) {
        String indent = Strings.emptyIfNull((String)indentationString);
        String comment = backend.getCommentText();
        int offset = comment.indexOf(this.getMultilineCommentStartSymbols());
        if (offset < 0) {
            backend.replace(0, 0, this.getMultilineCommentStartSymbols());
            offset = 0;
        } else {
            offset += this.getMultilineCommentStartSymbols().length();
        }
        int endOffset = comment.indexOf(this.getMultilineCommentEndSymbols(), offset);
        if (endOffset < 0) {
            endOffset = comment.length();
            backend.replace(endOffset, 0, this.getMultilineCommentEndSymbols());
        }
        T currentLine = backend.getFirstLine(backend.getCommentOffset());
        boolean firstLine = true;
        while (currentLine != null) {
            int len;
            String lineText = backend.getLineText(currentLine);
            int lineOffset = backend.getLineOffset(currentLine);
            int lineLength = backend.getLineLength(currentLine);
            if (lineOffset < offset) {
                len = offset - lineOffset;
                lineText = lineText.substring(len);
                lineOffset += len;
                lineLength -= len;
            }
            if (lineOffset + lineLength > endOffset) {
                len = lineOffset + lineLength - endOffset;
                lineText = lineText.substring(0, lineText.length() - len);
                lineLength -= len;
            }
            if (firstLine) {
                if (this.formatMultlineCommentFirstLine(lineText, indent, newLineString, endOffset - lineOffset, new SubAccessor<T>(this, backend, lineOffset))) {
                    backend.applyReplacements();
                    return;
                }
            } else if (this.formatMultlineCommentOtherLines(lineText, indent, newLineString, endOffset - lineOffset, new SubAccessor<T>(this, backend, lineOffset))) {
                backend.applyReplacements();
                return;
            }
            firstLine = false;
            currentLine = backend.getNextLine(currentLine);
        }
        backend.applyReplacements();
    }

    private static class AppendableAccessor
    extends AbstractReplacementAccessor<Line> {
        private final IAppendable target;
        private final int commentOffset;
        private final int commentEndOffset;

        public AppendableAccessor(IAppendable target, String documentation, SortedMap<Integer, Replacement> replacements, int commentOffset, int commentEndOffset) {
            super(documentation, replacements);
            this.target = target;
            this.commentOffset = commentOffset;
            this.commentEndOffset = commentEndOffset;
        }

        @Override
        public Line getFirstLine(int offset) {
            return Line.newInstance(this.getCommentText(), offset);
        }

        @Override
        public Line getNextLine(Line currentLine) {
            int index = this.getCommentText().indexOf(DocumentationFormatter.NL_CHAR, currentLine.getOffset());
            if (index < 0) {
                return null;
            }
            return Line.newInstance(this.getCommentText(), index + 1);
        }

        @Override
        public int getLineOffset(Line currentLine) {
            return currentLine.getOffset();
        }

        @Override
        public int getLineLength(Line currentLine) {
            return currentLine.getLength();
        }

        @Override
        public String getLineText(Line line) {
            int offset = line.getOffset();
            return this.getCommentText().substring(offset, offset + line.getLength());
        }

        @Override
        public int getCommentOffset() {
            return this.commentOffset;
        }

        @Override
        public int getCommentEndOffset() {
            return this.commentEndOffset;
        }

        @Override
        public void applyReplacements() {
            this.checkNotApplied();
            AppendableAccessor.applyReplacements(this.target, this.getCommentText(), this.getReplacements());
        }
    }

    public static interface FormattedTextAccessor<T> {
        public T getFirstLine(int var1);

        public T getNextLine(T var1);

        public int getLineOffset(T var1);

        public int getLineLength(T var1);

        public String getLineText(T var1);

        public String getCommentText();

        public int getCommentOffset();

        public int getCommentEndOffset();

        public Replacement replace(int var1, int var2, String var3);

        public void applyReplacements();
    }

    public static class RegionAccessor
    extends AbstractReplacementAccessor<ILineRegion> {
        private final ITextReplacerContext context;
        private final ITextRegionAccess access;
        private final IComment comment;

        public RegionAccessor(ITextReplacerContext context, IComment comment) {
            super(comment.getText(), null);
            this.context = context;
            this.comment = comment;
            this.access = comment.getTextRegionAccess();
        }

        @Override
        public String getCommentText() {
            return this.comment.getText();
        }

        @Override
        public String getLineText(ILineRegion line) {
            ITextSegment segment = this.access.regionForOffset(line.getOffset(), line.getLength());
            return segment.getText();
        }

        @Override
        public int getCommentOffset() {
            return this.comment.getOffset();
        }

        @Override
        public int getCommentEndOffset() {
            return this.comment.getEndOffset();
        }

        @Override
        public ILineRegion getFirstLine(int offset) {
            return this.access.regionForLineAtOffset(offset);
        }

        @Override
        public ILineRegion getNextLine(ILineRegion currentLine) {
            return currentLine.getNextLine();
        }

        @Override
        public int getLineOffset(ILineRegion currentLine) {
            return currentLine.getOffset() - this.getCommentOffset();
        }

        @Override
        public int getLineLength(ILineRegion currentLine) {
            return currentLine.getLength();
        }

        @Override
        public void applyReplacements() {
            this.checkNotApplied();
            for (Replacement replacement : this.getReplacements().values()) {
                ITextSegment target = this.access.regionForOffset(replacement.getOffset() + this.getCommentOffset(), replacement.getLength());
                this.context.addReplacement(target.replaceWith(replacement.getText()));
            }
        }
    }

    public static class Replacement {
        private final int offset;
        private final int length;
        private final String text;

        public Replacement(int offset, int length, String text) {
            this.offset = offset;
            this.length = length;
            this.text = text;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String getText() {
            return this.text;
        }

        public String toString() {
            return "offset: " + this.getOffset() + "; length: " + this.getLength() + "; new text: " + this.getText();
        }
    }

    public class SubAccessor<T>
    implements FormattedTextAccessor<T> {
        private final FormattedTextAccessor<T> parent;
        private final int offsetInParent;

        public SubAccessor(DocumentationFormatter this$0, FormattedTextAccessor<T> parent, int offsetInParent) {
            assert (parent != null);
            this.parent = parent;
            this.offsetInParent = offsetInParent;
        }

        @Override
        public T getFirstLine(int offset) {
            return this.parent.getFirstLine(offset);
        }

        @Override
        public T getNextLine(T currentLine) {
            return this.parent.getNextLine(currentLine);
        }

        @Override
        public int getLineOffset(T currentLine) {
            return this.parent.getLineOffset(currentLine);
        }

        @Override
        public int getLineLength(T currentLine) {
            return this.parent.getLineLength(currentLine);
        }

        @Override
        public String getLineText(T line) {
            return this.parent.getLineText(line);
        }

        @Override
        public String getCommentText() {
            return this.parent.getCommentText();
        }

        @Override
        public int getCommentOffset() {
            return this.parent.getCommentOffset();
        }

        @Override
        public int getCommentEndOffset() {
            return this.parent.getCommentEndOffset();
        }

        @Override
        public Replacement replace(int offset, int length, String newText) {
            return this.parent.replace(this.offsetInParent + offset, length, newText);
        }

        @Override
        public final void applyReplacements() {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class AbstractDebuggingAccessor<T>
    extends AbstractReplacementAccessor<T> {
        private String buffer;

        public AbstractDebuggingAccessor(String text, SortedMap<Integer, Replacement> replacements) {
            super(text, replacements);
        }

        private String computeBuffer() {
            FakeTreeAppendable appendable = new FakeTreeAppendable();
            AbstractDebuggingAccessor.applyReplacements((IAppendable)appendable, this.getCommentText(), this.getReplacements());
            return appendable.getContent();
        }

        public String toString() {
            if (this.buffer == null) {
                this.buffer = this.computeBuffer();
            }
            return this.buffer;
        }

        @Override
        public Replacement replace(int offset, int length, String newText) {
            Replacement rep = super.replace(offset, length, newText);
            this.buffer = this.computeBuffer();
            return rep;
        }
    }

    public static abstract class AbstractReplacementAccessor<T>
    implements FormattedTextAccessor<T> {
        private final String documentation;
        private SortedMap<Integer, Replacement> replacements;
        private boolean applied;

        public AbstractReplacementAccessor(String documentation, SortedMap<Integer, Replacement> replacements) {
            this.documentation = documentation;
            this.replacements = replacements;
        }

        protected final void checkNotApplied() {
            if (this.applied) {
                throw new IllegalStateException("Changes are already applied");
            }
            this.applied = true;
        }

        @Override
        public String getCommentText() {
            return this.documentation;
        }

        protected SortedMap<Integer, Replacement> getReplacements() {
            if (this.replacements == null) {
                this.replacements = new TreeMap<Integer, Replacement>();
            }
            return this.replacements;
        }

        @Override
        public Replacement replace(int offset, int length, String newText) {
            Replacement rep = (Replacement)this.getReplacements().remove(offset);
            rep = rep == null ? new Replacement(offset, length, newText) : new Replacement(offset, rep.getLength() + length, rep.getText() + newText);
            this.getReplacements().put(offset, rep);
            return rep;
        }

        protected static void applyReplacements(IAppendable appendable, String text, Map<Integer, Replacement> replacements) {
            int offset = 0;
            for (Replacement replacement : replacements.values()) {
                if (replacement.getOffset() < offset) {
                    appendable.append((CharSequence)"<<<Conflicting replacements>>>");
                    continue;
                }
                assert (offset >= 0);
                assert (replacement.getOffset() <= text.length());
                String notReplacedString = text.substring(offset, replacement.getOffset());
                appendable.append((CharSequence)notReplacedString);
                offset += notReplacedString.length();
                appendable.append((CharSequence)replacement.getText());
                offset += replacement.getLength();
            }
            if (offset < text.length()) {
                String notReplacedString = text.substring(offset);
                appendable.append((CharSequence)notReplacedString);
            }
        }
    }

    public static class Line {
        private final int offset;
        private final int length;

        public static Line newInstance(String text, int offset) {
            int eoffset;
            int soffset;
            if (offset < 0 || offset >= text.length()) {
                return null;
            }
            for (soffset = offset; soffset >= 0 && !DocumentationFormatter.isNewLine(text.charAt(soffset)); --soffset) {
            }
            for (eoffset = ++soffset; eoffset < text.length() && !DocumentationFormatter.isNewLine(text.charAt(eoffset)); ++eoffset) {
            }
            int length = Math.max(0, eoffset - soffset);
            return new Line(soffset, length);
        }

        private Line(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            return "offset: " + this.getOffset() + "; length: " + this.getLength();
        }
    }
}

