/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.documentation;

import io.sarl.lang.documentation.IDocumentationFormatter;
import io.sarl.lang.documentation.IEcoreDocumentationBuilder;
import io.sarl.lang.services.SARLGrammarAccess;
import jakarta.inject.Inject;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Group;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.UntilToken;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Pure;

public class EcoreDocumentationBuilder
implements IEcoreDocumentationBuilder {
    private AbstractRule mlRule;
    private AbstractRule slRule;
    private String mlStartSymbols;
    private String mlEndTagSymbols;
    private String slStartSymbols;
    @Inject
    private IDocumentationFormatter documentationFormatter;

    @Inject
    public void setGrammarAccess(SARLGrammarAccess access) {
        UntilToken $c$value;
        this.mlRule = access.getML_COMMENTRule();
        this.slRule = access.getSL_COMMENTRule();
        for (AbstractElement element : ((Group)this.mlRule.getAlternatives()).getElements()) {
            if (element instanceof Keyword) {
                Keyword $c$value2 = (Keyword)element;
                if (Strings.isEmpty((String)this.mlStartSymbols)) {
                    this.mlStartSymbols = $c$value2.getValue();
                    continue;
                }
            }
            if (!(element instanceof UntilToken)) continue;
            $c$value = (UntilToken)element;
            if (!Strings.isEmpty((String)this.mlEndTagSymbols)) continue;
            this.mlEndTagSymbols = ((Keyword)$c$value.getTerminal()).getValue();
        }
        TerminalRule slRule = access.getSL_COMMENTRule();
        for (AbstractElement element : ((Group)slRule.getAlternatives()).getElements()) {
            if (!(element instanceof Keyword)) continue;
            $c$value = (Keyword)element;
            this.slStartSymbols = $c$value.getValue().trim();
            break;
        }
    }

    @Override
    @Pure
    public AbstractRule getMLCommentRule() {
        return this.mlRule;
    }

    @Override
    @Pure
    public AbstractRule getSLCommentRule() {
        return this.slRule;
    }

    @Override
    @Pure
    public IDocumentationFormatter getDocumentationFormatter() {
        return this.documentationFormatter;
    }

    @Override
    @Pure
    public boolean isMultilineCommentFor(Class<?> type) {
        return XtendMember.class.isAssignableFrom(type);
    }

    @Override
    @Pure
    public String build(String doc, Class<?> objectType) {
        String givenDocumentation = Strings.emptyIfNull((String)doc).trim();
        StringBuilder documentation = new StringBuilder();
        IDocumentationFormatter formatter = this.getDocumentationFormatter();
        if (this.isMultilineCommentFor(objectType)) {
            if (!givenDocumentation.startsWith(this.mlStartSymbols)) {
                documentation.append(this.mlStartSymbols);
            }
            documentation.append(givenDocumentation);
            if (!givenDocumentation.endsWith(this.mlEndTagSymbols)) {
                documentation.append(this.mlEndTagSymbols);
            }
            return formatter.formatMultilineComment(documentation.toString());
        }
        documentation.append("\n");
        if (!givenDocumentation.startsWith(this.slStartSymbols)) {
            documentation.append(this.slStartSymbols);
        }
        documentation.append(givenDocumentation);
        if (!givenDocumentation.isEmpty() && !EcoreDocumentationBuilder.isNewLine(givenDocumentation.charAt(givenDocumentation.length() - 1))) {
            documentation.append("\n");
        }
        return formatter.formatSinglelineComment(documentation.toString());
    }

    private static boolean isNewLine(char character) {
        if (character == '\n' || character == '\r' || character == '\f') {
            return true;
        }
        return (24576 >> Character.getType((int)character) & 1) != 0;
    }
}

