/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.extralanguage;

import com.google.inject.Inject;
import io.sarl.lang.extralanguage.IExtraLanguageContribution;
import io.sarl.lang.extralanguage.IExtraLanguageContributions;
import io.sarl.lang.extralanguage.compiler.IExtraLanguageGeneratorProvider;
import io.sarl.lang.extralanguage.compiler.IRootGenerator;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.IGeneratorContext;

public class ContributionBasedExtraLanguageGeneratorProvider
implements IExtraLanguageGeneratorProvider {
    @Inject
    private IExtraLanguageContributions source;
    private List<IExtraLanguageGeneratorProvider> providers;

    @Override
    public Iterable<IRootGenerator> getGenerators(IGeneratorContext context, Resource resource) {
        ArrayList<IRootGenerator> generators = new ArrayList<IRootGenerator>();
        if (this.providers == null) {
            this.providers = new ArrayList<IExtraLanguageGeneratorProvider>();
            for (IExtraLanguageContribution contribution : this.source.getContributions()) {
                IExtraLanguageGeneratorProvider provider = contribution.getGeneratorProvider();
                if (provider == null) continue;
                this.providers.add(provider);
            }
        }
        for (IExtraLanguageGeneratorProvider provider : this.providers) {
            for (IRootGenerator gen : provider.getGenerators(context, resource)) {
                generators.add(gen);
            }
        }
        return generators;
    }
}

