/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.extralanguage;

import com.google.inject.Inject;
import io.sarl.lang.extralanguage.IExtraLanguageContribution;
import io.sarl.lang.extralanguage.IExtraLanguageContributions;
import io.sarl.lang.extralanguage.validator.AbstractExtraLanguageValidator;
import io.sarl.lang.extralanguage.validator.IExtraLanguageValidatorProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;

public class ContributionBasedExtraLanguageValidatorProvider
implements IExtraLanguageValidatorProvider {
    @Inject
    private IExtraLanguageContributions source;
    private List<IExtraLanguageValidatorProvider> providers;

    @Override
    public List<AbstractExtraLanguageValidator> getValidators(Resource resource) {
        ArrayList<AbstractExtraLanguageValidator> validators = new ArrayList<AbstractExtraLanguageValidator>();
        if (this.providers == null) {
            this.providers = new ArrayList<IExtraLanguageValidatorProvider>();
            for (IExtraLanguageContribution contribution : this.source.getContributions()) {
                IExtraLanguageValidatorProvider provider = contribution.getValidatorProvider();
                if (provider == null) continue;
                this.providers.add(provider);
            }
        }
        for (IExtraLanguageValidatorProvider provider : this.providers) {
            for (AbstractExtraLanguageValidator validator : provider.getValidators(resource)) {
                validators.add(validator);
            }
        }
        return validators;
    }
}

