/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.extralanguage;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import io.sarl.lang.extralanguage.IExtraLanguageContribution;
import io.sarl.lang.extralanguage.IExtraLanguageContributions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ServiceLoader;
import java.util.function.Predicate;

@Singleton
public class JavaPluginExtraLanguageContributions
implements IExtraLanguageContributions {
    @Inject
    private Injector injector;
    private ServiceLoader<IExtraLanguageContribution> serviceLoader;
    private Collection<IExtraLanguageContribution> contributions;
    private Predicate<IExtraLanguageContribution> checker;

    @Override
    public Collection<IExtraLanguageContribution> getContributions() {
        if (this.serviceLoader == null) {
            this.serviceLoader = ServiceLoader.load(IExtraLanguageContribution.class, this.getClass().getClassLoader());
        }
        if (this.contributions == null) {
            this.contributions = new ArrayList<IExtraLanguageContribution>();
            for (IExtraLanguageContribution contrib : this.serviceLoader) {
                if (this.checker != null && !this.checker.test(contrib)) continue;
                this.injector.injectMembers((Object)contrib);
                this.contributions.add(contrib);
            }
        }
        return this.contributions;
    }

    @Override
    public void setContributionChecker(Predicate<IExtraLanguageContribution> checker) {
        this.checker = checker;
    }
}

