/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.extralanguage.compiler;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import io.sarl.lang.extralanguage.compiler.ConversionResult;
import io.sarl.lang.extralanguage.compiler.ExtraLanguageAppendable;
import io.sarl.lang.extralanguage.compiler.ExtraLanguageFeatureNameConverter;
import io.sarl.lang.extralanguage.compiler.ExtraLanguageTypeConverter;
import io.sarl.lang.extralanguage.compiler.IExpressionGenerator;
import io.sarl.lang.extralanguage.compiler.IExtraLanguageConversionInitializer;
import io.sarl.lang.extralanguage.compiler.IExtraLanguageGeneratorContext;
import io.sarl.lang.extralanguage.compiler.IExtraLanguageKeywordProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.persistence.StorageAwareResource;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.featurecalls.IdentifiableSimpleNameProvider;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.util.XExpressionHelper;

public abstract class AbstractExpressionGenerator
implements IExpressionGenerator {
    private static final String TYPE_CONVERTER_INSTANCE = "typeConverterInstance";
    private static final String FEATURE_NAME_CONVERTER_INSTANCE = "featureNameConverterInstance";
    private final PolymorphicDispatcher<XExpression> generateDispatcher;
    private OperatorMapping operatorMapping;
    private TypeReferences typeReferences;
    private XExpressionHelper expressionHelper;
    private IdentifiableSimpleNameProvider featureNameProvider;
    private ILogicalContainerProvider contextProvider;
    private IBatchTypeResolver typeResolver;
    private JvmTypesBuilder jvmTypesBuilder;
    private Injector injector;
    private final IExtraLanguageKeywordProvider keywords;

    public AbstractExpressionGenerator(IExtraLanguageKeywordProvider keywordProvider) {
        assert (keywordProvider != null);
        this.generateDispatcher = new PolymorphicDispatcher("_generate", 3, 3, Collections.singletonList(this));
        this.keywords = keywordProvider;
    }

    @Inject
    public void setTypeBuilder(JvmTypesBuilder builder) {
        this.jvmTypesBuilder = builder;
    }

    public JvmTypesBuilder getTypeBuilder() {
        return this.jvmTypesBuilder;
    }

    @Inject
    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    public IExtraLanguageKeywordProvider getExtraLanguageKeywordProvider() {
        return this.keywords;
    }

    @Inject
    public void setTypeResolver(IBatchTypeResolver resolver) {
        this.typeResolver = resolver;
    }

    public IBatchTypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Inject
    public void setLogicalContainerProvider(ILogicalContainerProvider provider) {
        this.contextProvider = provider;
    }

    public ILogicalContainerProvider getLogicalContainerProvider() {
        return this.contextProvider;
    }

    @Inject
    public void setFeatureNameProvider(IdentifiableSimpleNameProvider provider) {
        this.featureNameProvider = provider;
    }

    public IdentifiableSimpleNameProvider getFeatureNameProvider() {
        return this.featureNameProvider;
    }

    @Inject
    public void setExpressionHelper(XExpressionHelper helper) {
        this.expressionHelper = helper;
    }

    public XExpressionHelper getExpressionHelper() {
        return this.expressionHelper;
    }

    @Inject
    public void setTypeReferences(TypeReferences finder) {
        this.typeReferences = finder;
    }

    public TypeReferences getTypeReferences() {
        return this.typeReferences;
    }

    @Inject
    public void setOperatorMapping(OperatorMapping mapping) {
        this.operatorMapping = mapping;
    }

    public OperatorMapping getOperatorMapping() {
        return this.operatorMapping;
    }

    protected LightweightTypeReference getExpectedType(XExpression expr) {
        IResolvedTypes resolvedTypes = this.getTypeResolver().resolveTypes((EObject)expr);
        LightweightTypeReference actualType = resolvedTypes.getActualType(expr);
        return actualType;
    }

    protected IExtraLanguageConversionInitializer getTypeConverterInitializer() {
        return null;
    }

    @Override
    public ExtraLanguageTypeConverter getTypeConverter(IExtraLanguageGeneratorContext context) {
        ExtraLanguageTypeConverter converter = context.getData(TYPE_CONVERTER_INSTANCE, ExtraLanguageTypeConverter.class);
        if (converter == null) {
            converter = this.createTypeConverterInstance(this.getTypeConverterInitializer(), context);
            this.injector.injectMembers((Object)converter);
            context.setData(TYPE_CONVERTER_INSTANCE, converter);
        }
        return converter;
    }

    protected ExtraLanguageTypeConverter createTypeConverterInstance(IExtraLanguageConversionInitializer initializer, IExtraLanguageGeneratorContext context) {
        return new ExtraLanguageTypeConverter(initializer, context);
    }

    protected IExtraLanguageConversionInitializer getFeatureNameConverterInitializer() {
        return null;
    }

    @Override
    public ExtraLanguageFeatureNameConverter getFeatureNameConverter(IExtraLanguageGeneratorContext context) {
        ExtraLanguageFeatureNameConverter converter = context.getData(FEATURE_NAME_CONVERTER_INSTANCE, ExtraLanguageFeatureNameConverter.class);
        if (converter == null) {
            converter = this.createFeatureNameConverterInstance(this.getFeatureNameConverterInitializer(), context);
            this.injector.injectMembers((Object)converter);
            context.setData(TYPE_CONVERTER_INSTANCE, converter);
        }
        return converter;
    }

    protected ExtraLanguageFeatureNameConverter createFeatureNameConverterInstance(IExtraLanguageConversionInitializer initializer, IExtraLanguageGeneratorContext context) {
        return new ExtraLanguageFeatureNameConverter(initializer, context, this.getExtraLanguageKeywordProvider());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XExpression generate(XExpression expression, LightweightTypeReference expectedType, IAppendable output, IExtraLanguageGeneratorContext context) {
        LightweightTypeReference old = context.setExpectedExpressionType(expectedType);
        try {
            this.before(expression, output, context);
            XExpression xExpression = (XExpression)this.generateDispatcher.invoke(new Object[]{expression, output, context});
            return xExpression;
        }
        finally {
            this.after(expression, output, context);
            context.setExpectedExpressionType(old);
        }
    }

    protected void before(XExpression expression, IAppendable output, IExtraLanguageGeneratorContext context) {
    }

    protected void after(XExpression expression, IAppendable output, IExtraLanguageGeneratorContext context) {
    }

    protected String getOperatorSymbol(XAbstractFeatureCall call) {
        if (call != null) {
            StorageAwareResource cvalue;
            boolean isLoadedFromStorage;
            Resource res = call.eResource();
            if (res instanceof StorageAwareResource && (isLoadedFromStorage = (cvalue = (StorageAwareResource)res).isLoadedFromStorage())) {
                QualifiedName operator = this.getOperatorMapping().getOperator(QualifiedName.create((String)call.getFeature().getSimpleName()));
                return Objects.toString(operator);
            }
            return call.getConcreteSyntaxFeatureName();
        }
        return null;
    }

    public static String getCallSimpleName(XAbstractFeatureCall featureCall, ILogicalContainerProvider logicalContainerProvider, IdentifiableSimpleNameProvider featureNameProvider, Functions.Function0<? extends String> nullKeyword, Functions.Function0<? extends String> thisKeyword, Functions.Function0<? extends String> superKeyword, Functions.Function1<? super JvmIdentifiableElement, ? extends String> referenceNameLambda) {
        String name = null;
        JvmIdentifiableElement calledFeature = featureCall.getFeature();
        if (calledFeature instanceof JvmConstructor) {
            JvmConstructor cvalue = (JvmConstructor)calledFeature;
            JvmDeclaredType constructorContainer = cvalue.getDeclaringType();
            JvmIdentifiableElement logicalContainer = logicalContainerProvider.getNearestLogicalContainer((EObject)featureCall);
            JvmDeclaredType contextType = ((JvmMember)logicalContainer).getDeclaringType();
            name = contextType == constructorContainer ? (String)thisKeyword.apply() : (String)superKeyword.apply();
        } else if (calledFeature != null) {
            String referenceName = (String)referenceNameLambda.apply((Object)calledFeature);
            name = referenceName != null ? referenceName : (calledFeature instanceof JvmOperation ? featureNameProvider.getSimpleName(calledFeature) : featureCall.getConcreteSyntaxFeatureName());
        }
        if (name == null) {
            return (String)nullKeyword.apply();
        }
        return name;
    }

    public static boolean buildCallReceiver(XAbstractFeatureCall call, Functions.Function0<? extends String> thisKeyword, Functions.Function1<? super XExpression, ? extends String> referenceNameDefinition, List<Object> output) {
        if (call.isStatic()) {
            XMemberFeatureCall memberFeatureCall;
            if (call instanceof XMemberFeatureCall && (memberFeatureCall = (XMemberFeatureCall)call).isStaticWithDeclaringType()) {
                XAbstractFeatureCall target = (XAbstractFeatureCall)memberFeatureCall.getMemberCallTarget();
                JvmType declaringType = (JvmType)target.getFeature();
                output.add(declaringType);
                return true;
            }
            output.add(((JvmFeature)call.getFeature()).getDeclaringType());
            return true;
        }
        XExpression receiver = call.getActualReceiver();
        if (receiver == null) {
            return false;
        }
        XExpression implicit = call.getImplicitReceiver();
        if (receiver == implicit) {
            output.add(thisKeyword.apply());
        } else {
            String referenceName;
            XAbstractFeatureCall cvalue;
            output.add(receiver);
            if (receiver instanceof XAbstractFeatureCall && (cvalue = (XAbstractFeatureCall)receiver).getFeature() instanceof JvmType && (referenceName = (String)referenceNameDefinition.apply((Object)receiver)) != null && referenceName.length() == 0) {
                return false;
            }
        }
        return true;
    }

    protected abstract class FeatureCallGenerator {
        protected final IExtraLanguageGeneratorContext context;
        protected final ExtraLanguageAppendable codeReceiver;
        private final Functions.Function1<? super XExpression, ? extends String> referenceNameLambda;
        private final Functions.Function1<? super JvmIdentifiableElement, ? extends String> referenceNameLambda2;

        protected FeatureCallGenerator(IExtraLanguageGeneratorContext context, ExtraLanguageAppendable codeReceiver) {
            this.context = context;
            this.codeReceiver = codeReceiver;
            this.referenceNameLambda = expr -> this.getReferenceName((XExpression)expr);
            this.referenceNameLambda2 = expr -> {
                if (this.codeReceiver.hasName(expr)) {
                    return this.codeReceiver.getName(expr);
                }
                return null;
            };
        }

        private XExpression normalizeBlockExpression(XExpression expr) {
            XBlockExpression block;
            if (expr instanceof XBlockExpression && (block = (XBlockExpression)expr).getExpressions().size() == 1) {
                return this.normalizeBlockExpression((XExpression)block.getExpressions().get(0));
            }
            return expr;
        }

        private List<XExpression> getActualArguments(XAbstractFeatureCall expr) {
            EList actualArguments = expr.getActualArguments();
            return Lists.transform((List)actualArguments, it -> this.normalizeBlockExpression((XExpression)it));
        }

        private List<XExpression> getActualArguments(XConstructorCall expr) {
            EList actualArguments = expr.getArguments();
            return Lists.transform((List)actualArguments, it -> this.normalizeBlockExpression((XExpression)it));
        }

        public void generate(XAbstractFeatureCall expr) {
            XMemberFeatureCall cvalue;
            if (expr.isTypeLiteral()) {
                JvmType type = (JvmType)expr.getFeature();
                this.codeReceiver.append(type);
            } else if (expr instanceof XMemberFeatureCall && (cvalue = (XMemberFeatureCall)expr).isNullSafe()) {
                this.featureCalltoJavaExpression(expr, (Functions.Function0<? extends XExpression>)((Functions.Function0)() -> expr));
            } else {
                this.featureCalltoJavaExpression(expr, null);
            }
        }

        public void generate(XConstructorCall expr) {
            ArrayList<Object> leftOperand = new ArrayList<Object>();
            ArrayList<Object> receiver = new ArrayList<Object>();
            JvmConstructor feature = expr.getConstructor();
            List<XExpression> args = this.getActualArguments(expr);
            JvmDeclaredType type = expr.getConstructor().getDeclaringType();
            this.codeReceiver.getImportManager().addImportFor((JvmType)type);
            this.internalAppendCall((JvmIdentifiableElement)feature, leftOperand, receiver, type.getSimpleName(), args, null);
        }

        private boolean needMultiAssignment(XAbstractFeatureCall expr) {
            if (expr instanceof XBinaryOperation) {
                XBinaryOperation binaryOperation = (XBinaryOperation)expr;
                return binaryOperation.isReassignFirstArgument();
            }
            return false;
        }

        private String getReferenceName(XExpression expr) {
            XFeatureCall featureCall;
            if (this.codeReceiver.hasName(expr)) {
                return this.codeReceiver.getName(expr);
            }
            if (expr instanceof XFeatureCall && this.codeReceiver.hasName((featureCall = (XFeatureCall)expr).getFeature())) {
                return this.codeReceiver.getName(featureCall.getFeature());
            }
            return null;
        }

        private void buildLeftOperand(XAbstractFeatureCall expr, List<Object> output) {
            XBinaryOperation binaryOperation = (XBinaryOperation)expr;
            XAbstractFeatureCall leftOperand = (XAbstractFeatureCall)binaryOperation.getLeftOperand();
            JvmIdentifiableElement feature = leftOperand.getFeature();
            if (this.codeReceiver.hasName(feature)) {
                output.add(this.codeReceiver.getName(feature));
                return;
            }
            AbstractExpressionGenerator.buildCallReceiver(leftOperand, AbstractExpressionGenerator.this.getExtraLanguageKeywordProvider().getThisKeywordLambda(), this.referenceNameLambda, output);
            output.add(feature.getSimpleName());
        }

        private void featureCalltoJavaExpression(XAbstractFeatureCall call, Functions.Function0<? extends XExpression> beginOfBlock) {
            ArrayList<Object> leftOperand = new ArrayList<Object>();
            if (this.needMultiAssignment(call)) {
                this.buildLeftOperand(call, leftOperand);
            }
            ArrayList<Object> receiver = new ArrayList<Object>();
            AbstractExpressionGenerator.buildCallReceiver(call, AbstractExpressionGenerator.this.getExtraLanguageKeywordProvider().getThisKeywordLambda(), this.referenceNameLambda, receiver);
            JvmIdentifiableElement feature = call.getFeature();
            List<XExpression> args = null;
            if (feature instanceof JvmExecutable) {
                args = this.getActualArguments(call);
            }
            String name = AbstractExpressionGenerator.getCallSimpleName(call, AbstractExpressionGenerator.this.getLogicalContainerProvider(), AbstractExpressionGenerator.this.getFeatureNameProvider(), AbstractExpressionGenerator.this.getExtraLanguageKeywordProvider().getNullKeywordLambda(), AbstractExpressionGenerator.this.getExtraLanguageKeywordProvider().getThisKeywordLambda(), AbstractExpressionGenerator.this.getExtraLanguageKeywordProvider().getSuperKeywordLambda(), this.referenceNameLambda2);
            this.internalAppendCall(feature, leftOperand, receiver, name, args, beginOfBlock);
        }

        private void internalAppendCall(JvmIdentifiableElement calledFeature, List<Object> leftOperand, List<Object> receiver, String name, List<XExpression> args, Functions.Function0<? extends XExpression> beginOfBlock) {
            ExtraLanguageFeatureNameConverter converter = AbstractExpressionGenerator.this.getFeatureNameConverter(this.context);
            ConversionResult result = converter.convertFeatureCall(name, calledFeature, leftOperand, receiver, args);
            if (result != null) {
                if (result.isFeatureRenaming()) {
                    this.appendCall(calledFeature, leftOperand, receiver, result.toString(), args, beginOfBlock);
                } else {
                    for (Object obj : result.toComplexConversion()) {
                        if (obj instanceof CharSequence) {
                            CharSequence cvalue = (CharSequence)obj;
                            this.codeReceiver.append(cvalue);
                            continue;
                        }
                        if (obj instanceof JvmType) {
                            JvmType cvalue = (JvmType)obj;
                            this.codeReceiver.append(cvalue);
                            continue;
                        }
                        if (obj instanceof LightweightTypeReference) {
                            LightweightTypeReference cvalue = (LightweightTypeReference)obj;
                            this.codeReceiver.append(cvalue);
                            continue;
                        }
                        if (!(obj instanceof XExpression)) continue;
                        XExpression cvalue = (XExpression)obj;
                        AbstractExpressionGenerator.this.generate(cvalue, (IAppendable)this.codeReceiver, this.context);
                    }
                }
            }
        }

        protected abstract void appendCall(JvmIdentifiableElement var1, List<Object> var2, List<Object> var3, String var4, List<XExpression> var5, Functions.Function0<? extends XExpression> var6);
    }
}

