/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.extralanguage.compiler;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import io.sarl.lang.extralanguage.compiler.ExtraLanguageAppendable;
import io.sarl.lang.extralanguage.compiler.ExtraLanguageFeatureNameConverter;
import io.sarl.lang.extralanguage.compiler.ExtraLanguageGeneratorContext;
import io.sarl.lang.extralanguage.compiler.ExtraLanguageTypeConverter;
import io.sarl.lang.extralanguage.compiler.IExpressionGenerator;
import io.sarl.lang.extralanguage.compiler.IExtraLanguageGeneratorContext;
import io.sarl.lang.extralanguage.compiler.IRootGenerator;
import io.sarl.lang.jvmmodel.SarlJvmModelAssociations;
import io.sarl.lang.sarl.SarlConstructor;
import io.sarl.lang.sarl.SarlScript;
import io.sarl.lang.sarl.actionprototype.IActionPrototypeProvider;
import io.sarl.lang.util.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.XtendExecutable;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.IAppendable;
import org.eclipse.xtext.xbase.compiler.ImportManager;
import org.eclipse.xtext.xbase.controlflow.IEarlyExitComputer;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeExtensions;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.osgi.framework.Bundle;

public abstract class AbstractExtraLanguageGenerator
extends AbstractGenerator
implements IRootGenerator {
    private static final String FILENAME_SEPARATOR = "/";
    private final PolymorphicDispatcher<Void> beforeDispatcher = new PolymorphicDispatcher<Void>(this, "_before", 2, 2, Collections.singletonList(this)){

        protected Void handleNoSuchMethod(Object ... params) {
            return null;
        }
    };
    private final PolymorphicDispatcher<Void> generateDispatcher = new PolymorphicDispatcher("_generate", 2, 2, Collections.singletonList(this));
    private final PolymorphicDispatcher<Void> generateDispatcher2 = new PolymorphicDispatcher("_generate", 3, 3, Collections.singletonList(this));
    private final PolymorphicDispatcher<Void> afterDispatcher = new PolymorphicDispatcher<Void>(this, "_after", 2, 2, Collections.singletonList(this)){

        protected Void handleNoSuchMethod(Object ... params) {
            return null;
        }
    };
    private IQualifiedNameProvider qualifiedNameProvider;
    private IQualifiedNameConverter qualifiedNameConverter;
    private JvmTypesBuilder jvmTypesBuilder;
    private TypeReferences typeReferences;
    private JvmTypeExtensions jvmTypeExtensions;
    private IActionPrototypeProvider actionPrototypeProvider;
    private SarlJvmModelAssociations sarlAssociations;
    private IEarlyExitComputer earlyExitComputer;
    private Injector injector;
    private IBatchTypeResolver typeResolver;
    private CommonTypeComputationServices services;

    public static List<Pair<String, String>> loadPropertyFile(String filename, ExtraLanguageSupportModule bundledPlugin, Class<?> readerClass) {
        URL url = bundledPlugin != null ? FileLocator.find((Bundle)bundledPlugin.getBundle(), (IPath)Path.fromPortableString((String)filename), null) : readerClass.getClassLoader().getResource(filename);
        if (url == null) {
            return Lists.newArrayList();
        }
        OrderedProperties properties = new OrderedProperties();
        try (InputStream is = url.openStream();){
            properties.load(is);
        }
        catch (IOException exception) {
            if (bundledPlugin != null) {
                bundledPlugin.logException(exception);
            }
            throw new RuntimeException(exception);
        }
        return properties.getOrderedProperties();
    }

    public ExtraLanguageTypeConverter getTypeConverter(IExtraLanguageGeneratorContext context) {
        return this.getExpressionGenerator().getTypeConverter(context);
    }

    public ExtraLanguageFeatureNameConverter getFeatureNameConverter(IExtraLanguageGeneratorContext context) {
        return this.getExpressionGenerator().getFeatureNameConverter(context);
    }

    @Inject
    public void setCommonTypeComputationServices(CommonTypeComputationServices services) {
        this.services = services;
    }

    @Inject
    public void setTypeReferences(TypeReferences finder) {
        this.typeReferences = finder;
    }

    public TypeReferences getTypeReferences() {
        return this.typeReferences;
    }

    @Inject
    public void setTypeResolver(IBatchTypeResolver resolver) {
        this.typeResolver = resolver;
    }

    public IBatchTypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    @Inject
    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    protected Injector getInjector() {
        return this.injector;
    }

    @Inject
    public void setEarlyExitComputer(IEarlyExitComputer computer) {
        this.earlyExitComputer = computer;
    }

    public IEarlyExitComputer getEarlyExitComputer() {
        return this.earlyExitComputer;
    }

    @Inject
    public void setJvmModelAssociations(SarlJvmModelAssociations associations) {
        this.sarlAssociations = associations;
    }

    public SarlJvmModelAssociations getJvmModelAssociations() {
        return this.sarlAssociations;
    }

    @Inject
    public void setLogicalContainerProvider(IActionPrototypeProvider provider) {
        this.actionPrototypeProvider = provider;
    }

    @Inject
    public void setActionPrototypeProvider(IActionPrototypeProvider provider) {
        this.actionPrototypeProvider = provider;
    }

    public IActionPrototypeProvider getActionPrototypeProvider() {
        return this.actionPrototypeProvider;
    }

    @Inject
    public void setTypeBuilder(JvmTypesBuilder builder) {
        this.jvmTypesBuilder = builder;
    }

    public JvmTypesBuilder getTypeBuilder() {
        return this.jvmTypesBuilder;
    }

    @Inject
    public void setTypeExtensions(JvmTypeExtensions provider) {
        this.jvmTypeExtensions = provider;
    }

    public JvmTypeExtensions getTypeExtensions() {
        return this.jvmTypeExtensions;
    }

    @Inject
    public void setQualifiedNameConverter(IQualifiedNameConverter converter) {
        this.qualifiedNameConverter = converter;
    }

    public IQualifiedNameConverter getQualifiedNameConverter() {
        return this.qualifiedNameConverter;
    }

    @Inject
    public void setQualifiedNameProvider(IQualifiedNameProvider provider) {
        this.qualifiedNameProvider = provider;
    }

    public IQualifiedNameProvider getQualifiedNameProvider() {
        return this.qualifiedNameProvider;
    }

    protected XExpression getAssociatedExpression(JvmMember object) {
        StringConcatenationClient template;
        Procedures.Procedure1 strategy;
        XExpression expr = this.getTypeBuilder().getExpression(object);
        if (expr != null || (strategy = this.getTypeExtensions().getCompilationStrategy((JvmIdentifiableElement)object)) != null || (template = this.getTypeExtensions().getCompilationTemplate((JvmIdentifiableElement)object)) != null) {
            // empty if block
        }
        return expr;
    }

    public abstract IExpressionGenerator getExpressionGenerator();

    protected String toFilename(QualifiedName name, String separator) {
        List segments = name.getSegments();
        if (segments.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(name.toString(separator));
        builder.append(this.getFilenameExtension());
        return builder.toString();
    }

    protected String toFilename(QualifiedName name) {
        return this.toFilename(name, FILENAME_SEPARATOR);
    }

    protected abstract String getFilenameExtension();

    protected abstract String getOutputConfigurationName();

    protected boolean writeFile(QualifiedName name, ExtraLanguageAppendable appendable, IExtraLanguageGeneratorContext context) {
        ExtraLanguageAppendable fileAppendable = this.createAppendable(null, context);
        this.generateFileHeader(name, fileAppendable, context);
        ImportManager importManager = appendable.getImportManager();
        if (importManager != null && !importManager.getImports().isEmpty()) {
            for (String imported : importManager.getImports()) {
                QualifiedName qn = this.getQualifiedNameConverter().toQualifiedName(imported);
                this.generateImportStatement(qn, fileAppendable, context);
            }
            fileAppendable.newLine();
        }
        fileAppendable.append(appendable.getContent());
        String content = fileAppendable.getContent();
        if (!Strings.isEmpty((String)content)) {
            String fileName = this.toFilename(name, FILENAME_SEPARATOR);
            String outputConfiguration = this.getOutputConfigurationName();
            if (Strings.isEmpty((String)outputConfiguration)) {
                context.getFileSystemAccess().generateFile(fileName, (CharSequence)content);
            } else {
                context.getFileSystemAccess().generateFile(fileName, outputConfiguration, (CharSequence)content);
            }
            return true;
        }
        return false;
    }

    protected abstract String getPreferenceID();

    public void beforeGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
        IExtraLanguageGeneratorContext generatorContext = this.createGeneratorContext(fsa, context, input);
        EList contents = input.getContents();
        for (EObject obj : contents) {
            if (!this.canGenerateFor(obj)) continue;
            this.before(obj, generatorContext);
            TreeIterator iterator = EcoreUtil.getAllContents((EObject)obj, (boolean)false);
            while (iterator.hasNext()) {
                EObject subobj = (EObject)iterator.next();
                this.before(subobj, generatorContext);
            }
        }
    }

    protected void initializeContext(IExtraLanguageGeneratorContext generatorContext) {
    }

    public void doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
        IExtraLanguageGeneratorContext generatorContext = this.createGeneratorContext(fsa, context, input);
        this.initializeContext(generatorContext);
        EList contents = input.getContents();
        for (EObject obj : contents) {
            if (!this.canGenerateFor(obj)) continue;
            this.generate(obj, generatorContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGenerate(EObject object, ExtraLanguageAppendable appendable, IExtraLanguageGeneratorContext context) {
        try {
            this.before(object, context);
            this.generate(object, appendable, context);
        }
        finally {
            this.after(object, context);
        }
    }

    public void afterGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
        IExtraLanguageGeneratorContext generatorContext = this.createGeneratorContext(fsa, context, input);
        EList contents = input.getContents();
        for (EObject obj : contents) {
            if (!this.canGenerateFor(obj)) continue;
            TreeIterator iterator = EcoreUtil.getAllContents((EObject)obj, (boolean)false);
            while (iterator.hasNext()) {
                EObject subobj = (EObject)iterator.next();
                this.after(subobj, generatorContext);
            }
            this.after(obj, generatorContext);
        }
    }

    protected IExtraLanguageGeneratorContext createGeneratorContext(IFileSystemAccess2 fsa, IGeneratorContext context, Resource resource) {
        if (context instanceof IExtraLanguageGeneratorContext) {
            IExtraLanguageGeneratorContext cvalue = (IExtraLanguageGeneratorContext)context;
            return cvalue;
        }
        return new ExtraLanguageGeneratorContext(context, fsa, this, resource, this.getPreferenceID());
    }

    protected abstract ExtraLanguageAppendable createAppendable(JvmDeclaredType var1, IExtraLanguageGeneratorContext var2);

    protected boolean canGenerateFor(EObject object) {
        return !(object instanceof JvmIdentifiableElement);
    }

    protected void before(EObject object, IExtraLanguageGeneratorContext context) {
        this.beforeDispatcher.invoke(new Object[]{object, context});
    }

    protected void generate(EObject object, IExtraLanguageGeneratorContext context) {
        this.generateDispatcher.invoke(new Object[]{object, context});
    }

    protected void generate(EObject object, ExtraLanguageAppendable appendable, IExtraLanguageGeneratorContext context) {
        this.generateDispatcher2.invoke(new Object[]{object, appendable, context});
    }

    protected void generate(XExpression expression, LightweightTypeReference needReturn, ExtraLanguageAppendable appendable, IExtraLanguageGeneratorContext context) {
        IExpressionGenerator generator = this.getExpressionGenerator();
        if (generator == null) {
            throw new UnsupportedOperationException();
        }
        generator.generate(expression, needReturn, (IAppendable)appendable, context);
    }

    protected void after(EObject object, IExtraLanguageGeneratorContext context) {
        this.afterDispatcher.invoke(new Object[]{object, context});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _generate(SarlScript script, IExtraLanguageGeneratorContext context) {
        if (script != null) {
            for (XtendTypeDeclaration content : script.getXtendTypes()) {
                if (context.getCancelIndicator().isCanceled()) {
                    return;
                }
                try {
                    this.generate((EObject)content, context);
                }
                finally {
                    context.clearData();
                }
            }
        }
    }

    protected void generateImportStatement(QualifiedName importedQualifiedName, ExtraLanguageAppendable appendable, IExtraLanguageGeneratorContext context) {
    }

    protected void generateFileHeader(QualifiedName qualifiedName, ExtraLanguageAppendable appendable, IExtraLanguageGeneratorContext context) {
    }

    protected boolean generateJvmMembers(List<? extends JvmMember> members, ExtraLanguageAppendable it, IExtraLanguageGeneratorContext context) {
        for (JvmMember jvmMember : members) {
            if (jvmMember instanceof JvmConstructor) continue;
            if (context.getCancelIndicator().isCanceled()) {
                return false;
            }
            this.generate((EObject)jvmMember, it, context);
        }
        return true;
    }

    protected boolean generateSarlMembers(List<? extends XtendMember> members, ExtraLanguageAppendable it, IExtraLanguageGeneratorContext context) {
        for (XtendMember xtendMember : members) {
            if (xtendMember instanceof SarlConstructor) continue;
            if (context.getCancelIndicator().isCanceled()) {
                return false;
            }
            this.generate((EObject)xtendMember, it, context);
        }
        return true;
    }

    protected static List<JvmTypeReference> getSuperTypes(JvmTypeReference extension, List<? extends JvmTypeReference> implemented) {
        ArrayList<JvmTypeReference> list = new ArrayList<JvmTypeReference>();
        if (extension != null) {
            list.add(extension);
        }
        if (implemented != null) {
            list.addAll(implemented);
        }
        return list;
    }

    protected LightweightTypeReference getExpectedType(XExpression expr) {
        IResolvedTypes resolvedTypes = this.getTypeResolver().resolveTypes((EObject)expr);
        LightweightTypeReference actualType = resolvedTypes.getActualType(expr);
        return actualType;
    }

    protected LightweightTypeReference getExpectedType(XtendExecutable executable, JvmTypeReference declaredReturnType) {
        if (declaredReturnType == null) {
            XtendFunction function;
            JvmOperation operation;
            if (executable instanceof XtendFunction && (operation = this.sarlAssociations.getDirectlyInferredOperation(function = (XtendFunction)executable)) != null) {
                return Utils.toLightweightTypeReference(operation.getReturnType(), this.services);
            }
            if (!this.getEarlyExitComputer().isEarlyExit(executable.getExpression())) {
                return this.getExpectedType(executable.getExpression());
            }
            return null;
        }
        if (!"void".equals(declaredReturnType.getIdentifier())) {
            return Utils.toLightweightTypeReference(declaredReturnType, this.services);
        }
        return null;
    }

    public static interface ExtraLanguageSupportModule {
        public Bundle getBundle();

        public void logException(Throwable var1);
    }

    private static class OrderedProperties
    extends Properties {
        private static final long serialVersionUID = 162949168401947298L;
        private final List<Pair<String, String>> orderedElements = new ArrayList<Pair<String, String>>();

        OrderedProperties() {
        }

        @Override
        public synchronized Object put(Object key, Object value) {
            this.orderedElements.add((Pair<String, String>)new Pair((Object)Objects.toString(key), (Object)Objects.toString(value)));
            return super.put(key, value);
        }

        public List<Pair<String, String>> getOrderedProperties() {
            return this.orderedElements;
        }
    }
}

