/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.extralanguage.compiler;

import com.google.inject.Inject;
import io.sarl.lang.extralanguage.compiler.AbstractExpressionGenerator;
import io.sarl.lang.extralanguage.compiler.ConversionResult;
import io.sarl.lang.extralanguage.compiler.ConversionType;
import io.sarl.lang.extralanguage.compiler.FeatureNameConverterRuleReader;
import io.sarl.lang.extralanguage.compiler.FeaturePattern;
import io.sarl.lang.extralanguage.compiler.FeatureReplacement;
import io.sarl.lang.extralanguage.compiler.IExtraLanguageConversionInitializer;
import io.sarl.lang.extralanguage.compiler.IExtraLanguageGeneratorContext;
import io.sarl.lang.extralanguage.compiler.IExtraLanguageKeywordProvider;
import io.sarl.lang.jvmmodel.SarlJvmModelAssociations;
import io.sarl.lang.sarl.SarlAction;
import io.sarl.lang.services.SARLGrammarKeywordAccess;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.featurecalls.IdentifiableSimpleNameProvider;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ExtraLanguageFeatureNameConverter {
    private final IExtraLanguageConversionInitializer initializer;
    private final IExtraLanguageGeneratorContext context;
    @Inject
    private FeatureNameConverterRuleReader ruleReader;
    @Inject
    private SarlJvmModelAssociations associations;
    @Inject
    private IdentifiableSimpleNameProvider simpleNameProvider;
    @Inject
    private ILogicalContainerProvider logicalContainerProvider;
    @Inject
    private SARLGrammarKeywordAccess sarlKeywords;
    private final IExtraLanguageKeywordProvider keywords;
    private Map<Character, List<Pair<FeaturePattern, FeatureReplacement>>> conversions;
    private final Functions.Function1<? super XExpression, ? extends String> referenceNameLambda;
    private final Functions.Function1<? super JvmIdentifiableElement, ? extends String> referenceNameLambda2;

    public ExtraLanguageFeatureNameConverter(IExtraLanguageConversionInitializer initializer, IExtraLanguageGeneratorContext context, IExtraLanguageKeywordProvider keywords) {
        this.initializer = initializer;
        this.context = context;
        this.referenceNameLambda = expr -> null;
        this.referenceNameLambda2 = expr -> null;
        this.keywords = keywords;
    }

    protected Map<Character, List<Pair<FeaturePattern, FeatureReplacement>>> initMapping() {
        TreeMap<Character, List<Pair<FeaturePattern, FeatureReplacement>>> map = new TreeMap<Character, List<Pair<FeaturePattern, FeatureReplacement>>>();
        if (!this.ruleReader.initializeConversions(map, this.context) && this.initializer != null) {
            this.initializer.initializeConversions((Procedures.Procedure3<? super String, ? super String, ? super String>)((Procedures.Procedure3)(simpleName, source, target) -> {
                char c = ExtraLanguageFeatureNameConverter.getKey(simpleName);
                if (c == '*') {
                    for (char i = 'a'; i <= 'z'; i = (char)(i + '\u0001')) {
                        ExtraLanguageFeatureNameConverter.createMappingEntry(map, i, source, target);
                    }
                } else {
                    ExtraLanguageFeatureNameConverter.createMappingEntry(map, c, source, target);
                }
            }));
        }
        return map;
    }

    private static void createMappingEntry(Map<Character, List<Pair<FeaturePattern, FeatureReplacement>>> map, char character, String source, String target) {
        List<Pair<FeaturePattern, FeatureReplacement>> internalStruct = map.get(Character.valueOf(character));
        if (internalStruct == null) {
            internalStruct = new ArrayList<Pair<FeaturePattern, FeatureReplacement>>();
            map.put(Character.valueOf(character), internalStruct);
        }
        internalStruct.add((Pair<FeaturePattern, FeatureReplacement>)new Pair((Object)new FeaturePattern(source), (Object)new FeatureReplacement(target)));
    }

    public static char getKey(String name) {
        return Character.toLowerCase(name.charAt(0));
    }

    public ConversionType getConversionTypeFor(XAbstractFeatureCall featureCall) {
        String replacementId;
        FeatureReplacement replacement;
        if (this.conversions == null) {
            this.conversions = this.initMapping();
        }
        ArrayList<Object> receiver = new ArrayList<Object>();
        AbstractExpressionGenerator.buildCallReceiver(featureCall, this.keywords.getThisKeywordLambda(), this.referenceNameLambda, receiver);
        String simpleName = AbstractExpressionGenerator.getCallSimpleName(featureCall, this.logicalContainerProvider, this.simpleNameProvider, this.keywords.getNullKeywordLambda(), this.keywords.getThisKeywordLambda(), this.keywords.getSuperKeywordLambda(), this.referenceNameLambda2);
        List<Pair<FeaturePattern, FeatureReplacement>> struct = this.conversions.get(Character.valueOf(ExtraLanguageFeatureNameConverter.getKey(simpleName)));
        if (struct != null && (replacement = this.matchFirstPattern(struct, replacementId = featureCall.getFeature().getIdentifier(), simpleName, receiver)) != null) {
            if (replacement.hasReplacement()) {
                return ConversionType.EXPLICIT;
            }
            return ConversionType.FORBIDDEN_CONVERSION;
        }
        return ConversionType.IMPLICIT;
    }

    public ConversionResult convertFeatureCall(String simpleName, JvmIdentifiableElement calledFeature, List<Object> leftOperand, List<Object> receiver, List<XExpression> arguments) {
        String replacementId;
        FeatureReplacement replacement;
        List<Pair<FeaturePattern, FeatureReplacement>> struct;
        if (this.conversions == null) {
            this.conversions = this.initMapping();
        }
        if ((struct = this.conversions.get(Character.valueOf(ExtraLanguageFeatureNameConverter.getKey(simpleName)))) != null && (replacement = this.matchFirstPattern(struct, replacementId = calledFeature.getIdentifier(), simpleName, receiver)) != null) {
            if (replacement.hasReplacement()) {
                return replacement.replace(calledFeature, leftOperand, receiver, arguments);
            }
            return null;
        }
        return new ConversionResult(simpleName, null);
    }

    private static void loopReceiver(LinkedList<String> sourceFeature, Object obj) {
        if (obj instanceof XMemberFeatureCall) {
            XMemberFeatureCall memberFeatureCall = (XMemberFeatureCall)obj;
            sourceFeature.addFirst(memberFeatureCall.getFeature().getSimpleName());
            ExtraLanguageFeatureNameConverter.loopReceiver(sourceFeature, memberFeatureCall.getMemberCallTarget());
        } else if (obj instanceof XFeatureCall) {
            XFeatureCall featureCall = (XFeatureCall)obj;
            sourceFeature.addFirst(featureCall.getFeature().getIdentifier());
        }
    }

    private FeatureReplacement matchFirstPattern(List<Pair<FeaturePattern, FeatureReplacement>> patterns, String source, String simpleName, List<Object> receiver) {
        LinkedList<String> sarlKeyword;
        boolean isSarlKeyword;
        LinkedList<String> sourceFeature = new LinkedList<String>();
        for (Object obj : receiver) {
            ExtraLanguageFeatureNameConverter.loopReceiver(sourceFeature, obj);
        }
        sourceFeature.add(source);
        boolean bl = isSarlKeyword = this.sarlKeywords.getThisKeyword().equals(simpleName) || this.sarlKeywords.getSuperKeyword().equals(simpleName);
        if (isSarlKeyword) {
            sarlKeyword = new LinkedList<String>();
            sarlKeyword.add(simpleName);
        } else {
            sarlKeyword = null;
        }
        for (Pair<FeaturePattern, FeatureReplacement> patternMatching : patterns) {
            FeaturePattern pattern = (FeaturePattern)patternMatching.getKey();
            if (!(pattern.isNameReplacement() ? isSarlKeyword && pattern.matches(sarlKeyword) : pattern.matches(sourceFeature))) continue;
            return (FeatureReplacement)patternMatching.getValue();
        }
        return null;
    }

    private static FeatureReplacement matchFirstPattern(List<Pair<FeaturePattern, FeatureReplacement>> patterns, String source) {
        LinkedList<String> sourceFeature = new LinkedList<String>();
        sourceFeature.add(source);
        for (Pair<FeaturePattern, FeatureReplacement> patternMatching : patterns) {
            FeaturePattern pattern = (FeaturePattern)patternMatching.getKey();
            if (!pattern.isNameReplacement() || !pattern.matches(sourceFeature)) continue;
            return (FeatureReplacement)patternMatching.getValue();
        }
        return null;
    }

    public String convertDeclarationName(String simpleName, SarlAction feature) {
        assert (simpleName != null);
        assert (feature != null);
        JvmOperation operation = this.associations.getDirectlyInferredOperation(feature);
        if (operation != null) {
            List<Pair<FeaturePattern, FeatureReplacement>> struct;
            if (this.conversions == null) {
                this.conversions = this.initMapping();
            }
            if ((struct = this.conversions.get(Character.valueOf(ExtraLanguageFeatureNameConverter.getKey(simpleName)))) == null) {
                return simpleName;
            }
            FeatureReplacement replacement = ExtraLanguageFeatureNameConverter.matchFirstPattern(struct, operation.getIdentifier());
            if (replacement != null) {
                if (replacement.hasReplacement()) {
                    return replacement.getText();
                }
                return null;
            }
            return simpleName;
        }
        return simpleName;
    }
}

