/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.extralanguage.compiler;

import io.sarl.lang.extralanguage.compiler.IExtraLanguageGeneratorContext;
import io.sarl.lang.extralanguage.compiler.IRootGenerator;
import io.sarl.lang.sarl.actionprototype.IActionPrototypeContext;
import io.sarl.lang.sarl.actionprototype.IActionPrototypeProvider;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class ExtraLanguageGeneratorContext
implements IExtraLanguageGeneratorContext {
    private final UUID identifier = UUID.randomUUID();
    private final Date generationDate = new Date();
    private final String preferenceId;
    private final IGeneratorContext delegate;
    private final WeakReference<IRootGenerator> rootGenerator;
    private final Resource resource;
    private IFileSystemAccess2 fileSystemAccess;
    private Map<String, Object> temporaryData;
    private LightweightTypeReference expectedExpressionType;
    private IActionPrototypeContext actionPrototypeContext;

    public ExtraLanguageGeneratorContext(IGeneratorContext delegate, IFileSystemAccess2 fileSystemAccess, IRootGenerator generator, Resource resource, String preferenceId) {
        this.preferenceId = preferenceId;
        this.delegate = delegate;
        this.fileSystemAccess = fileSystemAccess;
        this.resource = resource;
        this.rootGenerator = new WeakReference<IRootGenerator>(generator);
    }

    @Override
    public UUID getGenerationID() {
        return this.identifier;
    }

    @Override
    public Date getGenerationDate() {
        return this.generationDate;
    }

    @Override
    public String getPreferenceID() {
        return this.preferenceId;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public IRootGenerator getRootGenerator() {
        return (IRootGenerator)this.rootGenerator.get();
    }

    public CancelIndicator getCancelIndicator() {
        CancelIndicator indicator = this.delegate.getCancelIndicator();
        if (indicator == null) {
            return CancelIndicator.NullImpl;
        }
        return indicator;
    }

    @Override
    public IGeneratorContext getDelegate() {
        return this.delegate;
    }

    @Override
    public IFileSystemAccess2 getFileSystemAccess() {
        return this.fileSystemAccess;
    }

    @Override
    public <T> T getData(String id, Class<T> type, T defaultValue) {
        if (Strings.isEmpty((String)id) || this.temporaryData == null) {
            return defaultValue;
        }
        Object data = this.temporaryData.get(id);
        if (data == null) {
            return defaultValue;
        }
        try {
            return type.cast(data);
        }
        catch (Throwable exception) {
            return defaultValue;
        }
    }

    @Override
    public <T> T getData(String id, Class<T> type) {
        return this.getData(id, type, null);
    }

    @Override
    public void setData(String id, Object value) {
        if (Strings.isEmpty((String)id)) {
            return;
        }
        if (value == null) {
            if (this.temporaryData != null) {
                this.temporaryData.remove(id);
            }
            return;
        }
        if (this.temporaryData == null) {
            this.temporaryData = new TreeMap<String, Object>();
        }
        this.temporaryData.put(id, value);
    }

    @Override
    public void clearData() {
        this.temporaryData = null;
        this.actionPrototypeContext = null;
    }

    @Override
    public <T> List<T> getListData(String id) {
        ArrayList list;
        if (this.temporaryData == null) {
            this.temporaryData = new TreeMap<String, Object>();
        }
        if ((list = (ArrayList)this.temporaryData.get(id)) == null) {
            list = new ArrayList();
            this.temporaryData.put(id, list);
        }
        return list;
    }

    @Override
    public <T> Set<T> getSetData(String id) {
        HashSet set;
        if (this.temporaryData == null) {
            this.temporaryData = new TreeMap<String, Object>();
        }
        if ((set = (HashSet)this.temporaryData.get(id)) == null) {
            set = new HashSet();
            this.temporaryData.put(id, set);
        }
        return set;
    }

    @Override
    public <K, V> Map<K, V> getMapData(String id) {
        HashMap map;
        if (this.temporaryData == null) {
            this.temporaryData = new TreeMap<String, Object>();
        }
        if ((map = (HashMap)this.temporaryData.get(id)) == null) {
            map = new HashMap();
            this.temporaryData.put(id, map);
        }
        return map;
    }

    @Override
    public <K, V> Map<K, List<V>> getMultimapData(String id) {
        HashMap multimap;
        if (this.temporaryData == null) {
            this.temporaryData = new TreeMap<String, Object>();
        }
        if ((multimap = (HashMap)this.temporaryData.get(id)) == null) {
            multimap = new HashMap();
            this.temporaryData.put(id, multimap);
        }
        return multimap;
    }

    @Override
    public <K, V> List<V> getMultimapValues(String id, K multimapKey) {
        ArrayList list;
        HashMap multimap;
        if (this.temporaryData == null) {
            this.temporaryData = new TreeMap<String, Object>();
        }
        if ((multimap = (HashMap)this.temporaryData.get(id)) == null) {
            multimap = new HashMap();
            this.temporaryData.put(id, multimap);
        }
        if ((list = (ArrayList)multimap.get(multimapKey)) == null) {
            list = new ArrayList();
            multimap.put(multimapKey, list);
        }
        return list;
    }

    @Override
    public LightweightTypeReference getExpectedExpressionType() {
        return this.expectedExpressionType;
    }

    @Override
    public LightweightTypeReference setExpectedExpressionType(LightweightTypeReference expectedType) {
        LightweightTypeReference old = this.expectedExpressionType;
        this.expectedExpressionType = expectedType != null && expectedType.isPrimitiveVoid() ? null : expectedType;
        return old;
    }

    @Override
    public IActionPrototypeContext getActionPrototypeContext(IActionPrototypeProvider provider) {
        if (this.actionPrototypeContext == null) {
            this.actionPrototypeContext = provider.createContext();
        }
        return this.actionPrototypeContext;
    }
}

