/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.extralanguage.compiler;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.sarl.lang.extralanguage.compiler.IExtraLanguageGeneratorProvider;
import io.sarl.lang.extralanguage.compiler.IRootGenerator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.GeneratorContext;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.IGenerator2;
import org.eclipse.xtext.generator.IGeneratorContext;

public class ExtraLanguageGeneratorSupport
implements IGenerator,
IGenerator2 {
    public static final String MAIN_GENERATOR_NAME = "io.sarl.lang.generator.extra.MAIN";
    private IGenerator2 mainGenerator;
    private IExtraLanguageGeneratorProvider extraGeneratorProvider;
    private Logger logger;

    @Inject
    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    @Inject
    public void setExtraGeneratorProvider(IExtraLanguageGeneratorProvider provider) {
        this.extraGeneratorProvider = provider;
    }

    public IExtraLanguageGeneratorProvider getExtraGeneratorProvider() {
        return this.extraGeneratorProvider;
    }

    @Inject
    public void setMainGenerator(@Named(value="io.sarl.lang.generator.extra.MAIN") IGenerator2 generator) {
        this.mainGenerator = generator;
    }

    public IGenerator2 getMainGenerator() {
        return this.mainGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
        try {
            this.beforeGenerate(input, fsa, context);
            this.doGenerate(input, fsa, context);
        }
        finally {
            this.afterGenerate(input, fsa, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doGenerate(Resource input, IFileSystemAccess fsa) {
        IFileSystemAccess2 casted = (IFileSystemAccess2)fsa;
        GeneratorContext context = new GeneratorContext();
        try {
            this.beforeGenerate(input, casted, (IGeneratorContext)context);
            this.doGenerate(input, casted, (IGeneratorContext)context);
        }
        finally {
            this.afterGenerate(input, casted, (IGeneratorContext)context);
        }
    }

    public void doGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
        Iterable<IRootGenerator> generators;
        IGenerator2 mainGenerator = this.getMainGenerator();
        if (mainGenerator != null) {
            mainGenerator.doGenerate(input, fsa, context);
        }
        if ((generators = this.getExtraGeneratorProvider().getGenerators(context, input)) != null) {
            for (IRootGenerator generator : generators) {
                try {
                    generator.doGenerate(input, fsa, context);
                }
                catch (Throwable exception) {
                    this.getLogger().log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                }
            }
        }
    }

    public void beforeGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
        Iterable<IRootGenerator> generators;
        IGenerator2 mainGenerator = this.getMainGenerator();
        if (mainGenerator != null) {
            mainGenerator.beforeGenerate(input, fsa, context);
        }
        if ((generators = this.getExtraGeneratorProvider().getGenerators(context, input)) != null) {
            for (IRootGenerator generator : generators) {
                try {
                    generator.beforeGenerate(input, fsa, context);
                }
                catch (Throwable exception) {
                    this.getLogger().log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                }
            }
        }
    }

    public void afterGenerate(Resource input, IFileSystemAccess2 fsa, IGeneratorContext context) {
        Iterable<IRootGenerator> generators;
        IGenerator2 mainGenerator = this.getMainGenerator();
        if (mainGenerator != null) {
            mainGenerator.afterGenerate(input, fsa, context);
        }
        if ((generators = this.getExtraGeneratorProvider().getGenerators(context, input)) != null) {
            for (IRootGenerator generator : generators) {
                try {
                    generator.afterGenerate(input, fsa, context);
                }
                catch (Throwable exception) {
                    this.getLogger().log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                }
            }
        }
    }
}

