/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.extralanguage.compiler;

import io.sarl.lang.extralanguage.compiler.ExtraLanguageTypeConverter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmPrimitiveType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.xbase.compiler.ImportManager;

public class ExtraLanguageImportManager
extends ImportManager {
    private final ExtraLanguageTypeConverter converter;

    public ExtraLanguageImportManager(ExtraLanguageTypeConverter converter) {
        super(true);
        this.converter = converter;
    }

    public ExtraLanguageImportManager(ExtraLanguageTypeConverter converter, JvmDeclaredType thisType) {
        super(true, thisType);
        this.converter = converter;
    }

    public ExtraLanguageImportManager(ExtraLanguageTypeConverter converter, char innerSeparator) {
        super(true, innerSeparator);
        this.converter = converter;
    }

    public ExtraLanguageImportManager(ExtraLanguageTypeConverter converter, JvmDeclaredType thisType, char innerSeparator) {
        super(true, thisType, innerSeparator);
        this.converter = converter;
    }

    protected String convertQualifiedName(String name) {
        return this.converter.convert(name);
    }

    private String getSimpleName(String name) {
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf(this.getInnerTypeSeparator());
        if (index < 0) {
            return name;
        }
        return name.substring(index + 1);
    }

    public boolean addImportFor(JvmType type) {
        String qualifiedName = this.convertQualifiedName(type.getQualifiedName(this.getInnerTypeSeparator()));
        if (qualifiedName == null) {
            return false;
        }
        String simpleName = this.getSimpleName(qualifiedName);
        if (!(this.allowsSimpleName(qualifiedName, simpleName) || this.needsQualifiedName(qualifiedName, simpleName) || this.internalGetImports().containsKey(simpleName))) {
            this.internalGetImports().put(simpleName, qualifiedName);
            return true;
        }
        return false;
    }

    public void appendType(Class<?> type, StringBuilder builder) {
        if (type.isPrimitive()) {
            String qualifiedName = this.convertQualifiedName(type.getSimpleName());
            if (qualifiedName == null) {
                return;
            }
            builder.append(qualifiedName);
        } else {
            String qualifiedName = this.convertQualifiedName(type.getCanonicalName());
            if (qualifiedName == null) {
                return;
            }
            if (!qualifiedName.contains(Character.toString(this.getInnerTypeSeparator()))) {
                builder.append(qualifiedName);
                return;
            }
            String nameToImport = qualifiedName;
            Object shortName = this.getSimpleName(qualifiedName);
            String outerShortName = shortName;
            if (this.shouldUseQualifiedNestedName(qualifiedName)) {
                Class<?> outerContainer = type;
                while (outerContainer.getDeclaringClass() != null) {
                    outerContainer = outerContainer.getDeclaringClass();
                }
                if (type != outerContainer) {
                    outerShortName = outerContainer.getSimpleName();
                    if (!this.getThisTypeQualifiedNames().contains(outerContainer.getCanonicalName()) && this.getThisTypeSimpleNames().contains(outerShortName)) {
                        outerShortName = qualifiedName;
                        shortName = qualifiedName;
                    } else {
                        nameToImport = outerContainer.getCanonicalName();
                        shortName = outerShortName + qualifiedName.substring(nameToImport.length());
                    }
                }
            }
            this.appendType(qualifiedName, (String)shortName, outerShortName, nameToImport, builder);
        }
    }

    public void appendType(JvmType type, StringBuilder builder) {
        String qualifiedName = this.convertQualifiedName(type.getQualifiedName(this.getInnerTypeSeparator()));
        if (qualifiedName == null) {
            return;
        }
        if (type instanceof JvmPrimitiveType || type instanceof JvmVoid || type instanceof JvmTypeParameter || !qualifiedName.contains(Character.toString(this.getInnerTypeSeparator()))) {
            builder.append(qualifiedName);
        } else {
            String nameToImport = qualifiedName;
            Object shortName = this.getSimpleName(qualifiedName);
            String outerShortName = shortName;
            if (this.shouldUseQualifiedNestedName(qualifiedName)) {
                EObject eObject;
                JvmType outerContainer = type;
                while ((eObject = outerContainer.eContainer()) instanceof JvmType) {
                    JvmType cvalue;
                    outerContainer = cvalue = (JvmType)eObject;
                }
                if (type != outerContainer) {
                    outerShortName = outerContainer.getSimpleName();
                    if (!this.getThisTypeQualifiedNames().contains(outerContainer.getQualifiedName(this.getInnerTypeSeparator())) && this.getThisTypeSimpleNames().contains(outerShortName)) {
                        outerShortName = qualifiedName;
                        shortName = qualifiedName;
                    } else {
                        nameToImport = outerContainer.getQualifiedName(this.getInnerTypeSeparator());
                        shortName = outerShortName + qualifiedName.substring(nameToImport.length());
                    }
                }
            }
            this.appendType(qualifiedName, (String)shortName, outerShortName, nameToImport, builder);
        }
    }
}

