/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.extralanguage.compiler;

import com.google.inject.Inject;
import io.sarl.lang.core.Agent;
import io.sarl.lang.extralanguage.compiler.IExtraLanguageConversionInitializer;
import io.sarl.lang.extralanguage.compiler.IExtraLanguageGeneratorContext;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.eclipse.xtext.xbase.lib.Procedures;

public final class ExtraLanguageTypeConverter {
    private static final String PACKAGE_SEPARATOR = ".";
    private static final String IMPLICIT_PACKAGE;
    private final IExtraLanguageConversionInitializer initializer;
    private final IExtraLanguageGeneratorContext context;
    @Inject
    private TypeConverterRuleReader converterReader;
    private Map<String, String> mapping;
    private boolean implicitSarlTypes = true;
    private boolean implicitJvmTypes;

    public ExtraLanguageTypeConverter(IExtraLanguageConversionInitializer initializer, IExtraLanguageGeneratorContext context) {
        this.initializer = initializer;
        this.context = context;
    }

    public boolean isImplicitSarlTypes() {
        return this.implicitSarlTypes;
    }

    public void setImplicitSarlTypes(boolean enable) {
        this.implicitSarlTypes = enable;
    }

    public boolean isImplicitJvmTypes() {
        return this.implicitJvmTypes;
    }

    public void setImplicitJvmTypes(boolean enable) {
        this.implicitJvmTypes = enable;
    }

    public void reset() {
        this.mapping = null;
    }

    protected Map<String, String> initMapping() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (!this.converterReader.initializeConversions(map, this.context) && this.initializer != null) {
            this.initializer.initializeConversions((Procedures.Procedure3<? super String, ? super String, ? super String>)((Procedures.Procedure3)(simpleName, source, target) -> map.put((String)source, (String)target)));
        }
        return map;
    }

    public boolean hasConversion(String type) {
        if (this.isImplicitSarlTypes() && type.startsWith(IMPLICIT_PACKAGE) || this.isImplicitJvmTypes()) {
            return true;
        }
        if (this.mapping == null) {
            this.mapping = this.initMapping();
        }
        return this.mapping.containsKey(type);
    }

    public String convert(String type) {
        String map;
        if (this.isImplicitSarlTypes() && type.startsWith(IMPLICIT_PACKAGE)) {
            return type;
        }
        if (this.mapping == null) {
            this.mapping = this.initMapping();
        }
        if ((map = this.mapping.get(type)) != null) {
            if (map.isEmpty() && !this.isImplicitJvmTypes()) {
                return null;
            }
            return map;
        }
        if (this.isImplicitJvmTypes()) {
            return type;
        }
        return null;
    }

    static {
        String[] basePackage = Agent.class.getPackage().getName().split(Pattern.quote(PACKAGE_SEPARATOR));
        StringBuilder name = new StringBuilder();
        for (int i = 0; i < 2 && i < basePackage.length; ++i) {
            name.append(basePackage[i]).append(PACKAGE_SEPARATOR);
        }
        IMPLICIT_PACKAGE = name.toString();
    }

    public static class TypeConverterRuleReader {
        public boolean initializeConversions(Map<String, String> result, IExtraLanguageGeneratorContext context) {
            return false;
        }
    }
}

