/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.extralanguage.compiler;

import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.xtext.util.Strings;

public class FeaturePattern {
    private static final String SEPARATOR_PATTERN = "\\/+";
    public static final char ALL_PATTERN_CHAR = '*';
    private static final String ALL_PATTERN = Character.toString('*');
    private static final String ANY_PATTERN = ".*";
    private static final char OPARENTHESIS = '(';
    private static final char CPARENTHESIS = ')';
    private static final char SEPARATOR = '/';
    private static final char DOT = '.';
    private final boolean isNameReplacement;
    private final String rawFeature;
    private final Pattern featurePattern;
    private final Pattern[] pathPatterns;

    public FeaturePattern(String specification) {
        String[] elements = specification.split(SEPARATOR_PATTERN);
        String last = elements[elements.length - 1];
        if (last.contains(ALL_PATTERN)) {
            this.rawFeature = null;
            this.featurePattern = Pattern.compile(FeaturePattern.protect(last));
        } else {
            this.rawFeature = last;
            this.featurePattern = null;
        }
        this.pathPatterns = new Pattern[elements.length - 1];
        if (this.pathPatterns.length > 0) {
            for (int i = 0; i < this.pathPatterns.length; ++i) {
                this.pathPatterns[i] = Pattern.compile(FeaturePattern.protect(elements[i]));
            }
        }
        this.isNameReplacement = specification.charAt(specification.length() - 1) != ')';
    }

    public String toString() {
        if (this.rawFeature != null) {
            return this.rawFeature;
        }
        return Objects.toString(this.featurePattern);
    }

    private static String protect(String source) {
        if (Strings.equal((String)source, (String)ALL_PATTERN)) {
            return ANY_PATTERN;
        }
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String element : source.split(Pattern.quote(ALL_PATTERN))) {
            if (first) {
                first = false;
            } else {
                builder.append(ANY_PATTERN);
            }
            builder.append(Pattern.quote(element));
        }
        return builder.toString();
    }

    public boolean isNameReplacement() {
        return this.isNameReplacement;
    }

    public boolean matches(Deque<String> feature) {
        boolean match;
        if (this.rawFeature != null) {
            match = this.rawFeature.equals(feature.getLast());
        } else {
            Matcher featureMatcher = this.featurePattern.matcher(feature.getLast());
            match = featureMatcher.matches();
        }
        if (match && this.pathPatterns.length > 0) {
            Iterator<String> iterator = feature.descendingIterator();
            iterator.next();
            for (int j = this.pathPatterns.length - 1; match && iterator.hasNext() && j >= 0; --j) {
                String component = iterator.next();
                Pattern pathPattern = this.pathPatterns[j];
                Matcher pathMatcher = pathPattern.matcher(component);
                match = pathMatcher.matches();
            }
        }
        return match;
    }

    public static String simpleName(String textualRepresentation) {
        int dot;
        int start = textualRepresentation.lastIndexOf(47);
        int end = textualRepresentation.length();
        start = start < 0 ? 0 : ++start;
        if (textualRepresentation.charAt(textualRepresentation.length() - 1) == ')') {
            end = textualRepresentation.lastIndexOf(40);
            assert (end > 0);
        }
        if ((dot = textualRepresentation.lastIndexOf(46, end - 1)) + 1 >= start) {
            start = dot + 1;
        }
        return textualRepresentation.substring(start, end);
    }
}

