/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.extralanguage.compiler;

import io.sarl.lang.extralanguage.compiler.ConversionResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.xbase.XExpression;

public class FeatureReplacement {
    private static final char PROTECT_CHAR = '\\';
    private static final char VARIABLE_CHAR = '$';
    private static final char ALL_CHAR = '*';
    private static final String ARGUMENT_SEPARATOR = ",";
    private final boolean hasReplacement;
    private List<String> staticParts = new ArrayList<String>();
    private List<Integer> dynamicParts = new ArrayList<Integer>();
    private String raw;

    public FeatureReplacement(String specification) {
        StringBuilder builder = new StringBuilder();
        boolean isProtected = false;
        StringBuilder isVariable = null;
        int i = 0;
        while (i < specification.length()) {
            char character = specification.charAt(i);
            if (isProtected) {
                isProtected = false;
                builder.append(character);
                ++i;
                continue;
            }
            if (isVariable != null) {
                if (character == '*' && isVariable.length() == 0) {
                    this.dynamicParts.add(-1);
                    isVariable = null;
                    ++i;
                    continue;
                }
                if (character >= '0' && character <= '9') {
                    isVariable.append(character);
                    ++i;
                    continue;
                }
                int varNumber = Integer.parseInt(isVariable.toString());
                this.dynamicParts.add(varNumber);
                isVariable = null;
                continue;
            }
            switch (character) {
                case '\\': {
                    isProtected = true;
                    break;
                }
                case '$': {
                    this.staticParts.add(builder.toString());
                    builder = new StringBuilder();
                    isVariable = new StringBuilder();
                    break;
                }
                default: {
                    builder.append(character);
                }
            }
            ++i;
        }
        if (isVariable != null) {
            Integer varNumber = Integer.valueOf(isVariable.toString());
            this.dynamicParts.add(varNumber);
        } else if (builder.length() > 0) {
            this.staticParts.add(builder.toString());
        }
        this.hasReplacement = !specification.isEmpty();
        this.raw = specification;
    }

    public String toString() {
        return this.raw;
    }

    public boolean hasReplacement() {
        return this.hasReplacement;
    }

    public ConversionResult replace(JvmIdentifiableElement calledFeature, List<Object> leftOperand, List<Object> receiver, List<XExpression> arguments) {
        assert (this.hasReplacement);
        if (!this.dynamicParts.isEmpty()) {
            ArrayList<Object> content = new ArrayList<Object>(this.staticParts.size() + this.dynamicParts.size());
            Iterator<String> staticIterator = this.staticParts.iterator();
            Iterator<Integer> dynamicIterator = this.dynamicParts.iterator();
            while (staticIterator.hasNext()) {
                assert (staticIterator.hasNext());
                content.add(staticIterator.next());
                if (!dynamicIterator.hasNext()) continue;
                int varNumber = dynamicIterator.next();
                if (varNumber == -1) {
                    boolean first = true;
                    for (XExpression arg : arguments) {
                        if (first) {
                            first = false;
                        } else {
                            content.add(ARGUMENT_SEPARATOR);
                        }
                        content.add(arg);
                    }
                    continue;
                }
                if (varNumber == 0) {
                    content.add(receiver.get(receiver.size() - 1));
                    continue;
                }
                if (varNumber <= 0 || varNumber > arguments.size()) continue;
                content.add(arguments.get(varNumber - 1));
            }
            return new ConversionResult(null, content.toArray());
        }
        return new ConversionResult(this.staticParts.get(this.staticParts.size() - 1), null);
    }

    public String getText() {
        return this.raw;
    }
}

