/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.extralanguage.validator;

import com.google.inject.Inject;
import com.google.inject.Injector;
import io.sarl.lang.extralanguage.compiler.ConversionType;
import io.sarl.lang.extralanguage.compiler.ExtraLanguageFeatureNameConverter;
import io.sarl.lang.extralanguage.compiler.ExtraLanguageTypeConverter;
import io.sarl.lang.extralanguage.compiler.IExtraLanguageConversionInitializer;
import io.sarl.lang.extralanguage.compiler.IExtraLanguageGeneratorContext;
import io.sarl.lang.extralanguage.compiler.IExtraLanguageKeywordProvider;
import io.sarl.lang.util.Utils;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.util.Exceptions;
import org.eclipse.xtext.util.SimpleCache;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;

public abstract class AbstractExtraLanguageValidator {
    private static final String CHECKED_FEATURE_CALLS = "io.sarl.lang.validation.extra.CheckedFeatureCalls";
    private ExtraLanguageTypeConverter typeConverter;
    private ExtraLanguageFeatureNameConverter featureConverter;
    private Injector injector;
    private final ThreadLocal<Context> currentContext = new ThreadLocal();
    private volatile Set<MethodWrapper> checkMethods;
    private final SimpleCache<Class<?>, List<MethodWrapper>> methodsForType = new SimpleCache(it -> this.updateMethodCache((Class<?>)it));
    private final IExtraLanguageKeywordProvider keywords;

    public AbstractExtraLanguageValidator(IExtraLanguageKeywordProvider keywordProvider) {
        assert (keywordProvider != null);
        this.keywords = keywordProvider;
    }

    public IExtraLanguageKeywordProvider getExtraLanguageKeywordProvider() {
        return this.keywords;
    }

    private List<MethodWrapper> updateMethodCache(Class<?> parameterType) {
        ArrayList<MethodWrapper> result = new ArrayList<MethodWrapper>();
        for (MethodWrapper method : this.checkMethods) {
            if (!method.isMatching(parameterType)) continue;
            result.add(method);
        }
        return result;
    }

    @Inject
    public void setInjector(Injector injector) {
        this.injector = injector;
    }

    protected Context getContext() {
        return this.currentContext.get();
    }

    protected void initializeContext(Context validatorContext) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(AbstractDeclarativeValidator.StateAccess validationState, ValidationMessageAcceptor messageAcceptor) {
        if (this.isResponsible(validationState.getState().context, validationState.getState().currentObject)) {
            try {
                for (MethodWrapper method : this.getMethods(validationState.getState().currentObject)) {
                    Context ctx = new Context(validationState, this, method, messageAcceptor);
                    this.currentContext.set(ctx);
                    this.initializeContext(ctx);
                    method.invoke(ctx);
                }
            }
            finally {
                this.currentContext.set(null);
            }
        }
    }

    protected void collectMethods(Class<? extends AbstractExtraLanguageValidator> clazz, Collection<Class<?>> visitedClasses, Collection<MethodWrapper> result) {
        if (!visitedClasses.add(clazz)) {
            return;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (method.getAnnotation(Check.class) == null || method.getParameterTypes().length != 1) continue;
            result.add(this.createMethodWrapper(method));
        }
        Class<? extends AbstractExtraLanguageValidator> superClass = AbstractExtraLanguageValidator.getSuperClass(clazz);
        if (superClass != null) {
            this.collectMethods(superClass, visitedClasses, result);
        }
    }

    protected MethodWrapper createMethodWrapper(Method method) {
        return new MethodWrapper(method);
    }

    private static Class<? extends AbstractExtraLanguageValidator> getSuperClass(Class<? extends AbstractExtraLanguageValidator> clazz) {
        try {
            Class<AbstractExtraLanguageValidator> superClass = clazz.getSuperclass().asSubclass(AbstractExtraLanguageValidator.class);
            if (AbstractExtraLanguageValidator.class.equals(superClass)) {
                return null;
            }
            return superClass;
        }
        catch (ClassCastException exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterable<MethodWrapper> getMethods(EObject currentObject) {
        if (currentObject == null) {
            return Collections.emptyList();
        }
        if (this.checkMethods == null) {
            AbstractExtraLanguageValidator abstractExtraLanguageValidator = this;
            synchronized (abstractExtraLanguageValidator) {
                if (this.checkMethods == null) {
                    LinkedHashSet<MethodWrapper> checkMethods = new LinkedHashSet<MethodWrapper>();
                    HashSet visitedClasses = new HashSet(4);
                    this.collectMethods(this.getClass(), visitedClasses, checkMethods);
                    this.checkMethods = checkMethods;
                }
            }
        }
        return (Iterable)this.methodsForType.get((Object)currentObject.getClass());
    }

    protected boolean isResponsible(Map<Object, Object> context, EObject eObject) {
        if (eObject instanceof XMemberFeatureCall || eObject instanceof XFeatureCall) {
            XAbstractFeatureCall rootFeatureCall = Utils.getRootFeatureCall((XAbstractFeatureCall)eObject);
            return !AbstractExtraLanguageValidator.isCheckedFeatureCall(context, (EObject)rootFeatureCall);
        }
        return true;
    }

    protected void error(String message, EObject source, EStructuralFeature feature) {
        this.getContext().getMessageAcceptor().acceptError(MessageFormat.format(this.getErrorMessageFormat(), message), source, feature, -1, "io.sarl.lang.validation.IssueCodes.invalid_extra_language_generation", new String[0]);
    }

    protected void warning(String message, EObject source, EStructuralFeature feature) {
        this.getContext().getMessageAcceptor().acceptWarning(MessageFormat.format(this.getErrorMessageFormat(), message), source, feature, -1, "io.sarl.lang.validation.IssueCodes.invalid_extra_language_generation", new String[0]);
    }

    protected void info(String message, EObject source, EStructuralFeature feature) {
        this.getContext().getMessageAcceptor().acceptInfo(MessageFormat.format(this.getErrorMessageFormat(), message), source, feature, -1, "io.sarl.lang.validation.IssueCodes.invalid_extra_language_generation", new String[0]);
    }

    protected abstract String getErrorMessageFormat();

    protected abstract IExtraLanguageConversionInitializer getTypeConverterInitializer();

    protected abstract IExtraLanguageConversionInitializer getFeatureConverterInitializer();

    public ExtraLanguageTypeConverter getTypeConverter() {
        ExtraLanguageTypeConverter converter = this.typeConverter;
        if (converter == null) {
            converter = this.createTypeConverterInstance(this.getTypeConverterInitializer(), null);
            this.injector.injectMembers((Object)converter);
            this.typeConverter = converter;
        }
        return converter;
    }

    protected ExtraLanguageTypeConverter createTypeConverterInstance(IExtraLanguageConversionInitializer initializer, IExtraLanguageGeneratorContext context) {
        return new ExtraLanguageTypeConverter(initializer, context);
    }

    public ExtraLanguageFeatureNameConverter getFeatureNameConverter() {
        ExtraLanguageFeatureNameConverter converter = this.featureConverter;
        if (converter == null) {
            converter = this.createFeatureNameConverterInstance(this.getFeatureConverterInitializer(), null);
            this.injector.injectMembers((Object)converter);
            this.featureConverter = converter;
        }
        return converter;
    }

    protected ExtraLanguageFeatureNameConverter createFeatureNameConverterInstance(IExtraLanguageConversionInitializer initializer, IExtraLanguageGeneratorContext context) {
        return new ExtraLanguageFeatureNameConverter(initializer, context, this.getExtraLanguageKeywordProvider());
    }

    protected boolean doTypeMappingCheck(EObject source, JvmType type, Procedures.Procedure3<? super EObject, ? super JvmType, ? super String> errorHandler) {
        if (source != null && type != null) {
            ExtraLanguageTypeConverter converter = this.getTypeConverter();
            String qn = type.getQualifiedName();
            if (converter != null && !converter.hasConversion(qn)) {
                if (errorHandler != null) {
                    errorHandler.apply((Object)source, (Object)type, (Object)qn);
                }
                return false;
            }
        }
        return true;
    }

    private static boolean isCheckedFeatureCall(Map<Object, Object> context, EObject eObject) {
        Object calls;
        return (eObject instanceof XMemberFeatureCall || eObject instanceof XFeatureCall) && (calls = context.get(CHECKED_FEATURE_CALLS)) != null && ((Collection)calls).contains(eObject);
    }

    private static void setCheckedFeatureCall(Map<Object, Object> context, EObject eObject) {
        if (eObject instanceof XMemberFeatureCall || eObject instanceof XFeatureCall) {
            TreeSet<XAbstractFeatureCall> calls = (TreeSet<XAbstractFeatureCall>)context.get(CHECKED_FEATURE_CALLS);
            if (calls == null) {
                calls = new TreeSet<XAbstractFeatureCall>(FeatureCallComparator.SINGLETON);
                context.put(CHECKED_FEATURE_CALLS, calls);
            }
            calls.add((XAbstractFeatureCall)eObject);
        }
    }

    protected void doCheckMemberFeatureCallMapping(XAbstractFeatureCall featureCall, Procedures.Procedure3<? super EObject, ? super JvmType, ? super String> typeErrorHandler, Functions.Function2<? super EObject, ? super JvmIdentifiableElement, ? extends Boolean> featureErrorHandler) {
        XAbstractFeatureCall rootFeatureCall = Utils.getRootFeatureCall(featureCall);
        Map<Object, Object> context = this.getContext().getContext();
        if (AbstractExtraLanguageValidator.isCheckedFeatureCall(context, (EObject)rootFeatureCall)) {
            return;
        }
        AbstractExtraLanguageValidator.setCheckedFeatureCall(context, (EObject)rootFeatureCall);
        this.internalCheckMemberFeaturCallMapping(rootFeatureCall, typeErrorHandler, featureErrorHandler);
    }

    private boolean internalCheckMemberFeaturCallMapping(XAbstractFeatureCall featureCall, Procedures.Procedure3<? super EObject, ? super JvmType, ? super String> typeErrorHandler, Functions.Function2<? super EObject, ? super JvmIdentifiableElement, ? extends Boolean> featureErrorHandler) {
        ExtraLanguageFeatureNameConverter converter = this.getFeatureNameConverter();
        if (converter != null) {
            ConversionType conversionType = converter.getConversionTypeFor(featureCall);
            switch (conversionType) {
                case EXPLICIT: {
                    return true;
                }
                case IMPLICIT: {
                    XMemberFeatureCall memberFeatureCall;
                    XExpression receiver;
                    JvmIdentifiableElement element = featureCall.getFeature();
                    if (element instanceof JvmType) {
                        JvmType cvalue = (JvmType)element;
                        return this.doTypeMappingCheck((EObject)featureCall, cvalue, typeErrorHandler);
                    }
                    if (!(featureCall instanceof XMemberFeatureCall) || !((receiver = (memberFeatureCall = (XMemberFeatureCall)featureCall).getMemberCallTarget()) instanceof XMemberFeatureCall) && !(receiver instanceof XFeatureCall)) break;
                    this.internalCheckMemberFeaturCallMapping((XAbstractFeatureCall)receiver, typeErrorHandler, featureErrorHandler);
                    break;
                }
                default: {
                    if (featureErrorHandler != null) {
                        return (Boolean)featureErrorHandler.apply((Object)featureCall, (Object)featureCall.getFeature()) == false;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    protected void handleInvocationTargetException(Throwable targetException, Context context) {
        if (!(targetException instanceof NullPointerException)) {
            Exceptions.throwUncheckedException((Throwable)targetException);
        }
    }

    protected static class MethodWrapper {
        private final Method method;
        private final CheckType checkType;

        public MethodWrapper(Method method) {
            this.method = method;
            this.method.setAccessible(true);
            this.checkType = this.method.getAnnotation(Check.class).value();
        }

        public String toString() {
            return this.method.toString();
        }

        public Method getMethod() {
            return this.method;
        }

        public boolean isMatching(Class<?> param) {
            return this.method.getParameterTypes()[0].isAssignableFrom(param);
        }

        public void invoke(Context context) {
            if (!context.getCheckMode().shouldCheck(this.checkType)) {
                return;
            }
            try {
                this.method.invoke((Object)context.getCurrentValidator(), context.getCurrentObject());
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                context.getCurrentValidator().handleInvocationTargetException(exception, context);
            }
        }
    }

    protected static class Context {
        private final AbstractDeclarativeValidator.StateAccess validationState;
        private final MethodWrapper currentMethod;
        private final WeakReference<AbstractExtraLanguageValidator> currentValidator;
        private final ValidationMessageAcceptor messageAcceptor;

        Context(AbstractDeclarativeValidator.StateAccess validationState, AbstractExtraLanguageValidator validator, MethodWrapper currentMethod, ValidationMessageAcceptor messageAcceptor) {
            this.currentValidator = new WeakReference<AbstractExtraLanguageValidator>(validator);
            this.validationState = validationState;
            this.currentMethod = currentMethod;
            this.messageAcceptor = messageAcceptor;
        }

        public EObject getCurrentObject() {
            return this.validationState.getState().currentObject;
        }

        public Method getCurrentMethod() {
            return this.currentMethod.getMethod();
        }

        public AbstractExtraLanguageValidator getCurrentValidator() {
            return (AbstractExtraLanguageValidator)this.currentValidator.get();
        }

        public DiagnosticChain getChain() {
            return this.validationState.getState().chain;
        }

        public CheckMode getCheckMode() {
            return this.validationState.getState().checkMode;
        }

        public CheckType getCheckType() {
            return this.validationState.getState().currentCheckType;
        }

        public Map<Object, Object> getContext() {
            return this.validationState.getState().context;
        }

        public ValidationMessageAcceptor getMessageAcceptor() {
            return this.messageAcceptor;
        }
    }

    private static final class FeatureCallComparator
    implements Comparator<XAbstractFeatureCall> {
        public static final FeatureCallComparator SINGLETON = new FeatureCallComparator();

        private FeatureCallComparator() {
        }

        @Override
        public int compare(XAbstractFeatureCall o1, XAbstractFeatureCall o2) {
            assert (o1 != null && o2 != null);
            if (o1 == o2) {
                return 0;
            }
            return Integer.compare(System.identityHashCode(o1), System.identityHashCode(o2));
        }
    }
}

