/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.formatting2;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import io.sarl.lang.core.util.SarlUtils;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.formatting2.FormatterPreferences;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormatter2;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.TextRegionAccessBuilder;
import org.eclipse.xtext.preferences.IPreferenceValues;
import org.eclipse.xtext.preferences.IPreferenceValuesProvider;
import org.eclipse.xtext.preferences.TypedPreferenceValues;
import org.eclipse.xtext.resource.IResourceFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.StringInputStream;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

public class FormatterFacade {
    @Inject
    private IResourceFactory resourceFactory;
    @Inject
    @FormatterPreferences
    private IPreferenceValuesProvider configurationProvider;
    @Inject
    private IFormatter2 formatter;
    @Inject
    private Provider<TextRegionAccessBuilder> regionAccessBuilder;
    @Inject
    @Named(value="file.extensions")
    private String fileExtensions;
    private String fileExtension;

    private String getFileExtension() {
        if (this.fileExtension == null) {
            this.fileExtension = SarlUtils.getMajorFileExtension((String)this.fileExtensions);
        }
        return this.fileExtension;
    }

    @Pure
    public String format(String sarlCode) {
        return this.format(sarlCode, (ResourceSet)new XtextResourceSet());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Pure
    public String format(String sarlCode, ResourceSet resourceSet) {
        try {
            URI createURI = URI.createURI((String)("synthetic://to-be-formatted." + this.getFileExtension()));
            Resource res = this.resourceFactory.createResource(createURI);
            if (res instanceof XtextResource) {
                XtextResource resource = (XtextResource)res;
                EList resources = resourceSet.getResources();
                resources.add((Object)resource);
                try {
                    String string;
                    try (StringInputStream stringInputStream = new StringInputStream(sarlCode);){
                        resource.load((InputStream)stringInputStream, Collections.emptyMap());
                        string = this.formatResource(resource);
                    }
                    return string;
                }
                finally {
                    resources.remove((Object)resource);
                }
            }
            return sarlCode;
        }
        catch (Exception exception) {
            throw Exceptions.sneakyThrow((Throwable)exception);
        }
    }

    public void format(XtextResource resource) {
        assert (resource != null);
        String result = this.formatResource(resource);
        try (StringInputStream stringInputStream = new StringInputStream(result);){
            resource.load((InputStream)stringInputStream, Collections.emptyMap());
        }
        catch (Exception exception) {
            throw Exceptions.sneakyThrow((Throwable)exception);
        }
    }

    @Pure
    protected String formatResource(XtextResource resource) {
        assert (resource != null);
        try {
            ITextRegionAccess regionAccess = ((TextRegionAccessBuilder)this.regionAccessBuilder.get()).forNodeModel(resource).create();
            FormatterRequest formatterRequest = new FormatterRequest();
            formatterRequest.setAllowIdentityEdits(false);
            formatterRequest.setTextRegionAccess(regionAccess);
            IPreferenceValues preferenceValues = this.configurationProvider.getPreferenceValues((Resource)resource);
            formatterRequest.setPreferences(TypedPreferenceValues.castOrWrap((IPreferenceValues)preferenceValues));
            List replacements = this.formatter.format(formatterRequest);
            return regionAccess.getRewriter().renderToString((Iterable)replacements);
        }
        catch (Exception exception) {
            throw Exceptions.sneakyThrow((Throwable)exception);
        }
    }

    public void formatRegion(XtextResource resource, int offset, int length) {
        assert (resource != null);
        assert (offset >= 0);
        assert (length >= 0);
        String result = this.formatResourceRegion(resource, offset, length);
        try (StringInputStream stringInputStream = new StringInputStream(result);){
            resource.load((InputStream)stringInputStream, Collections.emptyMap());
        }
        catch (Exception exception) {
            throw Exceptions.sneakyThrow((Throwable)exception);
        }
    }

    @Pure
    public String formatResourceRegion(XtextResource resource, int offset, int length) {
        assert (resource != null);
        assert (offset >= 0);
        assert (length >= 0);
        try {
            ITextRegionAccess regionAccess = ((TextRegionAccessBuilder)this.regionAccessBuilder.get()).forNodeModel(resource).create();
            FormatterRequest formatterRequest = new FormatterRequest();
            formatterRequest.setAllowIdentityEdits(false);
            formatterRequest.setRegions(Collections.singleton(regionAccess.regionForOffset(offset, length)));
            formatterRequest.setTextRegionAccess(regionAccess);
            List replacements = this.formatter.format(formatterRequest);
            return regionAccess.getRewriter().renderToString((Iterable)replacements);
        }
        catch (Exception exception) {
            throw Exceptions.sneakyThrow((Throwable)exception);
        }
    }
}

