/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.formatting2;

import com.google.inject.Inject;
import com.google.inject.Injector;
import io.sarl.lang.formatting2.Messages;
import io.sarl.lang.formatting2.SARLFormatterPreferenceKeys;
import io.sarl.lang.formatting2.SARLMultilineCommentReplacer;
import io.sarl.lang.formatting2.SARLSinglelineCommentReplacer;
import io.sarl.lang.sarl.SarlAction;
import io.sarl.lang.sarl.SarlAgent;
import io.sarl.lang.sarl.SarlBehavior;
import io.sarl.lang.sarl.SarlBehaviorUnit;
import io.sarl.lang.sarl.SarlCapacity;
import io.sarl.lang.sarl.SarlCapacityUses;
import io.sarl.lang.sarl.SarlEvent;
import io.sarl.lang.sarl.SarlRequiredCapacity;
import io.sarl.lang.sarl.SarlSkill;
import io.sarl.lang.services.SARLGrammarKeywordAccess;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend.core.formatting2.XtendFormatter;
import org.eclipse.xtend.core.formatting2.XtendFormatterPreferenceKeys;
import org.eclipse.xtend.core.xtend.XtendAnnotationTarget;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendEnumLiteral;
import org.eclipse.xtend.core.xtend.XtendExecutable;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.internal.CommentReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IComment;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionFinder;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionsFinder;
import org.eclipse.xtext.grammaranalysis.impl.GrammarElementTitleSwitch;
import org.eclipse.xtext.preferences.TypedPreferenceKey;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotationElementValuePair;
import org.eclipse.xtext.xbase.formatting2.XbaseFormatterPreferenceKeys;
import org.eclipse.xtext.xbase.lib.Procedures;

public class SARLFormatter
extends XtendFormatter {
    public static final String COMMENT_NAME = "io.sarl.lang.formatting2.COMMENT_TO_FORMAT";
    public static final String COMMENT_PREFIX_NAME = "io.sarl.lang.formatting2.COMMENT_PREFIX";
    private static final Procedures.Procedure1<? super IHiddenRegionFormatter> ONE_SPACE = it -> it.oneSpace();
    private static final Procedures.Procedure1<? super IHiddenRegionFormatter> NO_SPACE = it -> it.noSpace();
    private static final Procedures.Procedure1<? super IHiddenRegionFormatter> NEW_LINE = it -> it.newLine();
    private static final Procedures.Procedure1<? super IHiddenRegionFormatter> INDENT = it -> it.indent();
    @Inject
    private Injector injector;
    @Inject
    private SARLGrammarKeywordAccess keywords;

    public ITextReplacer createCommentReplacer(IComment comment) {
        EObject grammarElement = comment.getGrammarElement();
        if (grammarElement instanceof AbstractRule) {
            AbstractRule cvalue = (AbstractRule)grammarElement;
            String ruleName = cvalue.getName();
            CommentReplacer replacer = null;
            if (ruleName.startsWith("ML")) {
                replacer = new SARLMultilineCommentReplacer(comment);
            } else if (ruleName.startsWith("SL")) {
                replacer = new SARLSinglelineCommentReplacer(comment);
            }
            if (replacer != null) {
                this.injector.injectMembers((Object)replacer);
                return replacer;
            }
        }
        String elementName = new GrammarElementTitleSwitch().showQualified().showRule().doSwitch(grammarElement);
        throw new IllegalStateException(MessageFormat.format(Messages.SARLFormatter_0, ITextReplacer.class.getSimpleName(), elementName));
    }

    public void format(Object sarlComponent, IFormattableDocument document) {
        try {
            if (sarlComponent instanceof SarlEvent) {
                SarlEvent cvalue = (SarlEvent)sarlComponent;
                this._format(cvalue, document);
            } else if (sarlComponent instanceof SarlCapacity) {
                SarlCapacity cvalue = (SarlCapacity)sarlComponent;
                this._format(cvalue, document);
            } else if (sarlComponent instanceof SarlAgent) {
                SarlAgent cvalue = (SarlAgent)sarlComponent;
                this._format(cvalue, document);
            } else if (sarlComponent instanceof SarlBehavior) {
                SarlBehavior cvalue = (SarlBehavior)sarlComponent;
                this._format(cvalue, document);
            } else if (sarlComponent instanceof SarlSkill) {
                SarlSkill cvalue = (SarlSkill)sarlComponent;
                this._format(cvalue, document);
            } else if (sarlComponent instanceof SarlBehaviorUnit) {
                SarlBehaviorUnit cvalue = (SarlBehaviorUnit)sarlComponent;
                this._format(cvalue, document);
            } else if (sarlComponent instanceof SarlCapacityUses) {
                SarlCapacityUses cvalue = (SarlCapacityUses)sarlComponent;
                this._format(cvalue, document);
            } else if (sarlComponent instanceof SarlRequiredCapacity) {
                SarlRequiredCapacity cvalue = (SarlRequiredCapacity)sarlComponent;
                this._format(cvalue, document);
            } else {
                super.format(sarlComponent, document);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void _format(XBlockExpression expr, IFormattableDocument document) {
        if (((Boolean)this.getPreferences().getPreference((TypedPreferenceKey)SARLFormatterPreferenceKeys.ENABLE_SINGLELINE_EXPRESSION)).booleanValue()) {
            super._format(expr, document);
        } else {
            ISemanticRegionsFinder regionFor = this.textRegionExtensions.regionFor((EObject)expr);
            if (expr.eContainer() == null) {
                document.surround((EObject)expr, NO_SPACE);
            }
            ISemanticRegion open = regionFor.keyword(this.keywords.getLeftCurlyBracketKeyword());
            ISemanticRegion close = regionFor.keyword(this.keywords.getRightCurlyBracketKeyword());
            if (open != null && close != null) {
                this.formatExpressionsMultiline((Collection)expr.getExpressions(), open, close, document);
            }
        }
    }

    protected void _format(SarlEvent event, IFormattableDocument document) {
        this.formatAnnotations((XtendAnnotationTarget)event, document, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.newLineAfterClassAnnotations);
        this.formatModifiers((XtendMember)event, document);
        this.formatTypeParameters((XtendMember)event, (List)event.getTypeParameters(), document);
        ISemanticRegionsFinder regionFor = this.textRegionExtensions.regionFor((EObject)event);
        document.append(regionFor.keyword(this.keywords.getEventKeyword()), ONE_SPACE);
        document.surround(regionFor.keyword(this.keywords.getExtendsKeyword()), ONE_SPACE);
        document.format((Object)event.getExtends());
        this.formatBody(event, document);
    }

    protected void _format(SarlCapacity capacity, IFormattableDocument document) {
        this.formatAnnotations((XtendAnnotationTarget)capacity, document, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.newLineAfterClassAnnotations);
        this.formatModifiers((XtendMember)capacity, document);
        ISemanticRegionsFinder regionFor = this.textRegionExtensions.regionFor((EObject)capacity);
        document.append(regionFor.keyword(this.keywords.getCapacityKeyword()), ONE_SPACE);
        document.surround(regionFor.keyword(this.keywords.getExtendsKeyword()), ONE_SPACE);
        this.formatCommaSeparatedList((Collection<? extends EObject>)capacity.getExtends(), document);
        this.formatBody(capacity, document);
    }

    protected void _format(SarlAgent agent, IFormattableDocument document) {
        this.formatAnnotations((XtendAnnotationTarget)agent, document, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.newLineAfterClassAnnotations);
        this.formatModifiers((XtendMember)agent, document);
        ISemanticRegionsFinder regionFor = this.textRegionExtensions.regionFor((EObject)agent);
        document.append(regionFor.keyword(this.keywords.getAgentKeyword()), ONE_SPACE);
        document.surround(regionFor.keyword(this.keywords.getExtendsKeyword()), ONE_SPACE);
        document.format((Object)agent.getExtends());
        this.formatBody(agent, document);
    }

    protected void _format(SarlBehavior behavior, IFormattableDocument document) {
        this.formatAnnotations((XtendAnnotationTarget)behavior, document, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.newLineAfterClassAnnotations);
        this.formatModifiers((XtendMember)behavior, document);
        ISemanticRegionsFinder regionFor = this.textRegionExtensions.regionFor((EObject)behavior);
        document.append(regionFor.keyword(this.keywords.getBehaviorKeyword()), ONE_SPACE);
        document.surround(regionFor.keyword(this.keywords.getExtendsKeyword()), ONE_SPACE);
        document.format((Object)behavior.getExtends());
        this.formatBody(behavior, document);
    }

    protected void _format(SarlSkill skill, IFormattableDocument document) {
        this.formatAnnotations((XtendAnnotationTarget)skill, document, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.newLineAfterClassAnnotations);
        this.formatModifiers((XtendMember)skill, document);
        ISemanticRegionsFinder regionFor = this.textRegionExtensions.regionFor((EObject)skill);
        document.append(regionFor.keyword(this.keywords.getSkillKeyword()), ONE_SPACE);
        document.surround(regionFor.keyword(this.keywords.getExtendsKeyword()), ONE_SPACE);
        document.format((Object)skill.getExtends());
        document.surround(regionFor.keyword(this.keywords.getImplementsKeyword()), ONE_SPACE);
        this.formatCommaSeparatedList((Collection<? extends EObject>)skill.getImplements(), document);
        this.formatBody(skill, document);
    }

    protected void _format(XtendField field, IFormattableDocument document) {
        this.formatAnnotations((XtendAnnotationTarget)field, document, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.newLineAfterFieldAnnotations);
        this.formatModifiers((XtendMember)field, document);
        ISemanticRegionsFinder regionFor = this.textRegionExtensions.regionFor((EObject)field);
        ISemanticRegion columnKw = regionFor.keyword(this.keywords.getColonKeyword());
        document.prepend(columnKw, ONE_SPACE);
        document.append(columnKw, ONE_SPACE);
        ISemanticRegion equalKw = regionFor.keyword(this.keywords.getEqualsSignKeyword());
        document.prepend(equalKw, ONE_SPACE);
        document.append(equalKw, ONE_SPACE);
        ISemanticRegion semicolumn = regionFor.keyword(this.keywords.getSemicolonKeyword());
        document.prepend(semicolumn, NO_SPACE);
        JvmTypeReference type = field.getType();
        document.format((Object)type);
        XExpression initialValue = field.getInitialValue();
        document.format((Object)initialValue);
    }

    protected void _format(XtendFunction function, IFormattableDocument document) {
        XExpression expression;
        EList exceptions;
        ISemanticRegion nameNode;
        ISemanticRegionFinder immediatelyFollowing;
        this.formatAnnotations((XtendAnnotationTarget)function, document, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.newLineAfterMethodAnnotations);
        this.formatModifiers((XtendMember)function, document);
        EList typeParameters = function.getTypeParameters();
        ISemanticRegionsFinder regionFor = this.textRegionExtensions.regionFor((EObject)function);
        if (!typeParameters.isEmpty()) {
            ISemanticRegion open = regionFor.keyword(this.keywords.getLessThanSignKeyword());
            document.prepend(open, ONE_SPACE);
            document.append(open, NO_SPACE);
            ISemanticRegion close = regionFor.keyword(this.keywords.getGreaterThanSignKeyword());
            document.prepend(close, NO_SPACE);
            document.append(close, ONE_SPACE);
            document.surround(regionFor.keyword(this.keywords.getWithKeyword()), ONE_SPACE);
            this.formatCommaSeparatedList((Collection<? extends EObject>)function.getTypeParameters(), document);
        }
        if ((immediatelyFollowing = (nameNode = regionFor.feature((EStructuralFeature)XtendPackage.Literals.XTEND_FUNCTION__NAME)) != null ? nameNode.immediatelyFollowing() : null) != null) {
            ISemanticRegion open = immediatelyFollowing.keyword(this.keywords.getLeftParenthesisKeyword());
            document.prepend(open, NO_SPACE);
            ISemanticRegion close = regionFor.keyword(this.keywords.getRightParenthesisKeyword());
            EList parameters = function.getParameters();
            this.formatCommaSeparatedList((Collection)parameters, open, close, document);
        } else {
            Object open = null;
        }
        JvmTypeReference returnType = function.getReturnType();
        if (returnType != null) {
            ISemanticRegion typeColumn = this.textRegionExtensions.immediatelyPreceding((EObject)returnType).keyword(this.keywords.getColonKeyword());
            document.surround(typeColumn, ONE_SPACE);
            document.format((Object)returnType);
        }
        if (!(exceptions = function.getExceptions()).isEmpty()) {
            document.surround(regionFor.keyword(this.keywords.getThrowsKeyword()), ONE_SPACE);
        }
        this.formatCommaSeparatedList((Collection<? extends EObject>)exceptions, document);
        if (function instanceof SarlAction) {
            SarlAction cvalue = (SarlAction)function;
            EList<JvmTypeReference> events = cvalue.getFiredEvents();
            if (!events.isEmpty()) {
                document.surround(regionFor.keyword(this.keywords.getFiresKeyword()), ONE_SPACE);
            }
            this.formatCommaSeparatedList((Collection<? extends EObject>)events, document);
        }
        if ((expression = function.getExpression()) != null) {
            ISemanticRegionsFinder finder = this.textRegionExtensions.regionFor((EObject)expression);
            ISemanticRegion brace = finder.keyword(this.keywords.getLeftCurlyBracketKeyword());
            document.prepend(brace, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.bracesInNewLine);
            document.format((Object)expression);
        } else {
            ISemanticRegion column = regionFor.keyword(this.keywords.getSemicolonKeyword());
            document.prepend(column, NO_SPACE);
        }
    }

    protected void _format(XtendConstructor constructor, IFormattableDocument document) {
        Object immediatelyFollowing;
        ISemanticRegion close;
        Object open;
        this.formatAnnotations((XtendAnnotationTarget)constructor, document, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.newLineAfterConstructorAnnotations);
        this.formatModifiers((XtendMember)constructor, document);
        EList typeParameters = constructor.getTypeParameters();
        ISemanticRegionsFinder regionFor = this.textRegionExtensions.regionFor((EObject)constructor);
        ISemanticRegion nameNode = regionFor.keyword(this.keywords.getNewKeyword());
        if (!typeParameters.isEmpty()) {
            open = regionFor.keyword(this.keywords.getLessThanSignKeyword());
            document.prepend(open, ONE_SPACE);
            document.append(open, NO_SPACE);
            close = regionFor.keyword(this.keywords.getGreaterThanSignKeyword());
            document.prepend(close, NO_SPACE);
            document.append(close, ONE_SPACE);
            document.surround(regionFor.keyword(this.keywords.getWithKeyword()), ONE_SPACE);
            this.formatCommaSeparatedList((Collection<? extends EObject>)constructor.getTypeParameters(), document);
            immediatelyFollowing = close != null ? close.immediatelyFollowing() : (nameNode != null ? nameNode.immediatelyFollowing() : null);
        } else {
            immediatelyFollowing = nameNode != null ? nameNode.immediatelyFollowing() : null;
        }
        open = immediatelyFollowing != null ? immediatelyFollowing.keyword(this.keywords.getLeftParenthesisKeyword()) : null;
        close = regionFor.keyword(this.keywords.getRightParenthesisKeyword());
        XExpression expression = constructor.getExpression();
        if (expression != null) {
            ISemanticRegionsFinder finder = this.textRegionExtensions.regionFor((EObject)expression);
            ISemanticRegion brace = finder.keyword(this.keywords.getLeftCurlyBracketKeyword());
            document.prepend(brace, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.bracesInNewLine);
            document.format((Object)expression);
        }
        EList parameters = constructor.getParameters();
        this.formatCommaSeparatedList((Collection)parameters, (ISemanticRegion)open, close, document);
        EList exceptions = constructor.getExceptions();
        if (!exceptions.isEmpty()) {
            document.surround(regionFor.keyword(this.keywords.getThrowsKeyword()), ONE_SPACE);
        }
        this.formatCommaSeparatedList((Collection<? extends EObject>)exceptions, document);
    }

    protected void _format(SarlBehaviorUnit behaviorUnit, IFormattableDocument document) {
        this.formatAnnotations((XtendAnnotationTarget)behaviorUnit, document, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.newLineAfterMethodAnnotations);
        ISemanticRegionsFinder regionFor = this.textRegionExtensions.regionFor((EObject)behaviorUnit);
        document.append(regionFor.keyword(this.keywords.getOnKeyword()), ONE_SPACE);
        if (behaviorUnit.getGuard() != null) {
            ISemanticRegion keyword = this.textRegionExtensions.immediatelyPreceding((EObject)behaviorUnit.getGuard()).keyword(this.keywords.getLeftSquareBracketKeyword());
            document.prepend(keyword, ONE_SPACE);
            document.append(keyword, NO_SPACE);
            keyword = this.textRegionExtensions.immediatelyFollowing((EObject)behaviorUnit.getGuard()).keyword(this.keywords.getRightSquareBracketKeyword());
            document.prepend(keyword, NO_SPACE);
        }
        document.format((Object)behaviorUnit.getName());
        document.format((Object)behaviorUnit.getGuard());
        XExpression expression = behaviorUnit.getExpression();
        if (expression != null) {
            ISemanticRegionsFinder finder = this.textRegionExtensions.regionFor((EObject)expression);
            ISemanticRegion brace = finder.keyword(this.keywords.getLeftCurlyBracketKeyword());
            document.prepend(brace, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.bracesInNewLine);
            document.format((Object)expression);
        }
    }

    protected void _format(SarlCapacityUses capacityUses, IFormattableDocument document) {
        ISemanticRegionsFinder regionFor = this.textRegionExtensions.regionFor((EObject)capacityUses);
        document.append(regionFor.keyword(this.keywords.getUsesKeyword()), ONE_SPACE);
        this.formatCommaSeparatedList((Collection<? extends EObject>)capacityUses.getCapacities(), document);
        document.prepend(regionFor.keyword(this.keywords.getSemicolonKeyword()), NO_SPACE);
    }

    protected void _format(SarlRequiredCapacity requiredCapacity, IFormattableDocument document) {
        ISemanticRegionsFinder regionFor = this.textRegionExtensions.regionFor((EObject)requiredCapacity);
        document.append(regionFor.keyword(this.keywords.getRequiresKeyword()), ONE_SPACE);
        this.formatCommaSeparatedList((Collection<? extends EObject>)requiredCapacity.getCapacities(), document);
        document.prepend(regionFor.keyword(this.keywords.getSemicolonKeyword()), NO_SPACE);
    }

    protected void _format(XtendParameter param, IFormattableDocument document) {
        this.formatAnnotations((XtendAnnotationTarget)param, document, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.newLineAfterParameterAnnotations);
        ISemanticRegionsFinder regionFor = this.textRegionExtensions.regionFor((EObject)param);
        document.surround(regionFor.keyword(this.keywords.getColonKeyword()), ONE_SPACE);
        document.surround(regionFor.keyword(this.keywords.getEqualsSignKeyword()), ONE_SPACE);
        JvmTypeReference parameterType = param.getParameterType();
        if (parameterType != null) {
            document.format((Object)parameterType);
            ISemanticRegion varArgToken = regionFor.keyword(this.keywords.getWildcardAsteriskKeyword());
            document.surround(varArgToken, NO_SPACE);
        }
    }

    protected void _format(XVariableDeclaration expr, IFormattableDocument document) {
        ISemanticRegionsFinder regionFor = this.textRegionExtensions.regionFor((EObject)expr);
        document.append(regionFor.keyword(this.keywords.getExtensionExtensionKeyword()), ONE_SPACE);
        document.append(regionFor.keyword(this.keywords.getValKeyword()), ONE_SPACE);
        document.append(regionFor.keyword(this.keywords.getWriteableVarKeyword()), ONE_SPACE);
        document.surround(regionFor.keyword(this.keywords.getColonKeyword()), ONE_SPACE);
        document.surround(regionFor.keyword(this.keywords.getEqualsSignKeyword()), ONE_SPACE);
        document.format((Object)expr.getType());
        document.format((Object)expr.getRight());
    }

    protected void _format(JvmFormalParameter expr, IFormattableDocument document) {
        ISemanticRegionsFinder regionFor = this.textRegionExtensions.regionFor((EObject)expr);
        document.append(regionFor.keyword(this.keywords.getExtensionExtensionKeyword()), ONE_SPACE);
        JvmTypeReference parameterType = expr.getParameterType();
        if (parameterType != null) {
            document.surround(regionFor.keyword(this.keywords.getColonKeyword()), ONE_SPACE);
            document.surround(regionFor.keyword(this.keywords.getAsKeyword()), ONE_SPACE);
        }
        document.format((Object)parameterType);
    }

    protected void _format(XForLoopExpression expr, IFormattableDocument document) {
        ISemanticRegionsFinder regionFor = this.textRegionExtensions.regionFor((EObject)expr);
        document.append(regionFor.keyword(this.keywords.getForKeyword()), ONE_SPACE);
        JvmFormalParameter declaredParam = expr.getDeclaredParam();
        document.prepend((EObject)declaredParam, NO_SPACE);
        document.append((EObject)declaredParam, ONE_SPACE);
        document.format((Object)declaredParam);
        XExpression forExpression = expr.getForExpression();
        document.prepend((EObject)forExpression, ONE_SPACE);
        document.append((EObject)forExpression, NO_SPACE);
        document.format((Object)forExpression);
        XExpression eachExpression = expr.getEachExpression();
        if (eachExpression != null) {
            this.formatBody(eachExpression, true, document);
        } else {
            document.prepend(regionFor.keyword(this.keywords.getSemicolonKeyword()), NO_SPACE);
        }
    }

    protected void _format(XAnnotation annotation, IFormattableDocument document) {
        ISemanticRegionsFinder regionFor = this.textRegionExtensions.regionFor((EObject)annotation);
        document.append(regionFor.keyword(this.keywords.getCommercialAtKeyword()), NO_SPACE);
        document.surround(regionFor.keyword(this.keywords.getLeftParenthesisKeyword()), NO_SPACE);
        XExpression value = annotation.getValue();
        if (value != null) {
            document.format((Object)value);
        } else {
            EList elementValuePairs = annotation.getElementValuePairs();
            if (!elementValuePairs.isEmpty()) {
                for (XAnnotationElementValuePair pair : elementValuePairs) {
                    ISemanticRegionsFinder regionForPair = this.textRegionExtensions.regionFor((EObject)pair);
                    document.surround(regionForPair.keyword(this.keywords.getEqualsSignKeyword()), ONE_SPACE);
                    value = pair.getValue();
                    document.format((Object)value);
                    ISemanticRegionFinder immediatelyFollowing = this.textRegionExtensions.immediatelyFollowing((EObject)pair);
                    ISemanticRegion keyword = immediatelyFollowing.keyword(this.keywords.getCommaKeyword());
                    document.prepend(keyword, NO_SPACE);
                    document.append(keyword, ONE_SPACE);
                }
            }
        }
        document.prepend(regionFor.keyword(this.keywords.getRightParenthesisKeyword()), NO_SPACE);
    }

    protected void _format(Object element, IFormattableDocument document) {
        throw new UnsupportedOperationException(element.getClass().getName());
    }

    protected void formatCommaSeparatedList(Collection<? extends EObject> elements, IFormattableDocument document) {
        for (EObject eObject : elements) {
            document.format((Object)eObject);
            ISemanticRegionFinder immediatelyFollowing = this.textRegionExtensions.immediatelyFollowing(eObject);
            ISemanticRegion keyword = immediatelyFollowing.keyword(this.keywords.getCommaKeyword());
            document.prepend(keyword, NO_SPACE);
            document.append(keyword, ONE_SPACE);
        }
    }

    protected ISemanticRegion formatBody(XtendTypeDeclaration type, IFormattableDocument document) {
        ISemanticRegionsFinder regionFor = this.textRegionExtensions.regionFor((EObject)type);
        ISemanticRegion open = regionFor.keyword(this.keywords.getLeftCurlyBracketKeyword());
        ISemanticRegion close = regionFor.keyword(this.keywords.getRightCurlyBracketKeyword());
        document.prepend(open, (Procedures.Procedure1)XbaseFormatterPreferenceKeys.bracesInNewLine);
        document.interior(open, close, INDENT);
        EList members = type.getMembers();
        if (!members.isEmpty()) {
            XtendMember previous = null;
            for (XtendMember current : members) {
                document.format((Object)current);
                if (previous == null) {
                    document.prepend((EObject)current, (Procedures.Procedure1)XtendFormatterPreferenceKeys.blankLinesBeforeFirstMember);
                } else if (previous instanceof XtendField) {
                    if (current instanceof XtendField) {
                        document.append((EObject)previous, (Procedures.Procedure1)XtendFormatterPreferenceKeys.blankLinesBetweenFields);
                    } else {
                        document.append((EObject)previous, (Procedures.Procedure1)SARLFormatterPreferenceKeys.BLANK_LINES_BETWEEN_MEMBER_CATEGORIES);
                    }
                } else if (previous instanceof XtendExecutable) {
                    if (current instanceof XtendExecutable) {
                        document.append((EObject)previous, (Procedures.Procedure1)XtendFormatterPreferenceKeys.blankLinesBetweenMethods);
                    } else {
                        document.append((EObject)previous, (Procedures.Procedure1)SARLFormatterPreferenceKeys.BLANK_LINES_BETWEEN_MEMBER_CATEGORIES);
                    }
                } else if (previous instanceof XtendTypeDeclaration) {
                    if (current instanceof XtendTypeDeclaration) {
                        document.append((EObject)previous, (Procedures.Procedure1)SARLFormatterPreferenceKeys.BLANK_LINES_BETWEEN_INNER_TYPES);
                    } else {
                        document.append((EObject)previous, (Procedures.Procedure1)SARLFormatterPreferenceKeys.BLANK_LINES_BETWEEN_MEMBER_CATEGORIES);
                    }
                } else if (previous instanceof XtendEnumLiteral) {
                    if (current instanceof XtendEnumLiteral) {
                        document.append((EObject)previous, (Procedures.Procedure1)XtendFormatterPreferenceKeys.blankLinesBetweenEnumLiterals);
                    } else {
                        document.append((EObject)previous, (Procedures.Procedure1)SARLFormatterPreferenceKeys.BLANK_LINES_BETWEEN_MEMBER_CATEGORIES);
                    }
                } else if (previous instanceof SarlCapacityUses) {
                    if (current instanceof SarlCapacityUses) {
                        document.append((EObject)previous, (Procedures.Procedure1)SARLFormatterPreferenceKeys.BLANK_LINES_BETWEEN_CAPACITY_USES);
                    } else {
                        document.append((EObject)previous, (Procedures.Procedure1)SARLFormatterPreferenceKeys.BLANK_LINES_BETWEEN_MEMBER_CATEGORIES);
                    }
                } else if (previous instanceof SarlRequiredCapacity) {
                    if (current instanceof SarlCapacityUses) {
                        document.append((EObject)previous, (Procedures.Procedure1)SARLFormatterPreferenceKeys.BLANK_LINES_BETWEEN_CAPACITY_REQUIREMENTS);
                    } else {
                        document.append((EObject)previous, (Procedures.Procedure1)SARLFormatterPreferenceKeys.BLANK_LINES_BETWEEN_MEMBER_CATEGORIES);
                    }
                } else {
                    document.append((EObject)previous, (Procedures.Procedure1)SARLFormatterPreferenceKeys.BLANK_LINES_BETWEEN_MEMBER_CATEGORIES);
                }
                previous = current;
            }
            if (previous != null) {
                document.append(previous, (Procedures.Procedure1)XtendFormatterPreferenceKeys.blankLinesAfterLastMember);
            }
            return null;
        }
        return document.append(open, NEW_LINE);
    }
}

