/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.formatting2;

import com.google.inject.Inject;
import io.sarl.lang.bugfixes.unpublished.BugMultilineCommentIndentation;
import io.sarl.lang.documentation.IDocumentationFormatter;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatting;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.internal.CommentReplacer;
import org.eclipse.xtext.formatting2.internal.WhitespaceReplacer;
import org.eclipse.xtext.formatting2.regionaccess.IComment;

public class SARLMultilineCommentReplacer
extends CommentReplacer {
    private static final int MIN_NUMBER_OF_LINES_BEFORE_COMMENT = 1;
    private static final int MAX_NUMBER_OF_LINES_BEFORE_COMMENT = 1;
    private static final int NUMBER_OF_LINES_AFTER_COMMENT = 0;
    @Inject
    private IDocumentationFormatter formatter;
    @Inject
    private BugMultilineCommentIndentation bugfix;

    public SARLMultilineCommentReplacer(IComment comment) {
        super(comment);
    }

    public void configureWhitespace(WhitespaceReplacer leading, WhitespaceReplacer trailing) {
        if (leading.getRegion().getOffset() > 0) {
            int nbMin = 2;
            int nbMax = 2;
            IHiddenRegionFormatting formatting = leading.getFormatting();
            formatting.setNewLinesDefault(Integer.valueOf(2));
            formatting.setNewLinesMin(Integer.valueOf(2));
            formatting.setNewLinesMax(Integer.valueOf(2));
            formatting.setNoIndentation(Boolean.FALSE);
        } else {
            IHiddenRegionFormatting formatting = leading.getFormatting();
            formatting.setNewLinesDefault(Integer.valueOf(0));
            formatting.setNewLinesMin(Integer.valueOf(0));
            formatting.setNewLinesMax(Integer.valueOf(0));
            formatting.setNoIndentation(Boolean.FALSE);
        }
        if (trailing.getRegion().getOffset() > 0) {
            boolean nb = true;
            IHiddenRegionFormatting formatting = trailing.getFormatting();
            formatting.setNewLinesDefault(Integer.valueOf(1));
            formatting.setNewLinesMin(Integer.valueOf(1));
            formatting.setNewLinesMax(Integer.valueOf(1));
            formatting.setNoIndentation(Boolean.FALSE);
        }
    }

    public ITextReplacerContext createReplacements(ITextReplacerContext context) {
        IComment comment = this.getComment();
        if (context != null && comment != null) {
            this.formatter.formatMultilineComment(this.bugfix.fix(context, comment), comment);
        }
        return context;
    }
}

