/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.jvmmodel;

import com.google.inject.Inject;
import io.sarl.lang.jvmmodel.IDefaultVisibilityProvider;
import io.sarl.lang.jvmmodel.SarlJvmModelAssociations;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.impl.XtendMemberImplCustom;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmVisibility;

public class DefaultVisibilityProvider
implements IDefaultVisibilityProvider {
    private final Method visiblityMethod;
    @Inject
    private SarlJvmModelAssociations associations;

    public DefaultVisibilityProvider() {
        try {
            this.visiblityMethod = XtendMemberImplCustom.class.getDeclaredMethod("getDefaultVisibility", new Class[0]);
            this.visiblityMethod.setAccessible(true);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public JvmVisibility getDefaultJvmVisibility(EObject element) {
        EObject obj;
        EObject realObject = element;
        if (realObject instanceof JvmIdentifiableElement && (obj = this.associations.getPrimarySourceElement(realObject)) != null) {
            realObject = obj;
        }
        if (realObject instanceof XtendMemberImplCustom) {
            try {
                return (JvmVisibility)this.visiblityMethod.invoke((Object)realObject, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                throw new RuntimeException(exception);
            }
        }
        return JvmVisibility.DEFAULT;
    }

    @Override
    public JvmVisibility getDefaultJvmVisibility(EObject container, EClass element) {
        EObject obj;
        EObject realObject = container;
        if (realObject instanceof JvmIdentifiableElement && (obj = this.associations.getPrimarySourceElement(realObject)) != null) {
            realObject = obj;
        }
        if (realObject != null) {
            if (XtendPackage.eINSTANCE.getXtendFunction().isSuperTypeOf(element)) {
                return IDefaultVisibilityProvider.getActionDefaultVisibilityIn(realObject);
            }
            if (XtendPackage.eINSTANCE.getXtendField().isSuperTypeOf(element)) {
                return IDefaultVisibilityProvider.getFieldDefaultVisibilityIn(realObject);
            }
            if (XtendPackage.eINSTANCE.getXtendClass().isSuperTypeOf(element)) {
                return IDefaultVisibilityProvider.getClassDefaultVisibilityIn(realObject);
            }
            if (XtendPackage.eINSTANCE.getXtendInterface().isSuperTypeOf(element)) {
                return IDefaultVisibilityProvider.getInterfaceDefaultVisibilityIn(realObject);
            }
            if (XtendPackage.eINSTANCE.getXtendEnum().isSuperTypeOf(element)) {
                return IDefaultVisibilityProvider.getEnumerationDefaultVisibilityIn(realObject);
            }
            if (XtendPackage.eINSTANCE.getXtendAnnotationType().isSuperTypeOf(element)) {
                return IDefaultVisibilityProvider.getAnnotationTypeDefaultVisibilityIn(realObject);
            }
            if (XtendPackage.eINSTANCE.getXtendMember().isSuperTypeOf(element)) {
                return JvmVisibility.PUBLIC;
            }
        }
        return JvmVisibility.DEFAULT;
    }
}

