/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.jvmmodel;

import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.inject.Inject;
import io.sarl.lang.compiler.GeneratorConfig2;
import io.sarl.lang.compiler.IGeneratorConfigProvider2;
import io.sarl.lang.core.annotation.Injectable;
import io.sarl.lang.sarl.SarlBehaviorUnit;
import io.sarl.lang.sarl.SarlClass;
import io.sarl.lang.sarl.actionprototype.ActionParameterTypes;
import io.sarl.lang.sarl.actionprototype.ActionPrototype;
import io.sarl.lang.sarl.actionprototype.IActionPrototypeContext;
import io.sarl.lang.sarl.actionprototype.IActionPrototypeProvider;
import io.sarl.lang.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.AnnotationLookup;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.IGeneratorConfigProvider;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public abstract class GenerationContext {
    private static final String MAIN_FUNCTION_PARAMETER_TYPE = String.class.getName() + "[]";
    private JvmDeclaredType target;
    private boolean isInjectable;
    private long serial = 1L;
    private int actionIndex;
    private int behaviorUnitIndex;
    private int localTypeIndex;
    private final Set<String> generatedCapacityUseFields = CollectionLiterals.newHashSet();
    private final Map<ActionParameterTypes, JvmConstructor> generatedConstructors = CollectionLiterals.newTreeMap(null);
    private final Map<ActionPrototype, JvmOperation> finalOperations = CollectionLiterals.newTreeMap(null);
    private final Map<ActionPrototype, JvmOperation> overridableOperations = CollectionLiterals.newTreeMap(null);
    private final Map<ActionPrototype, JvmOperation> operationsToImplement = CollectionLiterals.newTreeMap(null);
    private final Map<ActionPrototype, JvmOperation> localOperations = CollectionLiterals.newTreeMap(null);
    private final List<Runnable> preFinalization = CollectionLiterals.newLinkedList();
    private final List<Runnable> postFinalization = CollectionLiterals.newLinkedList();
    private final Map<String, BehaviorUnitGuardEvaluators> guardEvaluators = new TreeMap<String, BehaviorUnitGuardEvaluators>();
    private final EObject contextObject;
    @Inject
    private IGeneratorConfigProvider generatorConfigProvider;
    @Inject
    private IGeneratorConfigProvider2 generatorConfigProvider2;
    private GeneratorConfig generatorConfig;
    private GeneratorConfig2 generatorConfig2;
    private GenerationContext parent;
    private IActionPrototypeContext actionPrototypeContext;
    @Inject
    private AnnotationLookup annotationFinder;
    private Map<String, List<Object>> userData = new TreeMap<String, List<Object>>();
    @Inject
    private CommonTypeComputationServices services;
    private Boolean isMainFunctionManuallyDefined;

    GenerationContext(EObject owner, JvmDeclaredType target) {
        assert (owner != null);
        this.target = target;
        this.contextObject = owner;
    }

    public String toString() {
        return "Generation context for: " + this.getTypeIdentifier();
    }

    public GenerationContext getParentContext() {
        return this.parent;
    }

    public void setParentContext(GenerationContext parent) {
        this.parent = parent;
    }

    public String getTypeIdentifier() {
        return this.target == null ? null : this.target.getIdentifier();
    }

    public JvmDeclaredType getType() {
        return this.target;
    }

    public GeneratorConfig getGeneratorConfig() {
        if (this.generatorConfig == null) {
            this.generatorConfig = this.generatorConfigProvider.get(EcoreUtil.getRootContainer((EObject)this.contextObject));
        }
        return this.generatorConfig;
    }

    public GeneratorConfig2 getGeneratorConfig2() {
        if (this.generatorConfig2 == null) {
            this.generatorConfig2 = this.generatorConfigProvider2.get(EcoreUtil.getRootContainer((EObject)this.contextObject));
        }
        return this.generatorConfig2;
    }

    public Collection<BehaviorUnitGuardEvaluators> getGuardEvaluationCodes() {
        return this.guardEvaluators.values();
    }

    public Collection<Procedures.Procedure1<? super ITreeAppendable>> ensureGuardEvaluationCodeFor(SarlBehaviorUnit source, TypeReferences typeReferences) {
        JvmTypeParameterDeclarator cvalue;
        JvmType jvmType;
        assert (source != null);
        JvmParameterizedTypeReference eventType = source.getName();
        if (eventType.getArguments().isEmpty() && (jvmType = eventType.getType()) instanceof JvmTypeParameterDeclarator && !(cvalue = (JvmTypeParameterDeclarator)jvmType).getTypeParameters().isEmpty()) {
            int max = cvalue.getTypeParameters().size();
            JvmTypeReference[] tab = new JvmTypeReference[max];
            for (int i = 0; i < max; ++i) {
                tab[i] = typeReferences.wildCard();
            }
            eventType = typeReferences.createTypeRef(eventType.getType(), tab);
        }
        String id = Utils.createBehaviorUnitEventId(eventType);
        JvmParameterizedTypeReference finalEventType = eventType;
        BehaviorUnitGuardEvaluators evaluators = this.guardEvaluators.computeIfAbsent(id, key -> new BehaviorUnitGuardEvaluators(source, finalEventType, new ArrayList<Procedures.Procedure1<? super ITreeAppendable>>()));
        assert (evaluators != null);
        return evaluators.evaluators();
    }

    public long getSerial() {
        return this.serial;
    }

    public void incrementSerial(long value) {
        this.serial += value;
    }

    public boolean hasConstructor() {
        return !this.generatedConstructors.isEmpty();
    }

    public void addGeneratedConstructor(ActionParameterTypes parameters, JvmConstructor jvmElement) {
        this.generatedConstructors.put(parameters, jvmElement);
    }

    public Map<ActionParameterTypes, JvmConstructor> getGeneratedConstructors() {
        return this.generatedConstructors;
    }

    public void addGeneratedCapacityUseField(String capacity) {
        this.generatedCapacityUseFields.add(capacity);
    }

    public Set<String> getGeneratedCapacityUseFields() {
        return this.generatedCapacityUseFields;
    }

    public Map<ActionPrototype, JvmOperation> getInheritedFinalOperations() {
        return this.finalOperations;
    }

    public Map<ActionPrototype, JvmOperation> getInheritedOverridableOperations() {
        return this.overridableOperations;
    }

    public Map<ActionPrototype, JvmOperation> getInheritedOperationsToImplement() {
        return this.operationsToImplement;
    }

    public JvmOperation getLocalOperation(ActionPrototype prototype) {
        return this.localOperations.get(prototype);
    }

    public void doLocalOperationDefinition(ActionPrototype prototype, JvmOperation operation) {
        this.getInheritedOperationsToImplement().remove(prototype);
        this.getInheritedOverridableOperations().remove(prototype);
        this.localOperations.put(prototype, operation);
    }

    public boolean isMainFunctionManuallyDefined() {
        if (this.isMainFunctionManuallyDefined == null) {
            EObject eObject = this.getContextObject();
            if (eObject instanceof SarlClass) {
                SarlClass sarlClass = (SarlClass)eObject;
                this.isMainFunctionManuallyDefined = sarlClass.getMembers().stream().anyMatch(it -> {
                    XtendFunction action;
                    return it instanceof XtendFunction && Utils.isMainFunctionDeclaration(action = (XtendFunction)it, this.services);
                });
            } else {
                this.isMainFunctionManuallyDefined = Boolean.FALSE;
            }
        }
        return this.isMainFunctionManuallyDefined;
    }

    public boolean isMainFunctionGenerated() {
        ActionParameterTypes parameters = new ActionParameterTypes(false, 1);
        parameters.add(MAIN_FUNCTION_PARAMETER_TYPE);
        ActionPrototype prototype = new ActionPrototype(Utils.getNameForJavaMainFunction(), parameters, true);
        if (this.localOperations.containsKey(prototype)) {
            return true;
        }
        parameters = new ActionParameterTypes(true, 1);
        parameters.add(MAIN_FUNCTION_PARAMETER_TYPE);
        prototype = new ActionPrototype(Utils.getNameForJavaMainFunction(), parameters, true);
        return this.localOperations.containsKey(prototype);
    }

    public JvmOperation getInheritedOperation(ActionPrototype prototype) {
        JvmOperation inheritedOperation = this.getInheritedImplementedOperation(prototype);
        if (inheritedOperation == null) {
            inheritedOperation = this.getInheritedOperationsToImplement().get(prototype);
        }
        return inheritedOperation;
    }

    public JvmOperation getInheritedImplementedOperation(ActionPrototype prototype) {
        JvmOperation inheritedOperation = this.getInheritedFinalOperations().get(prototype);
        if (inheritedOperation == null) {
            inheritedOperation = this.getInheritedOverridableOperations().get(prototype);
        }
        return inheritedOperation;
    }

    public JvmOperation getDefinedOperation(ActionPrototype prototype) {
        JvmOperation localOperation = this.localOperations.get(prototype);
        if (localOperation != null) {
            return localOperation;
        }
        return this.getInheritedOperation(prototype);
    }

    public List<Runnable> getPreFinalizationElements() {
        return this.preFinalization;
    }

    public List<Runnable> getPostFinalizationElements() {
        GenerationContext prt = this.getParentContext();
        if (prt != null) {
            return prt.getPostFinalizationElements();
        }
        return this.postFinalization;
    }

    public int getActionIndex() {
        return this.actionIndex;
    }

    public void setActionIndex(int index) {
        this.actionIndex = index;
    }

    public int getBehaviorUnitIndex() {
        return this.behaviorUnitIndex;
    }

    public void setBehaviorUnitIndex(int index) {
        this.behaviorUnitIndex = index;
    }

    public int getLocalTypeIndex() {
        return this.localTypeIndex;
    }

    public void setLocalTypeIndex(int index) {
        this.localTypeIndex = index;
    }

    public abstract boolean isSupportedMember(XtendMember var1);

    public IActionPrototypeContext getActionPrototypeContext(IActionPrototypeProvider provider) {
        if (this.actionPrototypeContext == null) {
            this.actionPrototypeContext = provider.createContext();
        }
        return this.actionPrototypeContext;
    }

    public synchronized boolean isRelease() {
        return this.target == null || this.contextObject == null;
    }

    public synchronized void release() {
        if (this.actionPrototypeContext != null) {
            this.actionPrototypeContext.release();
            this.actionPrototypeContext = null;
        }
        this.target = null;
        this.generatorConfig = null;
        this.generatorConfig2 = null;
        this.finalOperations.clear();
        this.generatedCapacityUseFields.clear();
        this.generatedConstructors.clear();
        this.finalOperations.clear();
        this.overridableOperations.clear();
        this.operationsToImplement.clear();
        this.preFinalization.clear();
        this.postFinalization.clear();
        this.guardEvaluators.clear();
    }

    @Pure
    public EObject getContextObject() {
        return this.contextObject;
    }

    @Pure
    public boolean isInjectable() {
        return this.isInjectable;
    }

    public void setInjectable(boolean injectable) {
        this.isInjectable = injectable;
    }

    protected static boolean hasInjectAnnotation(JvmAnnotationTarget target) {
        return target.getAnnotations().stream().anyMatch(it -> {
            String name;
            JvmAnnotationType annotationType = it.getAnnotation();
            return annotationType != null && (name = annotationType.getQualifiedName()) != null && name.endsWith(".Inject") && (name.startsWith("jakarta.inject.") || name.startsWith("com.google.inject.") || name.startsWith("javax.inject."));
        });
    }

    public void setInjectable(JvmAnnotationTarget element) {
        if (element != null && GenerationContext.hasInjectAnnotation(element)) {
            this.setInjectable(true);
        }
    }

    public void setInjectable(JvmTypeReference element) {
        JvmAnnotationTarget cvalue;
        JvmType type;
        if (element != null && (type = element.getType()) instanceof JvmAnnotationTarget && this.annotationFinder.findAnnotation(cvalue = (JvmAnnotationTarget)type, Injectable.class) != null) {
            this.setInjectable(true);
        }
    }

    public void addUserObject(String id, Object value) {
        if (!Strings.isNullOrEmpty((String)id) && value != null) {
            List usrData = this.userData.computeIfAbsent(id, it -> new ArrayList());
            usrData.add(value);
        }
    }

    public Iterable<Object> consumeUserObject(String id) {
        List<Object> usrData;
        if (!Strings.isNullOrEmpty((String)id) && (usrData = this.userData.remove(id)) != null) {
            return usrData;
        }
        return Collections.emptyList();
    }

    public <T> Iterable<T> consumeUserObject(String id, Class<T> dataType) {
        List<Object> usrData;
        if (!Strings.isNullOrEmpty((String)id) && (usrData = this.userData.remove(id)) != null) {
            Collection output = Collections2.transform(usrData, it -> dataType.cast(it));
            return output;
        }
        return Collections.emptyList();
    }

    public record BehaviorUnitGuardEvaluators(SarlBehaviorUnit source, JvmParameterizedTypeReference eventType, Collection<Procedures.Procedure1<? super ITreeAppendable>> evaluators) {
    }
}

