/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.jvmmodel;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.MembersInjector;
import com.google.inject.Singleton;
import io.sarl.lang.jvmmodel.GenerationContext;
import io.sarl.lang.jvmmodel.IBaseJvmModelInferrer;
import io.sarl.lang.jvmmodel.IDefaultVisibilityProvider;
import io.sarl.lang.jvmmodel.Messages;
import io.sarl.lang.jvmmodel.SarlJvmModelAssociations;
import io.sarl.lang.jvmmodel.fragments.AbstractJvmModelInferrerFragment;
import io.sarl.lang.jvmmodel.fragments.DefaultJvmGenericTypeProvider;
import io.sarl.lang.jvmmodel.fragments.IBiStageInferrerFragment;
import io.sarl.lang.jvmmodel.fragments.IInferrerFragmentContributions;
import io.sarl.lang.jvmmodel.fragments.ISingleStageInferrerFragment;
import io.sarl.lang.jvmmodel.fragments.aop.IAgentInferrerFragment;
import io.sarl.lang.jvmmodel.fragments.aop.IArtifactInferrerFragment;
import io.sarl.lang.jvmmodel.fragments.aop.IBehaviorInferrerFragment;
import io.sarl.lang.jvmmodel.fragments.aop.IBehaviorUnitInferrerFragment;
import io.sarl.lang.jvmmodel.fragments.aop.ICapacityInferrerFragment;
import io.sarl.lang.jvmmodel.fragments.aop.ICapacityUseInferrerFragment;
import io.sarl.lang.jvmmodel.fragments.aop.IEventInferrerFragment;
import io.sarl.lang.jvmmodel.fragments.aop.IRequireCapacityInferrerFragment;
import io.sarl.lang.jvmmodel.fragments.aop.ISkillInferrerFragment;
import io.sarl.lang.jvmmodel.fragments.aop.ISpaceInferrerFragment;
import io.sarl.lang.jvmmodel.fragments.oop.IActionInferrerFragment;
import io.sarl.lang.jvmmodel.fragments.oop.IAnnotationTypeInferrerFragment;
import io.sarl.lang.jvmmodel.fragments.oop.IClassInferrerFragment;
import io.sarl.lang.jvmmodel.fragments.oop.IConstructorInferrerFragment;
import io.sarl.lang.jvmmodel.fragments.oop.IEnumInferrerFragment;
import io.sarl.lang.jvmmodel.fragments.oop.IFieldInferrerFragment;
import io.sarl.lang.jvmmodel.fragments.oop.IInterfaceInferrerFragment;
import io.sarl.lang.sarl.SarlAgent;
import io.sarl.lang.sarl.SarlArtifact;
import io.sarl.lang.sarl.SarlBehavior;
import io.sarl.lang.sarl.SarlBehaviorUnit;
import io.sarl.lang.sarl.SarlCapacity;
import io.sarl.lang.sarl.SarlCapacityUses;
import io.sarl.lang.sarl.SarlEvent;
import io.sarl.lang.sarl.SarlRequiredCapacity;
import io.sarl.lang.sarl.SarlSkill;
import io.sarl.lang.sarl.SarlSpace;
import io.sarl.lang.util.JvmVisibilityComparator;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.jvmmodel.XtendJvmModelInferrer;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.XtendAnnotationType;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendEnum;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFile;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmEnumerationType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.jvmmodel.IJvmDeclaredTypeAcceptor;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociator;
import org.eclipse.xtext.xbase.jvmmodel.JvmAnnotationReferenceBuilder;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypeReferenceBuilder;

@Singleton
public class SARLJvmModelInferrer
extends XtendJvmModelInferrer
implements IBaseJvmModelInferrer {
    @Inject
    private AbstractJvmModelInferrerFragment.Impl atomicFragment;
    @Inject
    private IFieldInferrerFragment fieldFragment;
    @Inject
    private IActionInferrerFragment actionFragment;
    @Inject
    private IConstructorInferrerFragment constructorFragment;
    @Inject
    private ICapacityUseInferrerFragment capacityUseFragment;
    @Inject
    private IRequireCapacityInferrerFragment requireCapacityInferrerFragment;
    @Inject
    private IBehaviorUnitInferrerFragment behaviorUnitInferrerFragment;
    @Inject
    private ISpaceInferrerFragment spaceInferrerFragment;
    @Inject
    private IArtifactInferrerFragment artifactInferrerFragment;
    @Inject
    private IInterfaceInferrerFragment interfaceInferrerFragment;
    @Inject
    private IEnumInferrerFragment enumInferrerFragment;
    @Inject
    private IAnnotationTypeInferrerFragment annotationTypeInferrerFragment;
    @Inject
    private IClassInferrerFragment classInferrerFragment;
    @Inject
    private ICapacityInferrerFragment capacityInferrerFragment;
    @Inject
    private IEventInferrerFragment eventInferrerFragment;
    @Inject
    private IBehaviorInferrerFragment behaviorInferrerFragment;
    @Inject
    private ISkillInferrerFragment skillInferrerFragment;
    @Inject
    private IAgentInferrerFragment agentInferrerFragment;
    @Inject
    private MembersInjector<GenerationContext> contextInjector;
    @Inject
    private IInferrerFragmentContributions fragmentContributions;
    @Inject
    private Logger log;
    @Inject
    private TypesFactory typesFactory;
    @Inject
    private IJvmModelAssociator associator;
    @Inject
    private SarlJvmModelAssociations sarlAssociations;
    @Inject
    private JvmVisibilityComparator visibilityComparator;
    @Inject
    private IDefaultVisibilityProvider defaultVisibilityProvider;
    private LinkedList<GenerationContext> bufferedContexes = new LinkedList();

    @Override
    public final void logInternalError(Throwable exception) {
        if (exception != null && this.log.isLoggable(Level.SEVERE)) {
            this.log.log(Level.SEVERE, Messages.SARLJvmModelInferrer_0, exception);
        }
    }

    @Override
    public final void logInternalError(String message) {
        if (this.log.isLoggable(Level.SEVERE) && !Strings.isNullOrEmpty((String)message)) {
            this.log.log(Level.SEVERE, MessageFormat.format(Messages.SARLJvmModelInferrer_1, Messages.SARLJvmModelInferrer_0, message));
        }
    }

    protected final void setBody(JvmExecutable executable, XExpression expression) {
        this.atomicFragment.setBody(this, executable, expression);
    }

    @Override
    public final synchronized GenerationContext openContext(EObject sarlObject, JvmDeclaredType type, final Iterable<Class<? extends XtendMember>> supportedMemberTypes) {
        assert (type != null);
        assert (supportedMemberTypes != null);
        GenerationContext context = new GenerationContext(this, sarlObject, type){

            @Override
            public boolean isSupportedMember(XtendMember member) {
                for (Class supportedMemberType : supportedMemberTypes) {
                    if (!supportedMemberType.isInstance(member)) continue;
                    return true;
                }
                return false;
            }
        };
        this.contextInjector.injectMembers((Object)context);
        this.bufferedContexes.push(context);
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void closeContext(GenerationContext context) {
        GenerationContext candidate;
        Iterator iterator;
        boolean runPostElements = false;
        GenerationContext selectedContext = null;
        Object object = this;
        synchronized (object) {
            iterator = this.bufferedContexes.iterator();
            while (selectedContext == null && iterator.hasNext()) {
                candidate = (GenerationContext)iterator.next();
                if (candidate.isRelease() || !Objects.equal((Object)candidate.getTypeIdentifier(), (Object)context.getTypeIdentifier())) continue;
                runPostElements = candidate.getParentContext() == null;
                selectedContext = candidate;
            }
        }
        if (selectedContext == null) {
            this.log.warning("Not same contexts when closing");
            return;
        }
        if (runPostElements) {
            for (Runnable handler : selectedContext.getPostFinalizationElements()) {
                handler.run();
            }
        }
        object = this;
        synchronized (object) {
            iterator = this.bufferedContexes.iterator();
            while (iterator.hasNext()) {
                candidate = (GenerationContext)iterator.next();
                if (selectedContext != candidate) continue;
                candidate.setParentContext(null);
                candidate.release();
                iterator.remove();
                return;
            }
        }
    }

    @Override
    public final synchronized GenerationContext getContext(JvmIdentifiableElement type) {
        for (GenerationContext candidate : this.bufferedContexes) {
            if (!Objects.equal((Object)candidate.getTypeIdentifier(), (Object)type.getIdentifier())) continue;
            return candidate;
        }
        throw new GenerationContextNotFoundInternalError(type);
    }

    protected final void inferTypeSceleton(XtendTypeDeclaration declaration, IJvmDeclaredTypeAcceptor acceptor, boolean preIndexingPhase, XtendFile xtendFile, List<Runnable> doLater, JvmDeclaredType containerSceleton) {
        Stream<? extends JvmDeclaredType> inferredSkeletons = null;
        try {
            inferredSkeletons = this.doInferTypeSkeletons(declaration, acceptor, preIndexingPhase, xtendFile, doLater);
        }
        catch (InternalError internalError) {
            throw internalError;
        }
        catch (Exception exception) {
            this.logInternalError(exception);
            inferredSkeletons = null;
        }
        if (inferredSkeletons != null) {
            this.associator.removeAllAssociation((EObject)declaration);
            Iterator iterator = inferredSkeletons.iterator();
            boolean first = true;
            while (iterator.hasNext()) {
                JvmDeclaredType inferredSkeleton = (JvmDeclaredType)iterator.next();
                if (Strings.isNullOrEmpty((String)inferredSkeleton.getSimpleName())) continue;
                inferredSkeleton.setPackageName(xtendFile.getPackage());
                inferredSkeleton.setVisibility(JvmVisibility.PUBLIC);
                this.setFileHeader(xtendFile, inferredSkeleton);
                if (first) {
                    first = false;
                    this.associator.associatePrimary((EObject)declaration, (EObject)inferredSkeleton);
                } else {
                    this.associator.associate((EObject)declaration, (EObject)inferredSkeleton);
                }
                if (containerSceleton != null) {
                    containerSceleton.getMembers().add((Object)inferredSkeleton);
                }
                acceptor.accept(inferredSkeleton);
            }
        } else {
            super.inferTypeSceleton(declaration, acceptor, preIndexingPhase, xtendFile, doLater, containerSceleton);
        }
    }

    private List<Runnable> wrapDoLaterList(final List<Runnable> doLater) {
        return new AbstractList<Runnable>(){

            @Override
            public void add(int index, Runnable element) {
                doLater.add(index, this.wrap(element));
            }

            @Override
            public Runnable set(int index, Runnable element) {
                return this.unwrap(doLater.set(index, this.wrap(element)));
            }

            @Override
            public Runnable remove(int index) {
                return this.unwrap((Runnable)doLater.remove(index));
            }

            @Override
            public Runnable get(int index) {
                return this.unwrap((Runnable)doLater.get(index));
            }

            @Override
            public int size() {
                return doLater.size();
            }

            private Runnable wrap(Runnable runnable) {
                return new SafeRunnable(runnable);
            }

            private Runnable unwrap(Runnable runnable) {
                SafeRunnable wrapper = (SafeRunnable)runnable;
                return wrapper == null ? null : wrapper.wrapped;
            }

            final class SafeRunnable
            implements Runnable {
                public final Runnable wrapped;

                SafeRunnable(Runnable wrapped) {
                    this.wrapped = wrapped;
                }

                @Override
                public void run() {
                    try {
                        this.wrapped.run();
                    }
                    catch (InternalError internalError) {
                        throw internalError;
                    }
                    catch (Exception exception) {
                        SARLJvmModelInferrer.this.logInternalError(exception);
                    }
                }
            }
        };
    }

    private Stream<? extends JvmDeclaredType> doInferTypeSkeletons(XtendTypeDeclaration declaration, IJvmDeclaredTypeAcceptor acceptor, boolean preIndexingPhase, XtendFile sarlFile, List<Runnable> doLater) {
        if (Strings.isNullOrEmpty((String)declaration.getName())) {
            return null;
        }
        List<Runnable> doLaterExceptionSafe = this.wrapDoLaterList(doLater);
        for (IBiStageInferrerFragment fragment : this.fragmentContributions.getBiStageFragmentContributions(declaration.getClass())) {
            DefaultJvmGenericTypeProvider javaTypes = new DefaultJvmGenericTypeProvider(this.typesFactory);
            fragment.prepareTransform(declaration, javaTypes, this);
            if (!preIndexingPhase) {
                doLaterExceptionSafe.add(() -> fragment.transform(declaration, javaTypes, this));
            }
            if (!javaTypes.hasGeneratedType()) continue;
            return javaTypes.stream();
        }
        if (declaration instanceof SarlSpace) {
            SarlSpace sarlSpace = (SarlSpace)declaration;
            DefaultJvmGenericTypeProvider javaTypes = new DefaultJvmGenericTypeProvider(this.typesFactory);
            this.spaceInferrerFragment.prepareTransform(sarlSpace, javaTypes, this);
            if (!preIndexingPhase) {
                doLaterExceptionSafe.add(() -> this.spaceInferrerFragment.transform(sarlSpace, javaTypes, this));
            }
            return javaTypes.stream();
        }
        return null;
    }

    protected final JvmDeclaredType doInferTypeSceleton(XtendTypeDeclaration declaration, IJvmDeclaredTypeAcceptor acceptor, boolean preIndexingPhase, XtendFile xtendFile, List<Runnable> doLater) {
        if (Strings.isNullOrEmpty((String)declaration.getName())) {
            return null;
        }
        try {
            List<Runnable> doLaterExceptionSafe = this.wrapDoLaterList(doLater);
            Iterator<ISingleStageInferrerFragment> iterator = this.fragmentContributions.getSingleStageFragmentContributions(declaration.getClass()).iterator();
            if (iterator.hasNext()) {
                ISingleStageInferrerFragment fragment = iterator.next();
                JvmGenericType javaType = this.typesFactory.createJvmGenericType();
                if (!preIndexingPhase) {
                    doLaterExceptionSafe.add(() -> fragment.transform(declaration, javaType, this));
                }
                return javaType;
            }
            if (declaration instanceof SarlAgent) {
                SarlAgent sarlAgent = (SarlAgent)declaration;
                JvmGenericType javaType = this.typesFactory.createJvmGenericType();
                if (!preIndexingPhase) {
                    doLaterExceptionSafe.add(() -> this.agentInferrerFragment.transform(sarlAgent, javaType, this));
                }
                return javaType;
            }
            if (declaration instanceof SarlBehavior) {
                SarlBehavior sarlBehavior = (SarlBehavior)declaration;
                JvmGenericType javaType = this.typesFactory.createJvmGenericType();
                if (!preIndexingPhase) {
                    doLaterExceptionSafe.add(() -> this.behaviorInferrerFragment.transform(sarlBehavior, javaType, this));
                }
                return javaType;
            }
            if (declaration instanceof SarlEvent) {
                SarlEvent sarlEvent = (SarlEvent)declaration;
                JvmGenericType javaType = this.typesFactory.createJvmGenericType();
                this.copyTypeParameters((List)sarlEvent.getTypeParameters(), (JvmTypeParameterDeclarator)javaType);
                if (!preIndexingPhase) {
                    doLaterExceptionSafe.add(() -> this.eventInferrerFragment.transform(sarlEvent, javaType, this));
                }
                return javaType;
            }
            if (declaration instanceof SarlSkill) {
                SarlSkill sarlSkill = (SarlSkill)declaration;
                JvmGenericType javaType = this.typesFactory.createJvmGenericType();
                if (!preIndexingPhase) {
                    doLaterExceptionSafe.add(() -> this.skillInferrerFragment.transform(sarlSkill, javaType, this));
                }
                return javaType;
            }
            if (declaration instanceof SarlCapacity) {
                SarlCapacity sarlCapacity = (SarlCapacity)declaration;
                JvmGenericType javaType = this.typesFactory.createJvmGenericType();
                if (!preIndexingPhase) {
                    doLaterExceptionSafe.add(() -> this.capacityInferrerFragment.transform(sarlCapacity, javaType, this));
                }
                return javaType;
            }
            if (declaration instanceof SarlArtifact) {
                SarlArtifact sarlArtifact = (SarlArtifact)declaration;
                JvmGenericType javaType = this.typesFactory.createJvmGenericType();
                if (!preIndexingPhase) {
                    doLaterExceptionSafe.add(() -> this.artifactInferrerFragment.transform(sarlArtifact, javaType, this));
                }
                return javaType;
            }
            return super.doInferTypeSceleton(declaration, acceptor, preIndexingPhase, xtendFile, doLaterExceptionSafe);
        }
        catch (InternalError internalError) {
            throw internalError;
        }
        catch (Exception exception) {
            this.logInternalError(exception);
            return null;
        }
    }

    protected final void addDefaultConstructor(XtendClass source, JvmGenericType target) {
    }

    @Override
    public final void inferLocalClass(AnonymousClass anonymousClass, String localClassName, JvmFeature container) {
        this.atomicFragment.inferLocalClass(this, anonymousClass, localClassName, container);
    }

    protected final void initialize(XtendClass source, JvmGenericType inferredJvmType) {
        this.classInferrerFragment.transform(source, inferredJvmType, this, (source0, inferredJvmType0) -> super.initialize(source0, inferredJvmType0));
    }

    protected final void initialize(XtendInterface source, JvmGenericType inferredJvmType) {
        this.interfaceInferrerFragment.transform(source, inferredJvmType, this, (source0, inferredJvmType0) -> super.initialize(source0, inferredJvmType0));
    }

    protected final void initialize(XtendAnnotationType source, JvmAnnotationType inferredJvmType) {
        this.annotationTypeInferrerFragment.transform(source, inferredJvmType, this, (source0, inferredJvmType0) -> super.initialize(source0, inferredJvmType0));
    }

    protected final void initialize(XtendEnum source, JvmEnumerationType inferredJvmType) {
        this.enumInferrerFragment.transform(source, inferredJvmType, this, (source0, inferredJvmType0) -> super.initialize(source0, inferredJvmType0));
    }

    @Override
    public final void transform(XtendMember sourceMember, JvmGenericType container, boolean allowDispatch) {
        try {
            if (sourceMember instanceof SarlBehaviorUnit) {
                SarlBehaviorUnit cvalue = (SarlBehaviorUnit)sourceMember;
                this.behaviorUnitInferrerFragment.transform(cvalue, container, this);
            } else if (sourceMember instanceof SarlCapacityUses) {
                SarlCapacityUses cvalue = (SarlCapacityUses)sourceMember;
                this.capacityUseFragment.transform(cvalue, container, this);
            } else if (sourceMember instanceof SarlRequiredCapacity) {
                SarlRequiredCapacity cvalue = (SarlRequiredCapacity)sourceMember;
                this.requireCapacityInferrerFragment.transform(cvalue, container, this);
            } else {
                super.transform(sourceMember, container, allowDispatch);
            }
        }
        catch (InternalError internalError) {
            throw internalError;
        }
        catch (Exception exception) {
            this.logInternalError(exception);
        }
    }

    protected final void transform(XtendConstructor source, JvmGenericType container) {
        if (source.isStatic()) {
            this.constructorFragment.transformStatic(source, container, this);
        } else {
            this.constructorFragment.transform(source, container, this);
        }
    }

    protected final void transform(XtendField source, JvmGenericType container) {
        this.fieldFragment.transform(source, container, this, (source0, container0) -> super.transform(source0, container0));
    }

    protected final void transform(XtendFunction source, JvmGenericType container, boolean allowDispatch) {
        this.actionFragment.transform(source, container, allowDispatch, this);
    }

    @Override
    public final void appendSyntheticDispatchMethods(XtendTypeDeclaration source, JvmGenericType target) {
        super.appendSyntheticDispatchMethods(source, target);
    }

    protected final JvmOperation deriveGenericDispatchOperationSignature(Iterable<JvmOperation> localOperations, JvmGenericType target) {
        JvmOperation dispatcher = super.deriveGenericDispatchOperationSignature(localOperations, target);
        JvmVisibility higherVisibility = JvmVisibility.PRIVATE;
        for (JvmOperation jvmOperation : localOperations) {
            Iterable xtendFunctions = Iterables.filter((Iterable)this.sarlAssociations.getSourceElements((EObject)jvmOperation), XtendFunction.class);
            for (XtendFunction func : xtendFunctions) {
                JvmVisibility visibility = func.getVisibility();
                if (visibility == null) {
                    visibility = this.defaultVisibilityProvider.getDefaultJvmVisibility((EObject)func);
                }
                if (this.visibilityComparator.compare(visibility, higherVisibility) <= 0) continue;
                higherVisibility = visibility;
            }
        }
        dispatcher.setVisibility(higherVisibility);
        return dispatcher;
    }

    @Override
    public final void fixTypeParameters(JvmTypeParameterDeclarator target) {
        super.fixTypeParameters(target);
    }

    @Override
    public final void translateParameter(JvmExecutable executable, XtendParameter parameter) {
        super.translateParameter(executable, parameter);
    }

    @Override
    public final void copyAndFixTypeParameters(List<JvmTypeParameter> typeParameters, JvmTypeParameterDeclarator target) {
        super.copyAndFixTypeParameters(typeParameters, target);
    }

    @Override
    public final void translateAnnotationsTo(List<XAnnotation> annotations, JvmAnnotationTarget target) {
        super.translateAnnotationsTo(annotations, target);
    }

    @Override
    public final JvmTypeReferenceBuilder getJvmTypeReferenceBuilder() {
        return this._typeReferenceBuilder;
    }

    @Override
    public final JvmAnnotationReferenceBuilder getJvmAnnotationReferenceBuilder() {
        return this._annotationTypesBuilder;
    }

    private static class GenerationContextNotFoundInternalError
    extends InternalError {
        private static final long serialVersionUID = 2275793506661573859L;

        GenerationContextNotFoundInternalError(JvmIdentifiableElement type) {
            super("generation context cannot be found for: " + type.getIdentifier());
        }
    }

    private static abstract class InternalError
    extends RuntimeException {
        private static final long serialVersionUID = 4637115741105214351L;

        InternalError(String message) {
            super(message);
        }
    }
}

