/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.jvmmodel.fragments;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import io.sarl.lang.compiler.IInlineExpressionCompiler;
import io.sarl.lang.controlflow.ISarlEarlyExitComputer;
import io.sarl.lang.core.annotation.DefaultValue;
import io.sarl.lang.core.annotation.DefaultValueSource;
import io.sarl.lang.jvmmodel.GenerationContext;
import io.sarl.lang.jvmmodel.IBaseJvmModelInferrer;
import io.sarl.lang.jvmmodel.Messages;
import io.sarl.lang.jvmmodel.fragments.AbstractJvmModelInferrerFragment;
import io.sarl.lang.sarl.SarlAssertExpression;
import io.sarl.lang.sarl.SarlBreakExpression;
import io.sarl.lang.sarl.SarlContinueExpression;
import io.sarl.lang.sarl.SarlFormalParameter;
import io.sarl.lang.sarl.actionprototype.ActionPrototype;
import io.sarl.lang.sarl.actionprototype.InferredStandardParameter;
import io.sarl.lang.sarl.actionprototype.InferredValuedParameter;
import io.sarl.lang.typesystem.IOperationHelper;
import io.sarl.lang.util.Utils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.typesystem.InferredTypeIndicator;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public abstract class AbstractJvmModelInferrerExecutableFragment
extends AbstractJvmModelInferrerFragment {
    @Inject
    protected IInlineExpressionCompiler inlineExpressionCompiler;
    @Inject
    protected IOperationHelper operationHelper;
    @Inject
    protected ISarlEarlyExitComputer earlyExitComputer;

    protected void translateSarlFormalParameters(GenerationContext context, JvmExecutable owner, JvmGenericType actionContainer, boolean varargs, List<? extends XtendParameter> params, boolean isForInterface, List<InferredStandardParameter> paramSpec, boolean ignoreOverridableOperations, IBaseJvmModelInferrer baseInferrer) {
        if (paramSpec == null) {
            return;
        }
        boolean hasDefaultValue = false;
        boolean isStaticOwner = owner instanceof JvmConstructor || owner instanceof JvmOperation && ((JvmOperation)owner).isStatic();
        for (int i = 0; i < params.size(); ++i) {
            SarlFormalParameter sarlParam;
            XtendParameter param = params.get(i);
            assert (param != null);
            String paramName = param.getName();
            JvmTypeReference paramType = param.getParameterType();
            if (Strings.isNullOrEmpty((String)paramName) || paramType == null) continue;
            baseInferrer.translateParameter(owner, param);
            JvmFormalParameter createdParam = (JvmFormalParameter)owner.getParameters().get(owner.getParameters().size() - 1);
            if (i >= paramSpec.size() || !(param instanceof SarlFormalParameter) || (sarlParam = (SarlFormalParameter)param).getDefaultValue() == null) continue;
            XExpression defaultValue = sarlParam.getDefaultValue();
            assert (defaultValue != null);
            hasDefaultValue = true;
            InferredStandardParameter inferredParam = paramSpec.get(i);
            assert (inferredParam != null);
            Runnable creationCode1 = () -> {
                ActionPrototype prototype;
                String namePostPart = inferredParam.getDefaultValueAnnotationValue();
                JvmTypeReference inferredType = this.skipTypeParameters(paramType, (Notifier)actionContainer);
                String functionName = this.sarlSignatureProvider.createFunctionNameForDefaultValueID(namePostPart);
                boolean addMethod = ignoreOverridableOperations ? context.getInheritedImplementedOperation(prototype = this.sarlSignatureProvider.createActionPrototype(functionName, this.sarlSignatureProvider.createParameterTypesForVoid())) == null : true;
                if (addMethod) {
                    JvmOperation method = this.jvmTypeBuilder.toMethod((EObject)defaultValue, functionName, inferredType, it -> {
                        this.jvmTypeBuilder.setDocumentation((JvmIdentifiableElement)it, MessageFormat.format(Messages.SARLJvmModelInferrer_11, paramName));
                        it.setReturnType(inferredType);
                        it.setStatic(isStaticOwner);
                        it.setFinal(!isStaticOwner && !isForInterface);
                        it.setDefault(isForInterface && !isStaticOwner);
                        if (isForInterface) {
                            it.setVisibility(JvmVisibility.PUBLIC);
                        } else {
                            it.setVisibility(JvmVisibility.PRIVATE);
                        }
                    });
                    actionContainer.getMembers().add((Object)method);
                    this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)method, Pure.class, new String[0]);
                    String rawCode = Utils.getSarlCodeFor((EObject)defaultValue);
                    this.appendGeneratedAnnotation(baseInferrer, (JvmAnnotationTarget)method, context, rawCode);
                    this.setBody(baseInferrer, (JvmExecutable)method, defaultValue);
                    this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)createdParam, DefaultValue.class, namePostPart);
                    this.associator.associate((EObject)defaultValue, (EObject)method);
                }
            };
            context.addUserObject("translateSarlFormalParameters", creationCode1);
        }
        if (hasDefaultValue) {
            this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)owner, DefaultValueSource.class, new String[0]);
        }
    }

    protected void translateSarlFormalParametersForLocalHiddenDefaultValues(GenerationContext context, JvmOperation inheritedOperation) {
        Iterable<Runnable> on = context.consumeUserObject("translateSarlFormalParameters", Runnable.class);
        if (inheritedOperation == null) {
            for (Runnable code : on) {
                code.run();
            }
        }
    }

    protected List<String> translateSarlFormalParametersForSyntheticOperation(JvmExecutable owner, JvmGenericType actionContainer, boolean varargs, List<InferredStandardParameter> signature, IBaseJvmModelInferrer baseInferrer) {
        ArrayList arguments = CollectionLiterals.newArrayList();
        for (InferredStandardParameter parameterSpec : signature) {
            LightweightTypeReference paramType = parameterSpec.getType();
            if (parameterSpec instanceof InferredValuedParameter) {
                InferredValuedParameter cvalue = (InferredValuedParameter)parameterSpec;
                StringBuilder argumentValue = new StringBuilder();
                JvmType jtype = paramType.getType();
                if (jtype instanceof JvmTypeParameter) {
                    argumentValue.append("(");
                    argumentValue.append(paramType.getSimpleName());
                    argumentValue.append(") ");
                }
                argumentValue.append(this.sarlSignatureProvider.toJavaArgument(actionContainer.getIdentifier(), cvalue.getCallingArgument()));
                arguments.add(argumentValue.toString());
                continue;
            }
            EObject param = parameterSpec.getParameter();
            String paramName = parameterSpec.getName();
            if (Strings.isNullOrEmpty((String)paramName) || paramType == null) continue;
            JvmFormalParameter lastParam = this.jvmTypesFactory.createJvmFormalParameter();
            owner.getParameters().add((Object)lastParam);
            lastParam.setName(paramName);
            if (owner instanceof JvmOperation) {
                lastParam.setParameterType(this.cloneWithTypeParametersAndProxies(paramType.toTypeReference(), owner, baseInferrer));
            } else {
                lastParam.setParameterType(this.jvmTypeBuilder.cloneWithProxies(paramType.toTypeReference()));
            }
            this.associator.associate(param, (EObject)lastParam);
            arguments.add(paramName);
        }
        return arguments;
    }

    protected JvmTypeReference inferFunctionReturnType(XExpression body, IBaseJvmModelInferrer baseInferrer) {
        XExpression expr = body;
        boolean stop = false;
        block4: while (!stop && expr instanceof XBlockExpression) {
            XBlockExpression block = (XBlockExpression)expr;
            switch (block.getExpressions().size()) {
                case 0: {
                    expr = null;
                    continue block4;
                }
                case 1: {
                    expr = (XExpression)block.getExpressions().get(0);
                    continue block4;
                }
            }
            stop = true;
        }
        if (expr == null || expr instanceof XAssignment || expr instanceof XVariableDeclaration || expr instanceof SarlBreakExpression || expr instanceof SarlContinueExpression || expr instanceof SarlAssertExpression) {
            return baseInferrer.getJvmTypeReferenceBuilder().typeRef(Void.TYPE, new JvmTypeReference[0]);
        }
        return this.jvmTypeBuilder.inferredType(body);
    }

    protected JvmTypeReference inferFunctionReturnType(XtendFunction source, JvmOperation target, JvmOperation overriddenOperation, IBaseJvmModelInferrer baseInferrer) {
        if (source.getReturnType() != null) {
            return this.ensureValidType(source.eResource(), source.getReturnType(), baseInferrer);
        }
        if (overriddenOperation != null) {
            JvmTypeReference type = overriddenOperation.getReturnType();
            return this.jvmTypeReferences.createDelegateTypeReference(type);
        }
        XExpression expression = source.getExpression();
        JvmTypeReference returnType = null;
        if (!(expression == null || expression instanceof XBlockExpression && ((XBlockExpression)expression).getExpressions().isEmpty())) {
            returnType = this.inferFunctionReturnType(expression, baseInferrer);
        }
        return this.ensureValidType(source.eResource(), returnType, baseInferrer);
    }

    private JvmTypeReference ensureValidType(Resource targetResource, JvmTypeReference returnType, IBaseJvmModelInferrer baseInferrer) {
        if (returnType == null) {
            return baseInferrer.getJvmTypeReferenceBuilder().typeRef(Void.TYPE, new JvmTypeReference[0]);
        }
        Resource returnTypeResource = returnType.eResource();
        if (returnTypeResource != null && !Objects.equal((Object)returnType.eResource(), (Object)targetResource)) {
            return this.jvmTypeBuilder.cloneWithProxies(returnType);
        }
        if (InferredTypeIndicator.isInferred((JvmTypeReference)returnType)) {
            return returnType;
        }
        return this.jvmTypeBuilder.cloneWithProxies(returnType);
    }

    protected void copyTypeParametersFromJvmOperation(JvmOperation fromOperation, JvmOperation toOperation, IBaseJvmModelInferrer baseInferrer) {
        Utils.copyTypeParametersFromJvmOperation(fromOperation, toOperation, baseInferrer.getJvmTypeReferenceBuilder(), this.jvmTypeBuilder, this.jvmTypeReferences, this.jvmTypesFactory);
    }
}

