/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.jvmmodel.fragments;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import io.sarl.lang.core.annotation.DefaultValueUse;
import io.sarl.lang.core.annotation.SarlSourceCode;
import io.sarl.lang.core.annotation.SyntheticMember;
import io.sarl.lang.jvmmodel.GenerationContext;
import io.sarl.lang.jvmmodel.IBaseJvmModelInferrer;
import io.sarl.lang.jvmmodel.IDefaultVisibilityProvider;
import io.sarl.lang.jvmmodel.SarlJvmModelAssociations;
import io.sarl.lang.sarl.SarlAction;
import io.sarl.lang.sarl.SarlConstructor;
import io.sarl.lang.sarl.SarlField;
import io.sarl.lang.sarl.actionprototype.ActionParameterTypes;
import io.sarl.lang.sarl.actionprototype.ActionPrototype;
import io.sarl.lang.sarl.actionprototype.IActionPrototypeProvider;
import io.sarl.lang.sarl.actionprototype.InferredPrototype;
import io.sarl.lang.sarl.actionprototype.InferredStandardParameter;
import io.sarl.lang.sarl.actionprototype.InferredValuedParameter;
import io.sarl.lang.sarl.actionprototype.QualifiedActionName;
import io.sarl.lang.services.ITypeDefaultValueProvider;
import io.sarl.lang.services.SARLGrammarKeywordAccess;
import io.sarl.lang.typesystem.SARLAnnotationUtil;
import io.sarl.lang.util.Utils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.processing.Generated;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.jvmmodel.SyntheticNameClashResolver;
import org.eclipse.xtend.core.xtend.AnonymousClass;
import org.eclipse.xtend.core.xtend.XtendExecutable;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmIntAnnotationValue;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.TypesFactory;
import org.eclipse.xtext.common.types.util.AnnotationLookup;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.compiler.GeneratorConfig;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociator;
import org.eclipse.xtext.xbase.jvmmodel.JvmTypesBuilder;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.InferredTypeIndicator;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public abstract class AbstractJvmModelInferrerFragment {
    protected static final String GENERATED_NAME = Generated.class.getName();
    protected static final String RUNNABLE_COLLECTION = Utils.createNameForHiddenLocalVariable("runnableCollection");
    private static final Predicate<JvmAnnotationReference> ANNOTATION_TRANSLATION_FILTER = annotation -> annotation != null && annotation.getAnnotation() != null;
    @Inject
    protected SarlJvmModelAssociations sarlAssociations;
    @Inject
    protected TypesFactory jvmTypesFactory;
    @Inject
    protected JvmTypesBuilder jvmTypeBuilder;
    @Inject
    protected IJvmModelAssociator associator;
    @Inject
    protected TypeReferences jvmTypeReferences;
    @Inject
    protected AnnotationLookup jvmAnnotationFinder;
    @Inject
    protected SARLAnnotationUtil annotationUtils;
    @Inject
    protected CommonTypeComputationServices services;
    @Inject
    protected SARLGrammarKeywordAccess grammarKeywordAccess;
    @Inject
    protected IActionPrototypeProvider sarlSignatureProvider;
    @Inject
    protected ITypeDefaultValueProvider defaultValueProvider;
    @Inject
    private IDefaultVisibilityProvider defaultVisibilityProvider;
    @Inject
    protected SyntheticNameClashResolver nameClashResolver;

    protected void setVisibility(JvmMember jvmMember, XtendMember member) {
        JvmVisibility visibility = member.getVisibility();
        if (visibility == null) {
            visibility = this.defaultVisibilityProvider.getDefaultJvmVisibility((EObject)member);
        }
        jvmMember.setVisibility(visibility);
    }

    protected JvmTypeReference cloneWithProxiesFromOtherResource(JvmTypeReference type, JvmExecutable target, IBaseJvmModelInferrer baseInferrer) {
        if (type == null) {
            return baseInferrer.getJvmTypeReferenceBuilder().typeRef(Void.TYPE, new JvmTypeReference[0]);
        }
        if (InferredTypeIndicator.isInferred((JvmTypeReference)type)) {
            return type;
        }
        String id = type.getIdentifier();
        if (Objects.equal((Object)id, (Object)Void.TYPE.getName())) {
            return baseInferrer.getJvmTypeReferenceBuilder().typeRef(Void.TYPE, new JvmTypeReference[0]);
        }
        if (this.services.getPrimitives().isPrimitive(type)) {
            return baseInferrer.getJvmTypeReferenceBuilder().typeRef(id, new JvmTypeReference[0]);
        }
        if (target != null) {
            return this.cloneWithTypeParametersAndProxies(type, target, baseInferrer);
        }
        return this.jvmTypeBuilder.cloneWithProxies(type);
    }

    protected JvmTypeReference cloneWithTypeParametersAndProxies(JvmTypeReference type, JvmExecutable forExecutable, IBaseJvmModelInferrer baseInferrer) {
        assert (forExecutable.getDeclaringType() != null);
        HashMap<String, JvmTypeReference> superTypeParameterMapping = new HashMap<String, JvmTypeReference>();
        Utils.getSuperTypeParameterMap(forExecutable.getDeclaringType(), superTypeParameterMapping);
        return Utils.cloneWithTypeParametersAndProxies(type, (Iterable<JvmTypeParameter>)forExecutable.getTypeParameters(), superTypeParameterMapping, baseInferrer.getJvmTypeReferenceBuilder(), this.jvmTypeBuilder, this.jvmTypeReferences, this.jvmTypesFactory);
    }

    protected boolean copyAndCleanDocumentationTo(JvmExecutable sourceOperation, JvmExecutable targetOperation) {
        assert (sourceOperation != null);
        assert (targetOperation != null);
        String comment = this.jvmTypeBuilder.getDocumentation((EObject)sourceOperation);
        if (Strings.isNullOrEmpty((String)comment)) {
            return false;
        }
        comment = AbstractJvmModelInferrerFragment.cleanDocumentation(comment, Iterables.transform((Iterable)sourceOperation.getParameters(), it -> it.getSimpleName()), Iterables.transform((Iterable)targetOperation.getParameters(), it -> it.getSimpleName()));
        this.jvmTypeBuilder.setDocumentation((JvmIdentifiableElement)targetOperation, comment);
        return true;
    }

    protected boolean copyAndCleanDocumentationTo(XtendExecutable sourceOperation, JvmExecutable targetOperation) {
        assert (sourceOperation != null);
        assert (targetOperation != null);
        String comment = this.jvmTypeBuilder.getDocumentation((EObject)sourceOperation);
        if (Strings.isNullOrEmpty((String)comment)) {
            return false;
        }
        comment = AbstractJvmModelInferrerFragment.cleanDocumentation(comment, Iterables.transform((Iterable)sourceOperation.getParameters(), it -> it.getName()), Iterables.transform((Iterable)targetOperation.getParameters(), it -> it.getSimpleName()));
        this.jvmTypeBuilder.setDocumentation((JvmIdentifiableElement)targetOperation, comment);
        return true;
    }

    private static String cleanDocumentation(String comment, Iterable<String> sourceParameters, Iterable<String> targetParameters) {
        String clean = comment;
        if (!Strings.isNullOrEmpty((String)clean)) {
            TreeSet<String> parameterNames = new TreeSet<String>();
            if (sourceParameters != null) {
                for (String param : sourceParameters) {
                    if (Strings.isNullOrEmpty((String)param)) continue;
                    parameterNames.add(param);
                }
            }
            if (targetParameters != null) {
                for (String param : targetParameters) {
                    if (Strings.isNullOrEmpty((String)param)) continue;
                    parameterNames.remove(param);
                }
            }
            for (String parameterName : parameterNames) {
                clean = clean.replaceFirst("\\Q@param\\E\\s+\\Q" + parameterName + "\\E\\s*", "@optionalparam " + parameterName + " ");
            }
        }
        return clean;
    }

    protected void translateAnnotationsTo(List<JvmAnnotationReference> annotations, JvmAnnotationTarget target, Class<?> ... exceptions) {
        HashSet<String> excepts = new HashSet<String>();
        for (Class<?> type : exceptions) {
            excepts.add(type.getName());
        }
        ArrayList<JvmAnnotationReference> addition = new ArrayList<JvmAnnotationReference>();
        for (JvmAnnotationReference annotation : Iterables.filter(annotations, an -> {
            if (!ANNOTATION_TRANSLATION_FILTER.apply(an)) {
                return false;
            }
            return !excepts.contains(an.getAnnotation().getIdentifier());
        })) {
            addition.add(annotation);
        }
        target.getAnnotations().addAll(addition);
    }

    protected final void appendGeneratedAnnotation(IBaseJvmModelInferrer baseInferrer, JvmAnnotationTarget target, GenerationContext context) {
        this.appendGeneratedAnnotation(baseInferrer, target, context, null);
    }

    protected void appendGeneratedAnnotation(IBaseJvmModelInferrer baseInferrer, JvmAnnotationTarget target, GenerationContext context, String sarlCode) {
        GeneratorConfig config = context.getGeneratorConfig();
        if (config.isGenerateGeneratedAnnotation()) {
            this.addAnnotationSafe(baseInferrer, target, GENERATED_NAME, this.getClass().getName());
        }
        if (target instanceof JvmFeature) {
            this.addAnnotationSafe(baseInferrer, target, SyntheticMember.class, new String[0]);
        }
        if (!Strings.isNullOrEmpty((String)sarlCode)) {
            this.addAnnotationSafe(baseInferrer, target, SarlSourceCode.class, sarlCode);
        }
    }

    protected JvmAnnotationReference addAnnotationSafe(IBaseJvmModelInferrer baseInferrer, JvmAnnotationTarget target, Class<?> annotationType, String ... values) {
        assert (target != null);
        assert (annotationType != null);
        try {
            JvmAnnotationReference annotationRef = baseInferrer.getJvmAnnotationReferenceBuilder().annotationRef(annotationType, values);
            if (annotationRef != null && target.getAnnotations().add((Object)annotationRef)) {
                return annotationRef;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    protected JvmAnnotationReference addAnnotationSafe(IBaseJvmModelInferrer baseInferrer, JvmAnnotationTarget target, String annotationType, String ... values) {
        assert (target != null);
        assert (annotationType != null);
        try {
            JvmAnnotationReference annotationRef = baseInferrer.getJvmAnnotationReferenceBuilder().annotationRef(annotationType, values);
            if (annotationRef != null && target.getAnnotations().add((Object)annotationRef)) {
                return annotationRef;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    protected JvmAnnotationReference addAnnotationSafe(JvmAnnotationTarget target, Class<?> annotationType, int value) {
        assert (target != null);
        assert (annotationType != null);
        try {
            JvmAnnotationReference result = this.jvmTypesFactory.createJvmAnnotationReference();
            JvmType jvmType = this.jvmTypeReferences.findDeclaredType(annotationType, (Notifier)target);
            if (jvmType == null) {
                return null;
            }
            if (jvmType instanceof JvmAnnotationType) {
                JvmAnnotationType cvalue = (JvmAnnotationType)jvmType;
                result.setAnnotation(cvalue);
                JvmIntAnnotationValue annotationValue = this.jvmTypesFactory.createJvmIntAnnotationValue();
                annotationValue.getValues().add((Object)value);
                result.getExplicitValues().add((Object)annotationValue);
                if (target.getAnnotations().add((Object)result)) {
                    return result;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    protected JvmTypeReference skipTypeParameters(JvmTypeReference type, Notifier context) {
        LightweightTypeReference ltr = Utils.toLightweightTypeReference(type, this.services);
        return ltr.getRawTypeReference().toJavaCompliantTypeReference();
    }

    protected JvmAnnotationReference annotationClassRef(IBaseJvmModelInferrer baseInferrer, Class<? extends Annotation> type, List<? extends JvmTypeReference> values) {
        try {
            JvmAnnotationReference annot = baseInferrer.getJvmAnnotationReferenceBuilder().annotationRef(type, new String[0]);
            JvmTypeAnnotationValue annotationValue = this.services.getTypesFactory().createJvmTypeAnnotationValue();
            for (JvmTypeReference jvmTypeReference : values) {
                annotationValue.getValues().add((Object)this.jvmTypeBuilder.cloneWithProxies(jvmTypeReference));
            }
            annot.getExplicitValues().add((Object)annotationValue);
            return annot;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    protected static StringConcatenationClient toStringConcatenation(final String ... javaCodeLines) {
        return new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation builder) {
                for (String line : javaCodeLines) {
                    builder.append((Object)line);
                    builder.newLineIfNotEmpty();
                }
            }
        };
    }

    protected void setBody(JvmExecutable executable, Procedures.Procedure1<ITreeAppendable> expression) {
        this.jvmTypeBuilder.setBody(executable, expression);
    }

    protected void setBody(JvmExecutable executable, StringConcatenationClient expression) {
        this.jvmTypeBuilder.setBody(executable, expression);
    }

    public void setBody(IBaseJvmModelInferrer baseInferrer, JvmExecutable executable, XExpression expression) {
        GenerationContext context = baseInferrer.getContext((JvmIdentifiableElement)EcoreUtil2.getContainerOfType((EObject)executable, JvmType.class));
        this.jvmTypeBuilder.removeExistingBody((JvmMember)executable);
        this.associator.associateLogicalContainer(expression, (JvmIdentifiableElement)executable);
        if (expression != null) {
            if (context.getParentContext() == null) {
                context.getPostFinalizationElements().add(() -> this.initializeLocalTypes(baseInferrer, context, (JvmFeature)executable, expression));
            } else {
                this.initializeLocalTypes(baseInferrer, context, (JvmFeature)executable, expression);
            }
        } else {
            this.initializeLocalTypes(baseInferrer, context, (JvmFeature)executable, expression);
        }
    }

    protected void initializeLocalTypes(IBaseJvmModelInferrer baseInferrer, GenerationContext context, JvmFeature feature, XExpression expression) {
        if (expression != null) {
            int localTypeIndex = context.getLocalTypeIndex();
            TreeIterator iterator = EcoreUtil2.getAllNonDerivedContents((EObject)expression, (boolean)true);
            String nameStub = "__" + feature.getDeclaringType().getSimpleName() + "_";
            while (iterator.hasNext()) {
                EObject next = (EObject)iterator.next();
                if (next.eClass() != XtendPackage.Literals.ANONYMOUS_CLASS) continue;
                this.inferLocalClass(baseInferrer, (AnonymousClass)next, nameStub + localTypeIndex, feature);
                iterator.prune();
                ++localTypeIndex;
            }
            context.setLocalTypeIndex(localTypeIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inferLocalClass(IBaseJvmModelInferrer baseInferrer, AnonymousClass anonymousClass, String localClassName, JvmFeature container) {
        assert (anonymousClass != null);
        assert (container != null);
        if (Strings.isNullOrEmpty((String)localClassName)) {
            return;
        }
        if (!Utils.isCompatibleSARLLibraryOnClasspath(this.jvmTypeReferences, (Notifier)anonymousClass)) {
            return;
        }
        try {
            JvmGenericType inferredJvmType = this.jvmTypesFactory.createJvmGenericType();
            inferredJvmType.setSimpleName(localClassName);
            boolean isAnonymous = container instanceof JvmConstructor || !AbstractJvmModelInferrerFragment.hasAdditionalMembers(anonymousClass);
            inferredJvmType.setAnonymous(isAnonymous);
            inferredJvmType.setFinal(true);
            this.setVisibility((JvmMember)inferredJvmType, (XtendMember)anonymousClass);
            inferredJvmType.getSuperTypes().add((Object)this.jvmTypeBuilder.inferredType((XExpression)anonymousClass));
            container.getLocalClasses().add((Object)inferredJvmType);
            this.associator.associatePrimary((EObject)anonymousClass, (EObject)inferredJvmType);
            GenerationContext parentContext = baseInferrer.getContext((JvmIdentifiableElement)EcoreUtil2.getContainerOfType((EObject)container, JvmType.class));
            GenerationContext context = baseInferrer.openContext((EObject)anonymousClass, (JvmDeclaredType)inferredJvmType, Arrays.asList(SarlField.class, SarlConstructor.class, SarlAction.class));
            context.setParentContext(parentContext);
            try {
                for (XtendMember member : anonymousClass.getMembers()) {
                    if (!context.isSupportedMember(member)) continue;
                    baseInferrer.transform(member, inferredJvmType, true);
                }
                baseInferrer.appendSyntheticDispatchMethods((XtendTypeDeclaration)anonymousClass, inferredJvmType);
                this.nameClashResolver.resolveNameClashes(inferredJvmType);
                this.appendSyntheticDefaultValuedParameterMethods(baseInferrer, (XtendTypeDeclaration)anonymousClass, (JvmDeclaredType)inferredJvmType, true, context);
                XConstructorCall constructorCall = anonymousClass.getConstructorCall();
                for (XExpression actualParameter : constructorCall.getArguments()) {
                    this.associator.associateLogicalContainer(actualParameter, (JvmIdentifiableElement)container);
                }
            }
            finally {
                baseInferrer.closeContext(context);
            }
        }
        catch (AssertionError | InternalError internalError) {
            throw internalError;
        }
        catch (Exception exception) {
            baseInferrer.logInternalError(exception);
        }
    }

    private static boolean hasAdditionalMembers(AnonymousClass anonymousClass) {
        for (XtendMember member : anonymousClass.getMembers()) {
            if (!(member instanceof XtendField) && (!(member instanceof XtendFunction) || ((XtendFunction)member).isOverride())) continue;
            return true;
        }
        return false;
    }

    private void appendSyntheticDefaultValuedParameterMethods(IBaseJvmModelInferrer baseInferrer, XtendTypeDeclaration source, JvmDeclaredType target, boolean ignoreOverridableOperations, GenerationContext context) {
        Iterator<Runnable> differedGeneration = context.getPreFinalizationElements().iterator();
        while (differedGeneration.hasNext()) {
            Runnable runnable = differedGeneration.next();
            differedGeneration.remove();
            runnable.run();
        }
        int actIndex = context.getActionIndex();
        Map<ActionPrototype, JvmOperation> inheritedOperations = context.getInheritedOperationsToImplement();
        for (Map.Entry<ActionPrototype, JvmOperation> missedOperation : inheritedOperations.entrySet()) {
            JvmOperation redefinedOperation;
            String originalSignature = this.annotationUtils.findStringValue((JvmAnnotationTarget)missedOperation.getValue(), DefaultValueUse.class);
            if (Strings.isNullOrEmpty((String)originalSignature) || (redefinedOperation = inheritedOperations.get(this.sarlSignatureProvider.createActionPrototype(missedOperation.getKey().getActionName(), this.sarlSignatureProvider.createParameterTypesFromString(originalSignature)))) == null) continue;
            ActionParameterTypes parameterTypes = this.sarlSignatureProvider.createParameterTypesFromJvmModel(redefinedOperation.isVarArgs(), (List<JvmFormalParameter>)redefinedOperation.getParameters());
            QualifiedActionName qualifiedActionName = this.sarlSignatureProvider.createQualifiedActionName((JvmIdentifiableElement)missedOperation.getValue().getDeclaringType(), redefinedOperation.getSimpleName());
            InferredPrototype redefinedPrototype = this.sarlSignatureProvider.getPrototypes(context.getActionPrototypeContext(this.sarlSignatureProvider), qualifiedActionName, parameterTypes);
            if (redefinedPrototype == null) {
                redefinedPrototype = this.sarlSignatureProvider.createPrototypeFromJvmModel(context.getActionPrototypeContext(this.sarlSignatureProvider), qualifiedActionName, redefinedOperation.isVarArgs(), (List<JvmFormalParameter>)redefinedOperation.getParameters());
            }
            List<InferredStandardParameter> argumentSpec = redefinedPrototype.getInferredParameterTypes().get(missedOperation.getKey().getParametersTypes());
            JvmOperation op = this.jvmTypeBuilder.toMethod((EObject)source, missedOperation.getValue().getSimpleName(), missedOperation.getValue().getReturnType(), null);
            op.setVarArgs(missedOperation.getValue().isVarArgs());
            op.setFinal(true);
            ArrayList<String> arguments = new ArrayList<String>();
            for (InferredStandardParameter parameter : argumentSpec) {
                if (parameter instanceof InferredValuedParameter) {
                    InferredValuedParameter inferredParameter = (InferredValuedParameter)parameter;
                    arguments.add(this.sarlSignatureProvider.toJavaArgument(target.getIdentifier(), inferredParameter.getCallingArgument()));
                    continue;
                }
                arguments.add(parameter.getName());
                JvmFormalParameter jvmParam = this.jvmTypesFactory.createJvmFormalParameter();
                jvmParam.setName(parameter.getName());
                jvmParam.setParameterType(this.jvmTypeBuilder.cloneWithProxies(parameter.getType().toTypeReference()));
                this.associator.associate(parameter.getParameter(), (EObject)jvmParam);
                op.getParameters().add((Object)jvmParam);
            }
            this.setBody((JvmExecutable)op, (Procedures.Procedure1<ITreeAppendable>)((Procedures.Procedure1)it -> {
                it.append((CharSequence)redefinedOperation.getSimpleName());
                it.append((CharSequence)"(");
                it.append((CharSequence)IterableExtensions.join((Iterable)arguments, (CharSequence)", "));
                it.append((CharSequence)");");
            }));
            this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)op, DefaultValueUse.class, originalSignature);
            this.appendGeneratedAnnotation(baseInferrer, (JvmAnnotationTarget)op, context);
            target.getMembers().add((Object)op);
            ++actIndex;
        }
        context.setActionIndex(actIndex);
    }

    public static class Impl
    extends AbstractJvmModelInferrerFragment {
    }
}

