/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.jvmmodel.fragments;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.Behavior;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.annotation.DefaultValueUse;
import io.sarl.lang.core.annotation.Injectable;
import io.sarl.lang.core.annotation.NoEqualityTestFunctionsGeneration;
import io.sarl.lang.core.annotation.PerceptGuardEvaluator;
import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.core.annotation.SarlSpecification;
import io.sarl.lang.core.util.SarlUtils;
import io.sarl.lang.jvmmodel.GenerationContext;
import io.sarl.lang.jvmmodel.IBaseJvmModelInferrer;
import io.sarl.lang.jvmmodel.fragments.AbstractJvmModelInferrerFragment;
import io.sarl.lang.sarl.SarlBehaviorUnit;
import io.sarl.lang.sarl.SarlCapacityUses;
import io.sarl.lang.sarl.SarlRequiredCapacity;
import io.sarl.lang.sarl.actionprototype.ActionParameterTypes;
import io.sarl.lang.sarl.actionprototype.ActionPrototype;
import io.sarl.lang.sarl.actionprototype.InferredPrototype;
import io.sarl.lang.sarl.actionprototype.InferredStandardParameter;
import io.sarl.lang.sarl.actionprototype.InferredValuedParameter;
import io.sarl.lang.sarl.actionprototype.QualifiedActionName;
import io.sarl.lang.typesystem.InheritanceHelper;
import io.sarl.lang.util.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.XtendClass;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendInterface;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUnknownTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.validation.ReadAndWriteTracking;

public abstract class AbstractJvmModelInferrerTypeFragment
extends AbstractJvmModelInferrerFragment {
    private static final String EQUALS_FUNCTION_NAME = "equals";
    private static final String HASHCODE_FUNCTION_NAME = "hashCode";
    private static final String CLONE_FUNCTION_NAME = "clone";
    private static final String SERIAL_FIELD_NAME = "serialVersionUID";
    private static final Set<Class<?>> EQUALITY_TEST_TYPES = new TreeSet((ele1, ele2) -> ele1.getName().compareTo(ele2.getName()));
    @Inject
    private InheritanceHelper inheritanceHelper;
    @Inject
    protected ReadAndWriteTracking readAndWriteTracking;

    protected void appendSyntheticDefaultValuedParameterMethods(IBaseJvmModelInferrer baseInferrer, XtendTypeDeclaration source, JvmDeclaredType target, boolean ignoreOverridableOperations, GenerationContext context) {
        Iterator<Runnable> differedGeneration = context.getPreFinalizationElements().iterator();
        while (differedGeneration.hasNext()) {
            Runnable runnable = differedGeneration.next();
            differedGeneration.remove();
            runnable.run();
        }
        int actIndex = context.getActionIndex();
        Map<ActionPrototype, JvmOperation> inheritedOperations = context.getInheritedOperationsToImplement();
        for (Map.Entry<ActionPrototype, JvmOperation> missedOperation : inheritedOperations.entrySet()) {
            JvmOperation redefinedOperation;
            String originalSignature = this.annotationUtils.findStringValue((JvmAnnotationTarget)missedOperation.getValue(), DefaultValueUse.class);
            if (Strings.isNullOrEmpty((String)originalSignature) || (redefinedOperation = inheritedOperations.get(this.sarlSignatureProvider.createActionPrototype(missedOperation.getKey().getActionName(), this.sarlSignatureProvider.createParameterTypesFromString(originalSignature)))) == null) continue;
            ActionParameterTypes parameterTypes = this.sarlSignatureProvider.createParameterTypesFromJvmModel(redefinedOperation.isVarArgs(), (List<JvmFormalParameter>)redefinedOperation.getParameters());
            QualifiedActionName qualifiedActionName = this.sarlSignatureProvider.createQualifiedActionName((JvmIdentifiableElement)missedOperation.getValue().getDeclaringType(), redefinedOperation.getSimpleName());
            InferredPrototype redefinedPrototype = this.sarlSignatureProvider.getPrototypes(context.getActionPrototypeContext(this.sarlSignatureProvider), qualifiedActionName, parameterTypes);
            if (redefinedPrototype == null) {
                redefinedPrototype = this.sarlSignatureProvider.createPrototypeFromJvmModel(context.getActionPrototypeContext(this.sarlSignatureProvider), qualifiedActionName, redefinedOperation.isVarArgs(), (List<JvmFormalParameter>)redefinedOperation.getParameters());
            }
            List<InferredStandardParameter> argumentSpec = redefinedPrototype.getInferredParameterTypes().get(missedOperation.getKey().getParametersTypes());
            JvmOperation op = this.jvmTypeBuilder.toMethod((EObject)source, missedOperation.getValue().getSimpleName(), missedOperation.getValue().getReturnType(), null);
            op.setVarArgs(missedOperation.getValue().isVarArgs());
            op.setFinal(true);
            ArrayList<String> arguments = new ArrayList<String>();
            for (InferredStandardParameter parameter : argumentSpec) {
                if (parameter instanceof InferredValuedParameter) {
                    InferredValuedParameter inferredParameter = (InferredValuedParameter)parameter;
                    arguments.add(this.sarlSignatureProvider.toJavaArgument(target.getIdentifier(), inferredParameter.getCallingArgument()));
                    continue;
                }
                arguments.add(parameter.getName());
                JvmFormalParameter jvmParam = this.jvmTypesFactory.createJvmFormalParameter();
                jvmParam.setName(parameter.getName());
                jvmParam.setParameterType(this.jvmTypeBuilder.cloneWithProxies(parameter.getType().toTypeReference()));
                this.associator.associate(parameter.getParameter(), (EObject)jvmParam);
                op.getParameters().add((Object)jvmParam);
            }
            this.setBody((JvmExecutable)op, (Procedures.Procedure1<ITreeAppendable>)((Procedures.Procedure1)it -> {
                it.append((CharSequence)redefinedOperation.getSimpleName());
                it.append((CharSequence)"(");
                it.append((CharSequence)IterableExtensions.join((Iterable)arguments, (CharSequence)", "));
                it.append((CharSequence)");");
            }));
            this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)op, DefaultValueUse.class, originalSignature);
            this.appendGeneratedAnnotation(baseInferrer, (JvmAnnotationTarget)op, context);
            target.getMembers().add((Object)op);
            ++actIndex;
        }
        context.setActionIndex(actIndex);
    }

    protected void appendFunctionalInterfaceAnnotation(IBaseJvmModelInferrer baseInferrer, JvmGenericType type) {
        if (type != null && Utils.isFunctionalInterface(type, this.sarlSignatureProvider) && this.jvmAnnotationFinder.findAnnotation((JvmAnnotationTarget)type, FunctionalInterface.class) == null) {
            this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)type, FunctionalInterface.class, new String[0]);
        }
    }

    protected void appendSARLSpecificationVersion(IBaseJvmModelInferrer baseInferrer, GenerationContext context, XtendTypeDeclaration source, JvmDeclaredType target) {
        this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)target, SarlSpecification.class, "0.15");
    }

    protected void appendSARLElementType(IBaseJvmModelInferrer baseInferrer, XtendTypeDeclaration source, JvmDeclaredType target) {
        this.addAnnotationSafe((JvmAnnotationTarget)target, SarlElementType.class, source.eClass().getClassifierID());
    }

    protected void appendInjectableAnnotationIfInjectable(IBaseJvmModelInferrer baseInferrer, JvmDeclaredType target, GenerationContext context) {
        if (context.isInjectable()) {
            this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)target, Injectable.class, new String[0]);
        }
    }

    protected void appendXbaseGeneratedAnnotation(IBaseJvmModelInferrer baseInferrer, JvmAnnotationTarget target) {
        if (target instanceof JvmExecutable || target instanceof JvmDeclaredType) {
            this.addAnnotationSafe(baseInferrer, target, XbaseGenerated.class, new String[0]);
        }
    }

    protected void appendComparisonFunctions(IBaseJvmModelInferrer baseInferrer, GenerationContext context, XtendTypeDeclaration source, JvmGenericType target) {
        if (this.isAppendComparisonFunctionsEnable(context, target)) {
            boolean isEqualsUserDefined = false;
            boolean isHashCodeUserDefined = false;
            for (Object operation : target.getDeclaredOperations()) {
                if (com.google.common.base.Objects.equal((Object)EQUALS_FUNCTION_NAME, (Object)operation.getSimpleName()) && operation.getParameters().size() == 1 && com.google.common.base.Objects.equal((Object)Object.class.getName(), (Object)((JvmFormalParameter)operation.getParameters().get(0)).getParameterType().getIdentifier())) {
                    isEqualsUserDefined = true;
                    continue;
                }
                if (!com.google.common.base.Objects.equal((Object)HASHCODE_FUNCTION_NAME, (Object)operation.getSimpleName()) || !operation.getParameters().isEmpty()) continue;
                isHashCodeUserDefined = true;
            }
            if (!isEqualsUserDefined || !isHashCodeUserDefined) {
                ArrayList<JvmField> declaredInstanceFields = new ArrayList<JvmField>();
                for (JvmField field : target.getDeclaredFields()) {
                    if (!this.isEqualityTestValidField(field)) continue;
                    declaredInstanceFields.add(field);
                }
                if (!declaredInstanceFields.isEmpty()) {
                    TreeMap<ActionPrototype, JvmOperation> finalOperations = new TreeMap<ActionPrototype, JvmOperation>();
                    Utils.populateInheritanceContext((JvmDeclaredType)target, finalOperations, null, null, null, null, this.sarlSignatureProvider);
                    boolean couldCreateEqualsFunction = true;
                    if (!isEqualsUserDefined) {
                        ActionPrototype prototype = new ActionPrototype(EQUALS_FUNCTION_NAME, this.sarlSignatureProvider.createParameterTypesFromString(Object.class.getName()), false);
                        couldCreateEqualsFunction = !finalOperations.containsKey(prototype);
                    }
                    boolean couldCreateHashCodeFunction = true;
                    if (!isHashCodeUserDefined) {
                        ActionPrototype prototype = new ActionPrototype(HASHCODE_FUNCTION_NAME, this.sarlSignatureProvider.createParameterTypesForVoid(), false);
                        boolean bl = couldCreateHashCodeFunction = !finalOperations.containsKey(prototype);
                    }
                    if (couldCreateEqualsFunction && couldCreateHashCodeFunction) {
                        JvmOperation op;
                        if (!isEqualsUserDefined && (op = this.toEqualsMethod(baseInferrer, source, (JvmDeclaredType)target, declaredInstanceFields, context.getGeneratorConfig2().isGeneratePureAnnotation())) != null) {
                            this.appendGeneratedAnnotation(baseInferrer, (JvmAnnotationTarget)op, context);
                            target.getMembers().add((Object)op);
                        }
                        if (!isHashCodeUserDefined && (op = this.toHashCodeMethod(baseInferrer, source, declaredInstanceFields, context.getGeneratorConfig2().isGeneratePureAnnotation())) != null) {
                            this.appendGeneratedAnnotation(baseInferrer, (JvmAnnotationTarget)op, context);
                            target.getMembers().add((Object)op);
                        }
                    }
                }
            }
        }
    }

    private boolean isAppendComparisonFunctionsEnable(GenerationContext context, JvmGenericType target) {
        if (context.getGeneratorConfig2().isGenerateEqualityTestFunctions()) {
            JvmGenericType current = target;
            TreeSet<String> encounteredTypes = new TreeSet<String>();
            do {
                JvmGenericType cvalue;
                JvmType type;
                encounteredTypes.add(current.getIdentifier());
                if (this.jvmAnnotationFinder.findAnnotation((JvmAnnotationTarget)current, NoEqualityTestFunctionsGeneration.class) != null) {
                    return false;
                }
                JvmTypeReference superType = current.getExtendedClass();
                current = null;
                if (superType == null || !((type = superType.getType()) instanceof JvmGenericType) || !encounteredTypes.contains((current = (cvalue = (JvmGenericType)type)).getIdentifier())) continue;
                current = null;
            } while (current != null);
            return true;
        }
        return false;
    }

    private boolean isEqualityTestValidField(JvmField field) {
        return !field.isStatic() && !SarlUtils.isHiddenMember((String)field.getSimpleName()) && this.jvmAnnotationFinder.findAnnotation((JvmAnnotationTarget)field, NoEqualityTestFunctionsGeneration.class) == null;
    }

    private boolean isEqualityTestValidField(JvmTypeReference reference) {
        for (Class<?> type : EQUALITY_TEST_TYPES) {
            if (!this.jvmTypeReferences.is(reference, type)) continue;
            return true;
        }
        return false;
    }

    private JvmOperation toEqualsMethod(IBaseJvmModelInferrer baseInferrer, final XtendTypeDeclaration sarlElement, final JvmDeclaredType declaredType, final Iterable<JvmField> jvmFields, boolean generatePureAnnotation) {
        if (sarlElement == null || declaredType == null) {
            return null;
        }
        JvmOperation result = this.jvmTypeBuilder.toMethod((EObject)sarlElement, EQUALS_FUNCTION_NAME, baseInferrer.getJvmTypeReferenceBuilder().typeRef(Boolean.TYPE, new JvmTypeReference[0]), null);
        if (result == null) {
            return null;
        }
        this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)result, Override.class, new String[0]);
        if (generatePureAnnotation) {
            this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)result, Pure.class, new String[0]);
        }
        JvmFormalParameter param = this.jvmTypesFactory.createJvmFormalParameter();
        param.setName("obj");
        param.setParameterType(baseInferrer.getJvmTypeReferenceBuilder().typeRef(Object.class, new JvmTypeReference[0]));
        this.associator.associate((EObject)sarlElement, (EObject)param);
        result.getParameters().add((Object)param);
        this.setBody((JvmExecutable)result, new Procedures.Procedure1<ITreeAppendable>(){

            public void apply(ITreeAppendable it) {
                boolean firstAttr = true;
                for (JvmField field : jvmFields) {
                    if (!AbstractJvmModelInferrerTypeFragment.this.isEqualityTestValidField(field.getType())) continue;
                    if (firstAttr) {
                        firstAttr = false;
                        it.append((CharSequence)"if (this == obj)").increaseIndentation();
                        it.newLine().append((CharSequence)"return true;").decreaseIndentation();
                        it.newLine().append((CharSequence)"if (obj == null)").increaseIndentation();
                        it.newLine().append((CharSequence)"return false;").decreaseIndentation();
                        it.newLine().append((CharSequence)"if (getClass() != obj.getClass())").increaseIndentation();
                        it.newLine().append((CharSequence)"return false;").decreaseIndentation();
                        StringBuilder currentTypeName = new StringBuilder();
                        currentTypeName.append(declaredType.getSimpleName());
                        List<JvmTypeParameter> typeParameters = AbstractJvmModelInferrerTypeFragment.this.getTypeParametersFor(sarlElement);
                        if (!typeParameters.isEmpty()) {
                            currentTypeName.append("<");
                            boolean first = true;
                            for (JvmTypeParameter typeParameter : typeParameters) {
                                if (first) {
                                    first = false;
                                } else {
                                    currentTypeName.append(", ");
                                }
                                currentTypeName.append(typeParameter.getName());
                            }
                            currentTypeName.append(">");
                        }
                        it.newLine().append((CharSequence)currentTypeName).append((CharSequence)" other = (");
                        it.append((CharSequence)currentTypeName).append((CharSequence)") obj;").newLine();
                    }
                    this.generateToEqualForField(it, field);
                }
                it.append((CharSequence)"return super.").append((CharSequence)AbstractJvmModelInferrerTypeFragment.EQUALS_FUNCTION_NAME);
                it.append((CharSequence)"(obj);");
            }

            private void generateToEqualForObjectNullity(ITreeAppendable it, JvmField field) {
                it.append((CharSequence)"if (other.").append((CharSequence)field.getSimpleName());
                it.append((CharSequence)" == null) {").increaseIndentation();
                it.newLine().append((CharSequence)"if (this.").append((CharSequence)field.getSimpleName()).append((CharSequence)" != null)").increaseIndentation();
                it.newLine().append((CharSequence)"return false;").decreaseIndentation().decreaseIndentation();
                it.newLine().append((CharSequence)"} else if (this.");
                it.append((CharSequence)field.getSimpleName()).append((CharSequence)" == null)").increaseIndentation();
                it.newLine().append((CharSequence)"return false;").decreaseIndentation();
            }

            private void generateToEqualForObjectTest(ITreeAppendable it, JvmField field, String convertName) {
                if (convertName != null) {
                    it.newLine().append((CharSequence)"if (other.").append((CharSequence)field.getSimpleName());
                    it.append((CharSequence)" != null && other.").append((CharSequence)field.getSimpleName());
                    it.append((CharSequence)".").append((CharSequence)convertName).append((CharSequence)"Value() != this.").append((CharSequence)field.getSimpleName());
                    it.append((CharSequence)".").append((CharSequence)convertName).append((CharSequence)"Value())").increaseIndentation();
                    it.newLine().append((CharSequence)"return false;").decreaseIndentation();
                } else {
                    it.newLine().append((CharSequence)"if (!").append(Objects.class);
                    it.append((CharSequence)".equals(this.").append((CharSequence)field.getSimpleName());
                    it.append((CharSequence)", other.").append((CharSequence)field.getSimpleName());
                    it.append((CharSequence)"))").increaseIndentation();
                    it.newLine().append((CharSequence)"return false;").decreaseIndentation();
                }
            }

            private void generateToEqualForField(ITreeAppendable it, JvmField field) {
                TypeReferences refs = AbstractJvmModelInferrerTypeFragment.this.jvmTypeReferences;
                JvmTypeReference type = field.getType();
                if (refs.is(type, Boolean.TYPE) || refs.is(type, Integer.TYPE) || refs.is(type, Long.TYPE) || refs.is(type, Character.TYPE) || refs.is(type, Byte.TYPE) || refs.is(type, Short.TYPE)) {
                    it.append((CharSequence)"if (other.").append((CharSequence)field.getSimpleName());
                    it.append((CharSequence)" != this.").append((CharSequence)field.getSimpleName()).append((CharSequence)")").increaseIndentation();
                    it.newLine().append((CharSequence)"return false;").decreaseIndentation();
                } else if (refs.is(type, Double.TYPE)) {
                    it.append((CharSequence)"if (Double.doubleToLongBits(other.").append((CharSequence)field.getSimpleName());
                    it.append((CharSequence)") != Double.doubleToLongBits(this.").append((CharSequence)field.getSimpleName());
                    it.append((CharSequence)"))").increaseIndentation();
                    it.newLine().append((CharSequence)"return false;").decreaseIndentation();
                } else if (refs.is(type, Double.class)) {
                    this.generateToEqualForObjectNullity(it, field);
                    it.newLine().append((CharSequence)"if (other.").append((CharSequence)field.getSimpleName());
                    it.append((CharSequence)" != null && Double.doubleToLongBits(other.").append((CharSequence)field.getSimpleName());
                    it.append((CharSequence)".doubleValue()) != Double.doubleToLongBits(this.").append((CharSequence)field.getSimpleName());
                    it.append((CharSequence)".doubleValue()))").increaseIndentation();
                    it.newLine().append((CharSequence)"return false;").decreaseIndentation();
                } else if (refs.is(type, Float.TYPE)) {
                    it.append((CharSequence)"if (Float.floatToIntBits(other.").append((CharSequence)field.getSimpleName());
                    it.append((CharSequence)") != Float.floatToIntBits(this.").append((CharSequence)field.getSimpleName());
                    it.append((CharSequence)"))").increaseIndentation();
                    it.newLine().append((CharSequence)"return false;").decreaseIndentation();
                } else if (refs.is(type, Float.class)) {
                    this.generateToEqualForObjectNullity(it, field);
                    it.newLine().append((CharSequence)"if (other.").append((CharSequence)field.getSimpleName());
                    it.append((CharSequence)" != null && Float.floatToIntBits(other.").append((CharSequence)field.getSimpleName());
                    it.append((CharSequence)".floatValue()) != Float.floatToIntBits(this.").append((CharSequence)field.getSimpleName());
                    it.append((CharSequence)".floatValue()))").increaseIndentation();
                    it.newLine().append((CharSequence)"return false;").decreaseIndentation();
                } else if (refs.is(type, Byte.class) || refs.is(type, Short.class) || refs.is(type, Integer.class) || refs.is(type, AtomicInteger.class) || refs.is(type, Long.class) || refs.is(type, AtomicLong.class) || refs.is(type, Boolean.class) || refs.is(type, Character.class)) {
                    this.generateToEqualForObjectNullity(it, field);
                    String conv = refs.is(type, Byte.class) ? "byte" : (refs.is(type, Short.class) ? "short" : (refs.is(type, Integer.class) ? "int" : (refs.is(type, Long.class) ? "long" : (refs.is(type, Character.class) ? "char" : (refs.is(type, Boolean.class) ? "boolean" : null)))));
                    this.generateToEqualForObjectTest(it, field, conv);
                } else {
                    it.append((CharSequence)"if (!").append(Objects.class);
                    it.append((CharSequence)".equals(this.").append((CharSequence)field.getSimpleName());
                    it.append((CharSequence)", other.").append((CharSequence)field.getSimpleName());
                    it.append((CharSequence)"))").increaseIndentation();
                    it.newLine().append((CharSequence)"return false;").decreaseIndentation();
                }
                it.newLine();
            }
        });
        return result;
    }

    private List<JvmTypeParameter> getTypeParametersFor(XtendTypeDeclaration type) {
        if (type instanceof XtendClass) {
            XtendClass cvalue = (XtendClass)type;
            return cvalue.getTypeParameters();
        }
        if (type instanceof XtendInterface) {
            XtendInterface cvalue = (XtendInterface)type;
            return cvalue.getTypeParameters();
        }
        return Collections.emptyList();
    }

    private JvmOperation toHashCodeMethod(IBaseJvmModelInferrer baseInferrer, XtendTypeDeclaration sarlElement, Iterable<JvmField> jvmFields, boolean generatePureAnnotation) {
        if (sarlElement == null) {
            return null;
        }
        JvmOperation result = this.jvmTypeBuilder.toMethod((EObject)sarlElement, HASHCODE_FUNCTION_NAME, baseInferrer.getJvmTypeReferenceBuilder().typeRef(Integer.TYPE, new JvmTypeReference[0]), null);
        if (result == null) {
            return null;
        }
        this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)result, Override.class, new String[0]);
        if (generatePureAnnotation) {
            this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)result, Pure.class, new String[0]);
        }
        this.setBody((JvmExecutable)result, (Procedures.Procedure1<ITreeAppendable>)((Procedures.Procedure1)it -> {
            TypeReferences refs = this.jvmTypeReferences;
            it.append((CharSequence)"int result = super.").append((CharSequence)HASHCODE_FUNCTION_NAME);
            it.append((CharSequence)"();");
            boolean firstAttr = true;
            for (JvmField field : jvmFields) {
                JvmTypeReference type;
                if (!this.isEqualityTestValidField(field.getType())) continue;
                if (firstAttr) {
                    firstAttr = false;
                    it.newLine().append((CharSequence)"final int prime = 31;");
                }
                if (refs.is(type = field.getType(), Boolean.TYPE)) {
                    it.newLine().append((CharSequence)"result = prime * result + Boolean.hashCode(this.");
                    it.append((CharSequence)field.getSimpleName()).append((CharSequence)");");
                    continue;
                }
                if (refs.is(type, Character.TYPE)) {
                    it.newLine().append((CharSequence)"result = prime * result + Character.hashCode(this.");
                    it.append((CharSequence)field.getSimpleName()).append((CharSequence)");");
                    continue;
                }
                if (refs.is(type, Byte.TYPE)) {
                    it.newLine().append((CharSequence)"result = prime * result + Byte.hashCode(this.");
                    it.append((CharSequence)field.getSimpleName()).append((CharSequence)");");
                    continue;
                }
                if (refs.is(type, Short.TYPE)) {
                    it.newLine().append((CharSequence)"result = prime * result + Short.hashCode(this.");
                    it.append((CharSequence)field.getSimpleName()).append((CharSequence)");");
                    continue;
                }
                if (refs.is(type, Integer.TYPE)) {
                    it.newLine().append((CharSequence)"result = prime * result + Integer.hashCode(this.");
                    it.append((CharSequence)field.getSimpleName()).append((CharSequence)");");
                    continue;
                }
                if (refs.is(type, Long.TYPE)) {
                    it.newLine().append((CharSequence)"result = prime * result + Long.hashCode(this.");
                    it.append((CharSequence)field.getSimpleName()).append((CharSequence)");");
                    continue;
                }
                if (refs.is(type, Float.TYPE)) {
                    it.newLine().append((CharSequence)"result = prime * result + Float.hashCode(this.");
                    it.append((CharSequence)field.getSimpleName()).append((CharSequence)");");
                    continue;
                }
                if (refs.is(type, Double.TYPE)) {
                    it.newLine().append((CharSequence)"result = prime * result + Double.hashCode(this.");
                    it.append((CharSequence)field.getSimpleName()).append((CharSequence)");");
                    continue;
                }
                it.newLine().append((CharSequence)"result = prime * result + ");
                it.append(Objects.class).append((CharSequence)".hashCode(this.");
                it.append((CharSequence)field.getSimpleName()).append((CharSequence)");");
            }
            it.newLine().append((CharSequence)"return result;");
        }));
        return result;
    }

    protected void appendCloneFunctionIfCloneable(IBaseJvmModelInferrer baseInferrer, GenerationContext context, XtendTypeDeclaration source, JvmGenericType target) {
        if (!target.isInterface() && this.inheritanceHelper.isSubTypeOf((JvmType)target, Cloneable.class, null)) {
            this.appendCloneFunction(baseInferrer, context, source, target);
        }
    }

    private void appendCloneFunction(IBaseJvmModelInferrer baseInferrer, GenerationContext context, XtendTypeDeclaration source, JvmGenericType target) {
        if (!AbstractJvmModelInferrerTypeFragment.isAppendCloneFunctionsEnable(context)) {
            return;
        }
        for (JvmOperation operation : target.getDeclaredOperations()) {
            if (!CLONE_FUNCTION_NAME.equals(operation.getSimpleName())) continue;
            return;
        }
        ActionPrototype standardPrototype = new ActionPrototype(CLONE_FUNCTION_NAME, this.sarlSignatureProvider.createParameterTypesForVoid(), false);
        TreeMap<ActionPrototype, JvmOperation> finalOperations = new TreeMap<ActionPrototype, JvmOperation>();
        Utils.populateInheritanceContext((JvmDeclaredType)target, finalOperations, null, null, null, null, this.sarlSignatureProvider);
        if (!finalOperations.containsKey(standardPrototype)) {
            JvmTypeReference[] genericParameters = new JvmTypeReference[target.getTypeParameters().size()];
            for (int i = 0; i < target.getTypeParameters().size(); ++i) {
                JvmTypeParameter typeParameter = (JvmTypeParameter)target.getTypeParameters().get(i);
                genericParameters[i] = baseInferrer.getJvmTypeReferenceBuilder().typeRef((JvmType)typeParameter, new JvmTypeReference[0]);
            }
            JvmTypeReference myselfReference = baseInferrer.getJvmTypeReferenceBuilder().typeRef((JvmType)target, genericParameters);
            JvmOperation operation = this.jvmTypeBuilder.toMethod((EObject)source, CLONE_FUNCTION_NAME, myselfReference, null);
            target.getMembers().add((Object)operation);
            operation.setVisibility(JvmVisibility.PUBLIC);
            this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)operation, Override.class, new String[0]);
            if (context.getGeneratorConfig2().isGeneratePureAnnotation()) {
                this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)operation, Pure.class, new String[0]);
            }
            LightweightTypeReference myselfReference2 = Utils.toLightweightTypeReference(operation.getReturnType(), this.services);
            this.setBody((JvmExecutable)operation, (Procedures.Procedure1<ITreeAppendable>)((Procedures.Procedure1)it -> {
                it.append((CharSequence)"try {");
                it.increaseIndentation().newLine();
                it.append((CharSequence)"return (").append(myselfReference2).append((CharSequence)") super.");
                it.append((CharSequence)CLONE_FUNCTION_NAME).append((CharSequence)"();");
                it.decreaseIndentation().newLine();
                it.append((CharSequence)"} catch (").append(Throwable.class).append((CharSequence)" exception) {");
                it.increaseIndentation().newLine();
                it.append((CharSequence)"throw new ").append(Error.class).append((CharSequence)"(exception);");
                it.decreaseIndentation().newLine();
                it.append((CharSequence)"}");
            }));
            this.appendGeneratedAnnotation(baseInferrer, (JvmAnnotationTarget)operation, context);
        }
    }

    private static boolean isAppendCloneFunctionsEnable(GenerationContext context) {
        return context.getGeneratorConfig2().isGenerateCloneFunctions();
    }

    protected void appendDefaultConstructors(IBaseJvmModelInferrer baseInferrer, XtendTypeDeclaration source, JvmGenericType target) {
        JvmType type;
        JvmTypeReference reference;
        boolean notInitializedValueField;
        GenerationContext context = baseInferrer.getContext((JvmIdentifiableElement)target);
        if (!context.hasConstructor() && !(notInitializedValueField = Iterables.any((Iterable)source.getMembers(), it -> {
            XtendField op;
            return it instanceof XtendField && (op = (XtendField)it).isFinal() && !op.isStatic() && op.getInitialValue() == null;
        })) && (reference = target.getExtendedClass()) != null && (type = reference.getType()) instanceof JvmGenericType) {
            JvmGenericType cvalue = (JvmGenericType)type;
            this.copyVisibleJvmConstructors(baseInferrer, context, cvalue, target, source, Sets.newTreeSet(), JvmVisibility.PUBLIC);
        }
    }

    protected Iterable<JvmConstructor> getVisibleInheritedJvmConstructors(JvmGenericType source, JvmGenericType target) {
        boolean samePackage = com.google.common.base.Objects.equal((Object)source.getPackageName(), (Object)target.getPackageName());
        Iterable constructors = Iterables.transform((Iterable)Iterables.filter((Iterable)source.getMembers(), it -> {
            if (it instanceof JvmConstructor) {
                JvmConstructor op = (JvmConstructor)it;
                return op.getVisibility() != JvmVisibility.PRIVATE && (op.getVisibility() != JvmVisibility.DEFAULT || samePackage);
            }
            return false;
        }), it -> (JvmConstructor)it);
        return constructors;
    }

    private void copyVisibleJvmConstructors(IBaseJvmModelInferrer baseInferrer, GenerationContext context, JvmGenericType source, JvmGenericType target, XtendTypeDeclaration sarlSource, Set<ActionParameterTypes> createdConstructors, JvmVisibility minimalVisibility) {
        Iterable<JvmConstructor> constructors = this.getVisibleInheritedJvmConstructors(source, target);
        TreeSet<Pair> sortedConstructors = new TreeSet<Pair>((elt1, elt2) -> ((ActionParameterTypes)elt1.getValue()).compareTo((ActionParameterTypes)elt2.getValue()));
        for (JvmConstructor constructor : constructors) {
            ActionParameterTypes types = this.sarlSignatureProvider.createParameterTypesFromJvmModel(constructor.isVarArgs(), (List<JvmFormalParameter>)constructor.getParameters());
            sortedConstructors.add(new Pair((Object)constructor, (Object)types));
        }
        for (Pair pair : sortedConstructors) {
            if (!createdConstructors.add((ActionParameterTypes)pair.getValue())) continue;
            JvmConstructor constructor = (JvmConstructor)pair.getKey();
            JvmConstructor newCons = this.jvmTypesFactory.createJvmConstructor();
            newCons.setDeprecated(constructor.isDeprecated());
            newCons.setSimpleName(target.getSimpleName());
            target.getMembers().add((Object)newCons);
            for (JvmFormalParameter parameter : constructor.getParameters()) {
                JvmFormalParameter newParam = this.jvmTypesFactory.createJvmFormalParameter();
                newParam.setName(parameter.getSimpleName());
                newCons.getParameters().add((Object)newParam);
                JvmTypeReference originalParamTypeReference = parameter.getParameterType();
                JvmTypeReference paramType = this.cloneWithTypeParametersAndProxies(originalParamTypeReference, (JvmExecutable)newCons, baseInferrer);
                assert (originalParamTypeReference != paramType);
                newParam.setParameterType(paramType);
                for (JvmAnnotationReference annotationReference : parameter.getAnnotations()) {
                    JvmAnnotationReference annotation;
                    if (this.annotationUtils.findAnnotation((JvmAnnotationTarget)newParam, annotationReference.getAnnotation().getQualifiedName()) != null || (annotation = (JvmAnnotationReference)EcoreUtil.copy((EObject)annotationReference)) == null) continue;
                    newParam.getAnnotations().add((Object)annotation);
                    this.associator.removeAllAssociation((EObject)annotation);
                }
                this.associator.removeAllAssociation((EObject)paramType);
                this.associator.removeAllAssociation((EObject)newParam);
            }
            newCons.setVarArgs(constructor.isVarArgs());
            JvmVisibility visibility = constructor.getVisibility();
            if (visibility != null && minimalVisibility != null && minimalVisibility.compareTo((Enum)visibility) > 0) {
                visibility = minimalVisibility;
            }
            newCons.setVisibility(visibility);
            this.setBody((JvmExecutable)newCons, (Procedures.Procedure1<ITreeAppendable>)((Procedures.Procedure1)it -> {
                it.append((CharSequence)this.grammarKeywordAccess.getSuperKeyword());
                it.append((CharSequence)"(");
                boolean first = true;
                for (JvmFormalParameter parameter : newCons.getParameters()) {
                    if (first) {
                        first = false;
                    } else {
                        it.append((CharSequence)", ");
                    }
                    it.append((CharSequence)parameter.getSimpleName());
                }
                it.append((CharSequence)");");
            }));
            this.copyAndCleanDocumentationTo((JvmExecutable)constructor, (JvmExecutable)newCons);
            this.appendGeneratedAnnotation(baseInferrer, (JvmAnnotationTarget)newCons, baseInferrer.getContext((JvmIdentifiableElement)target));
            for (JvmAnnotationReference annotationReference : constructor.getAnnotations()) {
                JvmAnnotationReference annotation;
                JvmAnnotationType annotationType = annotationReference.getAnnotation();
                if (!this.isAccessibleTypeAccordingToJavaSpecifications(baseInferrer, context, (JvmDeclaredType)annotationType) || this.annotationUtils.findAnnotation((JvmAnnotationTarget)newCons, annotationType.getQualifiedName()) != null || (annotation = (JvmAnnotationReference)EcoreUtil.copy((EObject)annotationReference)) == null) continue;
                newCons.getAnnotations().add((Object)annotation);
            }
            this.associator.removeAllAssociation((EObject)newCons);
        }
    }

    private boolean isAccessibleTypeAccordingToJavaSpecifications(IBaseJvmModelInferrer baseInferrer, GenerationContext context, JvmDeclaredType type) {
        String packageName = type.getPackageName();
        if (!Strings.isNullOrEmpty((String)packageName)) {
            return !packageName.contains(".internal");
        }
        return true;
    }

    protected void appendSerialNumberIfSerializable(IBaseJvmModelInferrer baseInferrer, GenerationContext context, XtendTypeDeclaration source, JvmGenericType target) {
        if (!target.isInterface() && this.inheritanceHelper.isSubTypeOf((JvmType)target, Serializable.class, null)) {
            this.appendSerialNumber(baseInferrer, context, source, target);
        }
    }

    protected void appendSerialNumber(IBaseJvmModelInferrer baseInferrer, GenerationContext context, XtendTypeDeclaration source, JvmGenericType target) {
        if (!AbstractJvmModelInferrerTypeFragment.isAppendSerialNumbersEnable(context)) {
            return;
        }
        for (JvmField field : target.getDeclaredFields()) {
            if (!SERIAL_FIELD_NAME.equals(field.getSimpleName())) continue;
            return;
        }
        JvmField field = this.jvmTypesFactory.createJvmField();
        field.setSimpleName(SERIAL_FIELD_NAME);
        field.setVisibility(JvmVisibility.PRIVATE);
        field.setStatic(true);
        field.setTransient(false);
        field.setVolatile(false);
        field.setFinal(true);
        target.getMembers().add((Object)field);
        field.setType(this.jvmTypeBuilder.cloneWithProxies(baseInferrer.getJvmTypeReferenceBuilder().typeRef(Long.TYPE, new JvmTypeReference[0])));
        long serial = context.getSerial();
        this.jvmTypeBuilder.setInitializer(field, AbstractJvmModelInferrerTypeFragment.toStringConcatenation(serial + "L"));
        this.appendGeneratedAnnotation(baseInferrer, (JvmAnnotationTarget)field, context);
        this.readAndWriteTracking.markInitialized((EObject)field, null);
    }

    private static boolean isAppendSerialNumbersEnable(GenerationContext context) {
        return context.getGeneratorConfig2().isGenerateSerialNumberFields();
    }

    protected void appendConstrainedExtends(IBaseJvmModelInferrer baseInferrer, GenerationContext context, JvmGenericType owner, Class<?> defaultJvmType, Class<? extends XtendTypeDeclaration> defaultSarlType, JvmParameterizedTypeReference supertype) {
        List<Object> supertypes = supertype == null ? Collections.emptyList() : Collections.singletonList(supertype);
        this.appendConstrainedExtends(baseInferrer, context, owner, defaultJvmType, defaultSarlType, supertypes);
    }

    protected void appendConstrainedExtends(IBaseJvmModelInferrer baseInferrer, GenerationContext context, JvmGenericType owner, Class<?> defaultJvmType, Class<? extends XtendTypeDeclaration> defaultSarlType, List<? extends JvmParameterizedTypeReference> supertypes) {
        boolean explicitType = false;
        String ownerId = owner.getIdentifier();
        for (JvmParameterizedTypeReference jvmParameterizedTypeReference : supertypes) {
            String superTypeId;
            try {
                superTypeId = jvmParameterizedTypeReference.getIdentifier();
            }
            catch (Exception ex) {
                baseInferrer.logInternalError(ex);
                superTypeId = null;
            }
            if (com.google.common.base.Objects.equal((Object)ownerId, (Object)superTypeId) || !(jvmParameterizedTypeReference.getType() instanceof JvmGenericType)) continue;
            owner.getSuperTypes().add((Object)this.jvmTypeBuilder.cloneWithProxies((JvmTypeReference)jvmParameterizedTypeReference));
            context.incrementSerial(jvmParameterizedTypeReference.getIdentifier().hashCode());
            explicitType = true;
        }
        if (!explicitType) {
            JvmTypeReference type = baseInferrer.getJvmTypeReferenceBuilder().typeRef(defaultJvmType, new JvmTypeReference[0]);
            if (!(type instanceof JvmUnknownTypeReference)) {
                owner.getSuperTypes().add((Object)type);
            }
            context.incrementSerial(type.getIdentifier().hashCode());
        }
    }

    protected void appendConstrainedImplements(IBaseJvmModelInferrer baseInferrer, GenerationContext context, JvmGenericType owner, Class<?> defaultJvmType, Class<? extends XtendTypeDeclaration> defaultSarlType, List<? extends JvmParameterizedTypeReference> implementedtypes) {
        boolean explicitType = false;
        for (JvmParameterizedTypeReference jvmParameterizedTypeReference : implementedtypes) {
            if (com.google.common.base.Objects.equal((Object)owner.getIdentifier(), (Object)jvmParameterizedTypeReference.getIdentifier()) || !(jvmParameterizedTypeReference.getType() instanceof JvmGenericType)) continue;
            owner.getSuperTypes().add((Object)this.jvmTypeBuilder.cloneWithProxies((JvmTypeReference)jvmParameterizedTypeReference));
            context.incrementSerial(jvmParameterizedTypeReference.getIdentifier().hashCode());
            explicitType = true;
        }
        if (!explicitType) {
            JvmTypeReference type = baseInferrer.getJvmTypeReferenceBuilder().typeRef(defaultJvmType, new JvmTypeReference[0]);
            owner.getSuperTypes().add((Object)type);
            context.incrementSerial(type.getIdentifier().hashCode());
        }
    }

    protected void copyNonStaticPublicJvmOperations(IBaseJvmModelInferrer baseInferrer, JvmGenericType source, JvmGenericType target, Set<ActionPrototype> createdActions, boolean copyHiddenNames, Procedures.Procedure2<? super JvmOperation, ? super ITreeAppendable> bodyBuilder) {
        Iterable operations = Iterables.transform((Iterable)Iterables.filter((Iterable)source.getMembers(), it -> {
            if (it instanceof JvmOperation) {
                JvmOperation op = (JvmOperation)it;
                if (!op.isStatic() && op.getVisibility() == JvmVisibility.PUBLIC) {
                    return copyHiddenNames || !SarlUtils.isHiddenMember((String)op.getSimpleName());
                }
                return false;
            }
            return false;
        }), it -> (JvmOperation)it);
        for (JvmOperation operation : operations) {
            ActionParameterTypes types = this.sarlSignatureProvider.createParameterTypesFromJvmModel(operation.isVarArgs(), (List<JvmFormalParameter>)operation.getParameters());
            ActionPrototype actSigKey = this.sarlSignatureProvider.createActionPrototype(operation.getSimpleName(), types);
            if (!createdActions.add(actSigKey)) continue;
            JvmOperation newOp = this.jvmTypesFactory.createJvmOperation();
            target.getMembers().add((Object)newOp);
            newOp.setAbstract(false);
            newOp.setFinal(false);
            newOp.setNative(false);
            newOp.setStatic(false);
            newOp.setSynchronized(false);
            newOp.setVisibility(JvmVisibility.PUBLIC);
            newOp.setDefault(operation.isDefault());
            newOp.setDeprecated(operation.isDeprecated());
            newOp.setSimpleName(operation.getSimpleName());
            newOp.setStrictFloatingPoint(operation.isStrictFloatingPoint());
            this.copyTypeParametersFromJvmOperation(baseInferrer, operation, newOp);
            for (JvmTypeReference exception : operation.getExceptions()) {
                newOp.getExceptions().add((Object)this.cloneWithTypeParametersAndProxies(exception, (JvmExecutable)newOp, baseInferrer));
            }
            for (JvmFormalParameter parameter : operation.getParameters()) {
                JvmFormalParameter newParam = this.jvmTypesFactory.createJvmFormalParameter();
                newOp.getParameters().add((Object)newParam);
                newParam.setName(parameter.getSimpleName());
                newParam.setParameterType(this.cloneWithTypeParametersAndProxies(parameter.getParameterType(), (JvmExecutable)newOp, baseInferrer));
            }
            newOp.setVarArgs(operation.isVarArgs());
            newOp.setReturnType(this.cloneWithTypeParametersAndProxies(operation.getReturnType(), (JvmExecutable)newOp, baseInferrer));
            this.setBody((JvmExecutable)newOp, (Procedures.Procedure1<ITreeAppendable>)((Procedures.Procedure1)it -> bodyBuilder.apply((Object)operation, it)));
        }
    }

    protected void copyTypeParametersFromJvmOperation(IBaseJvmModelInferrer baseInferrer, JvmOperation fromOperation, JvmOperation toOperation) {
        Utils.copyTypeParametersFromJvmOperation(fromOperation, toOperation, baseInferrer.getJvmTypeReferenceBuilder(), this.jvmTypeBuilder, this.jvmTypeReferences, this.jvmTypesFactory);
    }

    protected void appendAOPMembers(IBaseJvmModelInferrer baseInferrer, JvmGenericType featureContainerType, XtendTypeDeclaration container, GenerationContext context) {
        Utils.populateInheritanceContext((JvmDeclaredType)featureContainerType, context.getInheritedFinalOperations(), context.getInheritedOverridableOperations(), null, context.getInheritedOperationsToImplement(), null, this.sarlSignatureProvider);
        LinkedList<XtendMember> delayedMembers = new LinkedList<XtendMember>();
        for (XtendMember feature : container.getMembers()) {
            if (!context.isSupportedMember(feature)) continue;
            if (feature instanceof SarlCapacityUses || feature instanceof SarlRequiredCapacity) {
                delayedMembers.add(feature);
                continue;
            }
            baseInferrer.transform(feature, featureContainerType, true);
        }
        for (XtendMember feature : delayedMembers) {
            baseInferrer.transform(feature, featureContainerType, false);
        }
        this.appendEventGuardEvaluators(baseInferrer, featureContainerType);
        baseInferrer.appendSyntheticDispatchMethods(container, featureContainerType);
        this.appendSyntheticDefaultValuedParameterMethods(baseInferrer, container, (JvmDeclaredType)featureContainerType, true, context);
    }

    private void appendEventGuardEvaluators(IBaseJvmModelInferrer baseInferrer, JvmGenericType container) {
        GenerationContext context = baseInferrer.getContext((JvmIdentifiableElement)container);
        if (context != null) {
            Collection<GenerationContext.BehaviorUnitGuardEvaluators> allEvaluators = context.getGuardEvaluationCodes();
            if (allEvaluators == null || allEvaluators.isEmpty()) {
                return;
            }
            BehaviorUnitDefinitions guardDefs = new BehaviorUnitDefinitions();
            for (GenerationContext.BehaviorUnitGuardEvaluators evaluators : allEvaluators) {
                String behName = this.appendEventGuardEvaluatorForReflectMethod(baseInferrer, evaluators, container, context);
                BehaviorUnitFunctions functionNames = guardDefs.getFunctionsFor((JvmTypeReference)evaluators.eventType());
                ArrayList typeParameters = new ArrayList();
                Utils.TypeParameterStatus result = Utils.forEachTypeParameterName(evaluators.eventType(), (name, i) -> typeParameters.add(name));
                functionNames.registerFunction(behName, result == Utils.TypeParameterStatus.EXPLICIT_DIRECT_TYPE ? typeParameters : Collections.emptyList());
            }
            boolean isRootType = true;
            JvmTypeReference superType = container.getExtendedClass();
            if (superType != null) {
                String containerName = superType.getIdentifier();
                isRootType = containerName.equals(Agent.class.getName()) || containerName.equals(Behavior.class.getName()) || containerName.equals(Skill.class.getName());
            }
            this.appendEventGuardEvaluatorsForPolymorphicMethod(baseInferrer, guardDefs, isRootType, container, context);
        }
    }

    private String appendEventGuardEvaluatorForReflectMethod(IBaseJvmModelInferrer baseInferrer, GenerationContext.BehaviorUnitGuardEvaluators evaluators, JvmGenericType container, GenerationContext context) {
        List<JvmTypeReference> bounds;
        SarlBehaviorUnit source = evaluators.source();
        JvmParameterizedTypeReference sourceId = evaluators.eventType();
        JvmTypeReference voidType = baseInferrer.getJvmTypeReferenceBuilder().typeRef(Void.TYPE, new JvmTypeReference[0]);
        JvmTypeReference runnableType = baseInferrer.getJvmTypeReferenceBuilder().typeRef(Runnable.class, new JvmTypeReference[0]);
        JvmTypeReference collectionType = baseInferrer.getJvmTypeReferenceBuilder().typeRef(Collection.class, new JvmTypeReference[]{runnableType});
        JvmType rawEventId = sourceId.getType();
        JvmParameterizedTypeReference rawEventReference = this.jvmTypeReferences.createTypeRef(rawEventId, new JvmTypeReference[0]);
        rawEventReference.getArguments().clear();
        String behaviorUnitName = Utils.createNameForHiddenGuardGeneralEvaluatorMethod(sourceId);
        JvmOperation operation = this.jvmTypesFactory.createJvmOperation();
        this.appendGeneratedAnnotation(baseInferrer, (JvmAnnotationTarget)operation, context);
        JvmAnnotationReference guardAnnotation = this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)operation, PerceptGuardEvaluator.class, new String[0]);
        if (guardAnnotation != null && (bounds = Utils.getTypeParameterBoundsFor(sourceId, this.jvmTypeReferences)) != null && !bounds.isEmpty()) {
            JvmOperation boundOperation = null;
            for (JvmOperation guardAnnotationOperation : guardAnnotation.getAnnotation().getDeclaredOperations()) {
                if (!"typeParameters".equals(guardAnnotationOperation.getSimpleName())) continue;
                boundOperation = guardAnnotationOperation;
                break;
            }
            JvmTypeAnnotationValue generics = this.jvmTypesFactory.createJvmTypeAnnotationValue();
            for (JvmTypeReference boundType : bounds) {
                generics.getValues().add((Object)this.jvmTypeBuilder.cloneWithProxies(boundType));
            }
            generics.setOperation(boundOperation);
            guardAnnotation.getExplicitValues().add((Object)generics);
        }
        JvmFormalParameter jvmParam = this.jvmTypesFactory.createJvmFormalParameter();
        jvmParam.setName(this.grammarKeywordAccess.getOccurrenceKeyword());
        jvmParam.setParameterType((JvmTypeReference)rawEventReference);
        this.associator.associate((EObject)source, (EObject)jvmParam);
        operation.getParameters().add((Object)jvmParam);
        jvmParam = this.jvmTypesFactory.createJvmFormalParameter();
        jvmParam.setName(RUNNABLE_COLLECTION);
        jvmParam.setParameterType(this.jvmTypeBuilder.cloneWithProxies(collectionType));
        operation.getParameters().add((Object)jvmParam);
        operation.setAbstract(false);
        operation.setNative(false);
        operation.setSynchronized(false);
        operation.setStrictFloatingPoint(false);
        operation.setFinal(false);
        operation.setVisibility(JvmVisibility.PRIVATE);
        operation.setStatic(false);
        operation.setSimpleName(behaviorUnitName);
        operation.setReturnType(this.jvmTypeBuilder.cloneWithProxies(voidType));
        container.getMembers().add((Object)operation);
        this.setBody((JvmExecutable)operation, (Procedures.Procedure1<ITreeAppendable>)((Procedures.Procedure1)it -> {
            it.append((CharSequence)"assert ");
            it.append((CharSequence)this.grammarKeywordAccess.getOccurrenceKeyword());
            it.append((CharSequence)" != null;");
            it.newLine();
            it.append((CharSequence)"assert ");
            it.append((CharSequence)RUNNABLE_COLLECTION);
            it.append((CharSequence)" != null;");
            for (Procedures.Procedure1<? super ITreeAppendable> code : evaluators.evaluators()) {
                it.newLine();
                code.apply(it);
            }
        }));
        this.associator.associatePrimary((EObject)source, (EObject)operation);
        this.jvmTypeBuilder.copyDocumentationTo((EObject)source, (JvmIdentifiableElement)operation);
        return behaviorUnitName;
    }

    private void appendEventGuardEvaluatorsForPolymorphicMethod(IBaseJvmModelInferrer baseInferrer, BehaviorUnitDefinitions guardDefs, boolean isRootType, JvmGenericType container, GenerationContext context) {
        JvmTypeReference voidType = baseInferrer.getJvmTypeReferenceBuilder().typeRef(Void.TYPE, new JvmTypeReference[0]);
        JvmOperation eventTypeOperation = this.jvmTypesFactory.createJvmOperation();
        this.appendGeneratedAnnotation(baseInferrer, (JvmAnnotationTarget)eventTypeOperation, context);
        this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)eventTypeOperation, Override.class, new String[0]);
        eventTypeOperation.setAbstract(false);
        eventTypeOperation.setNative(false);
        eventTypeOperation.setSynchronized(false);
        eventTypeOperation.setStrictFloatingPoint(false);
        eventTypeOperation.setFinal(false);
        eventTypeOperation.setVisibility(JvmVisibility.PUBLIC);
        eventTypeOperation.setStatic(false);
        eventTypeOperation.setSimpleName("$getSupportedEvents");
        eventTypeOperation.setReturnType(this.jvmTypeBuilder.cloneWithProxies(voidType));
        JvmFormalParameter jvmParam0 = this.jvmTypesFactory.createJvmFormalParameter();
        jvmParam0.setName("toBeFilled");
        jvmParam0.setParameterType(baseInferrer.getJvmTypeReferenceBuilder().typeRef(Set.class, new JvmTypeReference[]{baseInferrer.getJvmTypeReferenceBuilder().typeRef(Class.class, new JvmTypeReference[]{baseInferrer.getJvmTypeReferenceBuilder().wildcardExtends(baseInferrer.getJvmTypeReferenceBuilder().typeRef(Event.class, new JvmTypeReference[0]))})}));
        eventTypeOperation.getParameters().add((Object)jvmParam0);
        container.getMembers().add((Object)eventTypeOperation);
        this.setBody((JvmExecutable)eventTypeOperation, (Procedures.Procedure1<ITreeAppendable>)((Procedures.Procedure1)it -> {
            it.append((CharSequence)"super.").append((CharSequence)"$");
            it.append((CharSequence)"getSupportedEvents(toBeFilled);");
            for (JvmTypeReference type : guardDefs.getEventTypes()) {
                it.newLine();
                it.append((CharSequence)"toBeFilled.add(");
                it.append(type.getType());
                it.append((CharSequence)".class);");
            }
        }));
        JvmOperation eventSupportOperation = this.jvmTypesFactory.createJvmOperation();
        this.appendGeneratedAnnotation(baseInferrer, (JvmAnnotationTarget)eventSupportOperation, context);
        this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)eventSupportOperation, Override.class, new String[0]);
        eventSupportOperation.setAbstract(false);
        eventSupportOperation.setNative(false);
        eventSupportOperation.setSynchronized(false);
        eventSupportOperation.setStrictFloatingPoint(false);
        eventSupportOperation.setFinal(false);
        eventSupportOperation.setVisibility(JvmVisibility.PUBLIC);
        eventSupportOperation.setStatic(false);
        eventSupportOperation.setSimpleName("$isSupportedEvent");
        eventSupportOperation.setReturnType(baseInferrer.getJvmTypeReferenceBuilder().typeRef(Boolean.TYPE, new JvmTypeReference[0]));
        JvmFormalParameter jvmParam1 = this.jvmTypesFactory.createJvmFormalParameter();
        jvmParam1.setName("event");
        jvmParam1.setParameterType(baseInferrer.getJvmTypeReferenceBuilder().typeRef(Class.class, new JvmTypeReference[]{baseInferrer.getJvmTypeReferenceBuilder().wildcardExtends(baseInferrer.getJvmTypeReferenceBuilder().typeRef(Event.class, new JvmTypeReference[0]))}));
        eventSupportOperation.getParameters().add((Object)jvmParam1);
        container.getMembers().add((Object)eventSupportOperation);
        this.setBody((JvmExecutable)eventSupportOperation, (Procedures.Procedure1<ITreeAppendable>)((Procedures.Procedure1)it -> {
            for (JvmTypeReference type : guardDefs.getEventTypes()) {
                it.append((CharSequence)"if (");
                it.append(type.getType());
                it.append((CharSequence)".class.isAssignableFrom(event)) {");
                it.increaseIndentation().newLine();
                it.append((CharSequence)"return true;");
                it.decreaseIndentation().newLine();
                it.append((CharSequence)"}");
                it.newLine();
            }
            it.append((CharSequence)"return ");
            if (isRootType) {
                it.append((CharSequence)"false");
            } else {
                it.append((CharSequence)"super.").append((CharSequence)"$");
                it.append((CharSequence)"isSupportedEvent(event)");
            }
            it.append((CharSequence)";");
        }));
        JvmTypeReference runnableType = baseInferrer.getJvmTypeReferenceBuilder().typeRef(Runnable.class, new JvmTypeReference[0]);
        JvmTypeReference collectionType = baseInferrer.getJvmTypeReferenceBuilder().typeRef(Collection.class, new JvmTypeReference[]{runnableType});
        JvmOperation evaluateOperation = this.jvmTypesFactory.createJvmOperation();
        this.appendGeneratedAnnotation(baseInferrer, (JvmAnnotationTarget)evaluateOperation, context);
        this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)evaluateOperation, Override.class, new String[0]);
        evaluateOperation.setAbstract(false);
        evaluateOperation.setNative(false);
        evaluateOperation.setSynchronized(false);
        evaluateOperation.setStrictFloatingPoint(false);
        evaluateOperation.setFinal(false);
        evaluateOperation.setVisibility(JvmVisibility.PUBLIC);
        evaluateOperation.setStatic(false);
        evaluateOperation.setSimpleName("$evaluateBehaviorGuards");
        evaluateOperation.setReturnType(this.jvmTypeBuilder.cloneWithProxies(voidType));
        JvmFormalParameter jvmParam4 = this.jvmTypesFactory.createJvmFormalParameter();
        jvmParam4.setName("eventType");
        jvmParam4.setParameterType(baseInferrer.getJvmTypeReferenceBuilder().typeRef(Class.class, new JvmTypeReference[]{baseInferrer.getJvmTypeReferenceBuilder().wildcard()}));
        evaluateOperation.getParameters().add((Object)jvmParam4);
        JvmFormalParameter jvmParam2 = this.jvmTypesFactory.createJvmFormalParameter();
        jvmParam2.setName("event");
        jvmParam2.setParameterType(baseInferrer.getJvmTypeReferenceBuilder().typeRef(Object.class, new JvmTypeReference[0]));
        evaluateOperation.getParameters().add((Object)jvmParam2);
        JvmFormalParameter jvmParam3 = this.jvmTypesFactory.createJvmFormalParameter();
        jvmParam3.setName("callbacks");
        jvmParam3.setParameterType(this.jvmTypeBuilder.cloneWithProxies(collectionType));
        evaluateOperation.getParameters().add((Object)jvmParam3);
        container.getMembers().add((Object)evaluateOperation);
        this.setBody((JvmExecutable)evaluateOperation, (Procedures.Procedure1<ITreeAppendable>)((Procedures.Procedure1)it -> {
            it.append((CharSequence)"assert eventType != null;").newLine();
            it.append((CharSequence)"assert event != null;").newLine();
            it.append((CharSequence)"super.").append((CharSequence)"$");
            it.append((CharSequence)"evaluateBehaviorGuards(eventType, event, callbacks);");
            for (BehaviorUnitFunctions functions : guardDefs.getFunctions()) {
                it.newLine();
                it.append((CharSequence)"if (");
                it.append(functions.getEventType());
                it.append((CharSequence)".class.equals(eventType)) {");
                it.increaseIndentation().newLine();
                it.append((CharSequence)"final var occurrence = (").append(functions.getEventType()).append((CharSequence)") event;");
                for (BehaviorUnitFunction methSpec : functions.getFunctions()) {
                    boolean hasTypeParameters;
                    it.newLine();
                    boolean bl = hasTypeParameters = !methSpec.bounds().isEmpty();
                    if (hasTypeParameters) {
                        it.append((CharSequence)"if (").append(functions.getEventType());
                        it.append((CharSequence)".").append((CharSequence)"$");
                        it.append((CharSequence)"matchesTypeBounds(occurrence");
                        for (JvmTypeReference typeParameter : methSpec.bounds) {
                            it.append((CharSequence)", ").append(typeParameter.getType()).append((CharSequence)".class");
                        }
                        it.append((CharSequence)")) {").increaseIndentation().newLine();
                    }
                    it.append((CharSequence)methSpec.name());
                    it.append((CharSequence)"(occurrence, callbacks);");
                    if (!hasTypeParameters) continue;
                    it.decreaseIndentation().newLine();
                    it.append((CharSequence)"}");
                }
                it.decreaseIndentation().newLine();
                it.append((CharSequence)"}");
            }
        }));
    }

    static {
        EQUALITY_TEST_TYPES.add(Boolean.TYPE);
        EQUALITY_TEST_TYPES.add(Boolean.class);
        EQUALITY_TEST_TYPES.add(Integer.TYPE);
        EQUALITY_TEST_TYPES.add(Integer.class);
        EQUALITY_TEST_TYPES.add(Character.TYPE);
        EQUALITY_TEST_TYPES.add(Character.class);
        EQUALITY_TEST_TYPES.add(Byte.TYPE);
        EQUALITY_TEST_TYPES.add(Byte.class);
        EQUALITY_TEST_TYPES.add(Short.TYPE);
        EQUALITY_TEST_TYPES.add(Short.class);
        EQUALITY_TEST_TYPES.add(Long.TYPE);
        EQUALITY_TEST_TYPES.add(Long.class);
        EQUALITY_TEST_TYPES.add(Float.TYPE);
        EQUALITY_TEST_TYPES.add(Float.class);
        EQUALITY_TEST_TYPES.add(Double.TYPE);
        EQUALITY_TEST_TYPES.add(Double.class);
        EQUALITY_TEST_TYPES.add(String.class);
        EQUALITY_TEST_TYPES.add(UUID.class);
    }

    protected static class BehaviorUnitDefinitions
    implements Serializable {
        private static final long serialVersionUID = 1382396220935311642L;
        private final Map<JvmTypeReference, BehaviorUnitFunctions> definitions = new TreeMap<JvmTypeReference, BehaviorUnitFunctions>((a, b) -> BehaviorUnitDefinitions.geIdentifier(a).compareTo(BehaviorUnitDefinitions.geIdentifier(b)));

        protected BehaviorUnitDefinitions() {
        }

        private static String geIdentifier(JvmTypeReference type) {
            return type.getType().getQualifiedName();
        }

        public Iterable<JvmTypeReference> getEventTypes() {
            return this.definitions.keySet();
        }

        public BehaviorUnitFunctions getFunctionsFor(JvmTypeReference type) {
            return this.definitions.computeIfAbsent(type, key -> new BehaviorUnitFunctions(type.getType()));
        }

        public Iterable<BehaviorUnitFunctions> getFunctions() {
            return this.definitions.values();
        }
    }

    protected static class BehaviorUnitFunctions
    implements Serializable {
        private static final long serialVersionUID = 8379370500334485114L;
        private final JvmType eventType;
        private final Map<String, List<JvmTypeReference>> functions = new TreeMap<String, List<JvmTypeReference>>();

        BehaviorUnitFunctions(JvmType eventType) {
            this.eventType = eventType;
        }

        public void registerFunction(String name, List<JvmTypeReference> typeParameterBounds) {
            this.functions.put(name, typeParameterBounds);
        }

        public JvmType getEventType() {
            return this.eventType;
        }

        public Iterable<BehaviorUnitFunction> getFunctions() {
            return this.functions.entrySet().stream().map(it -> new BehaviorUnitFunction((String)it.getKey(), (List)it.getValue())).toList();
        }
    }

    protected record BehaviorUnitFunction(String name, List<JvmTypeReference> bounds) {
    }
}

