/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.jvmmodel.fragments;

import com.google.common.base.Strings;
import io.sarl.lang.jvmmodel.fragments.JvmGenericTypeFactory;
import io.sarl.lang.jvmmodel.fragments.JvmGenericTypeProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.TypesFactory;

public class DefaultJvmGenericTypeProvider
implements JvmGenericTypeFactory,
JvmGenericTypeProvider {
    private final Map<Integer, JvmGenericType> createdTypes = new HashMap<Integer, JvmGenericType>();
    private final TypesFactory jvmTypesFactory;

    public DefaultJvmGenericTypeProvider(TypesFactory jvmTypesFactory) {
        this.jvmTypesFactory = jvmTypesFactory;
    }

    @Override
    public JvmGenericTypeFactory createReceiver(int index, String name) {
        assert (index >= 0 && !Strings.isNullOrEmpty((String)name));
        this.createdTypes.computeIfAbsent(index, it -> {
            JvmGenericType type = this.jvmTypesFactory.createJvmGenericType();
            type.setSimpleName(name);
            return type;
        });
        return this;
    }

    @Override
    public JvmGenericType getGenericType(int index) {
        assert (index >= 0);
        JvmGenericType type = this.createdTypes.get(index);
        assert (type != null);
        return type;
    }

    public Stream<JvmGenericType> stream() {
        return this.createdTypes.values().stream();
    }

    public boolean hasGeneratedType() {
        return !this.createdTypes.isEmpty();
    }
}

