/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.jvmmodel.fragments.aop.impl;

import com.google.common.base.Strings;
import io.sarl.lang.core.Agent;
import io.sarl.lang.jvmmodel.GenerationContext;
import io.sarl.lang.jvmmodel.IBaseJvmModelInferrer;
import io.sarl.lang.jvmmodel.fragments.AbstractJvmModelInferrerTypeFragment;
import io.sarl.lang.jvmmodel.fragments.aop.IAgentInferrerFragment;
import io.sarl.lang.sarl.SarlAction;
import io.sarl.lang.sarl.SarlAgent;
import io.sarl.lang.sarl.SarlBehaviorUnit;
import io.sarl.lang.sarl.SarlCapacityUses;
import io.sarl.lang.sarl.SarlConstructor;
import io.sarl.lang.sarl.SarlField;
import io.sarl.lang.sarl.SarlRequiredCapacity;
import io.sarl.lang.util.Utils;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;

public class AgentInferrerFragment
extends AbstractJvmModelInferrerTypeFragment
implements IAgentInferrerFragment {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transform(SarlAgent source, JvmGenericType inferredJvmType, IBaseJvmModelInferrer baseInferrer) {
        assert (source != null);
        assert (inferredJvmType != null);
        if (Strings.isNullOrEmpty((String)source.getName())) {
            return;
        }
        GenerationContext context = baseInferrer.openContext((EObject)source, (JvmDeclaredType)inferredJvmType, Arrays.asList(SarlField.class, SarlConstructor.class, SarlAction.class, SarlBehaviorUnit.class, SarlCapacityUses.class, SarlRequiredCapacity.class));
        try {
            Utils.populateInheritanceContext((JvmDeclaredType)inferredJvmType, (JvmTypeReference)source.getExtends(), null, context.getInheritedFinalOperations(), context.getInheritedOverridableOperations(), null, context.getInheritedOperationsToImplement(), null, this.sarlSignatureProvider);
            this.jvmTypeBuilder.copyDocumentationTo((EObject)source, (JvmIdentifiableElement)inferredJvmType);
            inferredJvmType.setStatic(false);
            inferredJvmType.setStrictFloatingPoint(false);
            this.setVisibility((JvmMember)inferredJvmType, (XtendMember)source);
            boolean isAbstract = source.isAbstract() || Utils.hasAbstractMember(source);
            inferredJvmType.setAbstract(isAbstract);
            inferredJvmType.setFinal(!isAbstract && source.isFinal());
            baseInferrer.translateAnnotationsTo((List<XAnnotation>)source.getAnnotations(), (JvmAnnotationTarget)inferredJvmType);
            this.appendConstrainedExtends(baseInferrer, context, inferredJvmType, Agent.class, SarlAgent.class, source.getExtends());
            if (Utils.isCompatibleSARLLibraryOnClasspath(this.jvmTypeReferences, (Notifier)source)) {
                this.appendAOPMembers(baseInferrer, inferredJvmType, source, context);
            }
            context.setInjectable(inferredJvmType.getExtendedClass());
            this.appendComparisonFunctions(baseInferrer, context, source, inferredJvmType);
            this.appendCloneFunctionIfCloneable(baseInferrer, context, source, inferredJvmType);
            this.appendDefaultConstructors(baseInferrer, source, inferredJvmType);
            this.appendSerialNumberIfSerializable(baseInferrer, context, source, inferredJvmType);
            this.appendSARLSpecificationVersion(baseInferrer, context, source, (JvmDeclaredType)inferredJvmType);
            this.appendSARLElementType(baseInferrer, source, (JvmDeclaredType)inferredJvmType);
            this.appendInjectableAnnotationIfInjectable(baseInferrer, (JvmDeclaredType)inferredJvmType, context);
            this.appendXbaseGeneratedAnnotation(baseInferrer, (JvmAnnotationTarget)inferredJvmType);
            this.nameClashResolver.resolveNameClashes(inferredJvmType);
        }
        finally {
            baseInferrer.closeContext(context);
        }
    }
}

