/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.jvmmodel.fragments.aop.impl;

import com.google.common.base.Strings;
import io.sarl.lang.jvmmodel.GenerationContext;
import io.sarl.lang.jvmmodel.IBaseJvmModelInferrer;
import io.sarl.lang.jvmmodel.Messages;
import io.sarl.lang.jvmmodel.fragments.AbstractJvmModelInferrerFragment;
import io.sarl.lang.jvmmodel.fragments.aop.IBehaviorUnitInferrerFragment;
import io.sarl.lang.sarl.SarlBehaviorUnit;
import io.sarl.lang.util.Utils;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;

public class BehaviorUnitInferrerFragment
extends AbstractJvmModelInferrerFragment
implements IBehaviorUnitInferrerFragment {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void transform(SarlBehaviorUnit source, JvmGenericType container, IBaseJvmModelInferrer baseInferrer) {
        GenerationContext context = baseInferrer.getContext((JvmIdentifiableElement)container);
        if (source.getName() != null && !Strings.isNullOrEmpty((String)source.getName().getSimpleName()) && context != null) {
            boolean isTrueGuard;
            XExpression guard = source.getGuard();
            if (guard == null) {
                isTrueGuard = true;
            } else if (guard instanceof XBooleanLiteral) {
                XBooleanLiteral literal = (XBooleanLiteral)guard;
                if (!literal.isIsTrue()) return;
                isTrueGuard = true;
            } else {
                isTrueGuard = false;
            }
            JvmTypeReference voidType = baseInferrer.getJvmTypeReferenceBuilder().typeRef(Void.TYPE, new JvmTypeReference[0]);
            String bodyMethodName = Utils.createNameForHiddenEventHandlerMethod(source.getName(), context.getBehaviorUnitIndex());
            JvmOperation bodyOperation = this.jvmTypesFactory.createJvmOperation();
            bodyOperation.setAbstract(false);
            bodyOperation.setNative(false);
            bodyOperation.setSynchronized(false);
            bodyOperation.setStrictFloatingPoint(false);
            bodyOperation.setFinal(false);
            bodyOperation.setVisibility(JvmVisibility.PRIVATE);
            bodyOperation.setStatic(false);
            bodyOperation.setSimpleName(bodyMethodName);
            bodyOperation.setReturnType(voidType);
            container.getMembers().add((Object)bodyOperation);
            this.associator.associatePrimary((EObject)source, (EObject)bodyOperation);
            JvmFormalParameter jvmParam = this.jvmTypesFactory.createJvmFormalParameter();
            jvmParam.setName(this.grammarKeywordAccess.getOccurrenceKeyword());
            jvmParam.setParameterType(this.jvmTypeBuilder.cloneWithProxies((JvmTypeReference)source.getName()));
            this.associator.associate((EObject)source, (EObject)jvmParam);
            bodyOperation.getParameters().add((Object)jvmParam);
            this.setBody(baseInferrer, (JvmExecutable)bodyOperation, source.getExpression());
            baseInferrer.translateAnnotationsTo((List<XAnnotation>)source.getAnnotations(), (JvmAnnotationTarget)bodyOperation);
            if (context.getGeneratorConfig2().isGeneratePureAnnotation() && !this.services.getExpressionHelper().hasSideEffects(source.getExpression())) {
                this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)bodyOperation, Pure.class, new String[0]);
            }
            Collection<Procedures.Procedure1<? super ITreeAppendable>> evaluators = context.ensureGuardEvaluationCodeFor(source, this.jvmTypeReferences);
            assert (evaluators != null);
            if (isTrueGuard) {
                evaluators.add((Procedures.Procedure1<? super ITreeAppendable>)((Procedures.Procedure1)it -> {
                    it.append((CharSequence)RUNNABLE_COLLECTION);
                    it.append((CharSequence)".add(() -> ");
                    it.append((CharSequence)bodyMethodName);
                    it.append((CharSequence)"(");
                    it.append((CharSequence)this.grammarKeywordAccess.getOccurrenceKeyword());
                    it.append((CharSequence)"));");
                }));
            } else {
                assert (guard != null);
                String guardMethodName = Utils.createNameForHiddenGuardEvaluatorMethod(source.getName(), context.getBehaviorUnitIndex());
                JvmOperation guardOperation = this.jvmTypesFactory.createJvmOperation();
                guardOperation.setAbstract(false);
                guardOperation.setNative(false);
                guardOperation.setSynchronized(false);
                guardOperation.setStrictFloatingPoint(false);
                guardOperation.setFinal(false);
                guardOperation.setVisibility(JvmVisibility.PRIVATE);
                guardOperation.setStatic(false);
                guardOperation.setSimpleName(guardMethodName);
                guardOperation.setReturnType(baseInferrer.getJvmTypeReferenceBuilder().typeRef(Boolean.TYPE, new JvmTypeReference[0]));
                container.getMembers().add((Object)guardOperation);
                this.associator.associate((EObject)source, (EObject)guardOperation);
                this.associator.associatePrimary((EObject)guard, (EObject)guardOperation);
                jvmParam = this.jvmTypesFactory.createJvmFormalParameter();
                jvmParam.setName(this.grammarKeywordAccess.getItKeyword());
                jvmParam.setParameterType(this.jvmTypeBuilder.cloneWithProxies((JvmTypeReference)source.getName()));
                this.associator.associate((EObject)source, (EObject)jvmParam);
                guardOperation.getParameters().add((Object)jvmParam);
                jvmParam = this.jvmTypesFactory.createJvmFormalParameter();
                jvmParam.setName(this.grammarKeywordAccess.getOccurrenceKeyword());
                jvmParam.setParameterType(this.jvmTypeBuilder.cloneWithProxies((JvmTypeReference)source.getName()));
                this.associator.associate((EObject)source, (EObject)jvmParam);
                guardOperation.getParameters().add((Object)jvmParam);
                this.setBody(baseInferrer, (JvmExecutable)guardOperation, guard);
                if (context.getGeneratorConfig2().isGeneratePureAnnotation()) {
                    this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)guardOperation, Pure.class, new String[0]);
                }
                evaluators.add((Procedures.Procedure1<? super ITreeAppendable>)((Procedures.Procedure1)it -> {
                    it.append((CharSequence)"if (");
                    it.append((CharSequence)guardMethodName);
                    it.append((CharSequence)"(");
                    it.append((CharSequence)this.grammarKeywordAccess.getOccurrenceKeyword());
                    it.append((CharSequence)", ");
                    it.append((CharSequence)this.grammarKeywordAccess.getOccurrenceKeyword());
                    it.append((CharSequence)")) {");
                    it.increaseIndentation();
                    it.newLine();
                    it.append((CharSequence)RUNNABLE_COLLECTION);
                    it.append((CharSequence)".add(() -> ");
                    it.append((CharSequence)bodyMethodName);
                    it.append((CharSequence)"(");
                    it.append((CharSequence)this.grammarKeywordAccess.getOccurrenceKeyword());
                    it.append((CharSequence)"));");
                    it.decreaseIndentation();
                    it.newLine();
                    it.append((CharSequence)"}");
                }));
            }
            context.setBehaviorUnitIndex(context.getBehaviorUnitIndex() + 1);
            context.incrementSerial(bodyMethodName.hashCode());
            return;
        } else {
            baseInferrer.logInternalError(Messages.SARLJvmModelInferrer_10);
        }
    }
}

