/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.jvmmodel.fragments.aop.impl;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import io.sarl.lang.core.AgentTrait;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.jvmmodel.GenerationContext;
import io.sarl.lang.jvmmodel.IBaseJvmModelInferrer;
import io.sarl.lang.jvmmodel.fragments.AbstractJvmModelInferrerTypeFragment;
import io.sarl.lang.jvmmodel.fragments.aop.ICapacityInferrerFragment;
import io.sarl.lang.sarl.SarlAction;
import io.sarl.lang.sarl.SarlCapacity;
import io.sarl.lang.sarl.actionprototype.ActionPrototype;
import io.sarl.lang.util.Utils;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmUpperBound;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Procedures;

public class CapacityInferrerFragment
extends AbstractJvmModelInferrerTypeFragment
implements ICapacityInferrerFragment {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transform(SarlCapacity source, JvmGenericType inferredJvmType, IBaseJvmModelInferrer baseInferrer) {
        assert (source != null);
        assert (inferredJvmType != null);
        if (Strings.isNullOrEmpty((String)source.getName())) {
            return;
        }
        GenerationContext context = baseInferrer.openContext((EObject)source, (JvmDeclaredType)inferredJvmType, Collections.singleton(SarlAction.class));
        try {
            Utils.populateInheritanceContext((JvmDeclaredType)inferredJvmType, null, source.getExtends(), context.getInheritedFinalOperations(), context.getInheritedOverridableOperations(), null, context.getInheritedOperationsToImplement(), null, this.sarlSignatureProvider);
            this.jvmTypeBuilder.copyDocumentationTo((EObject)source, (JvmIdentifiableElement)inferredJvmType);
            inferredJvmType.setInterface(true);
            inferredJvmType.setAbstract(true);
            this.setVisibility((JvmMember)inferredJvmType, (XtendMember)source);
            inferredJvmType.setStatic(false);
            inferredJvmType.setStrictFloatingPoint(false);
            inferredJvmType.setFinal(false);
            baseInferrer.translateAnnotationsTo((List<XAnnotation>)source.getAnnotations(), (JvmAnnotationTarget)inferredJvmType);
            this.appendConstrainedExtends(baseInferrer, context, inferredJvmType, (Class<?>)Capacity.class, (Class<? extends XtendTypeDeclaration>)SarlCapacity.class, (List<? extends JvmParameterizedTypeReference>)source.getExtends());
            if (Utils.isCompatibleSARLLibraryOnClasspath(this.jvmTypeReferences, (Notifier)source)) {
                this.appendAOPMembers(baseInferrer, inferredJvmType, source, context);
            }
            this.appendFunctionalInterfaceAnnotation(baseInferrer, inferredJvmType);
            this.appendSARLSpecificationVersion(baseInferrer, context, source, (JvmDeclaredType)inferredJvmType);
            this.appendSARLElementType(baseInferrer, source, (JvmDeclaredType)inferredJvmType);
            this.appendInjectableAnnotationIfInjectable(baseInferrer, (JvmDeclaredType)inferredJvmType, context);
            this.appendXbaseGeneratedAnnotation(baseInferrer, (JvmAnnotationTarget)inferredJvmType);
            this.nameClashResolver.resolveNameClashes(inferredJvmType);
        }
        finally {
            baseInferrer.closeContext(context);
        }
        this.appendCapacityContextAwareWrapper(baseInferrer, source, inferredJvmType);
    }

    private void appendCapacityContextAwareWrapper(IBaseJvmModelInferrer baseInferrer, SarlCapacity source, JvmGenericType inferredJvmType) {
        JvmGenericType innerType = this.jvmTypesFactory.createJvmGenericType();
        innerType.setInterface(false);
        innerType.setAbstract(false);
        innerType.setVisibility(JvmVisibility.PUBLIC);
        innerType.setStatic(true);
        innerType.setStrictFloatingPoint(false);
        innerType.setFinal(false);
        String innerTypeName = Capacity.ContextAwareCapacityWrapper.class.getSimpleName();
        innerType.setSimpleName(innerTypeName);
        inferredJvmType.getMembers().add((Object)innerType);
        this.jvmTypeBuilder.setDocumentation((JvmIdentifiableElement)innerType, "@ExcludeFromApidoc");
        JvmTypeParameter typeParameter = this.jvmTypesFactory.createJvmTypeParameter();
        typeParameter.setName("C");
        JvmUpperBound constraint = this.jvmTypesFactory.createJvmUpperBound();
        constraint.setTypeReference(baseInferrer.getJvmTypeReferenceBuilder().typeRef((JvmType)inferredJvmType, new JvmTypeReference[0]));
        typeParameter.getConstraints().add((Object)constraint);
        innerType.getTypeParameters().add((Object)typeParameter);
        Iterator extendedTypeIterator = inferredJvmType.getExtendedInterfaces().iterator();
        if (extendedTypeIterator.hasNext()) {
            JvmTypeReference extendedType = (JvmTypeReference)extendedTypeIterator.next();
            JvmTypeReference superType = baseInferrer.getJvmTypeReferenceBuilder().typeRef(extendedType.getQualifiedName() + "$" + innerTypeName, new JvmTypeReference[]{baseInferrer.getJvmTypeReferenceBuilder().typeRef((JvmType)typeParameter, new JvmTypeReference[0])});
            innerType.getSuperTypes().add((Object)superType);
        }
        innerType.getSuperTypes().add((Object)baseInferrer.getJvmTypeReferenceBuilder().typeRef((JvmType)inferredJvmType, new JvmTypeReference[0]));
        JvmConstructor constructor = this.jvmTypesFactory.createJvmConstructor();
        constructor.setVisibility(JvmVisibility.PUBLIC);
        innerType.getMembers().add((Object)constructor);
        JvmFormalParameter parameter1 = this.jvmTypesFactory.createJvmFormalParameter();
        parameter1.setName("capacity");
        parameter1.setParameterType(baseInferrer.getJvmTypeReferenceBuilder().typeRef((JvmType)typeParameter, new JvmTypeReference[0]));
        constructor.getParameters().add((Object)parameter1);
        JvmFormalParameter parameter2 = this.jvmTypesFactory.createJvmFormalParameter();
        parameter2.setName("caller");
        parameter2.setParameterType(baseInferrer.getJvmTypeReferenceBuilder().typeRef(AgentTrait.class, new JvmTypeReference[0]));
        constructor.getParameters().add((Object)parameter2);
        this.setBody((JvmExecutable)constructor, (Procedures.Procedure1<ITreeAppendable>)((Procedures.Procedure1)it -> it.append((CharSequence)"super(capacity, caller);")));
        TreeSet<ActionPrototype> createdActions = new TreeSet<ActionPrototype>();
        for (JvmGenericType sourceType : Iterables.concat(Collections.singletonList(inferredJvmType), (Iterable)Iterables.transform((Iterable)Iterables.skip((Iterable)inferredJvmType.getExtendedInterfaces(), (int)1), it -> (JvmGenericType)it.getType()))) {
            this.copyNonStaticPublicJvmOperations(baseInferrer, sourceType, innerType, createdActions, false, (Procedures.Procedure2<? super JvmOperation, ? super ITreeAppendable>)((Procedures.Procedure2)(operation, it) -> {
                it.append((CharSequence)"try {");
                it.newLine();
                it.append((CharSequence)"  ensureCallerInLocalThread();");
                it.newLine();
                it.append((CharSequence)"  ");
                if (operation.getReturnType() != null && !Objects.equal((Object)"void", (Object)operation.getReturnType().getIdentifier())) {
                    it.append((CharSequence)"return ");
                }
                it.append((CharSequence)"this.capacity.");
                it.append((CharSequence)operation.getSimpleName());
                it.append((CharSequence)"(");
                boolean first = true;
                for (JvmFormalParameter fparam : operation.getParameters()) {
                    if (first) {
                        first = false;
                    } else {
                        it.append((CharSequence)", ");
                    }
                    it.append((CharSequence)fparam.getName());
                }
                it.append((CharSequence)");");
                it.newLine();
                it.append((CharSequence)"} finally {");
                it.newLine();
                it.append((CharSequence)"  resetCallerInLocalThread();");
                it.newLine();
                it.append((CharSequence)"}");
            }));
        }
    }
}

