/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.jvmmodel.fragments.aop.impl;

import com.google.common.base.Strings;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.annotation.SyntheticEventConstructor;
import io.sarl.lang.core.annotation.SyntheticEventConstructorMandatoryParameter;
import io.sarl.lang.jvmmodel.GenerationContext;
import io.sarl.lang.jvmmodel.IBaseJvmModelInferrer;
import io.sarl.lang.jvmmodel.Messages;
import io.sarl.lang.jvmmodel.fragments.AbstractJvmModelInferrerTypeFragment;
import io.sarl.lang.jvmmodel.fragments.aop.IEventInferrerFragment;
import io.sarl.lang.sarl.SarlConstructor;
import io.sarl.lang.sarl.SarlEvent;
import io.sarl.lang.sarl.SarlField;
import io.sarl.lang.sarl.actionprototype.ActionParameterTypes;
import io.sarl.lang.sarl.actionprototype.FormalParameterProvider;
import io.sarl.lang.sarl.actionprototype.InferredStandardParameter;
import io.sarl.lang.sarl.actionprototype.InferredValuedParameter;
import io.sarl.lang.util.Utils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.xtend.XtendField;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class EventInferrerFragment
extends AbstractJvmModelInferrerTypeFragment
implements IEventInferrerFragment {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transform(SarlEvent source, JvmGenericType inferredJvmType, IBaseJvmModelInferrer baseInferrer) {
        assert (source != null);
        assert (inferredJvmType != null);
        if (Strings.isNullOrEmpty((String)source.getName())) {
            return;
        }
        GenerationContext context = baseInferrer.openContext((EObject)source, (JvmDeclaredType)inferredJvmType, Arrays.asList(SarlField.class, SarlConstructor.class));
        try {
            Utils.populateInheritanceContext((JvmDeclaredType)inferredJvmType, (JvmTypeReference)source.getExtends(), null, context.getInheritedFinalOperations(), context.getInheritedOverridableOperations(), null, context.getInheritedOperationsToImplement(), null, this.sarlSignatureProvider);
            this.jvmTypeBuilder.copyDocumentationTo((EObject)source, (JvmIdentifiableElement)inferredJvmType);
            this.setVisibility((JvmMember)inferredJvmType, (XtendMember)source);
            inferredJvmType.setStatic(false);
            boolean isAbstract = source.isAbstract() || Utils.hasAbstractMember(source);
            inferredJvmType.setAbstract(isAbstract);
            inferredJvmType.setStrictFloatingPoint(false);
            inferredJvmType.setFinal(!isAbstract && source.isFinal());
            baseInferrer.translateAnnotationsTo((List<XAnnotation>)source.getAnnotations(), (JvmAnnotationTarget)inferredJvmType);
            this.appendConstrainedExtends(baseInferrer, context, inferredJvmType, Event.class, SarlEvent.class, source.getExtends());
            baseInferrer.fixTypeParameters((JvmTypeParameterDeclarator)inferredJvmType);
            if (Utils.isCompatibleSARLLibraryOnClasspath(this.jvmTypeReferences, (Notifier)source)) {
                this.appendAOPMembers(baseInferrer, inferredJvmType, source, context);
            }
            if (!source.getTypeParameters().isEmpty()) {
                JvmOperation typeBoundMatchOperation = this.jvmTypesFactory.createJvmOperation();
                typeBoundMatchOperation.setAbstract(false);
                typeBoundMatchOperation.setNative(false);
                typeBoundMatchOperation.setSynchronized(false);
                typeBoundMatchOperation.setStrictFloatingPoint(false);
                typeBoundMatchOperation.setFinal(false);
                typeBoundMatchOperation.setVisibility(JvmVisibility.PUBLIC);
                typeBoundMatchOperation.setStatic(true);
                typeBoundMatchOperation.setSimpleName("$matchesTypeBounds");
                typeBoundMatchOperation.setReturnType(baseInferrer.getJvmTypeReferenceBuilder().typeRef(Boolean.TYPE, new JvmTypeReference[0]));
                inferredJvmType.getMembers().add((Object)typeBoundMatchOperation);
                this.associator.associate((EObject)source, (EObject)typeBoundMatchOperation);
                JvmFormalParameter jvmParam = this.jvmTypesFactory.createJvmFormalParameter();
                jvmParam.setName(this.grammarKeywordAccess.getItKeyword());
                jvmParam.setParameterType((JvmTypeReference)this.jvmTypeReferences.createTypeRef((JvmType)inferredJvmType, new JvmTypeReference[0]));
                this.associator.associate((EObject)source, (EObject)jvmParam);
                typeBoundMatchOperation.getParameters().add((Object)jvmParam);
                jvmParam = this.jvmTypesFactory.createJvmFormalParameter();
                jvmParam.setName("bounds");
                jvmParam.setParameterType((JvmTypeReference)this.jvmTypeReferences.createArrayType(this.jvmTypeReferences.getTypeForName(Class.class, (Notifier)source, new JvmTypeReference[0])));
                this.associator.associate((EObject)source, (EObject)jvmParam);
                typeBoundMatchOperation.getParameters().add((Object)jvmParam);
                typeBoundMatchOperation.setVarArgs(true);
                List<XtendField> declaredFields = source.getMembers().stream().filter(it0 -> it0 instanceof XtendField).map(it0 -> (XtendField)it0).toList();
                this.setBody((JvmExecutable)typeBoundMatchOperation, (Procedures.Procedure1<ITreeAppendable>)((Procedures.Procedure1)it -> {
                    it.append((CharSequence)"if (bounds != null && bounds.length == ");
                    it.append((CharSequence)Integer.toString(source.getTypeParameters().size()));
                    it.append((CharSequence)") {").increaseIndentation();
                    int i = 0;
                    for (JvmTypeParameter parameter : source.getTypeParameters()) {
                        List<XtendField> matchableFields = declaredFields.stream().filter(it0 -> it0.getType().getIdentifier().equals(parameter.getIdentifier())).toList();
                        if (!matchableFields.isEmpty()) {
                            it.newLine().append((CharSequence)"if (");
                            boolean first = true;
                            for (XtendField matchField : matchableFields) {
                                if (first) {
                                    first = false;
                                } else {
                                    it.append((CharSequence)" || ");
                                }
                                it.append((CharSequence)"(it.").append((CharSequence)matchField.getName()).append((CharSequence)" != null && !bounds[");
                                it.append((CharSequence)Integer.toString(i)).append((CharSequence)"].isInstance(it.");
                                it.append((CharSequence)matchField.getName()).append((CharSequence)"))");
                            }
                            it.append((CharSequence)") {").increaseIndentation().newLine();
                            it.append((CharSequence)"return false;").decreaseIndentation().newLine();
                            it.append((CharSequence)"}");
                        }
                        ++i;
                    }
                    it.newLine().append((CharSequence)"return true;");
                    it.decreaseIndentation().newLine().append((CharSequence)"}").newLine();
                    it.append((CharSequence)"return false;");
                }));
                this.appendGeneratedAnnotation(baseInferrer, (JvmAnnotationTarget)typeBoundMatchOperation, context);
                this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)typeBoundMatchOperation, Pure.class, new String[0]);
            }
            if (!context.hasConstructor()) {
                this.generateSyntheticConstructorForFields(context, source, inferredJvmType, baseInferrer);
            }
            context.setInjectable(inferredJvmType.getExtendedClass());
            this.appendDefaultConstructors(baseInferrer, source, inferredJvmType);
            this.appendComparisonFunctions(baseInferrer, context, source, inferredJvmType);
            this.appendToStringFunctions(baseInferrer, context, source, inferredJvmType);
            this.appendCloneFunctionIfCloneable(baseInferrer, context, source, inferredJvmType);
            this.appendSerialNumberIfSerializable(baseInferrer, context, source, inferredJvmType);
            this.appendSARLSpecificationVersion(baseInferrer, context, source, (JvmDeclaredType)inferredJvmType);
            this.appendSARLElementType(baseInferrer, source, (JvmDeclaredType)inferredJvmType);
            this.appendInjectableAnnotationIfInjectable(baseInferrer, (JvmDeclaredType)inferredJvmType, context);
            this.appendXbaseGeneratedAnnotation(baseInferrer, (JvmAnnotationTarget)inferredJvmType);
            this.nameClashResolver.resolveNameClashes(inferredJvmType);
        }
        finally {
            baseInferrer.closeContext(context);
        }
    }

    private static boolean isAppendToStringFunctionsEnable(GenerationContext context) {
        return context.getGeneratorConfig2().isGenerateToStringFunctions();
    }

    private void appendToStringFunctions(IBaseJvmModelInferrer baseInferrer, GenerationContext context, XtendTypeDeclaration source, JvmGenericType target) {
        JvmTypeReference voidType;
        JvmOperation op;
        if (!EventInferrerFragment.isAppendToStringFunctionsEnable(context)) {
            return;
        }
        ArrayList<JvmField> declaredInstanceFields = new ArrayList<JvmField>();
        for (JvmField field : target.getDeclaredFields()) {
            if (field.isStatic()) continue;
            declaredInstanceFields.add(field);
        }
        if (!declaredInstanceFields.isEmpty() && (op = this.jvmTypeBuilder.toMethod((EObject)source, "toString", voidType = baseInferrer.getJvmTypeReferenceBuilder().typeRef(Void.TYPE, new JvmTypeReference[0]), it2 -> {
            it2.setVisibility(JvmVisibility.PROTECTED);
            this.jvmTypeBuilder.setDocumentation((JvmIdentifiableElement)it2, MessageFormat.format(Messages.SARLJvmModelInferrer_2, target.getSimpleName()));
            JvmFormalParameter param = this.jvmTypesFactory.createJvmFormalParameter();
            param.setName("builder");
            param.setParameterType(baseInferrer.getJvmTypeReferenceBuilder().typeRef(ToStringBuilder.class, new JvmTypeReference[0]));
            it2.getParameters().add((Object)param);
            this.setBody((JvmExecutable)it2, (Procedures.Procedure1<ITreeAppendable>)((Procedures.Procedure1)it3 -> {
                it3.append((CharSequence)"super.toString(builder);");
                for (JvmField attr : declaredInstanceFields) {
                    it3.newLine();
                    it3.append((CharSequence)("builder.add(\"" + attr.getSimpleName() + "\", this." + attr.getSimpleName() + ");"));
                }
            }));
        })) != null) {
            this.appendGeneratedAnnotation(baseInferrer, (JvmAnnotationTarget)op, context);
            if (context.getGeneratorConfig2().isGeneratePureAnnotation()) {
                this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)op, Pure.class, new String[0]);
            }
            target.getMembers().add((Object)op);
        }
    }

    private void generateSyntheticConstructorForFields(GenerationContext context, SarlEvent source, JvmGenericType container, IBaseJvmModelInferrer baseInferrer) {
        JvmType superType;
        JvmTypeReference extendedClass = container.getExtendedClass();
        if (extendedClass != null && (superType = extendedClass.getType()) instanceof JvmGenericType) {
            JvmGenericType superGenericType = (JvmGenericType)superType;
            SyntheticConstructorGenerator generator = null;
            if (superGenericType.getQualifiedName().equals(Event.class.getName())) {
                List<XtendField> declaredFields = EventInferrerFragment.extractDeclaredFields(source);
                if (!declaredFields.isEmpty()) {
                    generator = new FieldBasedGenerator(declaredFields);
                }
            } else {
                Iterable<JvmConstructor> inheritedConstructors = this.extractInheritedConstructors(superGenericType, container);
                if (inheritedConstructors != null) {
                    List<XtendField> declaredFields = EventInferrerFragment.extractDeclaredFields(source);
                    boolean hasLocalField = !declaredFields.isEmpty();
                    boolean hasInheritedConstructor = inheritedConstructors.iterator().hasNext();
                    if (hasLocalField && hasInheritedConstructor) {
                        generator = new InheritedConstructorFieldBasedGenerator(inheritedConstructors, declaredFields);
                    } else if (hasLocalField) {
                        generator = new FieldBasedGenerator(declaredFields);
                    }
                }
            }
            if (generator != null) {
                generator.generate(context, source, container, baseInferrer);
            }
        }
    }

    protected static List<XtendField> extractDeclaredFields(SarlEvent event) {
        return event.getMembers().stream().filter(it0 -> it0 instanceof XtendField).map(it0 -> (XtendField)it0).filter(it0 -> !it0.isStatic() && (!it0.isFinal() || it0.getInitialValue() == null)).toList();
    }

    protected Iterable<JvmConstructor> extractInheritedConstructors(JvmGenericType superGenericType, JvmGenericType container) {
        ArrayList<JvmConstructor> constructors = new ArrayList<JvmConstructor>();
        boolean foundNotSyntheticConstructor = false;
        boolean foundDefaultConstructor = false;
        for (JvmConstructor constructor : this.getVisibleInheritedJvmConstructors(superGenericType, container)) {
            if (constructor.getParameters().isEmpty()) {
                foundDefaultConstructor = true;
            }
            if (this.annotationUtils.findAnnotation((JvmAnnotationTarget)constructor, SyntheticEventConstructor.class.getName()) == null) {
                foundNotSyntheticConstructor = true;
                continue;
            }
            constructors.add(constructor);
        }
        if (foundNotSyntheticConstructor && !foundDefaultConstructor) {
            return null;
        }
        return constructors;
    }

    private class FieldBasedGenerator
    extends SyntheticConstructorGenerator {
        private final List<XtendField> fields;

        FieldBasedGenerator(List<XtendField> fields) {
            this.fields = fields;
        }

        @Override
        public int getFormalParameterCount() {
            return this.fields.size();
        }

        @Override
        public String getFormalParameterName(int position) {
            return this.fields.get(position).getName();
        }

        @Override
        public String getFormalParameterType(int position, boolean isVarargs) {
            return this.fields.get(position).getType().getQualifiedName();
        }

        @Override
        public JvmTypeReference getFormalParameterTypeReference(int position, boolean isVarargs) {
            return this.fields.get(position).getType();
        }

        @Override
        public boolean hasFormalParameterDefaultValue(int position) {
            return !this.fields.get(position).isFinal();
        }

        @Override
        public EObject getFormalParameter(int position) {
            return (EObject)this.fields.get(position);
        }

        @Override
        protected Stream<SyntheticConstructorGenerator.GeneratedSyntheticConstructor> getConstructors(JvmGenericType container) {
            Map<ActionParameterTypes, List<InferredStandardParameter>> signatures = EventInferrerFragment.this.sarlSignatureProvider.buildSignatures((JvmIdentifiableElement)container, this);
            return signatures.entrySet().stream().map(signature -> {
                ArrayList<SyntheticConstructorGenerator.GeneratedSyntheticFormalParameter> parameters = new ArrayList<SyntheticConstructorGenerator.GeneratedSyntheticFormalParameter>(((List)signature.getValue()).size());
                ArrayList<String> names = new ArrayList<String>();
                for (InferredStandardParameter parameter : (List)signature.getValue()) {
                    if (parameter instanceof InferredValuedParameter) continue;
                    EObject eobj = parameter.getParameter();
                    SyntheticConstructorGenerator.GeneratedSyntheticFormalParameter syntheticParameter = new SyntheticConstructorGenerator.GeneratedSyntheticFormalParameter(parameter.getName(), parameter.getType(), eobj, this.isForFinalField(eobj));
                    names.add(syntheticParameter.name());
                    parameters.add(syntheticParameter);
                }
                return new SyntheticConstructorGenerator.GeneratedSyntheticConstructor((ActionParameterTypes)signature.getKey(), parameters, (Procedures.Procedure1<ITreeAppendable>)((Procedures.Procedure1)receiver -> {
                    receiver.append((CharSequence)"super();");
                    for (String name : names) {
                        receiver.newLine().append((CharSequence)"this.").append((CharSequence)name).append((CharSequence)" = ").append((CharSequence)name).append((CharSequence)";");
                    }
                }));
            });
        }
    }

    private class InheritedConstructorFieldBasedGenerator
    extends SyntheticConstructorGenerator {
        private final List<SyntheticConstructorGenerator.GeneratedSyntheticFormalParameter> parameters;

        InheritedConstructorFieldBasedGenerator(Iterable<JvmConstructor> inheritedConstructors, List<XtendField> fields) {
            this.parameters = new ArrayList<SyntheticConstructorGenerator.GeneratedSyntheticFormalParameter>();
            TreeSet<String> defined = new TreeSet<String>();
            for (XtendField field : fields) {
                if (!defined.add(field.getName())) continue;
                LightweightTypeReference type = Utils.toLightweightTypeReference(field.getType(), EventInferrerFragment.this.services, field.eResource().getResourceSet());
                SyntheticConstructorGenerator.GeneratedSyntheticFormalParameter syntheticParam = new SyntheticConstructorGenerator.GeneratedSyntheticFormalParameter(field.getName(), type, (EObject)field, field.isFinal());
                this.parameters.addLast(syntheticParam);
            }
            ArrayList<JvmFormalParameter> params = new ArrayList<JvmFormalParameter>();
            for (JvmConstructor inheritedConstructor : inheritedConstructors) {
                for (JvmFormalParameter parameter : inheritedConstructor.getParameters()) {
                    if (!defined.add(parameter.getName())) continue;
                    params.add(parameter);
                }
            }
            for (JvmFormalParameter param : params) {
                LightweightTypeReference type = Utils.toLightweightTypeReference(param.getParameterType(), EventInferrerFragment.this.services, param.eResource().getResourceSet());
                SyntheticConstructorGenerator.GeneratedSyntheticFormalParameter syntheticParam = new SyntheticConstructorGenerator.GeneratedSyntheticFormalParameter(param.getName(), type, (EObject)param, this.isForFinalField((EObject)param));
                this.parameters.addFirst(syntheticParam);
            }
        }

        @Override
        public int getFormalParameterCount() {
            return this.parameters.size();
        }

        @Override
        public String getFormalParameterName(int position) {
            return this.parameters.get((int)position).name;
        }

        @Override
        public String getFormalParameterType(int position, boolean isVarargs) {
            return this.parameters.get((int)position).type.getIdentifier();
        }

        @Override
        public JvmTypeReference getFormalParameterTypeReference(int position, boolean isVarargs) {
            return this.parameters.get((int)position).type.toJavaCompliantTypeReference();
        }

        @Override
        public boolean hasFormalParameterDefaultValue(int position) {
            return !this.parameters.get((int)position).isFinal;
        }

        @Override
        public EObject getFormalParameter(int position) {
            return this.parameters.get((int)position).source;
        }

        @Override
        protected Stream<SyntheticConstructorGenerator.GeneratedSyntheticConstructor> getConstructors(JvmGenericType container) {
            Map<ActionParameterTypes, List<InferredStandardParameter>> signatures = EventInferrerFragment.this.sarlSignatureProvider.buildSignatures((JvmIdentifiableElement)container, this);
            return signatures.entrySet().stream().map(signature -> {
                ArrayList<SyntheticConstructorGenerator.GeneratedSyntheticFormalParameter> parameters = new ArrayList<SyntheticConstructorGenerator.GeneratedSyntheticFormalParameter>(((List)signature.getValue()).size());
                ArrayList<String> inheritedNames = new ArrayList<String>();
                ArrayList<String> localNames = new ArrayList<String>();
                for (InferredStandardParameter parameter : (List)signature.getValue()) {
                    if (parameter instanceof InferredValuedParameter) continue;
                    SyntheticConstructorGenerator.GeneratedSyntheticFormalParameter syntheticParameter = new SyntheticConstructorGenerator.GeneratedSyntheticFormalParameter(parameter.getName(), parameter.getType(), parameter.getParameter(), this.isForFinalField(parameter.getParameter()));
                    if (parameter.getParameter() instanceof XtendField) {
                        localNames.add(syntheticParameter.name());
                    } else {
                        inheritedNames.add(syntheticParameter.name());
                    }
                    parameters.add(syntheticParameter);
                }
                return new SyntheticConstructorGenerator.GeneratedSyntheticConstructor((ActionParameterTypes)signature.getKey(), parameters, (Procedures.Procedure1<ITreeAppendable>)((Procedures.Procedure1)receiver -> {
                    receiver.append((CharSequence)"super(");
                    boolean first = true;
                    for (String name : inheritedNames) {
                        if (first) {
                            first = false;
                        } else {
                            receiver.append((CharSequence)", ");
                        }
                        receiver.append((CharSequence)name);
                    }
                    receiver.append((CharSequence)");");
                    for (String name : localNames) {
                        receiver.newLine().append((CharSequence)"this.").append((CharSequence)name).append((CharSequence)" = ").append((CharSequence)name).append((CharSequence)";");
                    }
                }));
            });
        }
    }

    private abstract class SyntheticConstructorGenerator
    implements FormalParameterProvider {
        private SyntheticConstructorGenerator() {
        }

        @Override
        public final XExpression getFormalParameterDefaultValue(int position) {
            return null;
        }

        @Override
        public final String getFormalParameterDefaultValueString(int position) {
            return "";
        }

        protected abstract Stream<GeneratedSyntheticConstructor> getConstructors(JvmGenericType var1);

        public void generate(GenerationContext context, SarlEvent source, JvmGenericType container, IBaseJvmModelInferrer baseInferrer) {
            this.getConstructors(container).forEach(constructor -> {
                JvmConstructor jvmConstructor = EventInferrerFragment.this.jvmTypesFactory.createJvmConstructor();
                container.getMembers().add((Object)jvmConstructor);
                String constructorName = container.getSimpleName();
                jvmConstructor.setSimpleName(constructorName);
                jvmConstructor.setVisibility(JvmVisibility.PUBLIC);
                jvmConstructor.setVarArgs(false);
                ArrayList<String> names = new ArrayList<String>();
                for (GeneratedSyntheticFormalParameter parameter : constructor.parameters) {
                    JvmFormalParameter formalParameter = EventInferrerFragment.this.jvmTypesFactory.createJvmFormalParameter();
                    jvmConstructor.getParameters().add((Object)formalParameter);
                    formalParameter.setName(parameter.name());
                    LightweightTypeReference originalType = parameter.type();
                    JvmTypeReference jType = originalType.toJavaCompliantTypeReference();
                    JvmTypeReference paramType = EventInferrerFragment.this.cloneWithProxiesFromOtherResource(jType, (JvmExecutable)jvmConstructor, baseInferrer);
                    formalParameter.setParameterType(paramType);
                    names.add(formalParameter.getName());
                    if (parameter.isFinal()) {
                        EventInferrerFragment.this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)formalParameter, SyntheticEventConstructorMandatoryParameter.class, new String[0]);
                    }
                    this.markInitialized(parameter, jvmConstructor);
                }
                EventInferrerFragment.this.setBody((JvmExecutable)jvmConstructor, (Procedures.Procedure1<ITreeAppendable>)constructor.body);
                EventInferrerFragment.this.appendGeneratedAnnotation(baseInferrer, (JvmAnnotationTarget)jvmConstructor, context);
                EventInferrerFragment.this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)jvmConstructor, SyntheticEventConstructor.class, new String[0]);
                context.addGeneratedConstructor(constructor.signature(), jvmConstructor);
            });
        }

        private void markInitialized(GeneratedSyntheticFormalParameter parameter, JvmConstructor constructor) {
            EObject source = parameter.source();
            if (source instanceof XtendField) {
                XtendField sfield = (XtendField)source;
                JvmField inferredField = EventInferrerFragment.this.sarlAssociations.getJvmField(sfield);
                if (inferredField != null) {
                    EventInferrerFragment.this.readAndWriteTracking.markInitialized((EObject)inferredField, constructor);
                }
            }
            EventInferrerFragment.this.readAndWriteTracking.markInitialized(source, constructor);
        }

        protected boolean isForFinalField(EObject obj) {
            if (obj instanceof XtendField) {
                XtendField target = (XtendField)obj;
                return target.isFinal();
            }
            if (obj instanceof JvmField) {
                JvmField target = (JvmField)obj;
                return target.isFinal();
            }
            if (obj instanceof JvmFormalParameter) {
                JvmFormalParameter target = (JvmFormalParameter)obj;
                return EventInferrerFragment.this.annotationUtils.findAnnotation((JvmAnnotationTarget)target, SyntheticEventConstructorMandatoryParameter.class.getName()) != null;
            }
            return false;
        }

        protected record GeneratedSyntheticFormalParameter(String name, LightweightTypeReference type, EObject source, boolean isFinal) {
        }

        protected record GeneratedSyntheticConstructor(ActionParameterTypes signature, List<GeneratedSyntheticFormalParameter> parameters, Procedures.Procedure1<ITreeAppendable> body) {
        }
    }
}

