/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.jvmmodel.fragments.oop.impl;

import com.google.common.base.Strings;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.annotation.DefaultValue;
import io.sarl.lang.core.annotation.DefaultValueSource;
import io.sarl.lang.core.annotation.DefaultValueUse;
import io.sarl.lang.core.annotation.EarlyExit;
import io.sarl.lang.core.annotation.FiredEvent;
import io.sarl.lang.jvmmodel.GenerationContext;
import io.sarl.lang.jvmmodel.IBaseJvmModelInferrer;
import io.sarl.lang.jvmmodel.fragments.AbstractJvmModelInferrerExecutableFragment;
import io.sarl.lang.jvmmodel.fragments.oop.IActionInferrerFragment;
import io.sarl.lang.sarl.SarlAction;
import io.sarl.lang.sarl.SarlClass;
import io.sarl.lang.sarl.actionprototype.ActionParameterTypes;
import io.sarl.lang.sarl.actionprototype.ActionPrototype;
import io.sarl.lang.sarl.actionprototype.InferredPrototype;
import io.sarl.lang.sarl.actionprototype.InferredStandardParameter;
import io.sarl.lang.sarl.actionprototype.QualifiedActionName;
import io.sarl.lang.typesystem.IOperationHelper;
import io.sarl.lang.util.Utils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.XtendExecutable;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Inline;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xtype.XComputedTypeReference;

public class ActionInferrerFragment
extends AbstractJvmModelInferrerExecutableFragment
implements IActionInferrerFragment {
    @Override
    public void transform(XtendFunction source, JvmGenericType container, boolean allowDispatch, IBaseJvmModelInferrer baseInferrer) {
        GenerationContext context = baseInferrer.getContext((JvmIdentifiableElement)container);
        assert (context != null);
        String originalFunctionName = source.getName();
        if (!Strings.isNullOrEmpty((String)originalFunctionName)) {
            if (Utils.isNameForJavaMainFunction(originalFunctionName) && source.getDeclaringType() instanceof SarlClass && source.isStatic() && !source.isDispatch() && !context.isMainFunctionGenerated() && !context.isMainFunctionManuallyDefined()) {
                this.translateMainFunction(context, source, container, baseInferrer);
            } else {
                this.translateRegularFunction(context, source, container, allowDispatch, baseInferrer);
            }
        }
    }

    protected void translateMainFunction(GenerationContext context, XtendFunction source, JvmGenericType container, IBaseJvmModelInferrer baseInferrer) {
        JvmTypeReference operationReturnType;
        LightweightTypeReference returnType;
        String functionName = Utils.getNameForJavaMainFunction();
        JvmOperation operation = this.jvmTypesFactory.createJvmOperation();
        container.getMembers().add((Object)operation);
        this.associator.associatePrimary((EObject)source, (EObject)operation);
        operation.setSimpleName(functionName);
        operation.setVisibility(JvmVisibility.PUBLIC);
        operation.setStrictFloatingPoint(source.isStrictFloatingPoint());
        operation.setStatic(true);
        operation.setSynchronized(false);
        operation.setNative(false);
        operation.setDefault(false);
        operation.setAbstract(false);
        operation.setFinal(false);
        operation.setVarArgs(false);
        operation.setReturnType(this.jvmTypeReferences.getTypeForName(Void.TYPE, (Notifier)container, new JvmTypeReference[0]));
        boolean isVarArgsFromSource = Utils.isVarArg((List<? extends XtendParameter>)source.getParameters());
        boolean isValidParameter = false;
        if (source.getParameters().size() == 1) {
            XtendParameter providedArg = (XtendParameter)source.getParameters().get(0);
            LightweightTypeReference argType = Utils.toLightweightTypeReference(providedArg.getParameterType(), this.services);
            if (!isVarArgsFromSource && argType.isArray()) {
                argType = argType.getComponentType();
            }
            isValidParameter = argType.isType(String.class);
        }
        boolean isValidReturnType = (returnType = Utils.toLightweightTypeReference(operationReturnType = source.getReturnType(), this.services)) == null || returnType.isPrimitiveVoid();
        JvmFormalParameter jvmParamArgs = this.jvmTypesFactory.createJvmFormalParameter();
        String jvmParamArgsName = isValidParameter ? ((XtendParameter)source.getParameters().get(0)).getName() : this.grammarKeywordAccess.getItKeyword();
        jvmParamArgs.setName(jvmParamArgsName);
        JvmTypeReference stringType = this.jvmTypeReferences.getTypeForName(String.class, (Notifier)container, new JvmTypeReference[0]);
        jvmParamArgs.setParameterType((JvmTypeReference)this.jvmTypeReferences.createArrayType(stringType));
        operation.getParameters().add((Object)jvmParamArgs);
        for (JvmTypeReference exception : source.getExceptions()) {
            operation.getExceptions().add((Object)this.jvmTypeBuilder.cloneWithProxies(exception));
        }
        QualifiedActionName actionKey = this.sarlSignatureProvider.createQualifiedActionName((JvmIdentifiableElement)container, functionName);
        InferredPrototype actionSignatures = this.sarlSignatureProvider.createPrototypeFromJvmModel(context.getActionPrototypeContext(this.sarlSignatureProvider), actionKey, false, (List<JvmFormalParameter>)operation.getParameters());
        ActionPrototype actSigKey = this.sarlSignatureProvider.createActionPrototype(functionName, actionSignatures.getFormalParameterTypes());
        Runnable differedGeneration = null;
        if (isValidParameter && isValidReturnType) {
            this.setBody(baseInferrer, (JvmExecutable)operation, source.getExpression());
        } else {
            String extractOperationName = "$" + operation.getSimpleName() + "_" + context.getActionIndex();
            boolean generateReturnWrapper = !isValidReturnType;
            boolean generateParameterWrapper = !isValidParameter;
            this.setBody((JvmExecutable)operation, (Procedures.Procedure1<ITreeAppendable>)((Procedures.Procedure1)it -> {
                String returnCodeVar = null;
                if (generateReturnWrapper) {
                    returnCodeVar = it.declareUniqueNameVariable((Object)operation, "returnCode");
                    it.append((CharSequence)"final ").append(returnType).append((CharSequence)" ");
                    it.append((CharSequence)returnCodeVar).append((CharSequence)" = ");
                }
                it.append((CharSequence)extractOperationName);
                it.append((CharSequence)"(");
                LightweightTypeReference stringTypeReference = Utils.toLightweightTypeReference(stringType, this.services);
                int i = 0;
                for (XtendParameter parameter : source.getParameters()) {
                    LightweightTypeReference paramType;
                    if (i > 0) {
                        it.append((CharSequence)", ");
                    }
                    if ((paramType = Utils.toLightweightTypeReference(parameter.getParameterType(), this.services)).isArray()) {
                        paramType = paramType.getComponentType();
                    }
                    if (paramType.isAssignableFrom(stringTypeReference)) {
                        if (generateParameterWrapper) {
                            it.append((CharSequence)jvmParamArgsName).append((CharSequence)"[");
                            it.append((CharSequence)Integer.toString(i)).append((CharSequence)"]");
                        } else {
                            it.append((CharSequence)parameter.getName());
                        }
                    } else {
                        it.append((CharSequence)Objects.toString(this.defaultValueProvider.getDefaultValue(parameter.getParameterType().getType())));
                    }
                    ++i;
                }
                it.append((CharSequence)");");
                if (generateReturnWrapper) {
                    it.newLine();
                    it.append(System.class).append((CharSequence)".exit(");
                    if (returnType.isPrimitive()) {
                        if (!returnType.isType(Integer.TYPE)) {
                            it.append((CharSequence)"(int) ");
                        }
                        it.append((CharSequence)returnCodeVar);
                    } else {
                        it.append((CharSequence)returnCodeVar);
                        it.append((CharSequence)" == null ? 255 : ");
                        if (returnType.isSubtypeOf(Number.class)) {
                            it.append((CharSequence)returnCodeVar);
                            it.append((CharSequence)".intValue()");
                        } else {
                            it.append((CharSequence)"0");
                        }
                    }
                    it.append((CharSequence)");");
                }
            }));
            differedGeneration = () -> {
                JvmOperation operation2 = this.jvmTypesFactory.createJvmOperation();
                container.getMembers().add((Object)operation2);
                operation2.setSimpleName(extractOperationName);
                operation2.setVisibility(JvmVisibility.PRIVATE);
                operation2.setVarArgs(isVarArgsFromSource);
                operation2.setAbstract(false);
                operation2.setDeprecated(false);
                operation2.setStatic(true);
                operation2.setFinal(false);
                operation2.setNative(false);
                operation2.setStrictFloatingPoint(false);
                operation2.setSynchronized(false);
                operation2.setDefault(false);
                operation2.setAbstract(false);
                this.associator.associate((EObject)source, (EObject)operation2);
                for (JvmTypeReference exception : operation.getExceptions()) {
                    operation2.getExceptions().add((Object)this.jvmTypeBuilder.cloneWithProxies(exception));
                }
                Object returnType2 = operationReturnType instanceof XComputedTypeReference ? this.jvmTypeReferences.createDelegateTypeReference(operationReturnType) : this.cloneWithTypeParametersAndProxies(operationReturnType, (JvmExecutable)operation2, baseInferrer);
                operation2.setReturnType((JvmTypeReference)returnType2);
                QualifiedActionName actionKey2 = this.sarlSignatureProvider.createQualifiedActionName((JvmIdentifiableElement)container, extractOperationName);
                InferredPrototype actionSignatures2 = this.sarlSignatureProvider.createPrototypeFromSarlModel(context.getActionPrototypeContext(this.sarlSignatureProvider), actionKey2, isVarArgsFromSource, (List<? extends XtendParameter>)source.getParameters());
                ActionPrototype actSigKey2 = this.sarlSignatureProvider.createActionPrototype(extractOperationName, actionSignatures2.getFormalParameterTypes());
                List<InferredStandardParameter> oparams = actionSignatures2.getOriginalParameterTypes();
                if (oparams == null) {
                    oparams = Collections.emptyList();
                }
                this.translateSarlFormalParametersForSyntheticOperation((JvmExecutable)operation2, container, isVarArgsFromSource, oparams, baseInferrer);
                this.setBody(baseInferrer, (JvmExecutable)operation2, source.getExpression());
                for (JvmAnnotationReference annotation : operation.getAnnotations()) {
                    String id = annotation.getAnnotation().getIdentifier();
                    if (DefaultValueSource.class.getName().equals(id) || DefaultValueUse.class.getName().equals(id) || Pure.class.getName().equals(id) || EarlyExit.class.getName().equals(id) || FiredEvent.class.getName().equals(id) || Inline.class.getName().equals(id) || XbaseGenerated.class.getName().equals(id) || GENERATED_NAME.equals(id)) continue;
                    try {
                        JvmAnnotationReference clone = baseInferrer.getJvmAnnotationReferenceBuilder().annotationRef(id, new String[0]);
                        if (clone == null) continue;
                        for (JvmAnnotationValue annotationValue : annotation.getExplicitValues()) {
                            clone.getExplicitValues().add((Object)((JvmAnnotationValue)EcoreUtil.copy((EObject)annotationValue)));
                        }
                        operation2.getAnnotations().add((Object)clone);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                this.copyAndCleanDocumentationTo((JvmExecutable)operation, (JvmExecutable)operation2);
                context.doLocalOperationDefinition(actSigKey2, operation2);
            };
        }
        baseInferrer.translateAnnotationsTo((List<XAnnotation>)source.getAnnotations(), (JvmAnnotationTarget)operation);
        if (!isValidParameter || !isValidReturnType) {
            this.appendGeneratedAnnotation(baseInferrer, (JvmAnnotationTarget)operation, context);
        }
        this.copyAndCleanDocumentationTo((XtendExecutable)source, (JvmExecutable)operation);
        context.doLocalOperationDefinition(actSigKey, operation);
        if (differedGeneration != null) {
            context.getPreFinalizationElements().add(differedGeneration);
        }
        context.setActionIndex(context.getActionIndex() + 1);
        context.incrementSerial(actSigKey.hashCode());
    }

    protected void translateRegularFunction(GenerationContext context, XtendFunction source, JvmGenericType container, boolean allowDispatch, IBaseJvmModelInferrer baseInferrer) {
        JvmOperation implementedOperation;
        boolean isEarlyExit;
        List firedEvents;
        boolean addDynamicPureAnnotationGenerator;
        boolean hasExplicitPureAnnotation;
        boolean enableFunctionBody;
        String originalFunctionName = source.getName();
        StringBuilder sourceNameBuffer = new StringBuilder(originalFunctionName);
        if (allowDispatch && source.isDispatch()) {
            sourceNameBuffer.insert(0, "_");
        }
        String sourceName = sourceNameBuffer.toString();
        JvmOperation operation = this.jvmTypesFactory.createJvmOperation();
        container.getMembers().add((Object)operation);
        this.associator.associatePrimary((EObject)source, (EObject)operation);
        operation.setSimpleName(sourceName);
        this.setVisibility((JvmMember)operation, (XtendMember)source);
        operation.setStrictFloatingPoint(source.isStrictFloatingPoint());
        operation.setStatic(source.isStatic());
        operation.setSynchronized(source.isSynchonized());
        operation.setNative(source.isNative());
        if (container.isInterface()) {
            enableFunctionBody = false;
            if (!Utils.toLightweightTypeReference((JvmType)container, this.services).isSubtypeOf(Capacity.class)) {
                if (operation.isStatic()) {
                    enableFunctionBody = true;
                } else if (source.getExpression() != null && !operation.isAbstract()) {
                    enableFunctionBody = true;
                }
            }
            operation.setDefault(enableFunctionBody && !operation.isStatic());
            operation.setAbstract(!enableFunctionBody);
            operation.setFinal(false);
        } else {
            operation.setDefault(false);
            enableFunctionBody = !source.isAbstract();
            operation.setAbstract(!enableFunctionBody);
            operation.setFinal(enableFunctionBody && source.isFinal());
        }
        baseInferrer.copyAndFixTypeParameters((List<JvmTypeParameter>)source.getTypeParameters(), (JvmTypeParameterDeclarator)operation);
        QualifiedActionName actionKey = this.sarlSignatureProvider.createQualifiedActionName((JvmIdentifiableElement)container, sourceName);
        boolean isVarArgs = Utils.isVarArg((List<? extends XtendParameter>)source.getParameters());
        InferredPrototype actionSignatures = this.sarlSignatureProvider.createPrototypeFromSarlModel(context.getActionPrototypeContext(this.sarlSignatureProvider), actionKey, isVarArgs, (List<? extends XtendParameter>)source.getParameters());
        ActionPrototype actSigKey = this.sarlSignatureProvider.createActionPrototype(sourceName, actionSignatures.getFormalParameterTypes());
        List<InferredStandardParameter> paramList = actionSignatures.getOriginalParameterTypes();
        this.translateSarlFormalParameters(context, (JvmExecutable)operation, container, isVarArgs, (List<? extends XtendParameter>)source.getParameters(), container.isInterface(), paramList, true, baseInferrer);
        JvmOperation inheritedOperation = context.getInheritedOperation(actSigKey);
        JvmTypeReference selectedReturnType = this.inferFunctionReturnType(source, operation, inheritedOperation, baseInferrer);
        operation.setReturnType(selectedReturnType);
        for (JvmTypeReference exception : source.getExceptions()) {
            operation.getExceptions().add((Object)this.jvmTypeBuilder.cloneWithProxies(exception));
        }
        if (enableFunctionBody) {
            this.setBody(baseInferrer, (JvmExecutable)operation, source.getExpression());
        }
        baseInferrer.translateAnnotationsTo((List<XAnnotation>)source.getAnnotations(), (JvmAnnotationTarget)operation);
        if (context.getGeneratorConfig2().isGenerateInlineAnnotation() && !source.isAbstract() && !container.isInterface() && (source.isStatic() || source.isFinal() || container.isFinal()) && context.getParentContext() == null && this.jvmAnnotationFinder.findAnnotation((JvmAnnotationTarget)operation, Inline.class) == null) {
            context.getPostFinalizationElements().add(() -> this.inlineExpressionCompiler.appendInlineAnnotation((JvmAnnotationTarget)operation, (XtendExecutable)source));
        }
        if (source.isOverride() && this.jvmAnnotationFinder.findAnnotation((JvmAnnotationTarget)operation, Override.class) == null && this.jvmTypeReferences.findDeclaredType(Override.class, (Notifier)source) != null) {
            this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)operation, Override.class, new String[0]);
        }
        boolean bl = hasExplicitPureAnnotation = this.jvmAnnotationFinder.findAnnotation((JvmAnnotationTarget)operation, Pure.class) != null;
        if (!hasExplicitPureAnnotation && context.getGeneratorConfig2().isGeneratePureAnnotation() && this.jvmTypeReferences.findDeclaredType(Pure.class, (Notifier)source) != null) {
            boolean bl2 = addDynamicPureAnnotationGenerator = inheritedOperation == null;
            if (addDynamicPureAnnotationGenerator) {
                this.operationHelper.attachPureAnnotationAdapter(operation, (Functions.Function2<? super JvmOperation, ? super IOperationHelper, ? extends Boolean>)((Functions.Function2)(op, helper) -> helper.isPurableOperation(source)));
            } else {
                this.operationHelper.attachPureAnnotationAdapter(operation, (Functions.Function2<? super JvmOperation, ? super IOperationHelper, ? extends Boolean>)((Functions.Function2)(op, helper) -> helper.isPureOperation(inheritedOperation)));
            }
        } else {
            addDynamicPureAnnotationGenerator = false;
        }
        if (source instanceof SarlAction) {
            SarlAction action = (SarlAction)source;
            firedEvents = action.getFiredEvents();
            isEarlyExit = this.earlyExitComputer.isEarlyExitOperation(action);
            if (isEarlyExit) {
                this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)operation, EarlyExit.class, new String[0]);
            }
        } else {
            firedEvents = Collections.emptyList();
            isEarlyExit = false;
        }
        if (!firedEvents.isEmpty()) {
            operation.getAnnotations().add((Object)this.annotationClassRef(baseInferrer, FiredEvent.class, firedEvents));
        }
        if ((implementedOperation = context.getInheritedOperationsToImplement().get(actSigKey)) == null) {
            implementedOperation = context.getInheritedOverridableOperations().get(actSigKey);
        }
        if (implementedOperation != null) {
            if (this.jvmAnnotationFinder.findAnnotation((JvmAnnotationTarget)implementedOperation, DefaultValueSource.class) != null && this.jvmAnnotationFinder.findAnnotation((JvmAnnotationTarget)operation, DefaultValueSource.class) == null) {
                this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)operation, DefaultValueSource.class, new String[0]);
            }
            EList oparams = implementedOperation.getParameters();
            EList cparams = operation.getParameters();
            assert (oparams.size() == cparams.size());
            for (int i = 0; i < oparams.size(); ++i) {
                JvmFormalParameter op2 = (JvmFormalParameter)oparams.get(i);
                JvmFormalParameter cp = (JvmFormalParameter)cparams.get(i);
                String ovalue = this.annotationUtils.findStringValue((JvmAnnotationTarget)op2, DefaultValue.class);
                if (ovalue == null || this.jvmAnnotationFinder.findAnnotation((JvmAnnotationTarget)cp, DefaultValue.class) != null) continue;
                this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)cp, DefaultValue.class, this.sarlSignatureProvider.qualifyDefaultValueID(implementedOperation.getDeclaringType().getIdentifier(), ovalue));
            }
        }
        context.doLocalOperationDefinition(actSigKey, operation);
        this.copyAndCleanDocumentationTo((XtendExecutable)source, (JvmExecutable)operation);
        Runnable differedGeneration = () -> {
            for (Map.Entry<ActionParameterTypes, List<InferredStandardParameter>> otherSignature : actionSignatures.getInferredParameterTypes().entrySet()) {
                ActionPrototype ak = this.sarlSignatureProvider.createActionPrototype(sourceName, otherSignature.getKey());
                if (ak == null) continue;
                JvmOperation inheritedOp = context.getInheritedImplementedOperation(ak);
                this.translateSarlFormalParametersForLocalHiddenDefaultValues(context, inheritedOp);
                JvmOperation localOp = context.getLocalOperation(ak);
                if (inheritedOp != null || localOp != null) continue;
                JvmOperation operation2 = this.jvmTypesFactory.createJvmOperation();
                container.getMembers().add((Object)operation2);
                operation2.setSimpleName(operation.getSimpleName());
                operation2.setVisibility(operation.getVisibility());
                operation2.setVarArgs(operation.isVarArgs());
                operation2.setAbstract(operation.isAbstract());
                operation2.setDeprecated(operation.isDeprecated());
                operation2.setStatic(operation.isStatic());
                operation2.setFinal(!operation.isStatic() && !container.isInterface());
                operation2.setNative(false);
                operation2.setStrictFloatingPoint(false);
                operation2.setSynchronized(false);
                this.associator.associate((EObject)source, (EObject)operation2);
                this.copyTypeParametersFromJvmOperation(operation, operation2, baseInferrer);
                for (JvmTypeReference exception : operation.getExceptions()) {
                    operation2.getExceptions().add((Object)this.jvmTypeBuilder.cloneWithProxies(exception));
                }
                Object returnType2 = selectedReturnType instanceof XComputedTypeReference ? this.jvmTypeReferences.createDelegateTypeReference(selectedReturnType) : this.cloneWithTypeParametersAndProxies(selectedReturnType, (JvmExecutable)operation2, baseInferrer);
                operation2.setReturnType((JvmTypeReference)returnType2);
                List<String> args = this.translateSarlFormalParametersForSyntheticOperation((JvmExecutable)operation2, container, isVarArgs, otherSignature.getValue(), baseInferrer);
                operation2.setDefault(container.isInterface());
                operation2.setAbstract(false);
                this.setBody((JvmExecutable)operation2, (Procedures.Procedure1<ITreeAppendable>)((Procedures.Procedure1)arg_0 -> this.lambda$translateRegularFunction$5(operation2, (JvmTypeReference)returnType2, sourceName, args, arg_0)));
                if (source.isOverride() && this.jvmAnnotationFinder.findAnnotation((JvmAnnotationTarget)operation, Override.class) == null && this.jvmTypeReferences.findDeclaredType(Override.class, (Notifier)source) != null) {
                    this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)operation, Override.class, new String[0]);
                }
                this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)operation2, DefaultValueUse.class, actionSignatures.getFormalParameterTypes().toString());
                this.appendGeneratedAnnotation(baseInferrer, (JvmAnnotationTarget)operation2, context);
                if (isEarlyExit) {
                    this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)operation2, EarlyExit.class, new String[0]);
                }
                if (!firedEvents.isEmpty()) {
                    operation2.getAnnotations().add((Object)this.annotationClassRef(baseInferrer, FiredEvent.class, firedEvents));
                }
                if (addDynamicPureAnnotationGenerator) {
                    this.operationHelper.attachPureAnnotationAdapter(operation2, (Functions.Function2<? super JvmOperation, ? super IOperationHelper, ? extends Boolean>)((Functions.Function2)(op, helper) -> helper.isPureOperation(operation)));
                } else if (hasExplicitPureAnnotation) {
                    this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)operation2, Pure.class, new String[0]);
                }
                for (JvmAnnotationReference annotation : operation.getAnnotations()) {
                    String id = annotation.getAnnotation().getIdentifier();
                    if (DefaultValueSource.class.getName().equals(id) || DefaultValueUse.class.getName().equals(id) || Pure.class.getName().equals(id) || EarlyExit.class.getName().equals(id) || FiredEvent.class.getName().equals(id) || Inline.class.getName().equals(id) || XbaseGenerated.class.getName().equals(id) || GENERATED_NAME.equals(id)) continue;
                    try {
                        JvmAnnotationReference clone = baseInferrer.getJvmAnnotationReferenceBuilder().annotationRef(id, new String[0]);
                        if (clone == null) continue;
                        for (JvmAnnotationValue annotationValue : annotation.getExplicitValues()) {
                            clone.getExplicitValues().add((Object)((JvmAnnotationValue)EcoreUtil.copy((EObject)annotationValue)));
                        }
                        operation2.getAnnotations().add((Object)clone);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                this.copyAndCleanDocumentationTo((JvmExecutable)operation, (JvmExecutable)operation2);
                context.doLocalOperationDefinition(ak, operation2);
            }
        };
        context.getPreFinalizationElements().add(differedGeneration);
        context.setActionIndex(context.getActionIndex() + 1);
        context.incrementSerial(actSigKey.hashCode());
        context.setInjectable((JvmAnnotationTarget)operation);
    }

    private /* synthetic */ void lambda$translateRegularFunction$5(JvmOperation operation2, JvmTypeReference returnType2, String sourceName, List args, ITreeAppendable it) {
        LightweightTypeReference ltr;
        JvmTypeReference type = operation2.getReturnType();
        if (!this.jvmTypeReferences.is(type, Void.TYPE)) {
            it.append((CharSequence)"return ");
        }
        if (Utils.containsGenericType(ltr = Utils.toLightweightTypeReference(returnType2, this.services))) {
            String typeId = ltr.getRawTypeReference().getType().getQualifiedName('.');
            String javaId = ltr.getRawTypeReference().getJavaIdentifier();
            String fullId = ltr.getJavaIdentifier().replaceAll(Pattern.quote(javaId), Matcher.quoteReplacement(typeId));
            it.append((CharSequence)"(");
            it.append((CharSequence)fullId);
            it.append((CharSequence)")");
        }
        it.append((CharSequence)sourceName);
        it.append((CharSequence)"(");
        it.append((CharSequence)IterableExtensions.join((Iterable)args, (CharSequence)", "));
        it.append((CharSequence)");");
    }
}

