/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.jvmmodel.fragments.oop.impl;

import io.sarl.lang.core.annotation.DefaultValueUse;
import io.sarl.lang.jvmmodel.GenerationContext;
import io.sarl.lang.jvmmodel.IBaseJvmModelInferrer;
import io.sarl.lang.jvmmodel.fragments.AbstractJvmModelInferrerExecutableFragment;
import io.sarl.lang.jvmmodel.fragments.oop.IConstructorInferrerFragment;
import io.sarl.lang.sarl.actionprototype.ActionParameterTypes;
import io.sarl.lang.sarl.actionprototype.InferredPrototype;
import io.sarl.lang.sarl.actionprototype.InferredStandardParameter;
import io.sarl.lang.sarl.actionprototype.QualifiedActionName;
import io.sarl.lang.util.Utils;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendExecutable;
import org.eclipse.xtend.core.xtend.XtendMember;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ConstructorInferrerFragment
extends AbstractJvmModelInferrerExecutableFragment
implements IConstructorInferrerFragment {
    @Override
    public void transformStatic(XtendConstructor source, JvmGenericType container, IBaseJvmModelInferrer baseInferrer) {
        JvmOperation staticConstructor = this.jvmTypesFactory.createJvmOperation();
        container.getMembers().add((Object)staticConstructor);
        this.associator.associatePrimary((EObject)source, (EObject)staticConstructor);
        staticConstructor.setSimpleName(Utils.getStaticConstructorName());
        staticConstructor.setVisibility(JvmVisibility.PRIVATE);
        staticConstructor.setStatic(true);
        staticConstructor.setReturnType(baseInferrer.getJvmTypeReferenceBuilder().typeRef(Void.TYPE, new JvmTypeReference[0]));
        this.setBody(baseInferrer, (JvmExecutable)staticConstructor, source.getExpression());
        this.copyAndCleanDocumentationTo((XtendExecutable)source, (JvmExecutable)staticConstructor);
    }

    @Override
    public void transform(XtendConstructor source, JvmGenericType container, IBaseJvmModelInferrer baseInferrer) {
        String constructorName = container.getSimpleName();
        GenerationContext context = baseInferrer.getContext((JvmIdentifiableElement)container);
        assert (context != null);
        boolean isVarArgs = Utils.isVarArg((List<? extends XtendParameter>)source.getParameters());
        QualifiedActionName actionKey = this.sarlSignatureProvider.createConstructorQualifiedName((JvmIdentifiableElement)container);
        InferredPrototype constructorSignatures = this.sarlSignatureProvider.createPrototypeFromSarlModel(context.getActionPrototypeContext(this.sarlSignatureProvider), actionKey, Utils.isVarArg((List<? extends XtendParameter>)source.getParameters()), (List<? extends XtendParameter>)source.getParameters());
        JvmConstructor constructor = this.jvmTypesFactory.createJvmConstructor();
        container.getMembers().add((Object)constructor);
        this.associator.associatePrimary((EObject)source, (EObject)constructor);
        constructor.setSimpleName(constructorName);
        this.setVisibility((JvmMember)constructor, (XtendMember)source);
        constructor.setVarArgs(isVarArgs);
        List<InferredStandardParameter> paramList = constructorSignatures.getOriginalParameterTypes();
        this.translateSarlFormalParameters(context, (JvmExecutable)constructor, container, isVarArgs, (List<? extends XtendParameter>)source.getParameters(), false, paramList, false, baseInferrer);
        baseInferrer.copyAndFixTypeParameters((List<JvmTypeParameter>)source.getTypeParameters(), (JvmTypeParameterDeclarator)constructor);
        for (JvmTypeReference exception : source.getExceptions()) {
            constructor.getExceptions().add((Object)this.jvmTypeBuilder.cloneWithProxies(exception));
        }
        baseInferrer.translateAnnotationsTo((List<XAnnotation>)source.getAnnotations(), (JvmAnnotationTarget)constructor);
        this.setBody(baseInferrer, (JvmExecutable)constructor, source.getExpression());
        ActionParameterTypes sigKey = this.sarlSignatureProvider.createParameterTypesFromJvmModel(isVarArgs, (List<JvmFormalParameter>)constructor.getParameters());
        context.getGeneratedConstructors().put(sigKey, constructor);
        this.copyAndCleanDocumentationTo((XtendExecutable)source, (JvmExecutable)constructor);
        Runnable differedGeneration = () -> {
            for (Map.Entry<ActionParameterTypes, List<InferredStandardParameter>> entry : constructorSignatures.getInferredParameterTypes().entrySet()) {
                if (context.getGeneratedConstructors().containsKey(entry.getKey())) continue;
                List<InferredStandardParameter> otherSignature = entry.getValue();
                this.translateSarlFormalParametersForLocalHiddenDefaultValues(context, null);
                JvmConstructor constructor2 = this.jvmTypesFactory.createJvmConstructor();
                container.getMembers().add((Object)constructor2);
                this.copyAndCleanDocumentationTo((XtendExecutable)source, (JvmExecutable)constructor2);
                constructor2.setSimpleName(container.getSimpleName());
                constructor2.setVisibility(constructor.getVisibility());
                constructor2.setVarArgs(isVarArgs);
                List<String> args = this.translateSarlFormalParametersForSyntheticOperation((JvmExecutable)constructor2, container, isVarArgs, otherSignature, baseInferrer);
                this.addAnnotationSafe(baseInferrer, (JvmAnnotationTarget)constructor2, DefaultValueUse.class, constructorSignatures.getFormalParameterTypes().toString());
                this.appendGeneratedAnnotation(baseInferrer, (JvmAnnotationTarget)constructor2, context);
                this.setBody((JvmExecutable)constructor2, ConstructorInferrerFragment.toStringConcatenation("this(" + IterableExtensions.join(args, (CharSequence)", ") + ");"));
                context.getGeneratedConstructors().put(entry.getKey(), constructor2);
            }
        };
        context.getPreFinalizationElements().add(differedGeneration);
        context.setActionIndex(context.getActionIndex() + 1);
        context.incrementSerial(sigKey.hashCode());
        context.setInjectable((JvmAnnotationTarget)constructor);
    }
}

