/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.sarl.actionprototype;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import io.sarl.lang.sarl.actionprototype.ActionPrototype;
import java.util.Iterator;
import org.eclipse.emf.common.util.BasicEList;

public class ActionParameterTypes
extends BasicEList<String>
implements Comparable<ActionParameterTypes> {
    private static final long serialVersionUID = 8389816963923769014L;
    private final boolean isVarargs;

    public ActionParameterTypes(boolean isVarArgs, int initialCapacity) {
        super(initialCapacity);
        this.isVarargs = isVarArgs;
    }

    public ActionParameterTypes(String text) {
        assert (text != null);
        String[] elements = text.split("\\s*,\\s*");
        boolean bl = this.isVarargs = elements.length > 0 && elements[elements.length - 1].endsWith("*");
        if (this.isVarargs) {
            elements[elements.length - 1] = elements[elements.length - 1].replaceFirst("\\*$", "[]");
        }
        for (String p : elements) {
            if (Strings.isNullOrEmpty((String)p) || "void".equals(p) || "java.lang.Void".equals(p)) continue;
            this.add(p);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() == object.getClass() && object instanceof ActionParameterTypes) {
            ActionParameterTypes types = (ActionParameterTypes)object;
            if (super.equals(object)) {
                return this.isVarargs == types.isVarargs;
            }
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.isVarargs});
    }

    public boolean isVarArg() {
        return this.isVarargs;
    }

    public boolean isVoid() {
        return this.size() == 0;
    }

    public ActionParameterTypes clone() {
        return (ActionParameterTypes)super.clone();
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean isRaw) {
        if (!this.isEmpty()) {
            StringBuilder b = new StringBuilder();
            int size = this.size() - 1;
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    b.append(",");
                }
                String elt = isRaw ? ((String)this.get(i)).replaceFirst("\\<.*\\>", "") : (String)this.get(i);
                b.append(elt);
            }
            String lastElement = (String)this.get(size);
            if (this.isVarArg()) {
                lastElement = lastElement.replaceFirst("\\[\\]$", "*");
            }
            if (isRaw) {
                lastElement = lastElement.replaceFirst("\\<.*\\>", "");
            }
            if (size > 0) {
                b.append(",");
            }
            b.append(lastElement);
            return b.toString();
        }
        return "";
    }

    @Override
    public int compareTo(ActionParameterTypes otherTypes) {
        if (otherTypes == null) {
            return Integer.MAX_VALUE;
        }
        int cmp = Integer.compare(this.size(), otherTypes.size());
        if (cmp != 0) {
            return cmp;
        }
        Iterator i1 = this.iterator();
        Iterator i2 = otherTypes.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            String s2;
            String s1 = (String)i1.next();
            cmp = s1.compareTo(s2 = (String)i2.next());
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public ActionPrototype toActionPrototype(String actionName) {
        return new ActionPrototype(actionName, this, false);
    }

    public ActionPrototype toRawActionPrototype(String actionName) {
        return new ActionPrototype(actionName, this, true);
    }
}

