/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.sarl.actionprototype;

import io.sarl.lang.sarl.actionprototype.ActionParameterTypes;
import java.io.Serializable;
import java.util.Iterator;

public class ActionPrototype
implements Cloneable,
Serializable,
Comparable<ActionPrototype> {
    private static final long serialVersionUID = -3797441140684942274L;
    private String function;
    private ActionParameterTypes signature;
    private final boolean isRaw;

    public ActionPrototype(String function, ActionParameterTypes signature, boolean isRaw) {
        this.function = function;
        this.signature = signature;
        this.isRaw = isRaw;
    }

    public String getActionName() {
        return this.function;
    }

    public ActionParameterTypes getParametersTypes() {
        return this.signature;
    }

    public ActionPrototype clone() {
        try {
            ActionPrototype prototype = (ActionPrototype)super.clone();
            prototype.signature = this.signature.clone();
            return prototype;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            ActionPrototype prototype = (ActionPrototype)obj;
            return this.function.equals(prototype.function) && this.signature.equals(prototype.signature);
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        hash = 31 * hash + this.function.hashCode();
        hash = 31 * hash + this.signature.hashCode();
        return hash;
    }

    public String toString() {
        return this.function + "(" + this.signature.toString(this.isRaw) + ")";
    }

    @Override
    public int compareTo(ActionPrototype otherProto) {
        if (otherProto == null) {
            return Integer.MAX_VALUE;
        }
        int cmp = this.function.compareTo(otherProto.function);
        if (cmp != 0) {
            return cmp;
        }
        return this.signature.compareTo(otherProto.signature);
    }

    public String toActionId() {
        StringBuilder b = new StringBuilder();
        b.append(this.getActionName());
        Iterator iterator = this.signature.iterator();
        while (iterator.hasNext()) {
            String type = (String)iterator.next();
            b.append("_");
            for (char c : type.replaceAll("(\\[\\])|\\*", "Array").toCharArray()) {
                if (!Character.isJavaIdentifierPart(c)) continue;
                b.append(c);
            }
        }
        return b.toString();
    }
}

