/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.sarl.actionprototype;

import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import io.sarl.lang.core.annotation.DefaultValue;
import io.sarl.lang.core.annotation.SarlSourceCode;
import io.sarl.lang.sarl.SarlFormalParameter;
import io.sarl.lang.sarl.actionprototype.ActionParameterTypes;
import io.sarl.lang.sarl.actionprototype.ActionPrototype;
import io.sarl.lang.sarl.actionprototype.DefaultInferredPrototype;
import io.sarl.lang.sarl.actionprototype.DynamicArgumentName;
import io.sarl.lang.sarl.actionprototype.FormalParameterProvider;
import io.sarl.lang.sarl.actionprototype.IActionPrototypeContext;
import io.sarl.lang.sarl.actionprototype.IActionPrototypeProvider;
import io.sarl.lang.sarl.actionprototype.InferredPrototype;
import io.sarl.lang.sarl.actionprototype.InferredStandardParameter;
import io.sarl.lang.sarl.actionprototype.InferredValuedParameter;
import io.sarl.lang.sarl.actionprototype.JvmFormalParameterProvider;
import io.sarl.lang.sarl.actionprototype.QualifiedActionName;
import io.sarl.lang.sarl.actionprototype.SarlFormalParameterProvider;
import io.sarl.lang.services.SARLGrammarKeywordAccess;
import io.sarl.lang.typesystem.SARLAnnotationUtil;
import io.sarl.lang.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.AnnotationLookup;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public class DefaultActionPrototypeProvider
implements IActionPrototypeProvider {
    @Inject
    private SARLAnnotationUtil annotationUtils;
    @Inject
    private TypeReferences references;
    @Inject
    private SARLGrammarKeywordAccess grammarAccess;
    @Inject
    private AnnotationLookup annotationFinder;
    @Inject
    private CommonTypeComputationServices services;

    protected LightweightTypeReference unifiesType(JvmTypeReference reference) {
        FunctionTypeReference functionReference;
        LightweightTypeReference lreference = Utils.toLightweightTypeReference(reference, this.services);
        if (lreference.isFunctionType() && (functionReference = lreference.getAsFunctionTypeReference()) != null) {
            return functionReference;
        }
        return lreference;
    }

    protected String toIdentifier(LightweightTypeReference reference) {
        if (reference.isFunctionType()) {
            return reference.getIdentifier();
        }
        return reference.getRawTypeReference().getIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<InferredPrototype> getPrototypes(IActionPrototypeContext context, QualifiedActionName id) {
        InnerMap c;
        Context ctx = (Context)context;
        ctx.getPrototypes().getLock().readLock().lock();
        try {
            c = (InnerMap)ctx.getPrototypes().get(id.getContainerID());
        }
        finally {
            ctx.getPrototypes().getLock().readLock().unlock();
        }
        if (c != null) {
            InnerMap list;
            c.getLock().readLock().lock();
            try {
                list = (InnerMap)c.get(id.getActionName());
            }
            finally {
                c.getLock().readLock().unlock();
            }
            if (list != null) {
                list.getLock().readLock().lock();
                try {
                    Collection<InferredPrototype> collection = Collections.unmodifiableCollection(list.values());
                    return collection;
                }
                finally {
                    list.getLock().readLock().unlock();
                }
            }
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InferredPrototype getPrototypes(IActionPrototypeContext context, QualifiedActionName actionID, ActionParameterTypes signatureID) {
        InnerMap c;
        Context ctx = (Context)context;
        ctx.getPrototypes().getLock().readLock().lock();
        try {
            c = (InnerMap)ctx.getPrototypes().get(actionID.getContainerID());
        }
        finally {
            ctx.getPrototypes().getLock().readLock().unlock();
        }
        if (c != null) {
            InnerMap list;
            c.getLock().readLock().lock();
            try {
                list = (InnerMap)c.get(actionID.getActionName());
            }
            finally {
                c.getLock().readLock().unlock();
            }
            if (list != null) {
                list.getLock().readLock().lock();
                try {
                    InferredPrototype inferredPrototype = (InferredPrototype)list.get(signatureID);
                    return inferredPrototype;
                }
                finally {
                    list.getLock().readLock().unlock();
                }
            }
        }
        return null;
    }

    private Pair<InnerMap<ActionParameterTypes, List<InferredStandardParameter>>, Boolean> buildParameter(int parameterIndex, int lastParameterIndex, DynamicArgumentName argumentValue, FormalParameterProvider params, InnerMap<ActionParameterTypes, List<InferredStandardParameter>> signatures, ActionParameterTypes fillSignatureKeyOutputParameter) {
        boolean isOptional = params.hasFormalParameterDefaultValue(parameterIndex) && (parameterIndex < lastParameterIndex || !fillSignatureKeyOutputParameter.isVarArg());
        boolean isVarArg = parameterIndex >= lastParameterIndex && fillSignatureKeyOutputParameter.isVarArg();
        String name = params.getFormalParameterName(parameterIndex);
        JvmTypeReference type = params.getFormalParameterTypeReference(parameterIndex, isVarArg);
        InnerMap<ActionParameterTypes, List> tmpSignatures = new InnerMap<ActionParameterTypes, List>();
        if (type == null) {
            return new Pair(tmpSignatures, (Object)isOptional);
        }
        LightweightTypeReference ltype = this.unifiesType(type);
        fillSignatureKeyOutputParameter.add(this.toIdentifier(ltype));
        if (signatures.isEmpty()) {
            ArrayList<InferredStandardParameter> value;
            ActionParameterTypes key;
            if (isOptional) {
                key = new ActionParameterTypes(isVarArg, 0);
                value = new ArrayList<InferredStandardParameter>();
                value.add(new InferredValuedParameter(params.getFormalParameter(parameterIndex), name, ltype, argumentValue));
                tmpSignatures.put(key, value);
            }
            key = new ActionParameterTypes(isVarArg, 1);
            key.add(this.toIdentifier(ltype));
            value = new ArrayList();
            value.add(new InferredStandardParameter(params.getFormalParameter(parameterIndex), name, ltype, argumentValue));
            tmpSignatures.put(key, value);
        } else {
            for (Map.Entry entry : signatures.entrySet()) {
                ActionParameterTypes key;
                if (isOptional) {
                    key = new ActionParameterTypes(isVarArg, ((ActionParameterTypes)entry.getKey()).size());
                    key.addAll((Collection)entry.getKey());
                    ArrayList<InferredValuedParameter> value = new ArrayList<InferredValuedParameter>((Collection)entry.getValue());
                    value.add(new InferredValuedParameter(params.getFormalParameter(parameterIndex), name, ltype, argumentValue));
                    tmpSignatures.put(key, value);
                }
                key = new ActionParameterTypes(isVarArg, ((ActionParameterTypes)entry.getKey()).size() + 1);
                key.addAll((Collection)entry.getKey());
                key.add(this.toIdentifier(ltype));
                List paramList = (List)entry.getValue();
                paramList.add(new InferredStandardParameter(params.getFormalParameter(parameterIndex), name, ltype, argumentValue));
                tmpSignatures.put(key, paramList);
            }
        }
        return new Pair(tmpSignatures, (Object)isOptional);
    }

    @Override
    public Map<ActionParameterTypes, List<InferredStandardParameter>> buildSignatures(JvmIdentifiableElement container, FormalParameterProvider parameterProvider) {
        Context context = new Context();
        ActionParameterTypes key = new ActionParameterTypes(false, parameterProvider.getFormalParameterCount());
        return this.buildSignaturesForArgDefaultValues(context, container, "$", parameterProvider, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InnerMap<ActionParameterTypes, List<InferredStandardParameter>> buildSignaturesForArgDefaultValues(Context context, JvmIdentifiableElement container, String actionId, FormalParameterProvider params, ActionParameterTypes fillSignatureKeyOutputParameter) {
        InnerMap signatures = new InnerMap();
        fillSignatureKeyOutputParameter.clear();
        if (params.getFormalParameterCount() > 0) {
            Integer lastIndex;
            InnerMap<String, Integer> indexes;
            int lastParamIndex = params.getFormalParameterCount() - 1;
            String containerFullyQualifiedName = this.createQualifiedActionName(container, null).getContainerID();
            context.getDefaultValueIDPrefixes().getLock().readLock().lock();
            try {
                indexes = (InnerMap<String, Integer>)context.getDefaultValueIDPrefixes().get(containerFullyQualifiedName);
            }
            finally {
                context.getDefaultValueIDPrefixes().getLock().readLock().unlock();
            }
            if (indexes == null) {
                context.getDefaultValueIDPrefixes().getLock().writeLock().lock();
                try {
                    indexes = (InnerMap)context.getDefaultValueIDPrefixes().get(containerFullyQualifiedName);
                    if (indexes == null) {
                        indexes = new InnerMap<String, Integer>();
                        context.getDefaultValueIDPrefixes().put(containerFullyQualifiedName, indexes);
                    }
                }
                finally {
                    context.getDefaultValueIDPrefixes().getLock().writeLock().unlock();
                }
            }
            indexes.getLock().readLock().lock();
            try {
                lastIndex = (Integer)indexes.get(actionId);
            }
            finally {
                indexes.getLock().readLock().unlock();
            }
            int defaultValueIndex = lastIndex == null ? 0 : lastIndex;
            String[] annotationValues = new String[params.getFormalParameterCount()];
            String prefix = container.getQualifiedName() + "#" + actionId.toUpperCase() + "_";
            for (int i = 0; i <= lastParamIndex; ++i) {
                DynamicArgumentName argumentName = new DynamicArgumentName(prefix + defaultValueIndex);
                Pair<InnerMap<ActionParameterTypes, List<InferredStandardParameter>>, Boolean> pair = this.buildParameter(i, lastParamIndex, argumentName, params, signatures, fillSignatureKeyOutputParameter);
                signatures = (InnerMap)pair.getKey();
                if (!((Boolean)pair.getValue()).booleanValue()) continue;
                annotationValues[i] = prefix + defaultValueIndex;
                ++defaultValueIndex;
            }
            indexes.getLock().writeLock().lock();
            try {
                indexes.put(actionId, defaultValueIndex);
            }
            finally {
                indexes.getLock().writeLock().unlock();
            }
            List parameters = (List)signatures.get(fillSignatureKeyOutputParameter);
            if (parameters != null) {
                for (int i = 0; i < parameters.size(); ++i) {
                    if (Strings.isNullOrEmpty((String)annotationValues[i])) continue;
                    ((InferredStandardParameter)parameters.get(i)).setDefaultValueAnnotationValue(annotationValues[i], annotationValues[i].substring(annotationValues[i].lastIndexOf("#") + 1));
                }
            }
        }
        return signatures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InferredPrototype createPrototype(Context context, QualifiedActionName id, boolean isVarargs, FormalParameterProvider parameters) {
        InnerMap<ActionParameterTypes, DefaultInferredPrototype> list;
        InnerMap<String, InnerMap<ActionParameterTypes, DefaultInferredPrototype>> c;
        assert (parameters != null);
        ActionParameterTypes key = new ActionParameterTypes(isVarargs, parameters.getFormalParameterCount());
        InnerMap<ActionParameterTypes, List<InferredStandardParameter>> ip = this.buildSignaturesForArgDefaultValues(context, id.getDeclaringType(), key.toActionPrototype(id.getActionName()).toActionId(), parameters, key);
        List op = (List)ip.remove(key);
        DefaultInferredPrototype proto = new DefaultInferredPrototype(id, parameters, key, op, ip);
        String containerID = id.getContainerID();
        context.getPrototypes().getLock().readLock().lock();
        try {
            c = (InnerMap<String, InnerMap<ActionParameterTypes, DefaultInferredPrototype>>)context.getPrototypes().get(containerID);
        }
        finally {
            context.getPrototypes().getLock().readLock().unlock();
        }
        if (c == null) {
            context.getPrototypes().getLock().writeLock().lock();
            try {
                c = (InnerMap)context.getPrototypes().get(containerID);
                if (c == null) {
                    c = new InnerMap<String, InnerMap<ActionParameterTypes, DefaultInferredPrototype>>();
                    context.getPrototypes().put(containerID, c);
                }
            }
            finally {
                context.getPrototypes().getLock().writeLock().unlock();
            }
        }
        c.getLock().readLock().lock();
        try {
            list = (InnerMap<ActionParameterTypes, DefaultInferredPrototype>)c.get(id.getActionName());
        }
        finally {
            c.getLock().readLock().unlock();
        }
        if (list == null) {
            c.getLock().writeLock().lock();
            try {
                list = (InnerMap)c.get(id.getActionName());
                if (list == null) {
                    list = new InnerMap<ActionParameterTypes, DefaultInferredPrototype>();
                    c.put(id.getActionName(), list);
                }
            }
            finally {
                c.getLock().writeLock().unlock();
            }
        }
        list.getLock().writeLock().lock();
        try {
            list.put(key, proto);
        }
        finally {
            list.getLock().writeLock().unlock();
        }
        return proto;
    }

    @Override
    public final InferredPrototype createPrototypeFromSarlModel(IActionPrototypeContext context, QualifiedActionName id, boolean isVarargs, List<? extends XtendParameter> parameters) {
        return this.createPrototype((Context)context, id, isVarargs, new SarlFormalParameterProvider(parameters, this.references));
    }

    @Override
    public final InferredPrototype createPrototypeFromJvmModel(IActionPrototypeContext context, QualifiedActionName id, boolean isVarargs, List<JvmFormalParameter> parameters) {
        return this.createPrototype((Context)context, id, isVarargs, new JvmFormalParameterProvider(parameters, this.annotationFinder, this));
    }

    @Override
    public IActionPrototypeContext createContext() {
        return new Context();
    }

    @Override
    public ActionParameterTypes createParameterTypesFromSarlModel(boolean isVarargs, List<? extends SarlFormalParameter> parameters) {
        ActionParameterTypes sig = new ActionParameterTypes(isVarargs, parameters.size());
        if (!parameters.isEmpty()) {
            int lastIndex = parameters.size() - 1;
            for (int i = 0; i < lastIndex; ++i) {
                SarlFormalParameter param = parameters.get(i);
                if (param == null || param.getParameterType() == null) continue;
                sig.add(this.toIdentifier(this.unifiesType(param.getParameterType())));
            }
            SarlFormalParameter param = parameters.get(lastIndex);
            if (param != null && param.getParameterType() != null) {
                JvmTypeReference type = param.getParameterType();
                if (isVarargs) {
                    type = this.references.createArrayType(type);
                }
                sig.add(this.toIdentifier(this.unifiesType(type)));
            }
        }
        return sig;
    }

    @Override
    public QualifiedActionName createQualifiedActionName(JvmIdentifiableElement container, String functionName) {
        return new QualifiedActionName(container.eResource().getURI().toString(), container, functionName);
    }

    @Override
    public QualifiedActionName createConstructorQualifiedName(JvmIdentifiableElement container) {
        return new QualifiedActionName(container.eResource().getURI().toString(), container, this.grammarAccess.getNewKeyword());
    }

    @Override
    public ActionParameterTypes createParameterTypes(boolean isVarargs, FormalParameterProvider provider) {
        int count = provider.getFormalParameterCount();
        ActionParameterTypes sig = new ActionParameterTypes(isVarargs, count);
        if (count > 0) {
            if (isVarargs) {
                --count;
                for (int i = 0; i < count; ++i) {
                    sig.add(provider.getFormalParameterType(i, false));
                }
                sig.add(provider.getFormalParameterType(count, true));
            } else {
                for (int i = 0; i < count; ++i) {
                    sig.add(provider.getFormalParameterType(i, false));
                }
            }
        }
        return sig;
    }

    @Override
    public ActionParameterTypes createParameterTypesFromString(String parameters) {
        return new ActionParameterTypes(parameters);
    }

    @Override
    public ActionParameterTypes createParameterTypesFromJvmModel(boolean isVarargs, List<JvmFormalParameter> parameters) {
        ActionParameterTypes sig = new ActionParameterTypes(isVarargs, parameters.size());
        for (JvmFormalParameter p : parameters) {
            JvmTypeReference paramType = p.getParameterType();
            if (paramType == null) continue;
            sig.add(this.toIdentifier(this.unifiesType(paramType)));
        }
        return sig;
    }

    @Override
    public ActionParameterTypes createParameterTypesForVoid() {
        return new ActionParameterTypes(false, 0);
    }

    @Override
    public ActionPrototype createActionPrototype(String actionName, ActionParameterTypes parameters) {
        return new ActionPrototype(actionName, parameters, false);
    }

    @Override
    public String createFunctionNameForDefaultValueID(String id) {
        int index = id.indexOf(35);
        if (index > 0) {
            return Utils.createNameForHiddenDefaultValueFunction(id.substring(index + 1));
        }
        return Utils.createNameForHiddenDefaultValueFunction(id);
    }

    @Override
    public String qualifyDefaultValueID(String containerQualifiedName, String id) {
        int index = id.indexOf(35);
        if (index > 0) {
            return id;
        }
        return containerQualifiedName + "#" + id;
    }

    @Override
    public String toJavaArgument(String callerQualifiedName, String id) {
        StringBuilder b = new StringBuilder();
        int index = id.indexOf(35);
        if (index > 0) {
            String qn = id.substring(0, index);
            if (!Objects.equals(qn, callerQualifiedName)) {
                b.append(qn);
                b.append(".");
            }
            b.append(Utils.createNameForHiddenDefaultValueFunction(id.substring(index + 1)));
        } else {
            b.append(Utils.createNameForHiddenDefaultValueFunction(id));
        }
        b.append("()");
        return b.toString();
    }

    @Override
    @Pure
    public String extractDefaultValueString(JvmFormalParameter parameter) {
        JvmDeclaredType container;
        String fieldId = this.annotationUtils.findStringValue((JvmAnnotationTarget)parameter, DefaultValue.class);
        if (!Strings.isNullOrEmpty((String)fieldId) && (container = (JvmDeclaredType)EcoreUtil2.getContainerOfType((EObject)parameter, JvmDeclaredType.class)) != null) {
            JvmField field;
            String methodName;
            JvmDeclaredType target;
            int index = fieldId.indexOf(35);
            if (index > 0) {
                JvmDeclaredType cvalue;
                JvmType type = this.references.findDeclaredType(fieldId.substring(0, index), (Notifier)container);
                target = type instanceof JvmDeclaredType ? (cvalue = (JvmDeclaredType)type) : container;
                methodName = Utils.createNameForHiddenDefaultValueFunction(fieldId.substring(index + 1));
            } else {
                target = container;
                methodName = Utils.createNameForHiddenDefaultValueFunction(fieldId);
            }
            JvmOperation operation = (JvmOperation)Iterables.find((Iterable)target.getDeclaredOperations(), it -> Objects.equals(it.getSimpleName(), methodName), null);
            if (operation != null) {
                String value = this.annotationUtils.findStringValue((JvmAnnotationTarget)operation, SarlSourceCode.class);
                if (!Strings.isNullOrEmpty((String)fieldId)) {
                    return value;
                }
            }
            if ((field = (JvmField)Iterables.find((Iterable)target.getDeclaredFields(), it -> Objects.equals(it.getSimpleName(), methodName), null)) != null) {
                String value = this.annotationUtils.findStringValue((JvmAnnotationTarget)field, SarlSourceCode.class);
                if (!Strings.isNullOrEmpty((String)fieldId)) {
                    return value;
                }
            }
        }
        return null;
    }

    private static class Context
    implements IActionPrototypeContext {
        private final InnerMap<String, InnerMap<String, InnerMap<ActionParameterTypes, InferredPrototype>>> prototypes = new InnerMap();
        private final InnerMap<String, InnerMap<String, Integer>> defaultValueIDPrefixes = new InnerMap();

        Context() {
        }

        @Override
        public void release() {
            this.prototypes.getLock().writeLock().lock();
            try {
                this.prototypes.clear();
            }
            finally {
                this.prototypes.getLock().writeLock().unlock();
            }
            this.defaultValueIDPrefixes.getLock().writeLock().lock();
            try {
                this.defaultValueIDPrefixes.clear();
            }
            finally {
                this.defaultValueIDPrefixes.getLock().writeLock().unlock();
            }
        }

        public InnerMap<String, InnerMap<String, Integer>> getDefaultValueIDPrefixes() {
            return this.defaultValueIDPrefixes;
        }

        public InnerMap<String, InnerMap<String, InnerMap<ActionParameterTypes, InferredPrototype>>> getPrototypes() {
            return this.prototypes;
        }
    }

    private static class InnerMap<K, V>
    extends TreeMap<K, V> {
        private static final long serialVersionUID = -7858620757455956027L;
        private final ReadWriteLock lock = new ReentrantReadWriteLock();

        InnerMap() {
        }

        public ReadWriteLock getLock() {
            return this.lock;
        }
    }
}

