/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.sarl.actionprototype;

import com.google.common.base.Strings;
import io.sarl.lang.sarl.actionprototype.ActionParameterTypes;
import io.sarl.lang.sarl.actionprototype.FormalParameterProvider;
import io.sarl.lang.sarl.actionprototype.InferredPrototype;
import io.sarl.lang.sarl.actionprototype.InferredStandardParameter;
import io.sarl.lang.sarl.actionprototype.QualifiedActionName;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultInferredPrototype
implements InferredPrototype {
    private final List<InferredStandardParameter> originalParameters;
    private final Map<ActionParameterTypes, List<InferredStandardParameter>> inferredParameters;
    private final FormalParameterProvider parameters;
    private final ActionParameterTypes parameterKey;
    private final QualifiedActionName key;

    protected DefaultInferredPrototype(QualifiedActionName key, FormalParameterProvider parameters, ActionParameterTypes parameterKey, List<InferredStandardParameter> originalParameters, Map<ActionParameterTypes, List<InferredStandardParameter>> inferredParameters) {
        this.key = key;
        this.parameters = parameters;
        this.parameterKey = parameterKey;
        this.originalParameters = originalParameters;
        this.inferredParameters = inferredParameters;
    }

    @Override
    public QualifiedActionName getActionName() {
        return this.key;
    }

    @Override
    public Map<ActionParameterTypes, List<InferredStandardParameter>> getInferredParameterTypes() {
        return this.inferredParameters;
    }

    @Override
    public List<InferredStandardParameter> getOriginalParameterTypes() {
        return this.originalParameters;
    }

    @Override
    public FormalParameterProvider getFormalParameters() {
        return this.parameters;
    }

    @Override
    public ActionParameterTypes getFormalParameterTypes() {
        return this.parameterKey;
    }

    @Override
    public boolean isVarargs() {
        return this.parameterKey.isVarArg();
    }

    @Override
    public Iterable<ActionParameterTypes> getParameterTypeAlternatives() {
        return new Iterable<ActionParameterTypes>(){

            @Override
            public Iterator<ActionParameterTypes> iterator() {
                return new SignatureKeyIterator(DefaultInferredPrototype.this.getFormalParameterTypes(), DefaultInferredPrototype.this.getInferredParameterTypes().keySet().iterator());
            }
        };
    }

    private void toParameterString(StringBuilder buffer, int param, boolean isVarArg) {
        String name = this.parameters.getFormalParameterName(param);
        buffer.append(!Strings.isNullOrEmpty((String)name) ? name : null);
        buffer.append(" : ");
        String type = this.parameters.getFormalParameterType(param, isVarArg);
        buffer.append(!Strings.isNullOrEmpty((String)type) ? type : null);
    }

    private void toParameterString(StringBuilder buffer) {
        if (this.parameters.getFormalParameterCount() > 0) {
            int lastParamIndex = this.parameters.getFormalParameterCount() - 1;
            for (int i = 0; i < lastParamIndex; ++i) {
                this.toParameterString(buffer, i, false);
                buffer.append(", ");
            }
            this.toParameterString(buffer, lastParamIndex, this.isVarargs());
        }
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        this.toParameterString(b);
        return b.toString();
    }

    @Override
    public String toString(String functionName) {
        StringBuilder b = new StringBuilder();
        b.append(functionName);
        if (this.parameters.getFormalParameterCount() > 0) {
            b.append("(");
            this.toParameterString(b);
            b.append(")");
        }
        return b.toString();
    }

    private static class SignatureKeyIterator
    implements Iterator<ActionParameterTypes> {
        private ActionParameterTypes first;
        private final Iterator<ActionParameterTypes> it;

        SignatureKeyIterator(ActionParameterTypes first, Iterator<ActionParameterTypes> it) {
            this.first = first;
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.first != null || this.it.hasNext();
        }

        @Override
        public ActionParameterTypes next() {
            if (this.first != null) {
                ActionParameterTypes first = this.first;
                this.first = null;
                return first;
            }
            return this.it.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

