/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.sarl.actionprototype;

import io.sarl.lang.core.annotation.DefaultValue;
import io.sarl.lang.sarl.actionprototype.FormalParameterProvider;
import io.sarl.lang.sarl.actionprototype.IActionPrototypeProvider;
import java.lang.ref.WeakReference;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.AnnotationLookup;
import org.eclipse.xtext.xbase.XExpression;

class JvmFormalParameterProvider
implements FormalParameterProvider {
    private final List<JvmFormalParameter> parameters;
    private final AnnotationLookup annotationFinder;
    private final WeakReference<IActionPrototypeProvider> prototypeProvider;

    JvmFormalParameterProvider(List<JvmFormalParameter> parameters, AnnotationLookup annotationFinder, IActionPrototypeProvider prototypeProvider) {
        this.parameters = parameters;
        this.annotationFinder = annotationFinder;
        this.prototypeProvider = new WeakReference<IActionPrototypeProvider>(prototypeProvider);
    }

    @Override
    public int getFormalParameterCount() {
        return this.parameters.size();
    }

    @Override
    public String getFormalParameterName(int position) {
        return this.parameters.get(position).getName();
    }

    @Override
    public String getFormalParameterType(int position, boolean isVarargs) {
        return this.getFormalParameterTypeReference(position, isVarargs).getQualifiedName();
    }

    @Override
    public JvmTypeReference getFormalParameterTypeReference(int position, boolean isVarargs) {
        return this.parameters.get(position).getParameterType();
    }

    @Override
    public boolean hasFormalParameterDefaultValue(int position) {
        JvmFormalParameter parameter = this.parameters.get(position);
        return this.annotationFinder.findAnnotation((JvmAnnotationTarget)parameter, DefaultValue.class) != null;
    }

    @Override
    public XExpression getFormalParameterDefaultValue(int position) {
        return null;
    }

    @Override
    public String getFormalParameterDefaultValueString(int position) {
        JvmFormalParameter parameter = this.parameters.get(position);
        IActionPrototypeProvider provider = (IActionPrototypeProvider)this.prototypeProvider.get();
        if (provider != null) {
            return provider.extractDefaultValueString(parameter);
        }
        return null;
    }

    @Override
    public EObject getFormalParameter(int position) {
        return (EObject)this.parameters.get(position);
    }
}

