/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.sarl.actionprototype;

import com.google.common.base.Objects;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.util.Strings;

public class QualifiedActionName
implements Cloneable,
Serializable,
Comparable<QualifiedActionName> {
    private static final long serialVersionUID = -5590450855487852546L;
    private String resourceID;
    private final WeakReference<JvmIdentifiableElement> declaringType;
    private String functionName;

    protected QualifiedActionName(String resourceID, JvmIdentifiableElement declaringType, String functionName) {
        this.functionName = Strings.emptyIfNull((String)functionName);
        this.resourceID = Strings.emptyIfNull((String)resourceID);
        this.declaringType = new WeakReference<JvmIdentifiableElement>(declaringType);
    }

    public String getResourceID() {
        return this.resourceID;
    }

    public JvmIdentifiableElement getDeclaringType() {
        return (JvmIdentifiableElement)this.declaringType.get();
    }

    public String getActionName() {
        return this.functionName;
    }

    public QualifiedActionName clone() {
        try {
            return (QualifiedActionName)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            QualifiedActionName k = (QualifiedActionName)obj;
            return Objects.equal((Object)this.resourceID, (Object)k.resourceID) && Objects.equal((Object)((JvmIdentifiableElement)this.declaringType.get()).getQualifiedName(), (Object)((JvmIdentifiableElement)k.declaringType.get()).getQualifiedName()) && Objects.equal((Object)this.functionName, (Object)k.functionName);
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        hash = 31 * hash + this.resourceID.hashCode();
        hash = 31 * hash + this.declaringType.hashCode();
        hash = 31 * hash + this.functionName.hashCode();
        return hash;
    }

    public String toString() {
        return this.getContainerID() + "#" + this.functionName;
    }

    public String getContainerID() {
        return this.resourceID + "/" + ((JvmIdentifiableElement)this.declaringType.get()).getQualifiedName();
    }

    @Override
    public int compareTo(QualifiedActionName otherName) {
        if (otherName == null) {
            return Integer.MAX_VALUE;
        }
        int cmp = this.resourceID.compareTo(otherName.resourceID);
        if (cmp != 0) {
            return cmp;
        }
        cmp = ((JvmIdentifiableElement)this.declaringType.get()).getQualifiedName().compareTo(((JvmIdentifiableElement)otherName.declaringType.get()).getQualifiedName());
        if (cmp != 0) {
            return cmp;
        }
        return this.functionName.compareTo(otherName.functionName);
    }
}

