/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.serializer;

import io.sarl.lang.documentation.IEcoreDocumentationBuilder;
import io.sarl.lang.documentation.InnerBlockDocumentationAdapter;
import io.sarl.lang.serializer.SARLSyntacticSequencer;
import io.sarl.lang.services.SARLGrammarKeywordAccess;
import jakarta.inject.Inject;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.ISequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.ISyntacticSequenceAcceptor;
import org.eclipse.xtext.serializer.analysis.ISyntacticSequencerPDAProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic;
import org.eclipse.xtext.serializer.sequencer.HiddenTokenSequencer;
import org.eclipse.xtext.serializer.sequencer.RuleCallStack;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.compiler.DocumentationAdapter;

public class SARLEcoreDocumentationSyntacticSequencer
extends SARLSyntacticSequencer {
    private final Set<EObject> documentedSemanticObjects = new HashSet<EObject>();
    private final Set<EObject> indocumentedSemanticObjects = new HashSet<EObject>();
    private InnerBlockDocumentationAdapter lastInnerBlock;
    @Inject
    private IEcoreDocumentationBuilder documentationBuilder;
    @Inject
    private SARLGrammarKeywordAccess keywords;
    private ISequenceAcceptor trailingSequenceAcceptor;

    public void init(ISerializationContext context, EObject semanticObject, ISyntacticSequenceAcceptor sequenceAcceptor, ISerializationDiagnostic.Acceptor errorAcceptor) {
        super.init(context, semanticObject, sequenceAcceptor, errorAcceptor);
        if (sequenceAcceptor instanceof ISequenceAcceptor) {
            ISequenceAcceptor $c$value;
            this.trailingSequenceAcceptor = $c$value = (ISequenceAcceptor)sequenceAcceptor;
        }
        this.documentedSemanticObjects.clear();
        this.indocumentedSemanticObjects.clear();
        this.lastInnerBlock = null;
    }

    protected ISequenceAcceptor getTrailingSequenceAcceptor() {
        if (this.trailingSequenceAcceptor == null) {
            try {
                Field delegateField = HiddenTokenSequencer.class.getDeclaredField("delegate");
                delegateField.setAccessible(true);
                this.trailingSequenceAcceptor = (ISequenceAcceptor)delegateField.get(this.delegate);
            }
            catch (Throwable exception) {
                throw new RuntimeException(exception);
            }
        }
        return this.trailingSequenceAcceptor;
    }

    protected void emitDocumentation(Class<?> semanticObjectType, String comment) {
        String fmtcomment = this.documentationBuilder.build(comment, semanticObjectType);
        if (!Strings.isEmpty((String)fmtcomment)) {
            AbstractRule rule = this.documentationBuilder.isMultilineCommentFor(semanticObjectType) ? this.documentationBuilder.getMLCommentRule() : this.documentationBuilder.getSLCommentRule();
            this.getTrailingSequenceAcceptor().acceptComment(rule, fmtcomment, null);
        }
    }

    protected void emitDocumentation(EObject semanticObject) {
        DocumentationAdapter documentationAdapter;
        if (this.documentedSemanticObjects.add(semanticObject) && (documentationAdapter = (DocumentationAdapter)EcoreUtil.getAdapter((List)semanticObject.eAdapters(), DocumentationAdapter.class)) != null) {
            this.emitDocumentation(semanticObject.getClass(), documentationAdapter.getDocumentation());
        }
    }

    protected void emitInnerDocumentation(EObject semanticObject) {
        InnerBlockDocumentationAdapter documentationAdapter;
        if (this.indocumentedSemanticObjects.add(semanticObject) && (documentationAdapter = (InnerBlockDocumentationAdapter)EcoreUtil.getAdapter((List)semanticObject.eAdapters(), InnerBlockDocumentationAdapter.class)) != null) {
            this.emitDocumentation(semanticObject.getClass(), documentationAdapter.getDocumentation());
        }
    }

    private InnerBlockDocumentationAdapter getInnerDocumentation(EObject semanticObject) {
        if (this.indocumentedSemanticObjects.add(semanticObject)) {
            return (InnerBlockDocumentationAdapter)EcoreUtil.getAdapter((List)semanticObject.eAdapters(), InnerBlockDocumentationAdapter.class);
        }
        return null;
    }

    @Override
    protected void emitUnassignedTokens(EObject semanticObject, ISyntacticSequencerPDAProvider.ISynTransition transition, INode fromNode, INode toNode) {
        super.emitUnassignedTokens(semanticObject, transition, fromNode, toNode);
        this.emitDocumentation(semanticObject);
        if (semanticObject instanceof XBlockExpression) {
            XBlockExpression cblock = (XBlockExpression)semanticObject;
            this.lastInnerBlock = this.getInnerDocumentation((EObject)cblock);
        }
    }

    protected void accept(ISyntacticSequencerPDAProvider.ISynState emitter, INode node, RuleCallStack stack) {
        super.accept(emitter, node, stack);
        InnerBlockDocumentationAdapter documentation = this.lastInnerBlock;
        if (documentation != null && emitter.getType() == ISyntacticSequencerPDAProvider.SynStateType.UNASSIGEND_KEYWORD) {
            String token;
            Keyword keyword = (Keyword)emitter.getGrammarElement();
            String string = token = node != null ? node.getText() : keyword.getValue();
            if (Strings.equal((String)token, (String)this.keywords.getLeftCurlyBracketKeyword())) {
                this.lastInnerBlock = null;
                this.emitDocumentation(documentation.getTarget().getClass(), documentation.getDocumentation());
            }
        }
    }
}

