/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.services;

import io.sarl.lang.services.ITypeDefaultValueProvider;
import io.sarl.lang.services.SARLGrammarKeywordAccess;
import jakarta.inject.Inject;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeReferences;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XNullLiteral;
import org.eclipse.xtext.xbase.XNumberLiteral;
import org.eclipse.xtext.xbase.XbaseFactory;
import org.eclipse.xtext.xbase.lib.Pure;

public class TypeDefaultValueProviderImpl
implements ITypeDefaultValueProvider {
    private TypeReferences typeReferences;
    private SARLGrammarKeywordAccess keywords;

    @Inject
    public void setTypeReferences(TypeReferences typeReferences) {
        this.typeReferences = typeReferences;
    }

    @Inject
    public void setKeywords(SARLGrammarKeywordAccess keywords) {
        this.keywords = keywords;
    }

    @Override
    @Pure
    public Object getDefaultValue(JvmType type) {
        if (type == null) {
            return null;
        }
        return this.getDefaultValue(type.getQualifiedName());
    }

    @Override
    @Pure
    public Object getDefaultValue(String typeName) {
        Comparable<Boolean> defaultValue = null;
        if (!Strings.isEmpty((String)typeName) && !"void".equals(typeName)) {
            switch (typeName) {
                case "boolean": 
                case "java.lang.Boolean": 
                case "java.util.concurrent.atomic.AtomicBoolean": {
                    defaultValue = Boolean.FALSE;
                    break;
                }
                case "double": 
                case "java.lang.Double": 
                case "com.google.common.util.concurrent.AtomicDouble": 
                case "java.math.BigDecimal": {
                    defaultValue = 0.0;
                    break;
                }
                case "float": 
                case "java.lang.Float": {
                    defaultValue = Float.valueOf(0.0f);
                    break;
                }
                case "int": 
                case "java.lang.Integer": 
                case "java.util.concurrent.atomic.AtomicInteger": 
                case "java.math.BigInteger": {
                    defaultValue = 0;
                    break;
                }
                case "long": 
                case "java.lang.Long": 
                case "java.util.concurrent.atomic.AtomicLong": {
                    defaultValue = 0L;
                    break;
                }
                case "byte": 
                case "java.lang.Byte": {
                    defaultValue = (byte)0;
                    break;
                }
                case "short": 
                case "java.lang.Short": {
                    defaultValue = (short)0;
                    break;
                }
                case "char": 
                case "java.lang.Character": {
                    defaultValue = Character.valueOf('\u0000');
                    break;
                }
                default: {
                    defaultValue = null;
                }
            }
        }
        return defaultValue;
    }

    @Override
    @Pure
    public String getDefaultValueInSarlSyntax(JvmType type) {
        if (type == null) {
            return null;
        }
        return this.getDefaultValueInSarlSyntax(type.getQualifiedName());
    }

    @Override
    @Pure
    public String getDefaultValueInSarlSyntax(String typeName) {
        Object defaultValue = "";
        if (!Strings.isEmpty((String)typeName) && !"void".equals(typeName)) {
            switch (typeName) {
                case "boolean": 
                case "java.lang.Boolean": 
                case "java.util.concurrent.atomic.AtomicBoolean": {
                    defaultValue = "false";
                    break;
                }
                case "double": 
                case "java.lang.Double": 
                case "com.google.common.util.concurrent.AtomicDouble": 
                case "java.math.BigDecimal": {
                    defaultValue = "0.0";
                    break;
                }
                case "float": 
                case "java.lang.Float": {
                    defaultValue = "0.0f";
                    break;
                }
                case "int": 
                case "java.lang.Integer": 
                case "long": 
                case "java.lang.Long": 
                case "java.util.concurrent.atomic.AtomicInteger": 
                case "java.util.concurrent.atomic.AtomicLong": 
                case "java.math.BigInteger": {
                    defaultValue = "0";
                    break;
                }
                case "byte": 
                case "java.lang.Byte": {
                    defaultValue = "(0 " + this.keywords.getAsKeyword() + " byte)";
                    break;
                }
                case "short": 
                case "java.lang.Short": {
                    defaultValue = "(0 " + this.keywords.getAsKeyword() + " short)";
                    break;
                }
                case "char": 
                case "java.lang.Character": {
                    defaultValue = "(0 " + this.keywords.getAsKeyword() + " char)";
                    break;
                }
                default: {
                    defaultValue = "null";
                }
            }
        }
        return defaultValue;
    }

    @Override
    @Pure
    public XExpression getDefaultValueXExpression(JvmType type, Notifier notifier) {
        if (type == null) {
            return null;
        }
        return this.getDefaultValueXExpression(type.getQualifiedName(), notifier);
    }

    @Override
    @Pure
    public XExpression getDefaultValueXExpression(String typeName, Notifier notifier) {
        XNullLiteral expr = null;
        if (typeName != null && !"void".equals(typeName) && !Void.class.getName().equals(typeName)) {
            switch (typeName) {
                case "boolean": 
                case "java.lang.Boolean": 
                case "java.util.concurrent.atomic.AtomicBoolean": {
                    XBooleanLiteral booleanLiteral = XbaseFactory.eINSTANCE.createXBooleanLiteral();
                    booleanLiteral.setIsTrue(false);
                    expr = booleanLiteral;
                    break;
                }
                case "float": 
                case "java.lang.Float": {
                    XNumberLiteral floatLiteral = XbaseFactory.eINSTANCE.createXNumberLiteral();
                    floatLiteral.setValue("0.0f");
                    expr = floatLiteral;
                    break;
                }
                case "double": 
                case "java.lang.Double": 
                case "com.google.common.util.concurrent.AtomicDouble": 
                case "java.math.BigDecimal": {
                    XNumberLiteral doubleLiteral = XbaseFactory.eINSTANCE.createXNumberLiteral();
                    doubleLiteral.setValue("0.0");
                    expr = doubleLiteral;
                    break;
                }
                case "int": 
                case "java.lang.Integer": 
                case "long": 
                case "java.lang.Long": 
                case "java.util.concurrent.atomic.AtomicInteger": 
                case "java.util.concurrent.atomic.AtomicLong": 
                case "java.math.BigInteger": {
                    XNumberLiteral intLiteral = XbaseFactory.eINSTANCE.createXNumberLiteral();
                    intLiteral.setValue("0");
                    expr = intLiteral;
                    break;
                }
                case "byte": 
                case "java.lang.Byte": {
                    expr = this.createCastExpression("byte", notifier);
                    break;
                }
                case "short": 
                case "java.lang.Short": {
                    expr = this.createCastExpression("short", notifier);
                    break;
                }
                case "char": 
                case "java.lang.Character": {
                    expr = this.createCastExpression("char", notifier);
                    break;
                }
                default: {
                    expr = XbaseFactory.eINSTANCE.createXNullLiteral();
                }
            }
        }
        return expr;
    }

    private XExpression createCastExpression(String targetTypeName, Notifier notifier) {
        XNumberLiteral cnumberLiteral = XbaseFactory.eINSTANCE.createXNumberLiteral();
        cnumberLiteral.setValue("0");
        XCastedExpression castExpression = XbaseFactory.eINSTANCE.createXCastedExpression();
        castExpression.setTarget((XExpression)cnumberLiteral);
        castExpression.setType(this.typeReferences.getTypeForName(targetTypeName, notifier, new JvmTypeReference[0]));
        return castExpression;
    }
}

