/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.typesystem;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.sarl.lang.core.Event;
import io.sarl.lang.typesystem.IImmutableTypeValidator;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.security.Permission;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import org.eclipse.xtend.lib.Data;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.util.AnnotationLookup;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

@Singleton
public class DefaultImmutableTypeValidator
implements IImmutableTypeValidator {
    public static final Class<?>[] IMMUTABLE_TYPES = new Class[]{String.class, UUID.class, URL.class, URI.class, Annotation.class, Enum.class, Byte.class, Short.class, Integer.class, Long.class, Double.class, Float.class, Character.class, Boolean.class, Date.class, File.class, Locale.class, InetAddress.class, StackTraceElement.class, Permission.class, Clock.class, Duration.class, Instant.class, LocalDate.class, LocalDateTime.class, LocalTime.class, MonthDay.class, OffsetDateTime.class, OffsetTime.class, Period.class, Year.class, YearMonth.class, ZonedDateTime.class, ZoneId.class, ZoneOffset.class, org.eclipse.xtext.util.Pair.class, Pair.class, Event.class};
    public static final Class<?>[] IMMUTABLE_TYPE_ANNOTATIONS = new Class[]{org.eclipse.xtend.lib.annotations.Data.class, Data.class};
    private AnnotationLookup annotationFinder;

    @Inject
    public void setAnnotationLookup(AnnotationLookup finder) {
        assert (finder != null);
        this.annotationFinder = finder;
    }

    @Override
    public boolean isImmutable(LightweightTypeReference type) {
        assert (type != null);
        if (this.isAlwaysMutable(type)) {
            return false;
        }
        if (this.isAlwaysImmutable(type)) {
            return true;
        }
        if (this.hasImmutableAnnotation(type)) {
            return true;
        }
        return this.isRegisteredImmutableType(type);
    }

    protected boolean isAlwaysMutable(LightweightTypeReference ref) {
        return ref.isArray() || ref.isAnonymous() || ref.isAny() || ref.isUnknown() || ref.isFunctionType();
    }

    protected boolean isAlwaysImmutable(LightweightTypeReference ref) {
        LightweightTypeReference pref = ref.getPrimitiveIfWrapperType();
        return pref.isPrimitive() || pref.isPrimitiveVoid();
    }

    protected boolean hasImmutableAnnotation(LightweightTypeReference ref) {
        JvmType backType = ref.getType();
        if (backType instanceof JvmAnnotationTarget) {
            JvmAnnotationTarget target = (JvmAnnotationTarget)backType;
            for (Class<?> jvmType : IMMUTABLE_TYPE_ANNOTATIONS) {
                if (this.annotationFinder.findAnnotation(target, jvmType.getCanonicalName()) == null) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isRegisteredImmutableType(LightweightTypeReference ref) {
        for (Class<?> jvmType : IMMUTABLE_TYPES) {
            if (!ref.isSubtypeOf(jvmType)) continue;
            return true;
        }
        return false;
    }
}

