/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.typesystem;

import com.google.inject.Singleton;
import io.sarl.lang.typesystem.ISARLTypeChecker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputer;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;

@Singleton
public class DefaultSARLTypeChecker
implements ISARLTypeChecker {
    private static final TypeConformanceComputationArgument CONFORMANCE_OPTIONS = new TypeConformanceComputationArgument(false, false, true, true, false, true);
    private static final TypeConformanceComputationArgument RAW_CONFORMANCE_OPTIONS = new TypeConformanceComputationArgument(true, false, true, true, false, true);

    @Override
    public int getTypeArgumentConformance(List<LightweightTypeReference> typeArguments, List<JvmTypeParameter> typeParameters, ITypeReferenceOwner referenceOwner) {
        int maxArgumentSize = Math.min(typeArguments.size(), typeParameters.size());
        if (maxArgumentSize == 0) {
            return typeArguments.size() == typeParameters.size() ? 512 : 262144;
        }
        TypeConformanceComputer conformanceComputer = referenceOwner.getServices().getTypeConformanceComputer();
        return DefaultSARLTypeChecker.getTypeArgumentConformance(typeParameters, it -> referenceOwner.newParameterizedTypeReference((JvmType)it), typeArguments, referenceOwner, conformanceComputer, new TreeSet<Pair<String, String>>((a, b) -> {
            if (a == b) {
                return 0;
            }
            if (a == null) {
                return -1;
            }
            if (b == null) {
                return 1;
            }
            int cmp = ((String)a.getKey()).compareTo((String)b.getKey());
            if (cmp != 0) {
                return cmp;
            }
            return ((String)a.getValue()).compareTo((String)b.getValue());
        }));
    }

    private static <T> int getTypeArgumentConformance(List<T> leftTypes, Functions.Function1<T, LightweightTypeReference> mapper, List<LightweightTypeReference> rightTypes, ITypeReferenceOwner referenceOwner, TypeConformanceComputer conformanceComputer, Set<Pair<String, String>> analyzedTypes) {
        int maxTypesSize = Math.min(leftTypes.size(), rightTypes.size());
        int conformance = 512;
        for (int i = 0; i < maxTypesSize; ++i) {
            LightweightTypeReference left = (LightweightTypeReference)mapper.apply(leftTypes.get(i));
            LightweightTypeReference right = rightTypes.get(i);
            if (left.getType() == right.getType() || ((conformance = DefaultSARLTypeChecker.getTypeArgumentConformance(left, right, referenceOwner, conformanceComputer, analyzedTypes)) & 0x200) != 0) continue;
            return conformance;
        }
        return conformance;
    }

    private static int getTypeArgumentConformance(LightweightTypeReference left, LightweightTypeReference right, ITypeReferenceOwner referenceOwner, TypeConformanceComputer conformanceComputer, Set<Pair<String, String>> analyzedTypes) {
        LightweightTypeReference left1 = DefaultSARLTypeChecker.substitute(left, referenceOwner);
        LightweightTypeReference right1 = DefaultSARLTypeChecker.substitute(right, referenceOwner);
        if (DefaultSARLTypeChecker.isParameterizedType(left1)) {
            LightweightTypeReference rawRight;
            LightweightTypeReference rawLeft = left1.getRawTypeReference();
            int conformance = conformanceComputer.isConformant(rawLeft, rawRight = right1.getRawTypeReference(), RAW_CONFORMANCE_OPTIONS);
            if ((conformance & 0x200) != 0) {
                Pair key = Pair.of((Object)rawLeft.getIdentifier(), (Object)rawRight.getIdentifier());
                if (!analyzedTypes.add((Pair<String, String>)key)) {
                    return conformance;
                }
                if ((conformance & 0x800) != 0) {
                    String id = rawLeft.getIdentifier();
                    Iterator iter = right1.getAllSuperTypes().stream().filter(it -> id.equals(it.getRawTypeReference().getIdentifier())).iterator();
                    while (iter.hasNext()) {
                        LightweightTypeReference candidate = (LightweightTypeReference)iter.next();
                        conformance = DefaultSARLTypeChecker.getTypeArgumentConformance(left1, candidate, referenceOwner, conformanceComputer, analyzedTypes);
                        if ((conformance & 0x200) != 0) continue;
                        return conformance;
                    }
                } else {
                    List leftTypes = left1.getTypeArguments();
                    List rightTypes = right1.getTypeArguments();
                    conformance = DefaultSARLTypeChecker.getTypeArgumentConformance(leftTypes, it -> it, rightTypes, referenceOwner, conformanceComputer, analyzedTypes);
                }
            }
            return conformance;
        }
        return conformanceComputer.isConformant(left1, right1.getRawTypeReference(), CONFORMANCE_OPTIONS);
    }

    private static LightweightTypeReference substitute(LightweightTypeReference reference, ITypeReferenceOwner referenceOwner) {
        LightweightTypeReference ref = reference;
        while (ref instanceof WildcardTypeReference) {
            WildcardTypeReference cvalue = (WildcardTypeReference)ref;
            LightweightTypeReference bound = cvalue.getUpperBoundSubstitute();
            ref = bound.copyInto(referenceOwner);
        }
        if (ref.getType() instanceof JvmTypeParameter) {
            return ref.getConstraintSubstitute();
        }
        return ref;
    }

    private static boolean isParameterizedType(LightweightTypeReference type) {
        JvmType jvmType = type.getType();
        if (jvmType instanceof JvmTypeParameterDeclarator) {
            JvmTypeParameterDeclarator gtype = (JvmTypeParameterDeclarator)jvmType;
            return !gtype.getTypeParameters().isEmpty();
        }
        return false;
    }

    private static LightweightTypeReference substitute(LightweightTypeReference argument, JvmTypeParameter parameter, ITypeReferenceOwner referenceOwner) {
        if (argument instanceof WildcardTypeReference) {
            WildcardTypeReference wild = (WildcardTypeReference)argument;
            LightweightTypeReference upper = wild.getUpperBoundSubstitute();
            if (upper.isType(Object.class)) {
                upper = DefaultSARLTypeChecker.getTypeParameterSubstitute(parameter, referenceOwner);
            }
            return upper;
        }
        return argument;
    }

    private static LightweightTypeReference getTypeParameterSubstitute(JvmTypeParameter parameter, ITypeReferenceOwner referenceOwner) {
        LightweightTypeReference parameterReference = referenceOwner.toLightweightTypeReference((JvmType)parameter);
        return parameterReference.getUpperBoundSubstitute();
    }

    @Override
    public List<LightweightTypeReference> substituteRootWildcard(List<LightweightTypeReference> arguments, List<JvmTypeParameter> parameters, ITypeReferenceOwner referenceOwner) {
        ArrayList<LightweightTypeReference> result = new ArrayList<LightweightTypeReference>(parameters.size());
        int i = 0;
        for (JvmTypeParameter parameter : parameters) {
            LightweightTypeReference arg;
            if (i < arguments.size()) {
                LightweightTypeReference argument = arguments.get(i);
                arg = DefaultSARLTypeChecker.substitute(argument, parameter, referenceOwner);
            } else {
                arg = DefaultSARLTypeChecker.getTypeParameterSubstitute(parameter, referenceOwner);
            }
            result.add(arg);
            ++i;
        }
        return result;
    }
}

