/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.typesystem;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.sarl.lang.core.Agent;
import io.sarl.lang.core.Behavior;
import io.sarl.lang.core.Capacity;
import io.sarl.lang.core.Event;
import io.sarl.lang.core.Skill;
import io.sarl.lang.core.annotation.SarlElementType;
import io.sarl.lang.jvmmodel.SarlJvmModelAssociations;
import io.sarl.lang.typesystem.SARLAnnotationUtil;
import io.sarl.lang.util.Utils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmGenericType;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

@Singleton
public class InheritanceHelper {
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private SarlJvmModelAssociations sarlAssociations;
    @Inject
    private SARLAnnotationUtil annotationUtil;

    public boolean isSubTypeOf(JvmTypeReference candidate, Class<?> jvmSuperType, Class<? extends XtendTypeDeclaration> sarlSuperType) {
        LightweightTypeReference reference = Utils.toLightweightTypeReference(candidate, this.services);
        return this.isSubTypeOf(reference, jvmSuperType, sarlSuperType);
    }

    public boolean isSubTypeOf(JvmTypeReference candidate, Class<?> jvmSuperType, Class<? extends XtendTypeDeclaration> sarlSuperType, boolean onlyInterface) {
        LightweightTypeReference reference = Utils.toLightweightTypeReference(candidate, this.services);
        if (reference.isInterfaceType() != onlyInterface) {
            return false;
        }
        return this.isSubTypeOf(reference, jvmSuperType, sarlSuperType);
    }

    public boolean isSubTypeOf(JvmType candidate, Class<?> jvmSuperType, Class<? extends XtendTypeDeclaration> sarlSuperType) {
        LightweightTypeReference reference = Utils.toLightweightTypeReference(candidate, this.services);
        return this.isSubTypeOf(reference, jvmSuperType, sarlSuperType);
    }

    public boolean isSubTypeOf(JvmType candidate, Class<?> jvmSuperType, Class<? extends XtendTypeDeclaration> sarlSuperType, boolean onlyInterface) {
        LightweightTypeReference reference = Utils.toLightweightTypeReference(candidate, this.services);
        if (reference.isInterfaceType() != onlyInterface) {
            return false;
        }
        return this.isSubTypeOf(reference, jvmSuperType, sarlSuperType);
    }

    public boolean isSubTypeOf(LightweightTypeReference candidate, Class<?> jvmSuperType, Class<? extends XtendTypeDeclaration> sarlSuperType) {
        JvmGenericType genType;
        JvmType type;
        if (candidate.isSubtypeOf(jvmSuperType)) {
            return true;
        }
        if (sarlSuperType != null && (type = candidate.getType()) instanceof JvmGenericType && (genType = (JvmGenericType)type).getSuperTypes().isEmpty()) {
            for (EObject sarlObject : this.sarlAssociations.getSourceElements((EObject)type)) {
                if (!sarlSuperType.isInstance(sarlObject)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isProxyOrSubTypeOf(JvmTypeReference candidate, Class<?> jvmSuperType, Class<? extends XtendTypeDeclaration> sarlSuperType) {
        LightweightTypeReference reference = Utils.toLightweightTypeReference(candidate, this.services);
        return this.isSubTypeOf(reference, jvmSuperType, sarlSuperType);
    }

    public boolean isProxyOrSubTypeOf(JvmTypeReference candidate, Class<?> jvmSuperType, Class<? extends XtendTypeDeclaration> sarlSuperType, boolean onlyInterface) {
        if (candidate.eIsProxy()) {
            return true;
        }
        return this.isSubTypeOf(candidate, jvmSuperType, sarlSuperType, onlyInterface);
    }

    public boolean isProxyOrSubTypeOf(LightweightTypeReference candidate, Class<?> jvmSuperType, Class<? extends XtendTypeDeclaration> sarlSuperType) {
        if (!candidate.isResolved()) {
            return true;
        }
        return this.isSubTypeOf(candidate, jvmSuperType, sarlSuperType);
    }

    public int getSarlElementEcoreType(JvmGenericType type) {
        Integer intValue;
        JvmAnnotationReference annotationRef = this.annotationUtil.findAnnotation((JvmAnnotationTarget)type, SarlElementType.class.getName());
        if (annotationRef != null && (intValue = this.annotationUtil.findIntValue(annotationRef)) != null) {
            return intValue;
        }
        return 0;
    }

    public int getSarlElementEcoreType(LightweightTypeReference type) {
        JvmType jvmType = type.getType();
        if (jvmType instanceof JvmGenericType) {
            JvmGenericType cvalue = (JvmGenericType)jvmType;
            return this.getSarlElementEcoreType(cvalue);
        }
        return 0;
    }

    public boolean isSarlAgent(JvmGenericType type) {
        return !type.isInterface() && this.getSarlElementEcoreType(type) == 19;
    }

    public boolean isSarlAgent(LightweightTypeReference type) {
        return !type.isInterfaceType() && (this.getSarlElementEcoreType(type) == 19 || type.isSubtypeOf(Agent.class));
    }

    public boolean isSarlBehavior(JvmGenericType type) {
        return !type.isInterface() && this.getSarlElementEcoreType(type) == 21;
    }

    public boolean isSarlBehavior(LightweightTypeReference type) {
        return !type.isInterfaceType() && (this.getSarlElementEcoreType(type) == 21 || type.isSubtypeOf(Behavior.class));
    }

    public boolean isSarlCapacity(JvmGenericType type) {
        return type.isInterface() && this.getSarlElementEcoreType(type) == 20;
    }

    public boolean isSarlCapacity(LightweightTypeReference type) {
        return type.isInterfaceType() && (this.getSarlElementEcoreType(type) == 20 || type.isSubtypeOf(Capacity.class));
    }

    public boolean isSarlEvent(JvmGenericType type) {
        return !type.isInterface() && this.getSarlElementEcoreType(type) == 15;
    }

    public boolean isSarlEvent(LightweightTypeReference type) {
        return !type.isInterfaceType() && (this.getSarlElementEcoreType(type) == 15 || type.isSubtypeOf(Event.class));
    }

    public boolean isSarlSkill(JvmGenericType type) {
        return !type.isInterface() && this.getSarlElementEcoreType(type) == 22;
    }

    public boolean isSarlSkill(LightweightTypeReference type) {
        return !type.isInterfaceType() && (this.getSarlElementEcoreType(type) == 22 || type.isSubtypeOf(Skill.class));
    }
}

