/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.typesystem;

import com.google.inject.Singleton;
import io.sarl.lang.typesystem.IPureOperationNameValidator;
import java.util.regex.Pattern;

@Singleton
public class PureOperationNameValidator
implements IPureOperationNameValidator {
    public static final String[] SPECIAL_PURE_FUNCTION_NAME_PATTERNS = new String[]{"abs", "a?cos", "a?sin", "atan2?", "cbrt", "ceil", "clone", "compare", "compareTo", "contains(?:[A-Z1-9_][a-zA-Z1-9_]*)?", "cosh", "equals", "empty(?:[A-Z1-9_][a-zA-Z1-9_]*)?", "exp", "floor", "get(?:[A-Z1-9_][a-zA-Z1-9_]*)?", "has[A-Z1-9_][a-zA-Z1-9_]*", "hashCode", "hypot", "is[A-Z1-9_][a-zA-Z1-9_]*", "iterator", "length", "log(?:1[0p])?", "max", "min", "pow", "random", "rint", "round", "si(?:(?:gnum)|(?:nh))", "sqrt", "tanh?", "to[A-Z1-9_][a-zA-Z1-9_]*", "ulp", "size"};
    public static final String[] SPECIAL_NOTPURE_FUNCTION_NAME_PATTERNS = new String[]{"set(?:[A-Z1-9].*)?", "print(?:(?:ln)|(?:[A-Z1-9].*))?"};
    private Pattern purePattern;
    private Pattern notPurePattern;

    public PureOperationNameValidator() {
        this.purePattern = PureOperationNameValidator.buildPurePattern(SPECIAL_PURE_FUNCTION_NAME_PATTERNS, new String[0]);
        this.notPurePattern = PureOperationNameValidator.buildPurePattern(SPECIAL_NOTPURE_FUNCTION_NAME_PATTERNS, new String[0]);
    }

    public PureOperationNameValidator(String ... additionalSpecialPureFunctionNamePatterns) {
        this.purePattern = PureOperationNameValidator.buildPurePattern(SPECIAL_PURE_FUNCTION_NAME_PATTERNS, additionalSpecialPureFunctionNamePatterns);
        this.notPurePattern = PureOperationNameValidator.buildPurePattern(SPECIAL_NOTPURE_FUNCTION_NAME_PATTERNS, new String[0]);
    }

    private static Pattern buildPurePattern(String[] patterns, String ... additionalPatterns) {
        StringBuilder fullPattern = new StringBuilder();
        fullPattern.append("^");
        boolean hasPattern = false;
        for (String pattern : patterns) {
            if (hasPattern) {
                fullPattern.append("|");
            } else {
                hasPattern = true;
            }
            fullPattern.append("(?:");
            fullPattern.append(pattern);
            fullPattern.append(")");
        }
        if (additionalPatterns != null && additionalPatterns.length > 0) {
            for (String pattern : additionalPatterns) {
                if (hasPattern) {
                    fullPattern.append("|");
                } else {
                    hasPattern = true;
                }
                fullPattern.append("(?:");
                fullPattern.append(pattern);
                fullPattern.append(")");
            }
        }
        fullPattern.append("$");
        return Pattern.compile(fullPattern.toString());
    }

    @Override
    public boolean isNamePatternForPureOperation(String name) {
        return name != null && this.purePattern.matcher(name).matches();
    }

    @Override
    public boolean isNamePatternForNotPureOperation(String name) {
        return name != null && this.notPurePattern.matcher(name).matches();
    }
}

