/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.typesystem;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmAnnotationType;
import org.eclipse.xtext.common.types.JvmAnnotationValue;
import org.eclipse.xtext.common.types.JvmBooleanAnnotationValue;
import org.eclipse.xtext.common.types.JvmIntAnnotationValue;
import org.eclipse.xtext.common.types.JvmStringAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.util.AnnotationLookup;

@Singleton
public class SARLAnnotationUtil {
    @Inject
    private AnnotationLookup lookup;

    public String findStringValue(JvmAnnotationTarget op, Class<? extends Annotation> annotationType) {
        JvmAnnotationReference reference = this.lookup.findAnnotation(op, annotationType);
        if (reference != null) {
            return this.findStringValue(reference);
        }
        return null;
    }

    public String findStringValue(JvmAnnotationReference reference) {
        assert (reference != null);
        for (JvmAnnotationValue value : reference.getValues()) {
            if (!(value instanceof JvmStringAnnotationValue)) continue;
            JvmStringAnnotationValue cvalue = (JvmStringAnnotationValue)value;
            for (String strValue : cvalue.getValues()) {
                if (strValue == null) continue;
                return strValue;
            }
        }
        return null;
    }

    public List<String> findStringValues(JvmAnnotationTarget op, Class<? extends Annotation> annotationType) {
        JvmAnnotationReference reference = this.lookup.findAnnotation(op, annotationType);
        if (reference != null) {
            return this.findStringValues(reference);
        }
        return null;
    }

    public List<String> findStringValues(JvmAnnotationReference reference) {
        assert (reference != null);
        ArrayList<String> values = new ArrayList<String>();
        for (JvmAnnotationValue value : reference.getValues()) {
            if (!(value instanceof JvmStringAnnotationValue)) continue;
            JvmStringAnnotationValue cvalue = (JvmStringAnnotationValue)value;
            for (String strValue : cvalue.getValues()) {
                if (strValue == null) continue;
                values.add(strValue);
            }
        }
        return values;
    }

    public List<JvmTypeReference> findTypeValues(JvmAnnotationTarget op, Class<? extends Annotation> annotationType) {
        JvmAnnotationReference reference = this.lookup.findAnnotation(op, annotationType);
        if (reference != null) {
            return this.findTypeValues(reference);
        }
        return null;
    }

    public List<JvmTypeReference> findTypeValues(JvmAnnotationReference reference) {
        assert (reference != null);
        ArrayList<JvmTypeReference> values = new ArrayList<JvmTypeReference>();
        for (JvmAnnotationValue value : reference.getValues()) {
            if (!(value instanceof JvmTypeAnnotationValue)) continue;
            JvmTypeAnnotationValue cvalue = (JvmTypeAnnotationValue)value;
            for (JvmTypeReference strValue : cvalue.getValues()) {
                if (strValue == null) continue;
                values.add(strValue);
            }
        }
        return values;
    }

    public Integer findIntValue(JvmAnnotationTarget op, Class<? extends Annotation> annotationType) {
        JvmAnnotationReference reference = this.lookup.findAnnotation(op, annotationType);
        if (reference != null) {
            return this.findIntValue(reference);
        }
        return null;
    }

    public Integer findIntValue(JvmAnnotationReference reference) {
        assert (reference != null);
        for (JvmAnnotationValue value : reference.getValues()) {
            if (!(value instanceof JvmIntAnnotationValue)) continue;
            JvmIntAnnotationValue cvalue = (JvmIntAnnotationValue)value;
            for (Integer intValue : cvalue.getValues()) {
                if (intValue == null) continue;
                return intValue;
            }
        }
        return null;
    }

    public List<Integer> findIntValues(JvmAnnotationTarget op, Class<? extends Annotation> annotationType) {
        JvmAnnotationReference reference = this.lookup.findAnnotation(op, annotationType);
        if (reference != null) {
            return this.findIntValues(reference);
        }
        return null;
    }

    public List<Integer> findIntValues(JvmAnnotationReference reference) {
        assert (reference != null);
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (JvmAnnotationValue value : reference.getValues()) {
            if (!(value instanceof JvmIntAnnotationValue)) continue;
            JvmIntAnnotationValue cvalue = (JvmIntAnnotationValue)value;
            for (Integer intValue : cvalue.getValues()) {
                if (intValue == null) continue;
                values.add(intValue);
            }
        }
        return values;
    }

    public JvmAnnotationReference findAnnotation(JvmAnnotationTarget annotationTarget, String lookupType) {
        if (annotationTarget.eIsSet((EStructuralFeature)TypesPackage.Literals.JVM_ANNOTATION_TARGET__ANNOTATIONS)) {
            for (JvmAnnotationReference annotation : annotationTarget.getAnnotations()) {
                JvmAnnotationType annotationType = annotation.getAnnotation();
                if (annotationType == null || !Objects.equals(lookupType, annotationType.getQualifiedName())) continue;
                return annotation;
            }
        }
        return null;
    }

    public Boolean findBooleanValue(JvmAnnotationTarget op, Class<? extends Annotation> annotationType) {
        JvmAnnotationReference reference = this.lookup.findAnnotation(op, annotationType);
        if (reference != null) {
            return this.findBooleanValue(reference);
        }
        return null;
    }

    public Boolean findBooleanValue(JvmAnnotationReference reference) {
        assert (reference != null);
        for (JvmAnnotationValue value : reference.getValues()) {
            if (!(value instanceof JvmBooleanAnnotationValue)) continue;
            JvmBooleanAnnotationValue cvalue = (JvmBooleanAnnotationValue)value;
            for (Boolean intValue : cvalue.getValues()) {
                if (intValue == null) continue;
                return intValue;
            }
        }
        return null;
    }

    public List<Boolean> findBooleanValues(JvmAnnotationTarget op, Class<? extends Annotation> annotationType) {
        JvmAnnotationReference reference = this.lookup.findAnnotation(op, annotationType);
        if (reference != null) {
            return this.findBooleanValues(reference);
        }
        return null;
    }

    public List<Boolean> findBooleanValues(JvmAnnotationReference reference) {
        assert (reference != null);
        ArrayList<Boolean> values = new ArrayList<Boolean>();
        for (JvmAnnotationValue value : reference.getValues()) {
            if (!(value instanceof JvmBooleanAnnotationValue)) continue;
            JvmBooleanAnnotationValue cvalue = (JvmBooleanAnnotationValue)value;
            for (Boolean boolValue : cvalue.getValues()) {
                if (boolValue == null) continue;
                values.add(boolValue);
            }
        }
        return values;
    }
}

