/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.typesystem;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.sarl.lang.typesystem.IPureOperationNameValidator;
import io.sarl.lang.util.Utils;
import org.eclipse.xtend.core.typing.XtendExpressionHelper;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBooleanLiteral;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

@Singleton
public class SARLExpressionHelper
extends XtendExpressionHelper {
    @Inject
    private IPureOperationNameValidator nameValidator;
    @Inject
    private CommonTypeComputationServices services;

    public boolean hasSideEffects(XAbstractFeatureCall featureCall, boolean inspectContents) {
        if (super.hasSideEffects(featureCall, inspectContents)) {
            JvmIdentifiableElement feature = featureCall.getFeature();
            if (feature != null && !feature.eIsProxy() && feature instanceof JvmOperation) {
                JvmOperation operation = (JvmOperation)feature;
                return this.nameValidator.isNamePatternForNotPureOperation(operation) || !this.nameValidator.isNamePatternForPureOperation(operation) || !this.hasPrimitiveParameters(operation);
            }
            return true;
        }
        return false;
    }

    private boolean hasPrimitiveParameters(JvmOperation op) {
        for (JvmFormalParameter parameter : op.getParameters()) {
            JvmTypeReference type = parameter.getParameterType();
            if (type != null && Utils.toLightweightTypeReference(type, this.services).isPrimitive()) continue;
            return false;
        }
        return true;
    }

    public Boolean toBooleanPrimitiveWrapperConstant(XExpression expression) {
        XMemberFeatureCall call;
        XExpression receiver;
        if (expression instanceof XBooleanLiteral) {
            XBooleanLiteral cvalue = (XBooleanLiteral)expression;
            return cvalue.isIsTrue() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (expression instanceof XMemberFeatureCall && (receiver = (call = (XMemberFeatureCall)expression).getMemberCallTarget()) instanceof XFeatureCall) {
            XFeatureCall call2 = (XFeatureCall)receiver;
            String call2Identifier = call2.getConcreteSyntaxFeatureName();
            if (Boolean.class.getSimpleName().equals(call2Identifier) || Boolean.class.getName().equals(call2Identifier)) {
                String callIdentifier = call.getConcreteSyntaxFeatureName();
                if ("TRUE".equals(callIdentifier)) {
                    return Boolean.TRUE;
                }
                if ("FALSE".equals(callIdentifier)) {
                    return Boolean.FALSE;
                }
            }
        }
        return null;
    }
}

