/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.typesystem;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.sarl.lang.jvmmodel.SarlJvmModelAssociations;
import io.sarl.lang.sarl.SarlAssertExpression;
import io.sarl.lang.sarl.SarlBreakExpression;
import io.sarl.lang.sarl.SarlContinueExpression;
import io.sarl.lang.sarl.actionprototype.ActionParameterTypes;
import io.sarl.lang.sarl.actionprototype.IActionPrototypeProvider;
import io.sarl.lang.sarl.actionprototype.InferredPrototype;
import io.sarl.lang.sarl.actionprototype.QualifiedActionName;
import io.sarl.lang.typesystem.IOperationHelper;
import io.sarl.lang.typesystem.IPureOperationNameValidator;
import io.sarl.lang.typesystem.ISideEffectContext;
import io.sarl.lang.util.Utils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.xtend.XtendConstructor;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtend.core.xtend.XtendParameter;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.AnnotationLookup;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.PolymorphicDispatcher;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XAbstractWhileExpression;
import org.eclipse.xtext.xbase.XAssignment;
import org.eclipse.xtext.xbase.XBasicForLoopExpression;
import org.eclipse.xtext.xbase.XBinaryOperation;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XCatchClause;
import org.eclipse.xtext.xbase.XCollectionLiteral;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XForLoopExpression;
import org.eclipse.xtext.xbase.XIfExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XPostfixOperation;
import org.eclipse.xtext.xbase.XReturnExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.XSynchronizedExpression;
import org.eclipse.xtext.xbase.XThrowExpression;
import org.eclipse.xtext.xbase.XTryCatchFinallyExpression;
import org.eclipse.xtext.xbase.XUnaryOperation;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.scoping.featurecalls.OperatorMapping;

@Singleton
public class SARLOperationHelper
implements IOperationHelper {
    @Inject
    private IPureOperationNameValidator nameValidator;
    @Inject
    private AnnotationLookup annotations;
    @Inject
    private IActionPrototypeProvider actionPrototypes;
    @Inject
    private SarlJvmModelAssociations associations;
    @Inject
    private OperatorMapping operatorMapping;
    private final PolymorphicDispatcher<Boolean> hasSideEffectsDispatcher = new PolymorphicDispatcher<Boolean>(this, "_hasSideEffects", 2, 2, Collections.singletonList(this)){

        protected Boolean handleNoSuchMethod(Object ... params) {
            return Boolean.FALSE;
        }
    };

    protected boolean isPureStateForbidden(XtendFunction operation) {
        if (operation == null || operation.isNative()) {
            return true;
        }
        JvmTypeReference returnType = operation.getReturnType();
        if (returnType != null) {
            return Void.TYPE.getName().equals(returnType.getIdentifier());
        }
        JvmOperation jvmOperation = this.associations.getDirectlyInferredOperation(operation);
        if (jvmOperation != null) {
            returnType = jvmOperation.getReturnType();
            if (returnType != null) {
                return Void.TYPE.getName().equals(returnType.getIdentifier());
            }
            return false;
        }
        return true;
    }

    protected boolean isPureStateAmbiguous(XtendFunction operation) {
        return operation.isAbstract() || operation.getExpression() == null;
    }

    @Override
    public boolean isPurableOperation(XtendFunction operation) {
        return this.isPurableOperation(operation, null);
    }

    boolean isPurableOperation(XtendFunction operation, ISideEffectContext context) {
        if (this.isPureStateForbidden(operation)) {
            return false;
        }
        if (this.nameValidator.isNamePatternForNotPureOperation(operation)) {
            return false;
        }
        if (this.nameValidator.isNamePatternForPureOperation(operation)) {
            return true;
        }
        if (this.isPureStateAmbiguous(operation)) {
            return false;
        }
        if (context == null) {
            return !this.hasSideEffects(this.getInferredPrototype(operation), operation.getExpression());
        }
        Boolean result = this.internalHasSideEffects(operation.getExpression(), context);
        return result == null || result == false;
    }

    private InferredPrototype createInferredPrototype(QualifiedActionName executableKey, List<XtendParameter> parameters) {
        boolean isVarArgs = Utils.isVarArg(parameters);
        return this.actionPrototypes.createPrototypeFromSarlModel(this.actionPrototypes.createContext(), executableKey, isVarArgs, parameters);
    }

    private InferredPrototype createInferredPrototype(QualifiedActionName executableKey, boolean isVarArgs, List<JvmFormalParameter> parameters) {
        return this.actionPrototypes.createPrototypeFromJvmModel(this.actionPrototypes.createContext(), executableKey, isVarArgs, parameters);
    }

    public InferredPrototype getInferredPrototype(XtendFunction operation) {
        JvmDeclaredType container = this.associations.getInferredType(operation.getDeclaringType());
        QualifiedActionName actionKey = this.actionPrototypes.createQualifiedActionName((JvmIdentifiableElement)container, operation.getName());
        return this.createInferredPrototype(actionKey, (List<XtendParameter>)operation.getParameters());
    }

    public InferredPrototype getInferredPrototype(XtendConstructor constructor) {
        JvmDeclaredType container = this.associations.getInferredType(constructor.getDeclaringType());
        QualifiedActionName constructorKey = this.actionPrototypes.createConstructorQualifiedName((JvmIdentifiableElement)container);
        return this.createInferredPrototype(constructorKey, (List<XtendParameter>)constructor.getParameters());
    }

    public InferredPrototype getInferredPrototype(JvmOperation operation) {
        XtendFunction fct = this.associations.getXtendFunction(operation);
        if (fct != null) {
            return this.getInferredPrototype(fct);
        }
        QualifiedActionName actionKey = this.actionPrototypes.createQualifiedActionName((JvmIdentifiableElement)operation.getDeclaringType(), operation.getSimpleName());
        return this.createInferredPrototype(actionKey, operation.isVarArgs(), (List<JvmFormalParameter>)operation.getParameters());
    }

    public InferredPrototype getInferredPrototype(JvmConstructor constructor) {
        XtendConstructor cons = this.associations.getXtendConstructor(constructor);
        if (cons != null) {
            return this.getInferredPrototype(cons);
        }
        QualifiedActionName actionKey = this.actionPrototypes.createConstructorQualifiedName((JvmIdentifiableElement)constructor.getDeclaringType());
        return this.createInferredPrototype(actionKey, constructor.isVarArgs(), (List<JvmFormalParameter>)constructor.getParameters());
    }

    @Override
    public Iterable<XExpression> getSideEffectExpressions(InferredPrototype calledOperation, XExpression expr) {
        SideEffectContext ctx = new SideEffectContext(calledOperation, false);
        this.hasSideEffects(expr, ctx);
        return ctx.getSideEffectExpressions();
    }

    private Boolean internalHasSideEffects(XExpression expr, ISideEffectContext ctx) {
        Boolean result = this.hasSideEffects(expr, ctx);
        if (result != null && result.booleanValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public boolean hasSideEffects(InferredPrototype calledOperation, XExpression expr) {
        SideEffectContext ctx = new SideEffectContext(calledOperation);
        return this.internalHasSideEffects(expr, ctx);
    }

    protected Boolean hasSideEffects(InferredPrototype calledOperation, XExpression expr, ISideEffectContext context) {
        SideEffectContext ctx = new SideEffectContext(calledOperation, context);
        return this.internalHasSideEffects(expr, ctx);
    }

    protected Boolean hasSideEffects(XExpression expr, ISideEffectContext context) {
        if (expr != null && !expr.eIsProxy()) {
            return (Boolean)this.hasSideEffectsDispatcher.invoke(new Object[]{expr, context});
        }
        return Boolean.FALSE;
    }

    protected Boolean _hasSideEffects(XSynchronizedExpression expression, ISideEffectContext context) {
        return this.hasSideEffects(expression.getExpression(), context);
    }

    protected Boolean _hasSideEffects(XCastedExpression expression, ISideEffectContext context) {
        return this.hasSideEffects(expression.getTarget(), context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean _hasSideEffects(XAbstractWhileExpression expression, ISideEffectContext context) {
        context.open();
        try {
            if (context.isStoppingAtFirstSideEffect()) {
                if (this.hasSideEffects(expression.getPredicate(), context).booleanValue()) {
                    Boolean bl = Boolean.TRUE;
                    return bl;
                }
                if (this.hasSideEffects(expression.getBody(), context.branch()).booleanValue()) {
                    Boolean bl = Boolean.TRUE;
                    return bl;
                }
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            boolean r0 = this.hasSideEffects(expression.getPredicate(), context);
            boolean r1 = this.hasSideEffects(expression.getBody(), context.branch());
            Boolean bl = r0 || r1;
            return bl;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean _hasSideEffects(XForLoopExpression expression, ISideEffectContext context) {
        if (context.isStoppingAtFirstSideEffect()) {
            context.open();
            try {
                if (this.hasSideEffects(expression.getForExpression(), context).booleanValue()) {
                    Boolean bl = Boolean.TRUE;
                    return bl;
                }
            }
            finally {
                context.close();
            }
            return this.hasSideEffects(expression.getEachExpression(), context.branch());
        }
        context.open();
        boolean r0 = false;
        try {
            r0 = this.hasSideEffects(expression.getForExpression(), context);
        }
        finally {
            context.close();
        }
        return this.hasSideEffects(expression.getEachExpression(), context.branch()) != false || r0;
    }

    protected Boolean _hasSideEffects(XIfExpression expression, ISideEffectContext context) {
        if (context.isStoppingAtFirstSideEffect()) {
            if (this.hasSideEffects(expression.getIf(), context).booleanValue()) {
                return Boolean.TRUE;
            }
            Map<String, List<XExpression>> buffer1 = context.createVariableAssignmentBufferForBranch();
            if (this.hasSideEffects(expression.getThen(), context.branch(buffer1)).booleanValue()) {
                return Boolean.TRUE;
            }
            Map<String, List<XExpression>> buffer2 = context.createVariableAssignmentBufferForBranch();
            if (this.hasSideEffects(expression.getElse(), context.branch(buffer2)).booleanValue()) {
                return Boolean.TRUE;
            }
            context.mergeBranchVariableAssignments(Arrays.asList(buffer1, buffer2));
            return Boolean.FALSE;
        }
        boolean r0 = this.hasSideEffects(expression.getIf(), context);
        Map<String, List<XExpression>> buffer1 = context.createVariableAssignmentBufferForBranch();
        boolean r1 = this.hasSideEffects(expression.getThen(), context.branch(buffer1));
        Map<String, List<XExpression>> buffer2 = context.createVariableAssignmentBufferForBranch();
        boolean r2 = this.hasSideEffects(expression.getElse(), context.branch(buffer2));
        context.mergeBranchVariableAssignments(Arrays.asList(buffer1, buffer2));
        return r0 || r1 || r2;
    }

    protected Boolean _hasSideEffects(XReturnExpression expression, ISideEffectContext context) {
        return this.hasSideEffects(expression.getExpression(), context);
    }

    protected Boolean _hasSideEffects(XThrowExpression expression, ISideEffectContext context) {
        context.registerSideEffect((XExpression)expression);
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean _hasSideEffects(XTryCatchFinallyExpression expression, ISideEffectContext context) {
        if (context.isStoppingAtFirstSideEffect()) {
            ArrayList<Map<String, List<XExpression>>> buffers = new ArrayList<Map<String, List<XExpression>>>();
            Map<String, List<XExpression>> buffer = context.createVariableAssignmentBufferForBranch();
            if (this.hasSideEffects(expression.getExpression(), context.branch(buffer)).booleanValue()) {
                return Boolean.TRUE;
            }
            buffers.add(buffer);
            for (XCatchClause clause : expression.getCatchClauses()) {
                context.open();
                try {
                    buffer = context.createVariableAssignmentBufferForBranch();
                    if (this.hasSideEffects(clause.getExpression(), context.branch(buffer)).booleanValue()) {
                        Boolean bl = Boolean.TRUE;
                        return bl;
                    }
                    buffers.add(buffer);
                }
                finally {
                    context.close();
                }
            }
            context.mergeBranchVariableAssignments(buffers);
            if (this.hasSideEffects(expression.getFinallyExpression(), context).booleanValue()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        ArrayList<Map<String, List<XExpression>>> buffers = new ArrayList<Map<String, List<XExpression>>>();
        Map<String, List<XExpression>> buffer = context.createVariableAssignmentBufferForBranch();
        boolean r0 = this.hasSideEffects(expression.getExpression(), context.branch(buffer));
        buffers.add(buffer);
        boolean r1 = false;
        for (XCatchClause clause : expression.getCatchClauses()) {
            context.open();
            try {
                buffer = context.createVariableAssignmentBufferForBranch();
                r1 = this.hasSideEffects(clause.getExpression(), context.branch(buffer)) != false || r1;
                buffers.add(buffer);
            }
            finally {
                context.close();
            }
        }
        context.mergeBranchVariableAssignments(buffers);
        boolean r2 = this.hasSideEffects(expression.getFinallyExpression(), context);
        return r0 || r1 || r2;
    }

    protected Boolean _hasSideEffects(XVariableDeclaration expression, ISideEffectContext context) {
        if (context.isStoppingAtFirstSideEffect()) {
            if (this.hasSideEffects(expression.getRight(), context).booleanValue()) {
                return Boolean.TRUE;
            }
            context.declareVariable(expression.getIdentifier(), expression.getRight());
            return Boolean.FALSE;
        }
        Boolean r0 = this.hasSideEffects(expression.getRight(), context);
        context.declareVariable(expression.getIdentifier(), expression.getRight());
        return r0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean _hasSideEffects(XBasicForLoopExpression expression, ISideEffectContext context) {
        context.open();
        try {
            if (context.isStoppingAtFirstSideEffect()) {
                Object object;
                for (XExpression ex : expression.getInitExpressions()) {
                    if (!this.hasSideEffects(ex, context).booleanValue()) continue;
                    Boolean bl = Boolean.TRUE;
                    return bl;
                }
                if (this.hasSideEffects(expression.getEachExpression(), context).booleanValue()) {
                    object = Boolean.TRUE;
                    return object;
                }
                for (XExpression ex : expression.getUpdateExpressions()) {
                    if (!this.hasSideEffects(ex, context.branch()).booleanValue()) continue;
                    Boolean bl = Boolean.TRUE;
                    return bl;
                }
                if (this.hasSideEffects(expression.getExpression(), context.branch()).booleanValue()) {
                    object = Boolean.TRUE;
                    return object;
                }
                object = Boolean.FALSE;
                return object;
            }
            boolean r0 = false;
            for (XExpression ex : expression.getInitExpressions()) {
                r0 = this.hasSideEffects(ex, context) != false || r0;
            }
            boolean r1 = this.hasSideEffects(expression.getEachExpression(), context);
            boolean r2 = false;
            for (XExpression ex : expression.getUpdateExpressions()) {
                r2 = this.hasSideEffects(ex, context.branch()) != false || r2;
            }
            boolean r3 = this.hasSideEffects(expression.getExpression(), context.branch());
            Boolean bl = r0 || r1 || r2 || r3;
            return bl;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean _hasSideEffects(XSwitchExpression expression, ISideEffectContext context) {
        context.open();
        try {
            if (context.isStoppingAtFirstSideEffect()) {
                Object ex2;
                if (this.hasSideEffects(expression.getSwitch(), context).booleanValue()) {
                    Boolean bl = Boolean.TRUE;
                    return bl;
                }
                ArrayList<Map<String, List<XExpression>>> buffers = new ArrayList<Map<String, List<XExpression>>>();
                for (Object ex2 : expression.getCases()) {
                    context.open();
                    try {
                        if (this.hasSideEffects(ex2.getCase(), context).booleanValue()) {
                            Boolean bl = Boolean.TRUE;
                            return bl;
                        }
                        Map<String, List<XExpression>> buffer = context.createVariableAssignmentBufferForBranch();
                        if (this.hasSideEffects(ex2.getThen(), context.branch(buffer)).booleanValue()) {
                            Boolean bl = Boolean.TRUE;
                            return bl;
                        }
                        buffers.add(buffer);
                    }
                    finally {
                        context.close();
                    }
                }
                Map<String, List<XExpression>> buffer = context.createVariableAssignmentBufferForBranch();
                if (this.hasSideEffects(expression.getDefault(), context.branch(buffer)).booleanValue()) {
                    ex2 = Boolean.TRUE;
                    return ex2;
                }
                buffers.add(buffer);
                context.mergeBranchVariableAssignments(buffers);
                ex2 = Boolean.FALSE;
                return ex2;
            }
            boolean r0 = this.hasSideEffects(expression.getSwitch(), context);
            ArrayList<Map<String, List<XExpression>>> buffers = new ArrayList<Map<String, List<XExpression>>>();
            boolean r1 = false;
            for (XCasePart ex : expression.getCases()) {
                context.open();
                try {
                    r1 = this.hasSideEffects(ex.getCase(), context) != false || r1;
                    Map<String, List<XExpression>> buffer = context.createVariableAssignmentBufferForBranch();
                    r1 = this.hasSideEffects(ex.getThen(), context.branch(buffer)) != false || r1;
                    buffers.add(buffer);
                }
                finally {
                    context.close();
                }
            }
            Map<String, List<XExpression>> buffer = context.createVariableAssignmentBufferForBranch();
            boolean r2 = this.hasSideEffects(expression.getDefault(), context.branch(buffer));
            buffers.add(buffer);
            context.mergeBranchVariableAssignments(buffers);
            Boolean bl = r0 || r1 || r2;
            return bl;
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean _hasSideEffects(XCollectionLiteral expression, ISideEffectContext context) {
        context.open();
        try {
            if (context.isStoppingAtFirstSideEffect()) {
                for (XExpression ex : expression.getElements()) {
                    if (!this.hasSideEffects(ex, context).booleanValue()) continue;
                    Boolean bl = Boolean.TRUE;
                    return bl;
                }
                Boolean bl = Boolean.FALSE;
                return bl;
            }
            boolean r0 = false;
            for (XExpression ex : expression.getElements()) {
                r0 = this.hasSideEffects(ex, context) != false || r0;
            }
            Boolean bl = r0;
            return bl;
        }
        finally {
            context.close();
        }
    }

    protected Boolean _hasSideEffects(XConstructorCall expression, ISideEffectContext context) {
        if (context.isStoppingAtFirstSideEffect()) {
            for (XExpression ex : expression.getArguments()) {
                if (!this.hasSideEffects(ex, context).booleanValue()) continue;
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        boolean r0 = false;
        for (XExpression ex : expression.getArguments()) {
            r0 = this.hasSideEffects(ex, context) != false || r0;
        }
        return r0;
    }

    protected Boolean _hasSideEffects(XBinaryOperation expression, ISideEffectContext context) {
        if (context.isStoppingAtFirstSideEffect()) {
            if (this.isReassignmentOperator(expression)) {
                if (!SARLOperationHelper.isLocalExpression(expression.getLeftOperand(), context, false)) {
                    context.registerSideEffect((XExpression)expression);
                    return Boolean.TRUE;
                }
            } else {
                if (expression.isTypeLiteral() || expression.isPackageFragment()) {
                    return Boolean.FALSE;
                }
                if (this.hasSideEffects(expression.getLeftOperand(), context).booleanValue()) {
                    return Boolean.TRUE;
                }
            }
            if (this.hasSideEffects(expression.getRightOperand(), context).booleanValue()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        boolean r0 = false;
        if (this.isReassignmentOperator(expression)) {
            if (!SARLOperationHelper.isLocalExpression(expression.getLeftOperand(), context, false)) {
                context.registerSideEffect((XExpression)expression);
                r0 = true;
            }
        } else {
            r0 = !expression.isTypeLiteral() && !expression.isPackageFragment();
            r0 = this.hasSideEffects(expression.getLeftOperand(), context) != false || r0;
        }
        boolean r1 = this.hasSideEffects(expression.getRightOperand(), context);
        return r0 || r1;
    }

    protected Boolean _hasSideEffects(XUnaryOperation expression, ISideEffectContext context) {
        if (context.isStoppingAtFirstSideEffect()) {
            if (expression.isTypeLiteral() || expression.isPackageFragment()) {
                return Boolean.FALSE;
            }
            if (this.hasSideEffects(expression.getOperand(), context).booleanValue()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        boolean r0 = !expression.isTypeLiteral() && !expression.isPackageFragment();
        boolean r1 = this.hasSideEffects(expression.getOperand(), context);
        return r0 || r1;
    }

    protected Boolean _hasSideEffects(XPostfixOperation expression, ISideEffectContext context) {
        context.registerSideEffect((XExpression)expression);
        return Boolean.TRUE;
    }

    protected Boolean _hasSideEffects(XFeatureCall expression, ISideEffectContext context) {
        return this.internalHasFeatureCallSideEffects((XAbstractFeatureCall)expression, context);
    }

    protected Boolean _hasSideEffects(XMemberFeatureCall expression, ISideEffectContext context) {
        return this.internalHasFeatureCallSideEffects((XAbstractFeatureCall)expression, context);
    }

    protected Boolean _hasSideEffects(XAssignment expression, ISideEffectContext context) {
        if (context.isStoppingAtFirstSideEffect()) {
            JvmIdentifiableElement feature = expression.getFeature();
            if (feature instanceof XVariableDeclaration) {
                Boolean se = this.hasSideEffects(expression.getValue(), context);
                context.assignVariable(feature.getIdentifier(), expression.getValue());
                return se;
            }
            return Boolean.TRUE;
        }
        JvmIdentifiableElement feature = expression.getFeature();
        if (feature instanceof XVariableDeclaration) {
            boolean r0 = this.hasSideEffects(expression.getActualReceiver(), context);
            boolean r1 = this.hasSideEffects(expression.getValue(), context);
            context.assignVariable(feature.getIdentifier(), expression.getValue());
            return r0 || r1;
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Boolean _hasSideEffects(XBlockExpression expression, ISideEffectContext context) {
        EList exprs = expression.getExpressions();
        if (exprs != null && !exprs.isEmpty()) {
            context.open();
            try {
                if (context.isStoppingAtFirstSideEffect()) {
                    for (XExpression ex : exprs) {
                        if (!this.hasSideEffects(ex, context).booleanValue()) continue;
                        Boolean bl = Boolean.TRUE;
                        return bl;
                    }
                    Boolean bl = Boolean.FALSE;
                    return bl;
                }
                boolean r0 = false;
                for (XExpression ex : exprs) {
                    r0 = this.hasSideEffects(ex, context) != false || r0;
                }
                Boolean bl = r0;
                return bl;
            }
            finally {
                context.close();
            }
        }
        return Boolean.FALSE;
    }

    protected Boolean _hasSideEffects(SarlAssertExpression expression, ISideEffectContext context) {
        return Boolean.FALSE;
    }

    protected Boolean _hasSideEffects(SarlBreakExpression expression, ISideEffectContext context) {
        return Boolean.FALSE;
    }

    protected Boolean _hasSideEffects(SarlContinueExpression expression, ISideEffectContext context) {
        return Boolean.FALSE;
    }

    protected boolean isReassignmentOperator(XBinaryOperation operator) {
        if (operator.isReassignFirstArgument()) {
            return true;
        }
        QualifiedName operatorName = this.operatorMapping.getOperator(QualifiedName.create((String)operator.getFeature().getSimpleName()));
        QualifiedName compboundOperatorName = this.operatorMapping.getSimpleOperator(operatorName);
        return compboundOperatorName != null;
    }

    private boolean internalHasFeatureCallSideEffects(XAbstractFeatureCall expression, ISideEffectContext context) {
        if (expression.eIsProxy()) {
            return false;
        }
        if (expression.isTypeLiteral() || expression.isPackageFragment()) {
            return false;
        }
        JvmIdentifiableElement feature = expression.getFeature();
        if (feature == null) {
            return false;
        }
        if (feature.eIsProxy() && (feature = (JvmIdentifiableElement)EcoreUtil.resolve((EObject)feature, (Resource)feature.eResource())).eIsProxy()) {
            return false;
        }
        if (feature instanceof JvmOperation) {
            JvmOperation operation = (JvmOperation)feature;
            if (SARLOperationHelper.isCalledOperation(operation, context.getCalledOperations())) {
                return false;
            }
            return this.internalHasOperationSideEffects(expression, operation, context);
        }
        if (SARLOperationHelper.isExternalFeature(feature)) {
            return SARLOperationHelper.internalHasExternalFeatureSideEffects(expression, context, feature);
        }
        return false;
    }

    private static boolean isCalledOperation(JvmOperation operation, List<InferredPrototype> prototypes) {
        String containerId0 = operation.getDeclaringType().getIdentifier();
        String operationId0 = operation.getSimpleName();
        String fullOperationId0 = containerId0 + "." + operationId0;
        List parameterTypes0 = operation.getParameters().stream().map(it -> it.getParameterType().getIdentifier()).collect(Collectors.toList());
        for (InferredPrototype prototype : prototypes) {
            String operationId1;
            QualifiedActionName action1 = prototype.getActionName();
            String containerId1 = action1.getDeclaringType().getIdentifier();
            String fullOperationId1 = containerId1 + "." + (operationId1 = action1.getActionName());
            if (!Strings.equal((String)fullOperationId0, (String)fullOperationId1)) continue;
            for (ActionParameterTypes parameterTypes1 : prototype.getParameterTypeAlternatives()) {
                String type1;
                String type0;
                if (parameterTypes0.size() != parameterTypes1.size()) continue;
                for (int i = 0; i < parameterTypes0.size() && Strings.equal((String)(type0 = (String)parameterTypes0.get(i)), (String)(type1 = (String)parameterTypes1.get(i))); ++i) {
                }
                return true;
            }
        }
        return false;
    }

    private boolean internalHasOperationSideEffects(XAbstractFeatureCall originalExpression, JvmOperation operation, ISideEffectContext context) {
        try {
            boolean isPureOperation;
            boolean hasEffectReceiver = false;
            if (this.hasSideEffects(originalExpression.getActualReceiver(), context).booleanValue()) {
                if (context.isStoppingAtFirstSideEffect()) {
                    return true;
                }
                hasEffectReceiver = true;
            }
            SideEffectContext ctx = new SideEffectContext(Iterables.concat(context.getCalledOperations(), Collections.singleton(this.getInferredPrototype(operation))));
            if (this.nameValidator.isNamePatternForNotPureOperation(operation)) {
                isPureOperation = false;
            } else if (this.nameValidator.isNamePatternForPureOperation(operation)) {
                isPureOperation = true;
            } else {
                boolean bl = isPureOperation = this.annotations.findAnnotation((JvmAnnotationTarget)operation, Pure.class) != null || this.evaluatePureAnnotationAdapters(operation, ctx, true);
            }
            if (!isPureOperation) {
                context.registerSideEffect((XExpression)originalExpression);
            }
            boolean hasEffectArgument = false;
            if (!context.isStoppingAtFirstSideEffect() || isPureOperation) {
                for (XExpression ex : originalExpression.getActualArguments()) {
                    Boolean bool = this.hasSideEffects(ex, context);
                    if (bool == null || !bool.booleanValue()) continue;
                    if (context.isStoppingAtFirstSideEffect()) {
                        return true;
                    }
                    hasEffectArgument = false;
                }
            }
            return hasEffectReceiver || !isPureOperation || hasEffectArgument;
        }
        catch (StackOverflowError ex) {
            StackOverflowError ex2 = new StackOverflowError(ex.getLocalizedMessage() + "\nCalled operation: " + operation.getIdentifier() + "\nin: " + originalExpression.toString() + "\nwith context: " + context.toString() + "\nisCalled=" + Boolean.toString(SARLOperationHelper.isCalledOperation(operation, context.getCalledOperations())));
            ex2.setStackTrace(ex.getStackTrace());
            throw ex2;
        }
    }

    private static boolean internalHasExternalFeatureSideEffects(XAbstractFeatureCall expression, ISideEffectContext context, JvmIdentifiableElement feature) {
        return false;
    }

    private static boolean isExternalFeature(JvmIdentifiableElement feature) {
        return feature instanceof JvmMember || feature instanceof JvmFormalParameter;
    }

    private static boolean isLocalExpression(XExpression expression, ISideEffectContext context, boolean dereference) {
        if (expression == null) {
            return true;
        }
        if (expression instanceof XAbstractFeatureCall) {
            XAbstractFeatureCall cvalue = (XAbstractFeatureCall)expression;
            return SARLOperationHelper.isLocalExpression(cvalue, context, dereference);
        }
        for (XAbstractFeatureCall featureCall : EcoreUtil2.getAllContentsOfType((EObject)expression, XAbstractFeatureCall.class)) {
            if (SARLOperationHelper.isLocalExpression(featureCall, context, dereference)) continue;
            return false;
        }
        return true;
    }

    private static boolean isLocalExpression(XAbstractFeatureCall expression, ISideEffectContext context, boolean dereference) {
        if (expression.isTypeLiteral() || expression.isPackageFragment()) {
            return false;
        }
        JvmIdentifiableElement feature = expression.getFeature();
        if (feature != null && (feature.eIsProxy() || SARLOperationHelper.isExternalFeature(feature))) {
            return false;
        }
        if (feature instanceof XVariableDeclaration) {
            XVariableDeclaration variable = (XVariableDeclaration)feature;
            if (dereference) {
                for (XExpression xExpression : context.getVariableValues(variable.getIdentifier())) {
                    if (SARLOperationHelper.isLocalExpression(xExpression, context, dereference)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean evaluatePureAnnotationAdapters(JvmOperation operation) {
        return this.evaluatePureAnnotationAdapters(operation, null, true);
    }

    boolean evaluatePureAnnotationAdapters(JvmOperation operation, ISideEffectContext context, boolean resetAdapterValue) {
        int index = -1;
        int i = 0;
        for (Adapter adapter : operation.eAdapters()) {
            if (adapter.isAdapterForType(AnnotationJavaGenerationAdapter.class)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index >= 0) {
            AnnotationJavaGenerationAdapter annotationAdapter = (AnnotationJavaGenerationAdapter)((Object)operation.eAdapters().get(index));
            assert (annotationAdapter != null);
            boolean purity = annotationAdapter.applyAdaptations(this, operation, context);
            if (resetAdapterValue) {
                annotationAdapter.removeAllPredicates();
                annotationAdapter.addPredicate((Functions.Function2<? super JvmOperation, ? super IOperationHelper, ? extends Boolean>)((Functions.Function2)(op, hlp) -> purity));
            }
            return purity;
        }
        return false;
    }

    @Override
    public void attachPureAnnotationAdapter(JvmOperation operation, Functions.Function2<? super JvmOperation, ? super IOperationHelper, ? extends Boolean> dynamicCallback) {
        if (operation != null && dynamicCallback != null) {
            AnnotationJavaGenerationAdapter adapter = (AnnotationJavaGenerationAdapter)EcoreUtil.getAdapter((List)operation.eAdapters(), AnnotationJavaGenerationAdapter.class);
            if (adapter == null) {
                adapter = new AnnotationJavaGenerationAdapter();
                operation.eAdapters().add((Object)adapter);
            }
            adapter.addPredicate(dynamicCallback);
        }
    }

    @Override
    public boolean isPureOperation(JvmOperation operation) {
        return this.isPureOperation(operation, null);
    }

    public boolean isPureOperation(JvmOperation operation, ISideEffectContext context) {
        if (operation == null) {
            return false;
        }
        if (this.annotations.findAnnotation((JvmAnnotationTarget)operation, Pure.class) != null) {
            return true;
        }
        return this.evaluatePureAnnotationAdapters(operation, context, true);
    }

    public static final class SideEffectContext
    implements ISideEffectContext {
        private final boolean stopFirstSideEffect;
        private final List<InferredPrototype> calledOperations = new ArrayList<InferredPrototype>();
        private final Deque<InternalContext> contextStack;
        private final boolean isBranchContext;
        private final Map<String, List<XExpression>> variableAssignmentBuffer;
        private final List<XExpression> sideEffectExpressions = new ArrayList<XExpression>();

        SideEffectContext(InferredPrototype calledOperation) {
            this(calledOperation, true);
        }

        SideEffectContext(InferredPrototype calledOperation, boolean stopFirst) {
            this.stopFirstSideEffect = stopFirst;
            if (calledOperation != null) {
                this.calledOperations.add(calledOperation);
            }
            this.variableAssignmentBuffer = null;
            this.isBranchContext = false;
            this.contextStack = new LinkedList<InternalContext>();
            this.contextStack.addLast(new InternalContext(null));
        }

        SideEffectContext(Iterable<InferredPrototype> calledOperations) {
            this.stopFirstSideEffect = true;
            if (calledOperations != null) {
                for (InferredPrototype proto : calledOperations) {
                    this.calledOperations.add(proto);
                }
            }
            this.variableAssignmentBuffer = null;
            this.isBranchContext = false;
            this.contextStack = new LinkedList<InternalContext>();
            this.contextStack.addLast(new InternalContext(null));
        }

        SideEffectContext(InferredPrototype calledOperation, ISideEffectContext context) {
            this.stopFirstSideEffect = context.isStoppingAtFirstSideEffect();
            this.calledOperations.addAll(context.getCalledOperations());
            if (calledOperation != null) {
                this.calledOperations.add(calledOperation);
            }
            this.variableAssignmentBuffer = null;
            this.isBranchContext = false;
            this.contextStack = new LinkedList<InternalContext>();
            this.contextStack.addLast(new InternalContext(null));
        }

        private SideEffectContext(List<InferredPrototype> calledOperations, Deque<InternalContext> contextStack, Map<String, List<XExpression>> buffer, boolean stopFirst) {
            this.stopFirstSideEffect = stopFirst;
            if (calledOperations != null) {
                this.calledOperations.addAll(calledOperations);
            }
            this.variableAssignmentBuffer = buffer;
            this.isBranchContext = true;
            this.contextStack = contextStack;
        }

        @Override
        @Pure
        public boolean isStoppingAtFirstSideEffect() {
            return this.stopFirstSideEffect;
        }

        @Override
        public void registerSideEffect(XExpression expression) {
            assert (expression != null);
            this.sideEffectExpressions.add(expression);
        }

        @Override
        public Iterable<XExpression> getSideEffectExpressions() {
            return Collections.unmodifiableList(this.sideEffectExpressions);
        }

        @Override
        public List<InferredPrototype> getCalledOperations() {
            return Collections.unmodifiableList(this.calledOperations);
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            for (InferredPrototype proto : this.getCalledOperations()) {
                buffer.append("> ");
                buffer.append(proto.getActionName().getActionName());
                buffer.append("(");
                buffer.append(proto.toString());
                buffer.append(");orginalParams:(");
                buffer.append(proto.getOriginalParameterTypes());
                buffer.append(");alternatives:(");
                buffer.append(Iterables.toString(proto.getParameterTypeAlternatives()));
                buffer.append(")\n");
            }
            Iterator<InternalContext> iterator = this.contextStack.descendingIterator();
            while (iterator.hasNext()) {
                InternalContext ctx = iterator.next();
                buffer.append("-----------------------------------\n");
                buffer.append(ctx.toString());
            }
            return buffer.toString();
        }

        @Override
        public Map<String, List<XExpression>> createVariableAssignmentBufferForBranch() {
            return new HashMap<String, List<XExpression>>();
        }

        @Override
        public void mergeBranchVariableAssignments(List<Map<String, List<XExpression>>> buffers) {
            class Data {
                public int occurrences;
                public final List<XExpression> expressions = new ArrayList<XExpression>();

                Data(SideEffectContext this$0) {
                }
            }
            TreeMap<String, Data> full = new TreeMap<String, Data>();
            for (Map<String, List<XExpression>> map : buffers) {
                for (Map.Entry<String, List<XExpression>> entry : map.entrySet()) {
                    Data doublet = (Data)full.get(entry.getKey());
                    if (doublet == null) {
                        doublet = new Data(this);
                        full.put(entry.getKey(), doublet);
                    }
                    doublet.expressions.addAll((Collection<XExpression>)entry.getValue());
                    ++doublet.occurrences;
                }
            }
            for (Map.Entry entry : full.entrySet()) {
                Data data = (Data)entry.getValue();
                if (data.occurrences < buffers.size()) {
                    this.contextStack.getLast().assignVariable((String)entry.getKey(), data.expressions, true);
                    continue;
                }
                this.contextStack.getLast().assignVariable((String)entry.getKey(), data.expressions, false);
            }
        }

        @Override
        public ISideEffectContext branch(Map<String, List<XExpression>> buffer) {
            return new SideEffectContext(this.getCalledOperations(), this.contextStack, buffer, this.stopFirstSideEffect);
        }

        @Override
        public void open() {
            this.contextStack.addLast(new InternalContext(this.contextStack.getLast()));
        }

        @Override
        public void close() {
            if (this.contextStack.size() > 1) {
                this.contextStack.removeLast();
            }
        }

        @Override
        public void declareVariable(String id, XExpression expression) {
            this.contextStack.getLast().declareVariable(id, expression);
        }

        @Override
        public void assignVariable(String id, XExpression expression) {
            InternalContext ctx = this.contextStack.getLast();
            if (this.variableAssignmentBuffer != null && !ctx.isLocalVariable(id)) {
                List<XExpression> expressions = this.variableAssignmentBuffer.get(id);
                if (expressions == null) {
                    expressions = new ArrayList<XExpression>();
                    this.variableAssignmentBuffer.put(id, expressions);
                }
                expressions.add(expression);
            } else {
                ctx.assignVariable(id, Collections.singletonList(expression), this.isBranchContext);
            }
        }

        @Override
        public List<? extends XExpression> getVariableValues(String name) {
            return this.contextStack.getLast().getVariableValues(name);
        }

        private static class InternalContext {
            private final WeakReference<InternalContext> parent;
            private Map<String, List<XExpression>> variables;

            InternalContext(InternalContext parent) {
                this.parent = new WeakReference<InternalContext>(parent);
            }

            public String toString() {
                StringBuilder buffer = new StringBuilder();
                if (this.variables != null) {
                    for (Map.Entry<String, List<XExpression>> variable : this.variables.entrySet()) {
                        buffer.append(variable.getKey());
                        buffer.append(" = ");
                        buffer.append(variable.getValue());
                        buffer.append("\n");
                    }
                }
                return buffer.toString();
            }

            public InternalContext parent() {
                return (InternalContext)this.parent.get();
            }

            public boolean isLocalVariable(String id) {
                return this.variables != null && this.variables.containsKey(id);
            }

            public void declareVariable(String id, XExpression expression) {
                if (this.variables == null) {
                    this.variables = new HashMap<String, List<XExpression>>();
                }
                ArrayList<XExpression> values = new ArrayList<XExpression>();
                values.add(expression);
                this.variables.put(id, values);
            }

            public void assignVariable(String id, Collection<XExpression> expressions, boolean isBranchContext) {
                if (expressions != null) {
                    for (InternalContext ctx = this; ctx != null; ctx = ctx.parent()) {
                        List<XExpression> localDeclaration;
                        if (ctx.variables == null || (localDeclaration = ctx.variables.get(id)) == null) continue;
                        if (isBranchContext) {
                            localDeclaration.addAll(expressions);
                        } else {
                            localDeclaration.clear();
                            localDeclaration.addAll(expressions);
                        }
                        return;
                    }
                }
            }

            public List<? extends XExpression> getVariableValues(String id) {
                for (InternalContext ctx = this; ctx != null; ctx = ctx.parent()) {
                    List<XExpression> localDeclaration;
                    if (ctx.variables == null || (localDeclaration = ctx.variables.get(id)) == null) continue;
                    return Collections.unmodifiableList(localDeclaration);
                }
                return Collections.emptyList();
            }
        }
    }

    public static class AnnotationJavaGenerationAdapter
    extends AdapterImpl {
        private Collection<Functions.Function2<? super JvmOperation, ? super IOperationHelper, ? extends Boolean>> predicates;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPredicate(Functions.Function2<? super JvmOperation, ? super IOperationHelper, ? extends Boolean> predicate) {
            if (predicate != null) {
                AnnotationJavaGenerationAdapter annotationJavaGenerationAdapter = this;
                synchronized (annotationJavaGenerationAdapter) {
                    if (this.predicates == null) {
                        this.predicates = new ArrayList<Functions.Function2<? super JvmOperation, ? super IOperationHelper, ? extends Boolean>>();
                    }
                    this.predicates.add(predicate);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeAllPredicates() {
            AnnotationJavaGenerationAdapter annotationJavaGenerationAdapter = this;
            synchronized (annotationJavaGenerationAdapter) {
                this.predicates = null;
            }
        }

        public boolean isAdapterForType(Object type) {
            return type == AnnotationJavaGenerationAdapter.class;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean applyAdaptations(IOperationHelper helper, JvmOperation operation, ISideEffectContext context) {
            AnnotationJavaGenerationAdapter annotationJavaGenerationAdapter = this;
            synchronized (annotationJavaGenerationAdapter) {
                if (this.predicates != null && !this.predicates.isEmpty()) {
                    for (Functions.Function2<? super JvmOperation, ? super IOperationHelper, ? extends Boolean> predicate : this.predicates) {
                        Boolean bool;
                        IOperationHelper hlp;
                        if (context != null && helper instanceof SARLOperationHelper) {
                            SARLOperationHelper cvalue = (SARLOperationHelper)helper;
                            hlp = new SubHelper(cvalue, context);
                        } else {
                            hlp = helper;
                        }
                        if ((bool = (Boolean)predicate.apply((Object)operation, (Object)hlp)) == null || !bool.booleanValue()) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private static class SubHelper
    implements IOperationHelper {
        private final SARLOperationHelper delegate;
        private final ISideEffectContext context;

        SubHelper(SARLOperationHelper original, ISideEffectContext context) {
            this.delegate = original;
            this.context = context;
        }

        @Override
        public boolean isPurableOperation(XtendFunction operation) {
            return this.delegate.isPurableOperation(operation, this.context);
        }

        @Override
        public boolean isPureOperation(JvmOperation operation) {
            return this.delegate.isPureOperation(operation, this.context);
        }

        @Override
        public boolean hasSideEffects(InferredPrototype calledOperation, XExpression expr) {
            return this.delegate.hasSideEffects(calledOperation, expr, this.context);
        }

        @Override
        public boolean evaluatePureAnnotationAdapters(JvmOperation operation) {
            return this.delegate.evaluatePureAnnotationAdapters(operation, this.context, true);
        }

        @Override
        public void attachPureAnnotationAdapter(JvmOperation operation, Functions.Function2<? super JvmOperation, ? super IOperationHelper, ? extends Boolean> dynamicCallback) {
            this.delegate.attachPureAnnotationAdapter(operation, dynamicCallback);
        }

        @Override
        public Iterable<XExpression> getSideEffectExpressions(InferredPrototype calledOperation, XExpression expr) {
            return this.delegate.getSideEffectExpressions(calledOperation, expr);
        }
    }
}

