/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.typesystem;

import com.google.inject.Inject;
import io.sarl.lang.core.annotation.ImportedCapacityFeature;
import io.sarl.lang.util.Utils;
import java.util.LinkedHashMap;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.typesystem.XtendReentrantTypeResolver;
import org.eclipse.xtend.core.xtend.RichString;
import org.eclipse.xtend.core.xtend.XtendPackage;
import org.eclipse.xtend.core.xtend.XtendTypeDeclaration;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeAnnotationValue;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.AnnotationLookup;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XClosure;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.XbaseFactory;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.Maps2;

public class SARLReentrantTypeResolver
extends XtendReentrantTypeResolver {
    @Inject
    private AnnotationLookup annotationLookup;

    protected IFeatureScopeSession addExtensionFieldsToMemberSession(ResolvedTypes resolvedTypes, IFeatureScopeSession featureScopeSession, JvmDeclaredType type, JvmIdentifiableElement thisFeature, Set<String> seenNames, Set<JvmType> seenTypes) {
        if (seenTypes.add((JvmType)type)) {
            Iterable fields = type.getDeclaredFields();
            LinkedHashMap extensionProviders = null;
            for (JvmField field : fields) {
                LightweightTypeReference fieldType;
                XAbstractFeatureCall extensionProvider;
                if (!featureScopeSession.isVisible((JvmMember)field) || !seenNames.add(field.getSimpleName()) || !this.isExtensionProvider((JvmAnnotationTarget)field)) continue;
                if (extensionProviders == null) {
                    extensionProviders = Maps2.newLinkedHashMapWithExpectedSize((int)3);
                }
                if ((extensionProvider = this.createSarlCapacityExtensionProvider(thisFeature, field)) == null) {
                    extensionProvider = this.createExtensionProvider(thisFeature, field);
                    fieldType = resolvedTypes.getActualType((JvmIdentifiableElement)field);
                } else {
                    fieldType = this.getSarlCapacityFieldType((IResolvedTypes)resolvedTypes, field);
                }
                extensionProviders.put(extensionProvider, fieldType);
            }
            JvmTypeReference superType = this.getExtendedClass(type);
            IFeatureScopeSession result = featureScopeSession;
            if (superType != null) {
                result = this.addExtensionFieldsToMemberSession(resolvedTypes, featureScopeSession, (JvmDeclaredType)superType.getType(), thisFeature, seenNames, seenTypes);
            }
            if (extensionProviders != null) {
                result = result.addToExtensionScope(extensionProviders);
            }
            return result;
        }
        return featureScopeSession;
    }

    protected LightweightTypeReference getSarlCapacityFieldType(IResolvedTypes resolvedTypes, JvmField field) {
        LightweightTypeReference fieldType = resolvedTypes.getActualType((JvmIdentifiableElement)field);
        JvmAnnotationReference capacityAnnotation = this.annotationLookup.findAnnotation((JvmAnnotationTarget)field, ImportedCapacityFeature.class);
        if (capacityAnnotation != null) {
            JvmTypeReference ref = (JvmTypeReference)((JvmTypeAnnotationValue)capacityAnnotation.getValues().get(0)).getValues().get(0);
            fieldType = resolvedTypes.getActualType((JvmIdentifiableElement)ref.getType());
        }
        return fieldType;
    }

    protected XAbstractFeatureCall createSarlCapacityExtensionProvider(JvmIdentifiableElement thisFeature, JvmField field) {
        if (thisFeature instanceof JvmDeclaredType) {
            String methodName;
            JvmOperation callerOperation;
            JvmDeclaredType cvalue = (JvmDeclaredType)thisFeature;
            JvmAnnotationReference capacityAnnotation = this.annotationLookup.findAnnotation((JvmAnnotationTarget)field, ImportedCapacityFeature.class);
            if (capacityAnnotation != null && (callerOperation = SARLReentrantTypeResolver.findOperation(cvalue, methodName = Utils.createNameForHiddenCapacityImplementationCallingMethodFromFieldName(field.getSimpleName()))) != null) {
                XbaseFactory baseFactory = this.getXbaseFactory();
                XMemberFeatureCall extensionProvider = baseFactory.createXMemberFeatureCall();
                extensionProvider.setFeature((JvmIdentifiableElement)callerOperation);
                XFeatureCall thisAccess = baseFactory.createXFeatureCall();
                thisAccess.setFeature(thisFeature);
                extensionProvider.setMemberCallTarget((XExpression)thisAccess);
                return extensionProvider;
            }
        }
        return null;
    }

    private static JvmOperation findOperation(JvmDeclaredType type, String operationName) {
        for (JvmOperation declaredOperation : type.getDeclaredOperations()) {
            if (!declaredOperation.getSimpleName().equals(operationName)) continue;
            return declaredOperation;
        }
        return null;
    }

    protected String getInvalidWritableVariableAccessMessage(XVariableDeclaration variable, XAbstractFeatureCall featureCall, IResolvedTypes resolvedTypes) {
        EObject containingStructure = this.getNearestClosureOrTypeDeclaration((EObject)featureCall, resolvedTypes);
        if (containingStructure instanceof XClosure && !EcoreUtil.isAncestor((EObject)containingStructure, (EObject)variable)) {
            return null;
        }
        return super.getInvalidWritableVariableAccessMessage(variable, featureCall, resolvedTypes);
    }

    private EObject getNearestClosureOrTypeDeclaration(EObject object, IResolvedTypes resolvedTypes) {
        for (EObject candidate = object; candidate != null; candidate = candidate.eContainer()) {
            RichString cvalue;
            LightweightTypeReference type;
            if (candidate instanceof XClosure) {
                return candidate;
            }
            if (candidate instanceof XConstructorCall) {
                if (candidate.eContainingFeature() == XtendPackage.Literals.ANONYMOUS_CLASS__CONSTRUCTOR_CALL) {
                    candidate = candidate.eContainer();
                }
            } else if (candidate instanceof XtendTypeDeclaration) {
                return candidate;
            }
            if (!(candidate instanceof RichString) || (type = resolvedTypes.getActualType((XExpression)(cvalue = (RichString)candidate))) == null || !type.isType(StringConcatenationClient.class)) continue;
            return candidate;
        }
        return null;
    }
}

