/*
 * Decompiled with CFR 0.152.
 */
package io.sarl.lang.typesystem;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.sarl.lang.sarl.SarlAssertExpression;
import io.sarl.lang.sarl.SarlBreakExpression;
import io.sarl.lang.sarl.SarlCastedExpression;
import io.sarl.lang.sarl.SarlContinueExpression;
import io.sarl.lang.typesystem.FeatureCallAdapter;
import io.sarl.lang.typesystem.cast.CastedExpressionTypeComputationState;
import io.sarl.lang.typesystem.cast.ICastOperationCandidateSelector;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtend.core.typesystem.XtendTypeComputer;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmAnnotationReference;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.AnnotationLookup;
import org.eclipse.xtext.diagnostics.AbstractDiagnostic;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.validation.EObjectDiagnosticImpl;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XCastedExpression;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.AmbiguousFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class SARLTypeComputer
extends XtendTypeComputer {
    @Inject
    private AnnotationLookup annotationLookup;
    @Inject
    private ICastOperationCandidateSelector castOperationValidator;

    protected ILinkingCandidate getBestCandidate(List<? extends ILinkingCandidate> candidates) {
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        ILinkingCandidate preferredCandidateWithoutConstraint = null;
        ILinkingCandidate preferredCandidateWithConstraint = null;
        for (ILinkingCandidate iLinkingCandidate : candidates) {
            preferredCandidateWithoutConstraint = preferredCandidateWithoutConstraint == null ? iLinkingCandidate : preferredCandidateWithoutConstraint.getPreferredCandidate(iLinkingCandidate);
            if (preferredCandidateWithConstraint == null) {
                if (this.isIgnorableCallToFeature(iLinkingCandidate)) continue;
                preferredCandidateWithConstraint = iLinkingCandidate;
                continue;
            }
            ILinkingCandidate preferredCandidate = preferredCandidateWithConstraint.getPreferredCandidate(iLinkingCandidate);
            if (preferredCandidate instanceof AmbiguousFeatureLinkingCandidate && this.isIgnorableCallToFeature(iLinkingCandidate)) continue;
            preferredCandidateWithConstraint = preferredCandidate;
        }
        if (preferredCandidateWithConstraint != null) {
            return preferredCandidateWithConstraint;
        }
        return preferredCandidateWithoutConstraint;
    }

    protected boolean isIgnorableCallToFeature(ILinkingCandidate candidate) {
        JvmIdentifiableElement feature = candidate.getFeature();
        if (feature instanceof JvmOperation) {
            JvmOperation cvalue = (JvmOperation)feature;
            JvmOperation target = cvalue;
            JvmAnnotationReference reference = this.annotationLookup.findAnnotation((JvmAnnotationTarget)target, Deprecated.class);
            if (reference == null) {
                do {
                    if ((target = (JvmAnnotationTarget)EcoreUtil2.getContainerOfType((EObject)target.eContainer(), JvmAnnotationTarget.class)) == null) continue;
                    reference = this.annotationLookup.findAnnotation((JvmAnnotationTarget)target, Deprecated.class);
                } while (reference == null && target != null);
            }
            if (reference != null) {
                return true;
            }
        }
        return false;
    }

    public void computeTypes(XExpression expression, ITypeComputationState state) {
        if (expression instanceof SarlBreakExpression) {
            SarlBreakExpression cvalue = (SarlBreakExpression)expression;
            this._computeTypes(cvalue, state);
        } else if (expression instanceof SarlContinueExpression) {
            SarlContinueExpression cvalue = (SarlContinueExpression)expression;
            this._computeTypes(cvalue, state);
        } else if (expression instanceof SarlAssertExpression) {
            SarlAssertExpression cvalue = (SarlAssertExpression)expression;
            this._computeTypes(cvalue, state);
        } else if (expression instanceof SarlCastedExpression) {
            SarlCastedExpression cvalue = (SarlCastedExpression)expression;
            this._computeTypes(cvalue, state);
        } else {
            try {
                super.computeTypes(expression, state);
            }
            catch (Throwable exception) {
                Throwable cause = Throwables.getRootCause((Throwable)exception);
                state.addDiagnostic((AbstractDiagnostic)new EObjectDiagnosticImpl(Severity.ERROR, "io.sarl.lang.validation.IssueCodes.internal_error", cause.getLocalizedMessage(), (EObject)expression, null, -1, null));
            }
        }
    }

    protected void _computeTypes(SarlBreakExpression object, ITypeComputationState state) {
        LightweightTypeReference primitiveVoid = this.getPrimitiveVoid(state);
        state.acceptActualType(primitiveVoid);
    }

    protected void _computeTypes(SarlContinueExpression object, ITypeComputationState state) {
        LightweightTypeReference primitiveVoid = this.getPrimitiveVoid(state);
        state.acceptActualType(primitiveVoid);
    }

    protected void _computeTypes(SarlAssertExpression object, ITypeComputationState state) {
        state.withExpectation(this.getTypeForName(Boolean.class, state)).computeTypes(object.getCondition());
    }

    protected void _computeTypes(SarlCastedExpression cast, ITypeComputationState state) {
        if (state instanceof AbstractTypeComputationState) {
            JvmTypeReference type = cast.getType();
            if (type != null) {
                state.withNonVoidExpectation().computeTypes(cast.getTarget());
                try {
                    ILinkingCandidate best;
                    List<? extends ILinkingCandidate> candidates;
                    AbstractTypeComputationState computationState = (AbstractTypeComputationState)state;
                    CastedExpressionTypeComputationState astate = new CastedExpressionTypeComputationState(cast, computationState, this.castOperationValidator);
                    astate.resetFeature(cast);
                    if (astate.isCastOperatorLinkingEnabled(cast) && !(candidates = astate.getLinkingCandidates(cast)).isEmpty() && (best = this.getBestCandidate(candidates)) != null) {
                        best.applyToModel((IResolvedTypes)computationState.getResolvedTypes());
                    }
                }
                catch (Throwable exception) {
                    Throwable cause = Throwables.getRootCause((Throwable)exception);
                    state.addDiagnostic((AbstractDiagnostic)new EObjectDiagnosticImpl(Severity.ERROR, "io.sarl.lang.validation.IssueCodes.internal_error", cause.getLocalizedMessage(), (EObject)cast, null, -1, null));
                }
                state.acceptActualType(state.getReferenceOwner().toLightweightTypeReference(type));
            } else {
                state.computeTypes(cast.getTarget());
            }
        } else {
            super._computeTypes((XCastedExpression)cast, state);
        }
    }

    protected void _computeTypes(XAbstractFeatureCall featureCall, ITypeComputationState state) {
        List candidates = state.getLinkingCandidates(featureCall);
        if (candidates.size() > 1) {
            FeatureCallAdapter adapter = (FeatureCallAdapter)EcoreUtil.getAdapter((List)featureCall.eAdapters(), FeatureCallAdapter.class);
            if (adapter == null) {
                adapter = new FeatureCallAdapter();
                featureCall.eAdapters().add((Object)adapter);
            }
            adapter.setCallCandidates(candidates);
        }
        super._computeTypes(featureCall, state);
    }
}

